/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import java.util.stream.IntStream;
import vcf.MarkerContainer;

public interface DuplicatesGTRec
extends MarkerContainer {
    public int allele1(int var1);

    public int allele2(int var1);

    default public int allele(int n) {
        if (n < 0 || n >= this.nHaps()) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        int n2 = n / 2;
        if ((n & 1) == 0) {
            return this.allele1(n2);
        }
        return this.allele2(n2);
    }

    default public int[] alleles() {
        return IntStream.range(0, this.nHaps()).map(n -> this.allele(n)).toArray();
    }

    public int nHaps();

    public int nSamples();

    public boolean isPhased(int var1);

    public boolean isPhased();
}

