/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.Const;
import java.util.Arrays;
import vcf.GT;
import vcf.GTRec;
import vcf.Marker;
import vcf.Markers;

public final class BasicGT
implements GT {
    private final Samples samples;
    private final Markers markers;
    private final GTRec[] vma;
    private final boolean isRefData;
    private final boolean isGTData;
    private final boolean[] isRefSample;

    public static int genotype(int n, int n2) {
        if (n <= n2) {
            if (n < 0) {
                String string = "allele < 0: " + n + " " + n2;
                throw new IllegalArgumentException(string);
            }
            return n2 * (n2 + 1) / 2 + n;
        }
        if (n2 < 0) {
            String string = "allele < 0: " + n + " " + n2;
            throw new IllegalArgumentException(string);
        }
        return n * (n + 1) / 2 + n2;
    }

    public BasicGT(Samples samples, GTRec[] gTRecArray) {
        BasicGT.checkSamples(samples, gTRecArray);
        this.markers = BasicGT.markers(gTRecArray);
        this.samples = samples;
        this.vma = (GTRec[])gTRecArray.clone();
        this.isRefSample = BasicGT.isRefSample(samples, gTRecArray);
        this.isRefData = BasicGT.isRefData(gTRecArray);
        this.isGTData = BasicGT.isGTData(gTRecArray);
    }

    private static void checkSamples(Samples samples, GTRec[] gTRecArray) {
        for (int i = 0; i < gTRecArray.length; ++i) {
            if (gTRecArray[i].samples().equals(samples)) continue;
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    private static Markers markers(GTRec[] gTRecArray) {
        Marker[] markerArray = new Marker[gTRecArray.length];
        for (int i = 0; i < markerArray.length; ++i) {
            markerArray[i] = gTRecArray[i].marker();
        }
        return Markers.create(markerArray);
    }

    private static boolean isRefData(GTRec[] gTRecArray) {
        boolean bl = true;
        for (int i = 0; i < gTRecArray.length && bl; ++i) {
            if (gTRecArray[i].isPhased()) continue;
            bl = false;
        }
        return bl;
    }

    private static boolean isGTData(GTRec[] gTRecArray) {
        boolean bl = true;
        for (int i = 0; i < gTRecArray.length && bl; ++i) {
            if (gTRecArray[i].isGTData()) continue;
            bl = false;
        }
        return bl;
    }

    private static boolean[] isRefSample(Samples samples, GTRec[] gTRecArray) {
        boolean[] blArray = new boolean[samples.nSamples()];
        Arrays.fill(blArray, true);
        block0: for (int i = 0; i < blArray.length; ++i) {
            for (GTRec gTRec : gTRecArray) {
                if (gTRec.isPhased(i)) continue;
                blArray[i] = false;
                continue block0;
            }
        }
        return blArray;
    }

    @Override
    public boolean isPhased() {
        return this.isRefData;
    }

    @Override
    public boolean isGTData() {
        return this.isGTData;
    }

    @Override
    public boolean isPhased(int n) {
        return this.isRefSample[n];
    }

    @Override
    public float gl(int n, int n2, int n3, int n4) {
        return this.vma[n].gl(n2, n3, n4);
    }

    @Override
    public boolean isPhased(int n, int n2) {
        return this.vma[n].isPhased(n2);
    }

    @Override
    public int allele1(int n, int n2) {
        return this.vma[n].allele1(n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.vma[n].allele2(n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.vma[n].allele(n2);
    }

    @Override
    public int nMarkers() {
        return this.vma.length;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public int nHaps() {
        return 2 * this.samples.nSamples();
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[BasicGL: nMarkers=");
        stringBuilder.append(this.nMarkers());
        stringBuilder.append(" nSamples=");
        stringBuilder.append(this.nSamples());
        for (GTRec gTRec : this.vma) {
            stringBuilder.append(Const.nl);
            stringBuilder.append(gTRec);
        }
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

