/*
 * Decompiled with CFR 0.152.
 */
package phase;

import beagleutil.Samples;
import blbutil.IntArray;
import blbutil.IntList;
import haplotype.BitHapPair;
import haplotype.HapPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReferenceArray;
import vcf.GT;
import vcf.Markers;

public final class EstPhase {
    private final Samples samples;
    private final Markers markers;
    private final AtomicReferenceArray<HapPair> phase;
    private final AtomicReferenceArray<IntArray> unphased;
    private final AtomicReferenceArray<IntArray> missing;

    public EstPhase(GT gT, List<HapPair> list) {
        Samples samples = gT.samples();
        if (samples.nSamples() != list.size()) {
            throw new IllegalArgumentException("inconsistent sample data");
        }
        int n = gT.nSamples();
        this.samples = gT.samples();
        this.markers = gT.markers();
        this.phase = new AtomicReferenceArray(n);
        this.unphased = new AtomicReferenceArray(n);
        this.missing = new AtomicReferenceArray(n);
        IntList intList = new IntList(gT.nMarkers() / 10);
        IntList intList2 = new IntList(gT.nMarkers() / 100);
        for (int i = 0; i < n; ++i) {
            HapPair hapPair;
            intList.clear();
            intList2.clear();
            boolean bl = false;
            if (!gT.isPhased(i)) {
                int n2 = gT.nMarkers();
                for (int j = 0; j < n2; ++j) {
                    int n3 = gT.allele1(j, i);
                    int n4 = gT.allele2(j, i);
                    if (n3 < 0 || n4 < 0) {
                        intList2.add(j);
                        continue;
                    }
                    if (n3 == n4) continue;
                    if (bl) {
                        intList.add(j);
                        continue;
                    }
                    bl = true;
                }
            }
            if ((hapPair = list.get(i)).idIndex() != gT.samples().idIndex(i)) {
                throw new IllegalArgumentException(String.valueOf(i));
            }
            this.phase.set(i, hapPair);
            this.missing.set(i, IntArray.create(intList2, 0, gT.nMarkers()));
            this.unphased.set(i, IntArray.create(intList, 0, gT.nMarkers()));
        }
    }

    public int nSamples() {
        return this.phase.length();
    }

    public Samples samples() {
        return this.samples;
    }

    public int nMarkers() {
        return this.markers.nMarkers();
    }

    public Markers markers() {
        return this.markers;
    }

    public boolean hasUnphasedHets(int n) {
        return this.unphased.get(n).size() > 0;
    }

    public int nUnphasedHets(int n) {
        return this.unphased.get(n).size();
    }

    public IntArray getUnphasedHets(int n) {
        return this.unphased.get(n);
    }

    public void setUnphasedHets(int n, IntArray intArray) {
        IntArray intArray2 = this.unphased.get(n);
        int n2 = intArray2.size();
        int n3 = 0;
        int n4 = -1;
        int n5 = intArray.size();
        for (int i = 0; i < n5; ++i) {
            int n6 = intArray.get(i);
            if (n3 < n2) {
                n4 = intArray2.get(n3++);
            }
            while (n4 != n6 && n3 < n2) {
                n4 = intArray2.get(n3++);
            }
            if (n4 == n6) continue;
            throw new IllegalArgumentException(intArray.toString());
        }
        this.unphased.set(n, intArray);
    }

    public HapPair getHapPair(int n) {
        return this.phase.get(n);
    }

    public List<HapPair> getHapPairs() {
        int n = this.phase.length();
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(this.phase.get(i));
        }
        return arrayList;
    }

    public void setHapPair(int n, int[] nArray, int[] nArray2) {
        int n2 = this.phase.get(n).idIndex();
        this.phase.set(n, new BitHapPair(this.markers, n2, nArray, nArray2));
    }

    public void getUnphasedHets(int n, boolean[] blArray) {
        if (blArray.length != this.markers.nMarkers()) {
            throw new IllegalArgumentException(String.valueOf(blArray.length));
        }
        Arrays.fill(blArray, false);
        IntArray intArray = this.unphased.get(n);
        int n2 = intArray.size();
        for (int i = 0; i < n2; ++i) {
            blArray[intArray.get((int)i)] = true;
        }
    }

    public boolean hasMissingGT(int n) {
        return this.missing.get(n).size() > 0;
    }

    public IntArray getMissing(int n) {
        return this.missing.get(n);
    }

    public void getMissing(int n, boolean[] blArray) {
        if (blArray.length != this.markers.nMarkers()) {
            throw new IllegalArgumentException(String.valueOf(blArray.length));
        }
        Arrays.fill(blArray, false);
        IntArray intArray = this.missing.get(n);
        int n2 = intArray.size();
        for (int i = 0; i < n2; ++i) {
            blArray[intArray.get((int)i)] = true;
        }
    }

    public void setHapsWithMaskedMissingAlleles(int n, int[] nArray, int[] nArray2) {
        if (nArray.length != this.markers.nMarkers()) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        if (nArray2.length != this.markers.nMarkers()) {
            throw new IllegalArgumentException(String.valueOf(nArray2.length));
        }
        HapPair hapPair = this.phase.get(n);
        int n2 = hapPair.nMarkers();
        for (int i = 0; i < n2; ++i) {
            nArray[i] = hapPair.allele1(i);
            nArray2[i] = hapPair.allele2(i);
        }
        IntArray intArray = this.missing.get(n);
        for (int i = 0; i < intArray.size(); ++i) {
            int n3 = intArray.get(i);
            nArray2[n3] = -1;
            nArray[n3] = -1;
        }
    }
}

