/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.Samples;
import blbutil.BGZIPOutputStream;
import blbutil.FileUtil;
import blbutil.Utilities;
import imp.ImpData;
import imp.ImputedVcfWriter;
import imp.StateProbs;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import main.CurrentData;
import main.GenotypeValues;
import vcf.PhasedGT;
import vcf.VcfWriter;

public class WindowWriter
implements Closeable {
    private final Samples samples;
    private final String outPrefix;
    private final File vcfOutFile;

    public WindowWriter(Samples samples, String string) {
        if (samples == null) {
            throw new NullPointerException("samples==null");
        }
        if (string.length() == 0) {
            throw new IllegalArgumentException("outPrefix.length()==0");
        }
        this.samples = samples;
        this.outPrefix = string;
        this.vcfOutFile = new File(string + ".vcf.gz");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (Closeable closeable = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
            boolean bl = true;
            boolean bl2 = false;
            boolean bl3 = true;
            boolean bl4 = false;
            VcfWriter.writeMetaLines(samples.ids(), "beagle.10Jun18.811.jar", bl, bl2, bl3, bl4, (PrintWriter)closeable);
        }
        try {
            closeable = new FileOutputStream(this.vcfOutFile);
            var5_6 = null;
            try {
                ((FileOutputStream)closeable).write(byteArrayOutputStream.toByteArray());
            }
            catch (Throwable throwable) {
                var5_6 = throwable;
                throw throwable;
            }
            finally {
                if (closeable != null) {
                    if (var5_6 != null) {
                        try {
                            ((FileOutputStream)closeable).close();
                        }
                        catch (Throwable throwable) {
                            var5_6.addSuppressed(throwable);
                        }
                    } else {
                        ((FileOutputStream)closeable).close();
                    }
                }
            }
        }
        catch (IOException iOException) {
            WindowWriter.fileOutputError(this.vcfOutFile, iOException);
        }
    }

    public String outPrefix() {
        return this.outPrefix;
    }

    public Samples samples() {
        return this.samples;
    }

    public void printGV(CurrentData currentData, GenotypeValues genotypeValues) {
        boolean bl = true;
        try (PrintWriter printWriter = FileUtil.bgzipPrintWriter(this.vcfOutFile, bl);){
            VcfWriter.appendRecords(genotypeValues, currentData.prevTargetSpliceStart(), currentData.nextTargetSpliceStart(), printWriter);
        }
    }

    public void print(ImpData impData, AtomicReferenceArray<StateProbs> atomicReferenceArray, int n, int n2) {
        if (atomicReferenceArray.length() != impData.nTargHaps()) {
            throw new IllegalArgumentException("inconsistent data:");
        }
        int n3 = impData.par().nthreads();
        AtomicInteger atomicInteger = new AtomicInteger(0);
        AtomicReferenceArray<byte[]> atomicReferenceArray2 = new AtomicReferenceArray<byte[]>(impData.nClusters());
        ExecutorService executorService = Executors.newFixedThreadPool(n3);
        for (int i = 0; i < n3; ++i) {
            executorService.submit(new RunImputeOutput(impData, atomicReferenceArray, n, n2, atomicInteger, atomicReferenceArray2));
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit("ERROR", throwable);
        }
        WindowWriter.print(atomicReferenceArray2, this.vcfOutFile);
    }

    public void print(PhasedGT phasedGT, int n, int n2, int n3) {
        int n4 = WindowWriter.nMarkersPerStep(phasedGT.nSamples());
        int n5 = WindowWriter.nSteps(n2 - n, n4);
        AtomicReferenceArray<byte[]> atomicReferenceArray = new AtomicReferenceArray<byte[]>(n5);
        ExecutorService executorService = Executors.newFixedThreadPool(n3);
        for (int i = 0; i < n3; ++i) {
            executorService.submit(new RunPhaseOutput(phasedGT, n, n2, n4, n5, atomicReferenceArray));
        }
        try {
            executorService.shutdown();
            executorService.awaitTermination(Long.MAX_VALUE, TimeUnit.DAYS);
        }
        catch (Throwable throwable) {
            Utilities.exit(throwable);
        }
        WindowWriter.print(atomicReferenceArray, this.vcfOutFile);
    }

    private static void print(AtomicReferenceArray<byte[]> atomicReferenceArray, File file) {
        boolean bl = true;
        try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file, bl));){
            int n = atomicReferenceArray.length();
            for (int i = 0; i < n; ++i) {
                ((OutputStream)bufferedOutputStream).write(atomicReferenceArray.get(i));
            }
        }
        catch (IOException iOException) {
            WindowWriter.fileOutputError(file, iOException);
        }
    }

    private static int nMarkersPerStep(int n) {
        int n2 = 0x500000;
        int n3 = 4;
        int n4 = n2 / (n * n3);
        return n4 == 0 ? 1 : n * n3;
    }

    private static int nSteps(int n, int n2) {
        int n3 = n / n2;
        if (n3 * n2 != n) {
            ++n3;
        }
        return n3;
    }

    @Override
    public void close() {
        boolean bl = true;
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.vcfOutFile, bl);
             BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);){
            BGZIPOutputStream bGZIPOutputStream = new BGZIPOutputStream(bufferedOutputStream, true);
            Throwable throwable = null;
            if (bGZIPOutputStream != null) {
                if (throwable != null) {
                    try {
                        bGZIPOutputStream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    bGZIPOutputStream.close();
                }
            }
        }
        catch (IOException iOException) {
            Utilities.exit("Error closing file: " + this.vcfOutFile, iOException);
        }
    }

    private static void fileOutputError(File file, Exception exception) {
        Utilities.exit("Error writing to file: " + file, exception);
    }

    private static class RunPhaseOutput
    implements Runnable {
        private final PhasedGT phasedTarg;
        private final int start;
        private final int end;
        private final AtomicInteger counter;
        private final int step;
        private final int nSteps;
        private final AtomicReferenceArray<byte[]> output;

        public RunPhaseOutput(PhasedGT phasedGT, int n, int n2, int n3, int n4, AtomicReferenceArray<byte[]> atomicReferenceArray) {
            this.phasedTarg = phasedGT;
            this.start = n;
            this.end = n2;
            this.step = n3;
            this.nSteps = n4;
            this.counter = new AtomicInteger(0);
            this.output = atomicReferenceArray;
        }

        @Override
        public void run() {
            try {
                boolean bl = false;
                boolean bl2 = false;
                int n = this.counter.getAndIncrement();
                while (n < this.nSteps) {
                    int n2 = this.start + this.step * n;
                    int n3 = Math.min(n2 + this.step, this.end);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try (PrintWriter printWriter = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
                        VcfWriter.appendRecords(this.phasedTarg, n2, n3, bl, bl2, printWriter);
                    }
                    this.output.set(n, byteArrayOutputStream.toByteArray());
                    n = this.counter.getAndIncrement();
                }
            }
            catch (Throwable throwable) {
                Utilities.exit(throwable);
            }
        }
    }

    private static class RunImputeOutput
    implements Runnable {
        private final ImpData impData;
        private final int refStart;
        private final int refEnd;
        private final int nClusters;
        private final AtomicInteger counter;
        private final AtomicReferenceArray<StateProbs> stateProbs;
        private final AtomicReferenceArray<byte[]> output;

        public RunImputeOutput(ImpData impData, AtomicReferenceArray<StateProbs> atomicReferenceArray, int n, int n2, AtomicInteger atomicInteger, AtomicReferenceArray<byte[]> atomicReferenceArray2) {
            this.impData = impData;
            this.refStart = n;
            this.refEnd = n2;
            this.nClusters = impData.nClusters();
            this.counter = atomicInteger;
            this.stateProbs = atomicReferenceArray;
            this.output = atomicReferenceArray2;
        }

        @Override
        public void run() {
            try {
                int n = this.counter.getAndIncrement();
                while (n < this.nClusters) {
                    ImputedVcfWriter imputedVcfWriter = new ImputedVcfWriter(this.impData, n, this.refStart, this.refEnd);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    try (PrintWriter printWriter = new PrintWriter(new BGZIPOutputStream(byteArrayOutputStream, false));){
                        imputedVcfWriter.appendRecords(this.stateProbs, printWriter);
                    }
                    this.output.set(n, byteArrayOutputStream.toByteArray());
                    n = this.counter.getAndIncrement();
                }
            }
            catch (Throwable throwable) {
                Utilities.exit(throwable);
            }
        }
    }
}

