/*
 * Decompiled with CFR 0.152.
 */
package main;

import beagleutil.ChromInterval;
import beagleutil.Samples;
import blbutil.Const;
import blbutil.FileIt;
import blbutil.Filter;
import blbutil.InputIt;
import blbutil.SampleFileIt;
import blbutil.Utilities;
import bref.Bref3It;
import haplotype.BitHapPair;
import haplotype.HapPair;
import haplotype.HapPairPhasedGT;
import imp.ImpData;
import imp.ImpLS;
import imp.StateProbs;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Supplier;
import main.CurrentData;
import main.GenotypeValues;
import main.MainHelper;
import main.Par;
import main.RunStats;
import main.WindowWriter;
import vcf.AllData;
import vcf.Data;
import vcf.FilterUtil;
import vcf.GT;
import vcf.GTRec;
import vcf.GeneticMap;
import vcf.IntervalVcfIt;
import vcf.Marker;
import vcf.Markers;
import vcf.PhasedGT;
import vcf.RefGTRec;
import vcf.RefIt;
import vcf.TargetData;
import vcf.VcfIt;
import vcf.VcfRecord;

public class Main {
    public static final String VERSION = "(version 5.0)";
    public static final String PROGRAM = "beagle.10Jun18.811.jar";
    public static final String COMMAND = "java -jar beagle.10Jun18.811.jar";
    public static final String COPYRIGHT = "Copyright (C) 2014-2016 Brian L. Browning";
    public static final String SHORT_HELP = "beagle.10Jun18.811.jar (version 5.0)" + Const.nl + "Copyright (C) 2014-2016 Brian L. Browning" + Const.nl + "Enter \"java -jar beagle.10Jun18.811.jar\" to " + "list command line argument";
    private final Par par;
    private final GeneticMap genMap;
    private final Data data;
    private final RunStats runStats;
    private final WindowWriter windowWriter;

    public static void main(String[] stringArray) {
        Locale.setDefault(Locale.US);
        if (stringArray.length == 0) {
            System.out.println("beagle.10Jun18.811.jar (version 5.0)");
            System.out.println(COPYRIGHT);
            System.out.println(Par.usage());
            System.exit(0);
        }
        Par par = Main.parameters(stringArray);
        System.setProperty("java.util.concurrent.ForkJoinPool.common.parallelism", String.valueOf(par.nthreads()));
        RunStats runStats = new RunStats(par);
        runStats.printStartInfo();
        try (Data data = Main.data(par, runStats);
             WindowWriter windowWriter = new WindowWriter(data.targetSamples(), par.out());){
            Main main = new Main(par, data, windowWriter, runStats);
            main.phaseData();
            runStats.printSummaryAndClose(data.nTargetMarkersSoFar(), data.nMarkersSoFar());
        }
    }

    private Main(Par par, Data data, WindowWriter windowWriter, RunStats runStats) {
        assert (par != null);
        assert (data != null);
        assert (windowWriter != null);
        assert (runStats != null);
        this.par = par;
        this.genMap = data.genMap();
        this.data = data;
        this.runStats = runStats;
        this.windowWriter = windowWriter;
    }

    private static Data data(Par par, RunStats runStats) {
        Filter<String> filter = FilterUtil.sampleFilter(par.excludesamples());
        Filter<Marker> filter2 = FilterUtil.markerFilter(par.excludemarkers());
        ChromInterval chromInterval = par.chromInt();
        if (par.ref() == null) {
            Supplier<SampleFileIt<GTRec>> supplier = () -> Main.targIt(par, filter2, filter, chromInterval);
            return TargetData.targetData(par, supplier);
        }
        SampleFileIt<GTRec> sampleFileIt = Main.targIt(par, filter2, filter, chromInterval);
        Supplier<SampleFileIt<RefGTRec>> supplier = Main.refSupplier(par, filter2, filter, chromInterval, runStats);
        return AllData.allData(supplier, sampleFileIt, par);
    }

    private void phaseData() {
        this.runStats.printSampleSummary(this.data);
        MainHelper mainHelper = new MainHelper(this.par, this.genMap, this.runStats);
        PhasedGT phasedGT = null;
        int n = 0;
        do {
            if (++n > 1) {
                this.data.advanceWindowCm();
            }
            this.runStats.printWindowUpdate(this.data);
            CurrentData currentData = new CurrentData(this.par, this.genMap, this.data, phasedGT);
            PhasedGT phasedGT2 = mainHelper.phase(currentData);
            this.printOutput(currentData, phasedGT2);
            phasedGT = this.overlapHaps(currentData, phasedGT2);
        } while (this.data.canAdvanceWindow());
    }

    private static void initializeGV(GenotypeValues genotypeValues, GT gT) {
        assert (genotypeValues.markers().equals(gT.markers()));
        assert (genotypeValues.samples().equals(gT.samples()));
        int n = gT.nMarkers();
        int n2 = gT.nSamples();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                int n3 = gT.allele1(i, j);
                int n4 = gT.allele2(i, j);
                if (n3 < 0 || n4 < 0) continue;
                int n5 = VcfRecord.gtIndex(n3, n4);
                genotypeValues.add(i, j, n5, 1.0);
            }
        }
    }

    private void printOutput(CurrentData currentData, PhasedGT phasedGT) {
        assert (this.par.gt() != null);
        int n = currentData.prevSpliceStart();
        int n2 = currentData.nextSpliceStart();
        int n3 = this.par.nthreads();
        if (currentData.nMarkers() == currentData.nTargMarkers() || !this.par.impute()) {
            this.windowWriter.print(phasedGT, n, n2, n3);
        } else {
            long l = System.nanoTime();
            ImpData impData = new ImpData(this.par, currentData, phasedGT, this.genMap);
            AtomicReferenceArray<StateProbs> atomicReferenceArray = ImpLS.stateProbs(impData);
            this.windowWriter.print(impData, atomicReferenceArray, n, n2);
            this.runStats.imputationNanos(System.nanoTime() - l);
            this.runStats.printImputationUpdate();
        }
    }

    private PhasedGT overlapHaps(CurrentData currentData, PhasedGT phasedGT) {
        int n = currentData.nextTargetOverlapStart();
        int n2 = currentData.nextTargetSpliceStart();
        if (currentData.nextOverlapStart() == currentData.nextSpliceStart()) {
            return null;
        }
        int n3 = phasedGT.nSamples();
        int n4 = n2 - n;
        Markers markers = phasedGT.markers().restrict(n, n2);
        Samples samples = phasedGT.samples();
        ArrayList<HapPair> arrayList = new ArrayList<HapPair>(n3);
        int[] nArray = new int[n4];
        int[] nArray2 = new int[n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                nArray[j] = phasedGT.allele1(n + j, i);
                nArray2[j] = phasedGT.allele2(n + j, i);
            }
            arrayList.add(new BitHapPair(markers, samples.idIndex(i), nArray, nArray2));
        }
        return new HapPairPhasedGT(phasedGT.samples(), arrayList);
    }

    private static SampleFileIt<GTRec> targIt(Par par, Filter<Marker> filter, Filter<String> filter2, ChromInterval chromInterval) {
        InputIt inputIt = InputIt.fromGzipFile(par.gt());
        SampleFileIt<GTRec> sampleFileIt = VcfIt.create(inputIt, filter2, filter, VcfIt.toBitSetGT);
        if (chromInterval != null) {
            sampleFileIt = new IntervalVcfIt<GTRec>(sampleFileIt, chromInterval);
        }
        return sampleFileIt;
    }

    private static Supplier<SampleFileIt<RefGTRec>> refSupplier(Par par, Filter<Marker> filter, Filter<String> filter2, ChromInterval chromInterval, RunStats runStats) {
        Filter<Marker> filter3 = Main.updateFilter(par, filter, filter2, chromInterval);
        return () -> {
            SampleFileIt<RefGTRec> sampleFileIt;
            Object object;
            String string = par.ref().toString();
            if (string.endsWith(".bref")) {
                object = Const.nl + "ERROR: bref format (.bref) is not supported" + Const.nl + "       Reference files should be in bref3 format (.brer3)";
                Utilities.exit((String)object);
            }
            if (string.endsWith(".bref3")) {
                sampleFileIt = new Bref3It(par.ref(), filter3);
            } else {
                if (!string.endsWith(".vcf") && !string.endsWith(".vcf.gz")) {
                    runStats.println(Const.nl + "WARNING: unrecognized reference file type " + "(expected \".bref3\", \".vcf\", or \".vcf.gz\")" + Const.nl);
                }
                object = InputIt.fromGzipFile(par.ref());
                sampleFileIt = RefIt.create((FileIt<String>)object, filter2, filter3, 1000);
            }
            if (chromInterval != null) {
                sampleFileIt = new IntervalVcfIt<RefGTRec>(sampleFileIt, chromInterval);
            }
            return sampleFileIt;
        };
    }

    private static Filter<Marker> updateFilter(Par par, Filter<Marker> filter, Filter<String> filter2, ChromInterval chromInterval) {
        if (par.impute() && par.gt() != null) {
            return filter;
        }
        HashSet<Marker> hashSet = new HashSet<Marker>(50000);
        try (SampleFileIt<GTRec> sampleFileIt = Main.targIt(par, filter, filter2, chromInterval);){
            while (sampleFileIt.hasNext()) {
                hashSet.add(((GTRec)sampleFileIt.next()).marker());
            }
        }
        return Filter.includeFilter(hashSet);
    }

    private static Par parameters(String[] stringArray) {
        Par par = new Par(stringArray);
        Main.checkOutputPrefix(par);
        if (1.1 * (double)par.overlap() >= (double)par.window()) {
            String string = SHORT_HELP + Const.nl + Const.nl + "ERROR: The \"window\" parameter must be at least " + "1.1 times the \"overlap\" parameter" + Const.nl + "Exiting program.";
            Utilities.exit(string);
        }
        return par;
    }

    private static void checkOutputPrefix(Par par) {
        String string;
        Object object;
        File file = new File(par.out());
        if (file.isDirectory()) {
            object = "ERROR: \"out\" parameter cannot be a directory: \"" + par.out() + "\"";
            Utilities.exit(Par.usage() + (String)object);
        }
        if (((File)(object = new File(par.out() + ".vcf.gz"))).equals(par.ref())) {
            string = "ERROR: VCF output file equals input file: " + par.ref();
            Utilities.exit(Par.usage() + string);
        }
        if (((File)object).equals(par.gt())) {
            string = "ERROR: VCF output file equals input file: " + par.gt();
            Utilities.exit(Par.usage() + string);
        }
    }
}

