/*
 * Decompiled with CFR 0.152.
 */
package imp;

import blbutil.FloatList;
import blbutil.IntList;
import imp.StateProbs;

public class StateProbsFactory {
    private final int nTargMarkers;
    private final int nTargMarkersM1;
    private final IntList hapList;
    private final FloatList probList;
    private final FloatList probP1List;
    private final int[][] haps;
    private final float[][] probs;
    private final float[][] probsP1;

    public StateProbsFactory(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.nTargMarkers = n;
        this.nTargMarkersM1 = n - 1;
        this.hapList = new IntList(50);
        this.probList = new FloatList(50);
        this.probP1List = new FloatList(50);
        this.haps = new int[n][];
        this.probs = new float[n][];
        this.probsP1 = new float[n][];
    }

    public int nTargMarkers() {
        return this.nTargMarkers;
    }

    public StateProbs stateProbs(int n, int n2, int[][] nArray, float[][] fArray) {
        if (nArray.length != this.nTargMarkers) {
            throw new IllegalArgumentException(String.valueOf(nArray.length));
        }
        if (fArray.length != this.nTargMarkers) {
            throw new IllegalArgumentException(String.valueOf(fArray.length));
        }
        float f = this.threshold(n2);
        for (int i = 0; i < this.nTargMarkers; ++i) {
            this.hapList.clear();
            this.probList.clear();
            this.probP1List.clear();
            int n3 = i < this.nTargMarkersM1 ? i + 1 : i;
            for (int j = 0; j < n2; ++j) {
                if (!(fArray[i][j] > f) && !(fArray[n3][j] > f)) continue;
                this.hapList.add(nArray[i][j]);
                this.probList.add(fArray[i][j]);
                this.probP1List.add(fArray[n3][j]);
            }
            this.haps[i] = this.hapList.toArray();
            this.probs[i] = this.probList.toArray();
            this.probsP1[i] = this.probP1List.toArray();
        }
        return new BasicStateProbs(n, this.haps, this.probs, this.probsP1);
    }

    private float threshold(int n) {
        return Math.min(0.005f, 0.9999f / (float)n);
    }

    private static class BasicStateProbs
    implements StateProbs {
        private final int targHap;
        private final int[][] haps;
        private final float[][] probs;
        private final float[][] probsP1;

        public BasicStateProbs(int n, int[][] nArray, float[][] fArray, float[][] fArray2) {
            this.targHap = n;
            this.haps = (int[][])nArray.clone();
            this.probs = (float[][])fArray.clone();
            this.probsP1 = (float[][])fArray2.clone();
        }

        @Override
        public int nTargMarkers() {
            return this.haps.length;
        }

        @Override
        public int nStates(int n) {
            return this.haps[n].length;
        }

        @Override
        public int targHap() {
            return this.targHap;
        }

        @Override
        public int refHap(int n, int n2) {
            return this.haps[n][n2];
        }

        @Override
        public float probs(int n, int n2) {
            return this.probs[n][n2];
        }

        @Override
        public float probsP1(int n, int n2) {
            return this.probsP1[n][n2];
        }
    }
}

