/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import haplotype.HapPair;
import vcf.Marker;
import vcf.Markers;
import vcf.PhasedGT;

public final class WrappedHapPair
implements HapPair {
    private final PhasedGT phasedGT;
    private final int hapPair;

    public WrappedHapPair(PhasedGT phasedGT, int n) {
        if (n < 0 || n >= phasedGT.nSamples()) {
            throw new IllegalArgumentException("hapPair: " + n);
        }
        this.phasedGT = phasedGT;
        this.hapPair = n;
    }

    @Override
    public int allele1(int n) {
        return this.phasedGT.allele1(n, this.hapPair);
    }

    @Override
    public int allele2(int n) {
        return this.phasedGT.allele2(n, this.hapPair);
    }

    @Override
    public Markers markers() {
        return this.phasedGT.markers();
    }

    @Override
    public Marker marker(int n) {
        return this.phasedGT.marker(n);
    }

    @Override
    public int nMarkers() {
        return this.phasedGT.nMarkers();
    }

    @Override
    public int idIndex() {
        return this.phasedGT.samples().idIndex(this.hapPair);
    }
}

