/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.HapPair;
import java.util.Collections;
import java.util.List;
import vcf.Marker;
import vcf.Markers;
import vcf.PhasedGT;

public final class HapPairPhasedGT
implements PhasedGT {
    private final Markers markers;
    private final Samples samples;
    private final HapPair[] hapPairs;

    public HapPairPhasedGT(Samples samples, List<HapPair> list) {
        if (list.isEmpty()) {
            throw new IllegalArgumentException("haps.isEmpy()==true");
        }
        Collections.sort(list, HapPair.comparator(samples));
        this.checkSamples(samples, list);
        this.markers = HapPairPhasedGT.checkAndExtractMarkers(list);
        this.samples = samples;
        this.hapPairs = list.toArray(new HapPair[0]);
    }

    private void checkSamples(Samples samples, List<HapPair> list) {
        if (samples.nSamples() != list.size()) {
            throw new IllegalArgumentException("inconsistent samples");
        }
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            if (samples.idIndex(i) == list.get(i).idIndex()) continue;
            throw new IllegalArgumentException("inconsistent samples");
        }
    }

    static Markers checkAndExtractMarkers(List<HapPair> list) {
        if (list.isEmpty()) {
            return Markers.create(new Marker[0]);
        }
        Markers markers = list.get(0).markers();
        int n = list.size();
        for (int i = 1; i < n; ++i) {
            if (list.get(i).markers().equals(markers)) continue;
            throw new IllegalArgumentException("inconsistent markers");
        }
        return markers;
    }

    @Override
    public int allele1(int n, int n2) {
        return this.hapPairs[n2].allele1(n);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.hapPairs[n2].allele2(n);
    }

    @Override
    public int allele(int n, int n2) {
        int n3 = n2 / 2;
        if ((n2 & 1) == 0) {
            return this.hapPairs[n3].allele1(n);
        }
        return this.hapPairs[n3].allele2(n);
    }

    @Override
    public int nMarkers() {
        return this.markers.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.markers;
    }

    @Override
    public Marker marker(int n) {
        return this.markers.marker(n);
    }

    @Override
    public int nHaps() {
        return 2 * this.hapPairs.length;
    }

    @Override
    public int nSamples() {
        return this.samples.nSamples();
    }

    @Override
    public Samples samples() {
        return this.samples;
    }
}

