/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.ByteArray;
import blbutil.CharArray;
import blbutil.IntList;
import blbutil.UnsignedByteArray;
import blbutil.WrappedIntArray;
import java.util.Arrays;

public interface IntArray {
    public int size();

    public int get(int var1);

    default public int max() {
        int n = Integer.MIN_VALUE;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.get(i) <= n) continue;
            n = this.get(i);
        }
        return n;
    }

    default public int min() {
        int n = Integer.MAX_VALUE;
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            if (this.get(i) >= n) continue;
            n = this.get(i);
        }
        return n;
    }

    public String toString();

    default public String asString() {
        int[] nArray = new int[this.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = this.get(i);
        }
        return Arrays.toString(nArray);
    }

    public static IntArray create(int[] nArray, int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n >= 0) {
            if (n2 <= 128) {
                return new ByteArray(nArray);
            }
            if (n2 <= 256) {
                return new UnsignedByteArray(nArray);
            }
            if (n2 <= 65536) {
                return new CharArray(nArray);
            }
        }
        return new WrappedIntArray(nArray);
    }

    public static IntArray create(IntList intList, int n, int n2) {
        if (n >= n2) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        if (n >= 0) {
            if (n2 <= 128) {
                return new ByteArray(intList);
            }
            if (n2 <= 256) {
                return new UnsignedByteArray(intList);
            }
            if (n2 <= 65536) {
                return new CharArray(intList);
            }
        }
        return new WrappedIntArray(intList);
    }
}

