/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.IntArray;
import blbutil.IntList;

public final class CharArray
implements IntArray {
    private final char[] ca;

    public CharArray(byte[] byArray) {
        if (byArray.length % 1 != 0) {
            throw new IllegalArgumentException(String.valueOf(byArray.length));
        }
        this.ca = new char[byArray.length / 2];
        for (int i = 0; i < byArray.length; i += 2) {
            int n = byArray[i] & 0xFF;
            int n2 = byArray[i + 1] & 0xFF;
            this.ca[i / 2] = (char)((n << 8) + n2);
        }
    }

    public CharArray(char[] cArray) {
        this.ca = (char[])cArray.clone();
    }

    public CharArray(int[] nArray) {
        this(nArray, 0, nArray.length);
    }

    public CharArray(IntList intList) {
        this(intList, 0, intList.size());
    }

    public CharArray(int[] nArray, int n, int n2) {
        this.ca = new char[n2 - n];
        for (int i = n; i < n2; ++i) {
            if (nArray[i] < 0 || nArray[i] > 65535) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            this.ca[i - n] = (char)nArray[i];
        }
    }

    public CharArray(IntList intList, int n, int n2) {
        this.ca = new char[n2 - n];
        for (int i = n; i < n2; ++i) {
            int n3 = intList.get(i);
            if (n3 < 0 || n3 > 65535) {
                throw new IllegalArgumentException(String.valueOf(n3));
            }
            this.ca[i - n] = (char)n3;
        }
    }

    @Override
    public int size() {
        return this.ca.length;
    }

    @Override
    public int get(int n) {
        return this.ca[n];
    }

    @Override
    public String toString() {
        return this.asString();
    }
}

