/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.IntArray;
import blbutil.IntList;

public final class ByteArray
implements IntArray {
    private final byte[] ba;

    public ByteArray(byte[] byArray) {
        this.ba = (byte[])byArray.clone();
    }

    public ByteArray(int[] nArray) {
        this(nArray, 0, nArray.length);
    }

    public ByteArray(IntList intList) {
        this(intList, 0, intList.size());
    }

    public ByteArray(int[] nArray, int n, int n2) {
        this.ba = new byte[n2 - n];
        for (int i = n; i < n2; ++i) {
            if (nArray[i] < -128 || nArray[i] > 127) {
                throw new IllegalArgumentException(String.valueOf(nArray[i]));
            }
            this.ba[i - n] = (byte)nArray[i];
        }
    }

    public ByteArray(IntList intList, int n, int n2) {
        this.ba = new byte[n2 - n];
        for (int i = n; i < n2; ++i) {
            int n3 = intList.get(i);
            if (n3 < -128 || n3 > 127) {
                throw new IllegalArgumentException(String.valueOf(n3));
            }
            this.ba[i - n] = (byte)n3;
        }
    }

    @Override
    public int size() {
        return this.ba.length;
    }

    @Override
    public int get(int n) {
        return this.ba[n];
    }

    @Override
    public String toString() {
        return this.asString();
    }
}

