/*
 * Decompiled with CFR 0.152.
 */
package beagleutil;

import beagleutil.SampleIds;
import java.util.Arrays;

public final class Samples {
    private static final SampleIds sampleIds = SampleIds.instance();
    private final int[] idIndexToIndex;
    private final int[] indexToIdIndex;

    public Samples(int[] nArray) {
        int[] nArray2 = (int[])nArray.clone();
        this.idIndexToIndex = Samples.idIndexToIndex(nArray2);
        this.indexToIdIndex = nArray2;
    }

    private static int[] idIndexToIndex(int[] nArray) {
        int[] nArray2 = new int[sampleIds.size()];
        Arrays.fill(nArray2, -1);
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            if (nArray2[n2] != -1) {
                String string = "duplicate sample: " + sampleIds.id(n2) + " (ID index: " + n2 + ")";
                throw new IllegalArgumentException(string);
            }
            nArray2[n2] = n++;
        }
        return nArray2;
    }

    public static Samples fromIds(String[] stringArray) {
        return new Samples(sampleIds.getIndices(stringArray));
    }

    public int hashCode() {
        return Arrays.hashCode(this.indexToIdIndex);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Samples samples = (Samples)object;
        return Arrays.equals(this.indexToIdIndex, samples.indexToIdIndex);
    }

    public int idIndex(int n) {
        return this.indexToIdIndex[n];
    }

    public int index(int n) {
        if (n >= this.idIndexToIndex.length) {
            return -1;
        }
        return this.idIndexToIndex[n];
    }

    public int index(String string) {
        int n = SampleIds.instance().getIndexIfIndexed(string);
        if (n != -1) {
            return this.index(n);
        }
        return -1;
    }

    public int nSamples() {
        return this.indexToIdIndex.length;
    }

    public String id(int n) {
        return sampleIds.id(this.indexToIdIndex[n]);
    }

    public String[] ids() {
        return sampleIds.ids(this.indexToIdIndex);
    }

    public String toString() {
        return Arrays.toString(this.ids());
    }
}

