/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import java.util.List;
import picard.vcf.filter.VariantFilter;

public class FisherStrandFilter
implements VariantFilter {
    private final double maxPhredScalePValue;

    public FisherStrandFilter(double maxPhredScalePValue) {
        this.maxPhredScalePValue = maxPhredScalePValue;
    }

    @Override
    public List<VCFFilterHeaderLine> headerLines() {
        return CollectionUtil.makeList(new VCFFilterHeaderLine("StrandBias", "Site exhibits excessive allele/strand correlation."));
    }

    @Override
    public String filter(VariantContext ctx) {
        double fs = ctx.getAttributeAsDouble("FS", 0.0);
        return fs > this.maxPhredScalePValue ? "StrandBias" : null;
    }
}

