/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFHeader;
import java.io.File;
import java.util.Iterator;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Splits SNPs and INDELs into separate files.  This tool reads in a VCF or BCF file and writes out the SNPs and INDELs it contains to separate files. The headers of the two output files will be identical and index files will be created for both outputs. If records other than SNPs or INDELs are present, set the STRICT option to \"false\", otherwise the tool will raise an exception and quit. <br /><h4>Usage example:</h4><pre>java -jar picard.jar SplitVcfs \\<br />      I=input.vcf \\<br />      SNP_OUTPUT=snp.vcf \\<br />      INDEL_OUTPUT=indel.vcf \\<br />      STRICT=false</pre><hr />", oneLineSummary="Splits SNPs and INDELs into separate files.  ", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class SplitVcfs
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Splits SNPs and INDELs into separate files.  ";
    static final String USAGE_DETAILS = "This tool reads in a VCF or BCF file and writes out the SNPs and INDELs it contains to separate files. The headers of the two output files will be identical and index files will be created for both outputs. If records other than SNPs or INDELs are present, set the STRICT option to \"false\", otherwise the tool will raise an exception and quit. <br /><h4>Usage example:</h4><pre>java -jar picard.jar SplitVcfs \\<br />      I=input.vcf \\<br />      SNP_OUTPUT=snp.vcf \\<br />      INDEL_OUTPUT=indel.vcf \\<br />      STRICT=false</pre><hr />";
    @Argument(shortName="I", doc="The VCF or BCF input file")
    public File INPUT;
    @Argument(doc="The VCF or BCF file to which SNP records should be written. The file format is determined by file extension.")
    public File SNP_OUTPUT;
    @Argument(doc="The VCF or BCF file to which indel records should be written. The file format is determined by file extension.")
    public File INDEL_OUTPUT;
    @Argument(shortName="D", doc="The index sequence dictionary to use instead of the sequence dictionaries in the input files", optional=true)
    public File SEQUENCE_DICTIONARY;
    @Argument(doc="If true an exception will be thrown if an event type other than SNP or indel is encountered")
    public Boolean STRICT = true;
    private final Log log = Log.getInstance(SplitVcfs.class);

    public static void main(String[] argv) {
        new SplitVcfs().instanceMainWithExit(argv);
    }

    public SplitVcfs() {
        this.CREATE_INDEX = true;
    }

    @Override
    protected int doWork() {
        SAMSequenceDictionary sequenceDictionary;
        IOUtil.assertFileIsReadable(this.INPUT);
        ProgressLogger progress = new ProgressLogger(this.log, 10000);
        VCFFileReader fileReader = new VCFFileReader(this.INPUT);
        VCFHeader fileHeader = fileReader.getFileHeader();
        SAMSequenceDictionary sAMSequenceDictionary = sequenceDictionary = this.SEQUENCE_DICTIONARY != null ? SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).getFileHeader(this.SEQUENCE_DICTIONARY).getSequenceDictionary() : fileHeader.getSequenceDictionary();
        if (this.CREATE_INDEX.booleanValue() && sequenceDictionary == null) {
            throw new PicardException("A sequence dictionary must be available (either through the input file or by setting it explicitly) when creating indexed output.");
        }
        VariantContextWriterBuilder builder = new VariantContextWriterBuilder().setReferenceDictionary(sequenceDictionary).clearOptions();
        if (this.CREATE_INDEX.booleanValue()) {
            builder.setOption(Options.INDEX_ON_THE_FLY);
        }
        VariantContextWriter snpWriter = builder.setOutputFile(this.SNP_OUTPUT).build();
        VariantContextWriter indelWriter = builder.setOutputFile(this.INDEL_OUTPUT).build();
        snpWriter.writeHeader(fileHeader);
        indelWriter.writeHeader(fileHeader);
        int incorrectVariantCount = 0;
        Iterator iterator = fileReader.iterator();
        while (iterator.hasNext()) {
            VariantContext context = (VariantContext)iterator.next();
            if (context.isIndel()) {
                indelWriter.add(context);
            } else if (context.isSNP()) {
                snpWriter.add(context);
            } else {
                if (this.STRICT.booleanValue()) {
                    throw new IllegalStateException("Found a record with type " + context.getType().name());
                }
                ++incorrectVariantCount;
            }
            progress.record(context.getContig(), context.getStart());
        }
        if (incorrectVariantCount > 0) {
            this.log.debug("Found " + incorrectVariantCount + " records that didn't match SNP or INDEL");
        }
        CloserUtil.close(iterator);
        CloserUtil.close(fileReader);
        snpWriter.close();
        indelWriter.close();
        return 0;
    }
}

