/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.variantcontext.writer.Options;
import htsjdk.variant.variantcontext.writer.VariantContextWriter;
import htsjdk.variant.variantcontext.writer.VariantContextWriterBuilder;
import htsjdk.variant.vcf.VCFCompoundHeaderLine;
import htsjdk.variant.vcf.VCFFileReader;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import htsjdk.variant.vcf.VCFFormatHeaderLine;
import htsjdk.variant.vcf.VCFHeader;
import htsjdk.variant.vcf.VCFHeaderLine;
import htsjdk.variant.vcf.VCFHeaderLineCount;
import htsjdk.variant.vcf.VCFHeaderLineType;
import htsjdk.variant.vcf.VCFInfoHeaderLine;
import htsjdk.variant.vcf.VCFSimpleHeaderLine;
import htsjdk.variant.vcf.VCFStandardHeaderLines;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.VariantManipulationProgramGroup;

@CommandLineProgramProperties(summary="Replaces or fixes a VCF header.This tool will either replace the header in the input VCF file (INPUT) with the given VCF header (HEADER) or will attempt to fill in any field definitions that are missing in the input header by examining the variants in the input VCF file (INPUT).  In the latter case, this tool will perform two passes over the input VCF, and any FILTER, INFO, and FORMAT fields found in the VCF records but not found in the input VCF header will be added to the output VCF header with dummy descriptions.<br /><h4>Replace header usage example:</h4><pre>java -jar picard.jar FixVcfHeader \\<br />     I=input.vcf \\<br />     O=fixed.vcf \\<br />     HEADER=header.vcf</pre><h4>Fix header usage example:</h4><pre>java -jar picard.jar FixVcfHeader \\<br />     I=input.vcf \\<br />     O=fixed.vcf \\<br /></pre><hr />", oneLineSummary="Replaces or fixes a VCF header.", programGroup=VariantManipulationProgramGroup.class)
@DocumentedFeature
public class FixVcfHeader
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Replaces or fixes a VCF header.";
    static final String USAGE_DETAILS = "This tool will either replace the header in the input VCF file (INPUT) with the given VCF header (HEADER) or will attempt to fill in any field definitions that are missing in the input header by examining the variants in the input VCF file (INPUT).  In the latter case, this tool will perform two passes over the input VCF, and any FILTER, INFO, and FORMAT fields found in the VCF records but not found in the input VCF header will be added to the output VCF header with dummy descriptions.<br /><h4>Replace header usage example:</h4><pre>java -jar picard.jar FixVcfHeader \\<br />     I=input.vcf \\<br />     O=fixed.vcf \\<br />     HEADER=header.vcf</pre><h4>Fix header usage example:</h4><pre>java -jar picard.jar FixVcfHeader \\<br />     I=input.vcf \\<br />     O=fixed.vcf \\<br /></pre><hr />";
    @Argument(shortName="I", doc="The input VCF/BCF file.")
    public File INPUT;
    @Argument(shortName="O", doc="The output VCF/BCF file.")
    public File OUTPUT;
    @Argument(shortName="N", doc="Check only the first N records when searching for missing INFO and FORMAT fields.", optional=true)
    public int CHECK_FIRST_N_RECORDS = -1;
    @Argument(shortName="H", doc="The replacement VCF header.", optional=true)
    public File HEADER = null;
    @Argument(doc="Enforce that the samples are the same (and in the same order) when replacing the VCF header.", optional=true)
    public boolean ENFORCE_SAME_SAMPLES = true;
    private final Log log = Log.getInstance(FixVcfHeader.class);

    public static void main(String[] args) {
        new FixVcfHeader().instanceMainWithExit(args);
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.HEADER != null && 0 <= this.CHECK_FIRST_N_RECORDS) {
            return new String[]{"CHECK_FIRST_N_RECORDS should no be specified when HEADER is specified"};
        }
        return super.customCommandLineValidation();
    }

    @Override
    protected int doWork() {
        VCFHeader outHeader;
        IOUtil.assertFileIsReadable(this.INPUT);
        if (this.HEADER != null) {
            IOUtil.assertFileIsReadable(this.HEADER);
        }
        IOUtil.assertFileIsWritable(this.OUTPUT);
        VCFFileReader reader = new VCFFileReader(this.INPUT, false);
        VCFHeader existingHeader = reader.getFileHeader();
        if (this.HEADER != null) {
            VCFFileReader headerReader = new VCFFileReader(this.HEADER, false);
            Object object = null;
            try {
                VCFHeader inputHeader = headerReader.getFileHeader();
                if (this.ENFORCE_SAME_SAMPLES) {
                    outHeader = inputHeader;
                    this.enforceSameSamples(existingHeader, outHeader);
                } else {
                    outHeader = new VCFHeader(inputHeader.getMetaDataInInputOrder(), existingHeader.getSampleNamesInOrder());
                }
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (headerReader != null) {
                    if (object != null) {
                        try {
                            headerReader.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        headerReader.close();
                    }
                }
            }
            outHeader.getFilterLines().stream().map(VCFSimpleHeaderLine::getID).filter(id -> !existingHeader.hasFilterLine((String)id)).forEach(id -> this.log.info("FILTER line found in HEADER will be added to OUTPUT: " + id));
            outHeader.getInfoHeaderLines().stream().map(VCFCompoundHeaderLine::getID).filter(id -> !existingHeader.hasInfoLine((String)id)).forEach(id -> this.log.info("INFO line found in HEADER will be added to OUTPUT: " + id));
            outHeader.getFormatHeaderLines().stream().map(VCFCompoundHeaderLine::getID).filter(id -> !existingHeader.hasInfoLine((String)id)).forEach(id -> this.log.info("FORMAT line found in HEADER will be added to OUTPUT: " + id));
        } else {
            HashMap<String, VCFFilterHeaderLine> filterHeaderLines = new HashMap<String, VCFFilterHeaderLine>();
            HashMap<String, VCFInfoHeaderLine> infoHeaderLines = new HashMap<String, VCFInfoHeaderLine>();
            HashMap<String, VCFFormatHeaderLine> formatHeaderLines = new HashMap<String, VCFFormatHeaderLine>();
            ProgressLogger progress = new ProgressLogger(this.log, 1000000, "read");
            try (VCFFileReader in = new VCFFileReader(this.INPUT, false);){
                this.log.info("Reading in records to re-build the header.");
                for (VariantContext ctx : in) {
                    for (String string : ctx.getFilters()) {
                        if (existingHeader.hasFilterLine(string) || filterHeaderLines.containsKey(string)) continue;
                        this.log.info("Will add an FILTER line with id: " + string);
                        filterHeaderLines.put(string, new VCFFilterHeaderLine(string, "Missing description: this FILTER line was added by Picard's FixVCFHeader"));
                    }
                    for (Map.Entry entry : ctx.getAttributes().entrySet()) {
                        String id2 = (String)entry.getKey();
                        if (existingHeader.hasInfoLine(id2) || infoHeaderLines.containsKey(id2)) continue;
                        this.log.info("Will add an INFO line with id: " + id2);
                        infoHeaderLines.put(id2, new VCFInfoHeaderLine(id2, VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Missing description: this INFO line was added by Picard's FixVCFHeader"));
                    }
                    for (Genotype genotype : ctx.getGenotypes()) {
                        for (Map.Entry<String, Object> attribute : genotype.getExtendedAttributes().entrySet()) {
                            String id3 = attribute.getKey();
                            if (existingHeader.hasFormatLine(id3) || formatHeaderLines.containsKey(id3)) continue;
                            this.log.info("Will add FORMAT line with id: " + id3);
                            formatHeaderLines.put(id3, new VCFFormatHeaderLine(id3, VCFHeaderLineCount.UNBOUNDED, VCFHeaderLineType.String, "Missing description: this FORMAT line was added by Picard's FixVCFHeader"));
                        }
                    }
                    progress.record(ctx.getContig(), ctx.getStart());
                    if (0 >= this.CHECK_FIRST_N_RECORDS || (long)this.CHECK_FIRST_N_RECORDS > progress.getCount()) continue;
                    break;
                }
            }
            HashSet<VCFHeaderLine> headerLines = new HashSet<VCFHeaderLine>(existingHeader.getMetaDataInInputOrder());
            VCFStandardHeaderLines.addStandardFormatLines(headerLines, false, Genotype.PRIMARY_KEYS);
            headerLines.addAll(filterHeaderLines.values());
            headerLines.addAll(infoHeaderLines.values());
            headerLines.addAll(formatHeaderLines.values());
            outHeader = new VCFHeader(headerLines, existingHeader.getSampleNamesInOrder());
            this.log.info("VCF header re-built.");
        }
        VariantContextWriter writer = new VariantContextWriterBuilder().setOption(Options.INDEX_ON_THE_FLY).setOutputFile(this.OUTPUT).unsetOption(Options.ALLOW_MISSING_FIELDS_IN_HEADER).setReferenceDictionary(outHeader.getSequenceDictionary()).build();
        writer.writeHeader(outHeader);
        this.log.info("Writing the output VCF.");
        ProgressLogger progress = new ProgressLogger(this.log, 1000000, "read");
        for (VariantContext ctx : reader) {
            writer.add(ctx);
            progress.record(ctx.getContig(), ctx.getStart());
        }
        writer.close();
        CloserUtil.close(reader);
        return 0;
    }

    private void enforceSameSamples(VCFHeader readerHeader, VCFHeader inputHeader) {
        ArrayList<String> readerSamples = readerHeader.getSampleNamesInOrder();
        ArrayList<String> inputSamples = inputHeader.getSampleNamesInOrder();
        if (readerSamples.size() != inputSamples.size()) {
            throw new PicardException("The input VCF had a different # of samples than the input VCF header.");
        }
        for (int i = 0; i < readerSamples.size(); ++i) {
            if (readerSamples.get(i).equals(inputSamples.get(i))) continue;
            throw new PicardException(String.format("Mismatch in the %dth sample: '%s' != '%s'", i, readerSamples.get(i), inputSamples.get(i)));
        }
    }
}

