/*
 * Decompiled with CFR 0.152.
 */
package picard.sam;

import htsjdk.samtools.MergingSamRecordIterator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamFileHeaderMerger;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Interval;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.ProgressLogger;
import htsjdk.samtools.util.SamRecordIntervalIteratorFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.ReadDataManipulationProgramGroup;

@CommandLineProgramProperties(summary="Merges multiple SAM and/or BAM files into a single file.  This tool is used for combining SAM and/or BAM files from different runs or read groups into a single file, similarl to the \"merge\" function of Samtools (http://www.htslib.org/doc/samtools.html).  <br /><br />Note that to prevent errors in downstream processing, it is critical to identify/label read groups appropriately. If different samples contain identical read group IDs, this tool will avoid collisions by modifying the read group IDs to be unique. For more information about read groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a> <br /><br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar MergeSamFiles \\<br />      I=input_1.bam \\<br />      I=input_2.bam \\<br />      O=output_merged_files.bam</pre><hr />", oneLineSummary="Merges multiple SAM and/or BAM files into a single file.  ", programGroup=ReadDataManipulationProgramGroup.class)
@DocumentedFeature
public class MergeSamFiles
extends CommandLineProgram {
    private static final Log log = Log.getInstance(MergeSamFiles.class);
    static final String USAGE_SUMMARY = "Merges multiple SAM and/or BAM files into a single file.  ";
    static final String USAGE_DETAILS = "This tool is used for combining SAM and/or BAM files from different runs or read groups into a single file, similarl to the \"merge\" function of Samtools (http://www.htslib.org/doc/samtools.html).  <br /><br />Note that to prevent errors in downstream processing, it is critical to identify/label read groups appropriately. If different samples contain identical read group IDs, this tool will avoid collisions by modifying the read group IDs to be unique. For more information about read groups, see the <a href='https://www.broadinstitute.org/gatk/guide/article?id=6472'>GATK Dictionary entry.</a> <br /><br /><br /><h4>Usage example:</h4><pre>java -jar picard.jar MergeSamFiles \\<br />      I=input_1.bam \\<br />      I=input_2.bam \\<br />      O=output_merged_files.bam</pre><hr />";
    @Argument(shortName="I", doc="SAM or BAM input file", minElements=1)
    public List<File> INPUT = new ArrayList<File>();
    @Argument(shortName="O", doc="SAM or BAM file to write merged result to")
    public File OUTPUT;
    @Argument(shortName="SO", doc="Sort order of output file", optional=true)
    public SAMFileHeader.SortOrder SORT_ORDER = SAMFileHeader.SortOrder.coordinate;
    @Argument(doc="If true, assume that the input files are in the same sort order as the requested output sort order, even if their headers say otherwise.", shortName="AS")
    public boolean ASSUME_SORTED = false;
    @Argument(shortName="MSD", doc="Merge the sequence dictionaries", optional=true)
    public boolean MERGE_SEQUENCE_DICTIONARIES = false;
    @Argument(doc="Option to create a background thread to encode, compress and write to disk the output file. The threaded version uses about 20% more CPU and decreases runtime by ~20% when writing out a compressed BAM file.")
    public boolean USE_THREADING = false;
    @Argument(doc="Comment(s) to include in the merged output file's header.", optional=true, shortName="CO")
    public List<String> COMMENT = new ArrayList<String>();
    @Argument(shortName="RGN", doc="An interval list file that contains the locations of the positions to merge. Assume bam are sorted and indexed. The resulting file will contain alignments that may overlap with genomic regions outside the requested region. Unmapped reads are discarded.", optional=true)
    public File INTERVALS = null;
    private static final int PROGRESS_INTERVAL = 1000000;

    public static void main(String[] argv) {
        System.exit(new MergeSamFiles().instanceMain(argv));
    }

    @Override
    protected int doWork() {
        MergingSamRecordIterator iterator;
        boolean presorted;
        boolean mergingSamRecordIteratorAssumeSorted;
        SAMFileHeader.SortOrder headerMergerSortOrder;
        boolean matchedSortOrders = true;
        List<Interval> intervalList = this.INTERVALS == null ? null : IntervalList.fromFile(this.INTERVALS).uniqued().getIntervals();
        HashMap<SamReader, CloseableIterator<SAMRecord>> samReaderToIterator = new HashMap<SamReader, CloseableIterator<SAMRecord>>(this.INPUT.size());
        ArrayList<SamReader> readers = new ArrayList<SamReader>();
        ArrayList<SAMFileHeader> headers = new ArrayList<SAMFileHeader>();
        SAMSequenceDictionary dict = null;
        for (File inFile : this.INPUT) {
            IOUtil.assertFileIsReadable(inFile);
            SamReader in = SamReaderFactory.makeDefault().referenceSequence(this.REFERENCE_SEQUENCE).open(inFile);
            if (this.INTERVALS != null) {
                if (!in.hasIndex()) {
                    throw new PicardException("Merging with interval but Bam file is not indexed " + inFile);
                }
                CloseableIterator<SAMRecord> samIterator = new SamRecordIntervalIteratorFactory().makeSamRecordIntervalIterator(in, intervalList, true);
                samReaderToIterator.put(in, samIterator);
            }
            readers.add(in);
            headers.add(in.getFileHeader());
            if (dict == null) {
                dict = in.getFileHeader().getSequenceDictionary();
            } else if (dict.equals(in.getFileHeader().getSequenceDictionary())) {
                in.getFileHeader().setSequenceDictionary(dict);
            }
            matchedSortOrders = matchedSortOrders && in.getFileHeader().getSortOrder() == this.SORT_ORDER;
        }
        IOUtil.assertFileIsWritable(this.OUTPUT);
        if (matchedSortOrders || this.SORT_ORDER == SAMFileHeader.SortOrder.unsorted || this.ASSUME_SORTED || this.INTERVALS != null) {
            log.info("Input files are in same order as output so sorting to temp directory is not needed.");
            headerMergerSortOrder = this.SORT_ORDER;
            mergingSamRecordIteratorAssumeSorted = this.ASSUME_SORTED;
            presorted = true;
        } else {
            log.info("Sorting input files using temp directory " + this.TMP_DIR);
            headerMergerSortOrder = SAMFileHeader.SortOrder.unsorted;
            mergingSamRecordIteratorAssumeSorted = false;
            presorted = false;
        }
        SamFileHeaderMerger headerMerger = new SamFileHeaderMerger(headerMergerSortOrder, headers, this.MERGE_SEQUENCE_DICTIONARIES);
        if (intervalList == null) {
            iterator = new MergingSamRecordIterator(headerMerger, readers, mergingSamRecordIteratorAssumeSorted);
        } else {
            log.info("Warning: merged bams from different interval lists may contain the same read in both files");
            iterator = new MergingSamRecordIterator(headerMerger, samReaderToIterator, true);
        }
        SAMFileHeader header = headerMerger.getMergedHeader();
        for (String comment : this.COMMENT) {
            header.addComment(comment);
        }
        header.setSortOrder(this.SORT_ORDER);
        SAMFileWriterFactory samFileWriterFactory = new SAMFileWriterFactory();
        if (this.USE_THREADING) {
            samFileWriterFactory.setUseAsyncIo(true);
        }
        SAMFileWriter out = samFileWriterFactory.makeSAMOrBAMWriter(header, presorted, this.OUTPUT);
        ProgressLogger progress = new ProgressLogger(log, 1000000);
        while (iterator.hasNext()) {
            SAMRecord record = iterator.next();
            out.addAlignment(record);
            progress.record(record);
        }
        log.info("Finished reading inputs.");
        for (CloseableIterator iter : samReaderToIterator.values()) {
            CloserUtil.close(iter);
        }
        CloserUtil.close(readers);
        out.close();
        return 0;
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.CREATE_INDEX.booleanValue() && this.SORT_ORDER != SAMFileHeader.SortOrder.coordinate) {
            return new String[]{"Can't CREATE_INDEX unless SORT_ORDER is coordinate"};
        }
        return null;
    }
}

