/*
 * Decompiled with CFR 0.152.
 */
package picard.illumina;

import htsjdk.samtools.BAMRecordCodec;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileWriter;
import htsjdk.samtools.SAMFileWriterFactory;
import htsjdk.samtools.SAMReadGroupRecord;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordQueryNameComparator;
import htsjdk.samtools.util.CollectionUtil;
import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Iso8601Date;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SortingCollection;
import htsjdk.samtools.util.StringUtil;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.help.DocumentedFeature;
import picard.PicardException;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.BaseCallingProgramGroup;
import picard.illumina.BasecallsConverter;
import picard.illumina.ClusterDataToSamConverter;
import picard.illumina.CustomAdapterPair;
import picard.illumina.IlluminaBasecallsConverter;
import picard.illumina.NewIlluminaBasecallsConverter;
import picard.illumina.parser.IlluminaFileUtil;
import picard.illumina.parser.ReadStructure;
import picard.illumina.parser.readers.BclQualityEvaluationStrategy;
import picard.util.AdapterPair;
import picard.util.IlluminaUtil;
import picard.util.TabbedTextFileWithHeaderParser;

@CommandLineProgramProperties(summary="Transforms raw Illumina sequencing data into an unmapped SAM or BAM file.<p>The IlluminaBaseCallsToSam program collects, demultiplexes, and sorts reads across all of the tiles of a lane via barcode to produce an unmapped SAM/BAM file.  An unmapped BAM file is often referred to as a uBAM.  All barcode, sample, and library data is provided in the LIBRARY_PARAMS file.  Note, this LIBRARY_PARAMS file should be formatted according to the specifications indicated below.  The following is an example of a properly formatted LIBRARY_PARAMS file:</p>BARCODE_1\tOUTPUT\tSAMPLE_ALIAS\tLIBRARY_NAME\nAAAAAAAA\tSA_AAAAAAAA.bam\tSA_AAAAAAAA\tLN_AAAAAAAA\nAAAAGAAG\tSA_AAAAGAAG.bam\tSA_AAAAGAAG\tLN_AAAAGAAG\nAACAATGG\tSA_AACAATGG.bam\tSA_AACAATGG\tLN_AACAATGG\nN\tSA_non_indexed.bam\tSA_non_indexed\tLN_NNNNNNNN\n <p>The BARCODES_DIR file is produced by the <a href='http://broadinstitute.github.io/picard/command-line-overview.html#ExtractIlluminaBarcodes'>ExtractIlluminaBarcodes</a> tool for each lane of a flow cell.</p>  <h4>Usage example:</h4><pre>java -jar picard.jar IlluminaBasecallsToSam \\<br />      BASECALLS_DIR=/BaseCalls/ \\<br />      LANE=001 \\<br />      READ_STRUCTURE=25T8B25T \\<br />      RUN_BARCODE=run15 \\<br />      IGNORE_UNEXPECTED_BARCODES=true \\<br />      LIBRARY_PARAMS=library.params </pre><hr />", oneLineSummary="Transforms raw Illumina sequencing data into an unmapped SAM or BAM file.", programGroup=BaseCallingProgramGroup.class)
@DocumentedFeature
public class IlluminaBasecallsToSam
extends CommandLineProgram {
    static final String USAGE_SUMMARY = "Transforms raw Illumina sequencing data into an unmapped SAM or BAM file.";
    static final String USAGE_DETAILS = "<p>The IlluminaBaseCallsToSam program collects, demultiplexes, and sorts reads across all of the tiles of a lane via barcode to produce an unmapped SAM/BAM file.  An unmapped BAM file is often referred to as a uBAM.  All barcode, sample, and library data is provided in the LIBRARY_PARAMS file.  Note, this LIBRARY_PARAMS file should be formatted according to the specifications indicated below.  The following is an example of a properly formatted LIBRARY_PARAMS file:</p>BARCODE_1\tOUTPUT\tSAMPLE_ALIAS\tLIBRARY_NAME\nAAAAAAAA\tSA_AAAAAAAA.bam\tSA_AAAAAAAA\tLN_AAAAAAAA\nAAAAGAAG\tSA_AAAAGAAG.bam\tSA_AAAAGAAG\tLN_AAAAGAAG\nAACAATGG\tSA_AACAATGG.bam\tSA_AACAATGG\tLN_AACAATGG\nN\tSA_non_indexed.bam\tSA_non_indexed\tLN_NNNNNNNN\n <p>The BARCODES_DIR file is produced by the <a href='http://broadinstitute.github.io/picard/command-line-overview.html#ExtractIlluminaBarcodes'>ExtractIlluminaBarcodes</a> tool for each lane of a flow cell.</p>  <h4>Usage example:</h4><pre>java -jar picard.jar IlluminaBasecallsToSam \\<br />      BASECALLS_DIR=/BaseCalls/ \\<br />      LANE=001 \\<br />      READ_STRUCTURE=25T8B25T \\<br />      RUN_BARCODE=run15 \\<br />      IGNORE_UNEXPECTED_BARCODES=true \\<br />      LIBRARY_PARAMS=library.params </pre><hr />";
    public static final String USAGE = "Generate a SAM or BAM file from data in an Illumina basecalls output directory";
    @Argument(doc="The basecalls directory. ", shortName="B")
    public File BASECALLS_DIR;
    @Argument(doc="The barcodes directory with _barcode.txt files (generated by ExtractIlluminaBarcodes). If not set, use BASECALLS_DIR. ", shortName="BCD", optional=true)
    public File BARCODES_DIR;
    @Argument(doc="Lane number. ", shortName="L")
    public Integer LANE;
    @Argument(doc="Deprecated (use LIBRARY_PARAMS).  The output SAM or BAM file. Format is determined by extension.", shortName="O", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public File OUTPUT;
    @Argument(doc="The barcode of the run.  Prefixed to read names.")
    public String RUN_BARCODE;
    @Argument(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced sample", shortName="ALIAS", mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String SAMPLE_ALIAS;
    @Argument(doc="ID used to link RG header record with RG tag in SAM record.  If these are unique in SAM files that get merged, merge performance is better.  If not specified, READ_GROUP_ID will be set to <first 5 chars of RUN_BARCODE>.<LANE> .", shortName="RG", optional=true)
    public String READ_GROUP_ID;
    @Argument(doc="Deprecated (use LIBRARY_PARAMS).  The name of the sequenced library", shortName="LIB", optional=true, mutex={"BARCODE_PARAMS", "LIBRARY_PARAMS"})
    public String LIBRARY_NAME;
    @Argument(doc="The name of the sequencing center that produced the reads.  Used to set the @RG->CN header tag.")
    public String SEQUENCING_CENTER;
    @Argument(doc="The start date of the run.", optional=true)
    public Date RUN_START_DATE;
    @Argument(doc="The name of the sequencing technology that produced the read.", optional=true)
    public String PLATFORM = "illumina";
    @Argument(doc="Whether to include the barcode information in the @RG->BC header tag. Defaults to false until included in the SAM spec.")
    public boolean INCLUDE_BC_IN_RG_TAG = false;
    @Argument(doc="A description of the logical structure of clusters in an Illumina Run, i.e. a description of the structure IlluminaBasecallsToSam assumes the  data to be in. It should consist of integer/character pairs describing the number of cycles and the type of those cycles (B for Sample Barcode, M for molecular barcode, T for Template, and S for skip).  E.g. If the input data consists of 80 base clusters and we provide a read structure of \"28T8M8B8S28T\" then the sequence may be split up into four reads:\n* read one with 28 cycles (bases) of template\n* read two with 8 cycles (bases) of molecular barcode (ex. unique molecular barcode)\n* read three with 8 cycles (bases) of sample barcode\n* 8 cycles (bases) skipped.\n* read four with 28 cycles (bases) of template\nThe skipped cycles would NOT be included in an output SAM/BAM file or in read groups therein.", shortName="RS")
    public String READ_STRUCTURE;
    @Argument(doc="Deprecated (use LIBRARY_PARAMS).  Tab-separated file for creating all output BAMs for barcoded run with single IlluminaBasecallsToSam invocation.  Columns are BARCODE, OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME.  Row with BARCODE=N is used to specify a file for no barcode match", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "LIBRARY_PARAMS"})
    public File BARCODE_PARAMS;
    @Argument(doc="Tab-separated file for creating all output BAMs for a lane with single IlluminaBasecallsToSam invocation.  The columns are OUTPUT, SAMPLE_ALIAS, and LIBRARY_NAME, BARCODE_1, BARCODE_2 ... BARCODE_X where X = number of barcodes per cluster (optional).  Row with BARCODE_1 set to 'N' is used to specify a file for no barcode match.  You may also provide any 2 letter RG header attributes (excluding PU, CN, PL, and DT)  as columns in this file and the values for those columns will be inserted into the RG tag for the BAM file created for a given row.", mutex={"OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME", "BARCODE_PARAMS"})
    public File LIBRARY_PARAMS;
    @Argument(doc="Which adapters to look for in the read.")
    public List<IlluminaUtil.IlluminaAdapterPair> ADAPTERS_TO_CHECK = new ArrayList<IlluminaUtil.IlluminaAdapterPair>(Arrays.asList(IlluminaUtil.IlluminaAdapterPair.INDEXED, IlluminaUtil.IlluminaAdapterPair.DUAL_INDEXED, IlluminaUtil.IlluminaAdapterPair.NEXTERA_V2, IlluminaUtil.IlluminaAdapterPair.FLUIDIGM));
    @Argument(doc="For specifying adapters other than standard Illumina", optional=true)
    public String FIVE_PRIME_ADAPTER;
    @Argument(doc="For specifying adapters other than standard Illumina", optional=true)
    public String THREE_PRIME_ADAPTER;
    @Argument(doc="The number of threads to run in parallel. If NUM_PROCESSORS = 0, number of cores is automatically set to the number of cores available on the machine. If NUM_PROCESSORS < 0, then the number of cores used will be the number available on the machine less NUM_PROCESSORS.")
    public Integer NUM_PROCESSORS = 0;
    @Argument(doc="If set, this is the first tile to be processed (used for debugging).  Note that tiles are not processed in numerical order.", mutex={"PROCESS_SINGLE_TILE"}, optional=true)
    public Integer FIRST_TILE;
    @Argument(doc="If set, process no more than this many tiles (used for debugging).", optional=true)
    public Integer TILE_LIMIT;
    @Argument(doc="If set, process only the tile number given and append the tile number to the output file name.", mutex={"FIRST_TILE"}, optional=true)
    public Integer PROCESS_SINGLE_TILE;
    @Argument(doc="If true, call System.gc() periodically.  This is useful in cases in which the -Xmx value passed is larger than the available memory.")
    public Boolean FORCE_GC = true;
    @Argument(doc="Apply EAMSS filtering to identify inappropriately quality scored bases towards the ends of reads and convert their quality scores to Q2.")
    public boolean APPLY_EAMSS_FILTER = true;
    @Argument(doc="Configure SortingCollections to store this many records before spilling to disk. For an indexed run, each SortingCollection gets this value/number of indices.")
    public int MAX_READS_IN_RAM_PER_TILE = 1200000;
    @Argument(doc="The minimum quality (after transforming 0s to 1s) expected from reads.  If qualities are lower than this value, an error is thrown.The default of 2 is what the Illumina's spec describes as the minimum, but in practice the value has been observed lower.")
    public int MINIMUM_QUALITY = 2;
    @Argument(doc="Whether to include non-PF reads", shortName="NONPF", optional=true)
    public boolean INCLUDE_NON_PF_READS = true;
    @Argument(doc="Whether to ignore reads whose barcodes are not found in LIBRARY_PARAMS.  Useful when outputting BAMs for only a subset of the barcodes in a lane.", shortName="IGNORE_UNEXPECTED")
    public boolean IGNORE_UNEXPECTED_BARCODES = false;
    @Argument(doc="The tag to use to store any molecular indexes.  If more than one molecular index is found, they will be concatenated and stored here.", optional=true)
    public String MOLECULAR_INDEX_TAG = "RX";
    @Argument(doc="The tag to use to store any molecular index base qualities.  If more than one molecular index is found, their qualities will be concatenated and stored here (.i.e. the number of \"M\" operators in the READ_STRUCTURE)", optional=true)
    public String MOLECULAR_INDEX_BASE_QUALITY_TAG = "QX";
    @Argument(doc="The list of tags to store each molecular index.  The number of tags should match the number of molecular indexes.", optional=true)
    public List<String> TAG_PER_MOLECULAR_INDEX;
    @Argument(doc="When should the sample barcode (as read by the sequencer) be placed on the reads in the BC tag?")
    public ClusterDataToSamConverter.PopulateBarcode BARCODE_POPULATION_STRATEGY = ClusterDataToSamConverter.PopulateBarcode.ORPHANS_ONLY;
    @Argument(doc="Should the barcode quality be included when the sample barcode is included?")
    public boolean INCLUDE_BARCODE_QUALITY = false;
    private final Map<String, SAMFileWriterWrapper> barcodeSamWriterMap = new HashMap<String, SAMFileWriterWrapper>();
    private ReadStructure readStructure;
    private BasecallsConverter<SAMRecordsForCluster> basecallsConverter;
    private static final Log log = Log.getInstance(IlluminaBasecallsToSam.class);

    @Override
    protected int doWork() {
        this.initialize();
        this.basecallsConverter.doTileProcessing();
        return 0;
    }

    private void initialize() {
        BclQualityEvaluationStrategy bclQualityEvaluationStrategy = new BclQualityEvaluationStrategy(this.MINIMUM_QUALITY);
        if (this.OUTPUT != null) {
            IOUtil.assertFileIsWritable(this.OUTPUT);
        }
        if (this.LIBRARY_PARAMS != null) {
            IOUtil.assertFileIsReadable(this.LIBRARY_PARAMS);
        }
        if (this.OUTPUT != null) {
            this.barcodeSamWriterMap.put(null, this.buildSamFileWriter(this.OUTPUT, this.SAMPLE_ALIAS, this.LIBRARY_NAME, this.buildSamHeaderParameters(null), true));
        } else {
            this.populateWritersFromLibraryParams();
        }
        int numOutputRecords = this.readStructure.templates.length();
        ArrayList<AdapterPair> adapters = new ArrayList<AdapterPair>(this.ADAPTERS_TO_CHECK);
        if (this.FIVE_PRIME_ADAPTER != null && this.THREE_PRIME_ADAPTER != null) {
            adapters.add((IlluminaUtil.IlluminaAdapterPair)((Object)new CustomAdapterPair(this.FIVE_PRIME_ADAPTER, this.THREE_PRIME_ADAPTER)));
        }
        if (IlluminaFileUtil.hasCbcls(this.BASECALLS_DIR, this.LANE)) {
            if (this.BARCODES_DIR == null) {
                this.BARCODES_DIR = this.BASECALLS_DIR;
            }
            this.basecallsConverter = new NewIlluminaBasecallsConverter<SAMRecordsForCluster>(this.BASECALLS_DIR, this.BARCODES_DIR, this.LANE, this.readStructure, this.barcodeSamWriterMap, true, Math.max(1, this.MAX_READS_IN_RAM_PER_TILE / numOutputRecords), this.TMP_DIR, this.NUM_PROCESSORS, this.FIRST_TILE, this.TILE_LIMIT, new QueryNameComparator(), new Codec(numOutputRecords), SAMRecordsForCluster.class, bclQualityEvaluationStrategy, this.IGNORE_UNEXPECTED_BARCODES);
        } else {
            this.basecallsConverter = new IlluminaBasecallsConverter<SAMRecordsForCluster>(this.BASECALLS_DIR, this.BARCODES_DIR, this.LANE, this.readStructure, this.barcodeSamWriterMap, true, this.MAX_READS_IN_RAM_PER_TILE / numOutputRecords, this.TMP_DIR, this.NUM_PROCESSORS, this.FORCE_GC, this.FIRST_TILE, this.TILE_LIMIT, new QueryNameComparator(), new Codec(numOutputRecords), SAMRecordsForCluster.class, bclQualityEvaluationStrategy, this.APPLY_EAMSS_FILTER, this.INCLUDE_NON_PF_READS, this.IGNORE_UNEXPECTED_BARCODES);
        }
        ClusterDataToSamConverter converter = new ClusterDataToSamConverter(this.RUN_BARCODE, this.READ_GROUP_ID, this.basecallsConverter.getFactory().getOutputReadStructure(), adapters, this.BARCODE_POPULATION_STRATEGY, this.INCLUDE_BARCODE_QUALITY).withMolecularIndexTag(this.MOLECULAR_INDEX_TAG).withMolecularIndexQualityTag(this.MOLECULAR_INDEX_BASE_QUALITY_TAG).withTagPerMolecularIndex(this.TAG_PER_MOLECULAR_INDEX);
        this.basecallsConverter.setConverter(converter);
        log.info("DONE_READING STRUCTURE IS " + this.readStructure.toString());
    }

    private Set<String> findAndFilterExpectedColumns(Set<String> actualCols, Set<String> expectedCols) {
        HashSet<String> missingColumns = new HashSet<String>(expectedCols);
        missingColumns.removeAll(actualCols);
        if (!missingColumns.isEmpty()) {
            throw new PicardException(String.format("LIBRARY_PARAMS file %s is missing the following columns: %s.", this.LIBRARY_PARAMS.getAbsolutePath(), StringUtil.join(", ", missingColumns)));
        }
        HashSet<String> remainingColumns = new HashSet<String>(actualCols);
        remainingColumns.removeAll(expectedCols);
        return remainingColumns;
    }

    private void checkRgTagColumns(Set<String> rgTagColumns) {
        Set<String> forbiddenHeaders = this.buildSamHeaderParameters(null).keySet();
        forbiddenHeaders.retainAll(rgTagColumns);
        if (!forbiddenHeaders.isEmpty()) {
            throw new PicardException("Illegal ReadGroup tags in library params(barcode params) file(" + this.LIBRARY_PARAMS.getAbsolutePath() + ") Offending headers = " + StringUtil.join(", ", forbiddenHeaders));
        }
        for (String column : rgTagColumns) {
            if (column.length() <= 2) continue;
            throw new PicardException("Column label (" + column + ") unrecognized.  Library params(barcode params) can only contain the columns (OUTPUT, LIBRARY_NAME, SAMPLE_ALIAS, BARCODE, BARCODE_<X> where X is a positive integer) OR two letter RG tags!");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void populateWritersFromLibraryParams() {
        TabbedTextFileWithHeaderParser libraryParamsParser = new TabbedTextFileWithHeaderParser(this.LIBRARY_PARAMS);
        Set<String> expectedColumnLabels = CollectionUtil.makeSet("OUTPUT", "SAMPLE_ALIAS", "LIBRARY_NAME");
        ArrayList<String> barcodeColumnLabels = new ArrayList<String>();
        if (this.readStructure.sampleBarcodes.length() == 1) {
            if (libraryParamsParser.hasColumn("BARCODE")) {
                barcodeColumnLabels.add("BARCODE");
            } else {
                if (!libraryParamsParser.hasColumn("BARCODE_1")) throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does not have column BARCODE or BARCODE_1.");
                barcodeColumnLabels.add("BARCODE_1");
            }
        } else {
            for (int i = 1; i <= this.readStructure.sampleBarcodes.length(); ++i) {
                barcodeColumnLabels.add("BARCODE_" + i);
            }
        }
        expectedColumnLabels.addAll(barcodeColumnLabels);
        Set<String> rgTagColumns = this.findAndFilterExpectedColumns(libraryParamsParser.columnLabels(), expectedColumnLabels);
        this.checkRgTagColumns(rgTagColumns);
        for (TabbedTextFileWithHeaderParser.Row row : libraryParamsParser) {
            String key;
            ArrayList<String> barcodeValues = null;
            if (!barcodeColumnLabels.isEmpty()) {
                barcodeValues = new ArrayList<String>();
                for (String barcodeLabel : barcodeColumnLabels) {
                    barcodeValues.add(row.getField(barcodeLabel));
                }
            }
            String string = key = barcodeValues == null || barcodeValues.contains("N") ? null : StringUtil.join("", barcodeValues);
            if (this.barcodeSamWriterMap.containsKey(key)) {
                throw new PicardException("Row for barcode " + key + " appears more than once in LIBRARY_PARAMS or BARCODE_PARAMS file " + this.LIBRARY_PARAMS);
            }
            Map<String, String> samHeaderParams = this.buildSamHeaderParameters(barcodeValues);
            for (String tagName : rgTagColumns) {
                samHeaderParams.put(tagName, row.getField(tagName));
            }
            File outputFile = new File(row.getField("OUTPUT"));
            if (this.PROCESS_SINGLE_TILE != null) {
                outputFile = new File(outputFile.getParentFile(), this.PROCESS_SINGLE_TILE + "." + outputFile.getName());
            }
            SAMFileWriterWrapper writer = this.buildSamFileWriter(outputFile, row.getField("SAMPLE_ALIAS"), row.getField("LIBRARY_NAME"), samHeaderParams, true);
            this.barcodeSamWriterMap.put(key, writer);
        }
        if (this.barcodeSamWriterMap.isEmpty()) {
            throw new PicardException("LIBRARY_PARAMS(BARCODE_PARAMS) file " + this.LIBRARY_PARAMS + " does have any data rows.");
        }
        libraryParamsParser.close();
    }

    private Map<String, String> buildSamHeaderParameters(List<String> barcodes) {
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        String platformUnit = this.RUN_BARCODE + "." + this.LANE;
        if (barcodes != null) {
            String barcodeString = IlluminaUtil.barcodeSeqsToString(barcodes);
            platformUnit = platformUnit + "." + barcodeString;
            if (this.INCLUDE_BC_IN_RG_TAG) {
                params.put("BC", barcodeString);
            }
        }
        if (this.PLATFORM != null) {
            params.put("PL", this.PLATFORM);
        }
        params.put("PU", platformUnit);
        if (this.SEQUENCING_CENTER != null) {
            params.put("CN", this.SEQUENCING_CENTER);
        }
        params.put("DT", this.RUN_START_DATE == null ? null : new Iso8601Date(this.RUN_START_DATE).toString());
        return params;
    }

    private SAMFileWriterWrapper buildSamFileWriter(File output, String sampleAlias, String libraryName, Map<String, String> headerParameters, boolean presorted) {
        IOUtil.assertFileIsWritable(output);
        SAMReadGroupRecord rg = new SAMReadGroupRecord(this.READ_GROUP_ID);
        rg.setSample(sampleAlias);
        if (libraryName != null) {
            rg.setLibrary(libraryName);
        }
        for (Map.Entry<String, String> tagNameToValue : headerParameters.entrySet()) {
            if (tagNameToValue.getValue() == null) continue;
            rg.setAttribute(tagNameToValue.getKey(), tagNameToValue.getValue());
        }
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.queryname);
        header.addReadGroup(rg);
        return new SAMFileWriterWrapper(new SAMFileWriterFactory().makeSAMOrBAMWriter(header, presorted, output));
    }

    public static void main(String[] args) {
        System.exit(new IlluminaBasecallsToSam().instanceMain(args));
    }

    @Override
    protected String[] customCommandLineValidation() {
        if (this.BARCODE_PARAMS != null) {
            this.LIBRARY_PARAMS = this.BARCODE_PARAMS;
        }
        ArrayList<String> messages = new ArrayList<String>();
        this.readStructure = new ReadStructure(this.READ_STRUCTURE);
        if (!this.readStructure.sampleBarcodes.isEmpty() && this.LIBRARY_PARAMS == null) {
            messages.add("BARCODE_PARAMS or LIBRARY_PARAMS is missing.  If READ_STRUCTURE contains a B (barcode) then either LIBRARY_PARAMS or BARCODE_PARAMS(deprecated) must be provided!");
        }
        if (this.READ_GROUP_ID == null) {
            this.READ_GROUP_ID = this.RUN_BARCODE.substring(0, 5) + "." + this.LANE;
        }
        if (!this.TAG_PER_MOLECULAR_INDEX.isEmpty() && this.TAG_PER_MOLECULAR_INDEX.size() != this.readStructure.molecularBarcode.length()) {
            messages.add("The number of tags given in TAG_PER_MOLECULAR_INDEX does not match the number of molecular indexes in READ_STRUCTURE");
        }
        if (this.FIVE_PRIME_ADAPTER == null != (this.THREE_PRIME_ADAPTER == null)) {
            messages.add("THREE_PRIME_ADAPTER and FIVE_PRIME_ADAPTER must either both be null or both be set.");
        }
        if (this.PROCESS_SINGLE_TILE != null) {
            this.TILE_LIMIT = 1;
            this.FIRST_TILE = this.PROCESS_SINGLE_TILE;
        }
        if (messages.isEmpty()) {
            return null;
        }
        return messages.toArray(new String[messages.size()]);
    }

    static class Codec
    implements SortingCollection.Codec<SAMRecordsForCluster> {
        private final BAMRecordCodec bamCodec;
        private final int numRecords;

        Codec(int numRecords, BAMRecordCodec bamCodec) {
            this.numRecords = numRecords;
            this.bamCodec = bamCodec;
        }

        Codec(int numRecords) {
            this(numRecords, new BAMRecordCodec(null));
        }

        @Override
        public void setOutputStream(OutputStream os) {
            this.bamCodec.setOutputStream(os);
        }

        @Override
        public void setInputStream(InputStream is) {
            this.bamCodec.setInputStream(is);
        }

        @Override
        public void encode(SAMRecordsForCluster val) {
            if (val.records.length != this.numRecords) {
                throw new IllegalStateException(String.format("Expected number of clusters %d != actual %d", this.numRecords, val.records.length));
            }
            for (SAMRecord rec : val.records) {
                this.bamCodec.encode(rec);
            }
        }

        @Override
        public SAMRecordsForCluster decode() {
            SAMRecord zerothRecord = this.bamCodec.decode();
            if (zerothRecord == null) {
                return null;
            }
            SAMRecordsForCluster ret = new SAMRecordsForCluster(this.numRecords);
            ret.records[0] = zerothRecord;
            for (int i = 1; i < this.numRecords; ++i) {
                ret.records[i] = this.bamCodec.decode();
                if (ret.records[i] != null) continue;
                throw new IllegalStateException(String.format("Expected to read %d records but read only %d", this.numRecords, i));
            }
            return ret;
        }

        @Override
        public SortingCollection.Codec<SAMRecordsForCluster> clone() {
            return new Codec(this.numRecords, this.bamCodec.clone());
        }
    }

    static class QueryNameComparator
    implements Comparator<SAMRecordsForCluster> {
        private final SAMRecordQueryNameComparator comparator = new SAMRecordQueryNameComparator();

        QueryNameComparator() {
        }

        @Override
        public int compare(SAMRecordsForCluster s1, SAMRecordsForCluster s2) {
            return this.comparator.compare(s1.records[0], s2.records[0]);
        }
    }

    static class SAMRecordsForCluster {
        final SAMRecord[] records;

        SAMRecordsForCluster(int numRecords) {
            this.records = new SAMRecord[numRecords];
        }
    }

    private static final class SAMFileWriterWrapper
    implements BasecallsConverter.ConvertedClusterDataWriter<SAMRecordsForCluster> {
        public final SAMFileWriter writer;

        private SAMFileWriterWrapper(SAMFileWriter writer) {
            this.writer = writer;
        }

        @Override
        public void write(SAMRecordsForCluster records) {
            for (SAMRecord rec : records.records) {
                this.writer.addAlignment(rec);
            }
        }

        @Override
        public void close() {
            this.writer.close();
        }
    }
}

