/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.IOUtil;
import htsjdk.samtools.util.Log;
import java.io.File;
import java.util.Map;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import picard.cmdline.CommandLineProgram;
import picard.cmdline.programgroups.DiagnosticsAndQCProgramGroup;
import picard.fingerprint.Fingerprint;
import picard.fingerprint.FingerprintChecker;
import picard.fingerprint.FingerprintUtils;

@CommandLineProgramProperties(summary="Computes the fingerprint genotype likelihoods from the supplied SAM/BAM file and a contamination estimate.NOTA BENE: the fingerprint is provided for the contamination (by default) for the main sample. It is given as a list of PLs at the fingerprinting sites.", oneLineSummary="Computes a fingerprint from the supplied SAM/BAM file, given a contamination estimate.", programGroup=DiagnosticsAndQCProgramGroup.class)
public class IdentifyContaminant
extends CommandLineProgram {
    @Argument(shortName="I", doc="Input SAM or BAM file.")
    public File INPUT;
    @Argument(shortName="O", doc="Output fingerprint file (VCF).")
    public File OUTPUT;
    @Argument(shortName="H", doc="A file of haplotype information. The file lists a set of SNPs, optionally arranged in high-LD blocks, to be used for fingerprinting. See https://software.broadinstitute.org/gatk/documentation/article?id=9526 for details.")
    public File HAPLOTYPE_MAP;
    @Argument(shortName="C", doc="A value of estimated contamination in the input. ", minValue=0.0, maxValue=1.0)
    public double CONTAMINATION;
    @Argument(doc="The sample alias to associate with the resulting fingerprint. When null, <SAMPLE> is extracted from the input file and \"<SAMPLE>-contamination\" is used.", optional=true)
    public String SAMPLE_ALIAS = null;
    @Argument(doc="The maximum number of reads to use as evidence for any given locus. This is provided as a way to limit the effect that any given locus may have.")
    public int LOCUS_MAX_READS = 200;
    @Argument(doc="Extract a fingerprint for the contaminated sample (instead of the contaminant). Setting to true changes the effect of SAMPLE_ALIAS when null. It names the sample in the VCF <SAMPLE>-contaminated, using the SM value from the SAM header.")
    public boolean EXTRACT_CONTAMINATED = false;
    private final Log log = Log.getInstance(IdentifyContaminant.class);

    @Override
    protected boolean requiresReference() {
        return true;
    }

    @Override
    protected int doWork() {
        Map<String, Fingerprint> fingerprintMap;
        IOUtil.assertFileIsReadable(this.INPUT);
        IOUtil.assertFileIsReadable(this.HAPLOTYPE_MAP);
        IOUtil.assertFileIsWritable(this.OUTPUT);
        IOUtil.assertFileIsReadable(this.REFERENCE_SEQUENCE);
        FingerprintChecker checker = new FingerprintChecker(this.HAPLOTYPE_MAP);
        if (this.EXTRACT_CONTAMINATED) {
            this.CONTAMINATION = 1.0 - this.CONTAMINATION;
        }
        if ((fingerprintMap = checker.identifyContaminant(this.INPUT.toPath(), this.CONTAMINATION, this.LOCUS_MAX_READS)).size() != 1) {
            this.log.error("Expected exactly 1 fingerprint, found " + fingerprintMap.size());
            throw new IllegalArgumentException("Expected exactly 1 fingerprint in Input file, found " + fingerprintMap.size());
        }
        Map.Entry<String, Fingerprint> soleEntry = fingerprintMap.entrySet().iterator().next();
        String sampleToUse = this.getSampleToUse(soleEntry.getKey());
        try {
            FingerprintUtils.writeFingerPrint(soleEntry.getValue(), this.OUTPUT, this.REFERENCE_SEQUENCE, sampleToUse, "PLs derived from " + this.INPUT + " using an assumed contamination of " + this.CONTAMINATION);
        }
        catch (Exception e) {
            this.log.error(e, new Object[0]);
        }
        return 0;
    }

    private String getSampleToUse(String fpSample) {
        if (this.SAMPLE_ALIAS == null) {
            return String.format("%s-%s", fpSample, this.EXTRACT_CONTAMINATED ? "contaminated" : "contamination");
        }
        return this.SAMPLE_ALIAS;
    }
}

