/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.samtools.util.QualityUtil;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesUsingLogLikelihoods;
import picard.fingerprint.Snp;

public class HaplotypeProbabilitiesFromSequence
extends HaplotypeProbabilitiesUsingLogLikelihoods {
    protected int obsAllele1;
    protected int obsAllele2;
    protected int obsAlleleOther;

    public HaplotypeProbabilitiesFromSequence(HaplotypeBlock haplotypeBlock) {
        super(haplotypeBlock);
    }

    @Override
    public boolean hasEvidence() {
        return super.hasEvidence() || this.obsAllele1 > 0 || this.obsAllele2 > 0;
    }

    public void addToProbs(Snp snp, byte base, byte qual) {
        this.assertSnpPartOfHaplotype(snp);
        double[] ll = this.getLogLikelihoods();
        double pError = QualityUtil.getErrorProbabilityFromPhredScore(qual);
        if (base == snp.getAllele1()) {
            ++this.obsAllele1;
            for (HaplotypeProbabilities.Genotype g : HaplotypeProbabilities.Genotype.values()) {
                double pAlt = (double)g.v / 2.0;
                int n = g.v;
                ll[n] = ll[n] + Math.log10((1.0 - pAlt) * (1.0 - pError) + pAlt * pError);
            }
        } else if (base == snp.getAllele2()) {
            ++this.obsAllele2;
            for (HaplotypeProbabilities.Genotype g : HaplotypeProbabilities.Genotype.values()) {
                double pAlt = 1.0 - (double)g.v / 2.0;
                int n = g.v;
                ll[n] = ll[n] + Math.log10((1.0 - pAlt) * (1.0 - pError) + pAlt * pError);
            }
        } else {
            ++this.obsAlleleOther;
        }
        this.setLogLikelihoods(ll);
    }

    @Override
    public void merge(HaplotypeProbabilities other) {
        super.merge(other);
        if (!this.getHaplotype().equals(other.getHaplotype())) {
            throw new IllegalArgumentException("Mismatched haplotypes in call to HaplotypeProbabilities.merge(): " + this.getHaplotype() + ", " + other.getHaplotype());
        }
        if (!(other instanceof HaplotypeProbabilitiesFromSequence)) {
            throw new IllegalArgumentException("Can only merge() HaplotypeProbabilities of same class: Tried to merge a " + this.getClass().getName() + " with a " + other.getClass().getName() + ".");
        }
        HaplotypeProbabilitiesFromSequence o = (HaplotypeProbabilitiesFromSequence)other;
        this.obsAllele1 += o.obsAllele1;
        this.obsAllele2 += o.obsAllele2;
        this.obsAlleleOther += o.obsAlleleOther;
    }

    @Override
    public int getObsAllele1() {
        return this.obsAllele1;
    }

    @Override
    public int getObsAllele2() {
        return this.obsAllele2;
    }

    @Override
    public int getTotalObs() {
        return this.obsAllele1 + this.obsAllele2 + this.obsAlleleOther;
    }

    public double getFractionUnexpectedAlleleObs() {
        return (double)this.obsAlleleOther / (double)this.getTotalObs();
    }
}

