/*
 * Decompiled with CFR 0.152.
 */
package picard.fingerprint;

import htsjdk.variant.variantcontext.Allele;
import java.util.List;
import picard.fingerprint.HaplotypeBlock;
import picard.fingerprint.HaplotypeProbabilities;
import picard.fingerprint.HaplotypeProbabilitiesUsingLogLikelihoods;
import picard.fingerprint.Snp;
import picard.util.MathUtil;

public class HaplotypeProbabilitiesFromGenotypeLikelihoods
extends HaplotypeProbabilitiesUsingLogLikelihoods {
    public HaplotypeProbabilitiesFromGenotypeLikelihoods(HaplotypeBlock haplotypeBlock) {
        super(haplotypeBlock);
    }

    public void addToLogLikelihoods(Snp snp, List<Allele> alleles, double[] logGenotypeLikelihoods) {
        this.assertSnpPartOfHaplotype(snp);
        assert (logGenotypeLikelihoods.length == HaplotypeProbabilities.Genotype.values().length);
        assert (alleles.size() == 2);
        for (int i = 0; i < 2; ++i) {
            assert (alleles.get(i).getBases().length == 1);
        }
        byte allele1 = alleles.get(0).getBases()[0];
        byte allele2 = alleles.get(1).getBases()[0];
        if (snp.getAllele1() == allele1 && snp.getAllele2() == allele2) {
            this.setLogLikelihoods(MathUtil.sum(this.getLogLikelihoods(), logGenotypeLikelihoods));
            return;
        }
        if (snp.getAllele2() == allele1 && snp.getAllele1() == allele2) {
            double[] ll = this.getLogLikelihoods();
            int n = HaplotypeProbabilities.Genotype.HOM_ALLELE1.v;
            ll[n] = ll[n] + logGenotypeLikelihoods[HaplotypeProbabilities.Genotype.HOM_ALLELE2.v];
            int n2 = HaplotypeProbabilities.Genotype.HET_ALLELE12.v;
            ll[n2] = ll[n2] + logGenotypeLikelihoods[HaplotypeProbabilities.Genotype.HET_ALLELE12.v];
            int n3 = HaplotypeProbabilities.Genotype.HOM_ALLELE2.v;
            ll[n3] = ll[n3] + logGenotypeLikelihoods[HaplotypeProbabilities.Genotype.HOM_ALLELE1.v];
            this.setLogLikelihoods(ll);
            return;
        }
    }
}

