/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.SamPairUtil;
import java.util.EnumSet;
import java.util.Set;

public class ChimeraUtil {
    public static int DEFAULT_INSERT_SIZE_LIMIT = 100000;
    public static Set<SamPairUtil.PairOrientation> DEFAULT_EXPECTED_ORIENTATIONS = EnumSet.of(SamPairUtil.PairOrientation.FR);

    public static boolean isChimeric(SAMRecord rec, int maxInsertSize, Set<SamPairUtil.PairOrientation> expectedOrientations) {
        return ChimeraUtil.isMappedPair(rec) && (Math.abs(rec.getInferredInsertSize()) > maxInsertSize || !rec.getReferenceIndex().equals(rec.getMateReferenceIndex()) || !ChimeraUtil.matchesExpectedOrientations(rec, expectedOrientations));
    }

    public static boolean isChimeric(SAMRecord r1, SAMRecord r2, int maxInsertSize, Set<SamPairUtil.PairOrientation> expectedOrientations) {
        return ChimeraUtil.isMappedPair(r1) && (Math.abs(r1.getInferredInsertSize()) > maxInsertSize || !r1.getReferenceIndex().equals(r2.getReferenceIndex()) || !ChimeraUtil.matchesExpectedOrientations(r1, expectedOrientations) || r2.getAttribute(SAMTag.SA.toString()) != null);
    }

    private static boolean isMappedPair(SAMRecord rec) {
        return rec.getReadPairedFlag() && !rec.getReadUnmappedFlag() && !rec.getMateUnmappedFlag();
    }

    private static boolean matchesExpectedOrientations(SAMRecord rec, Set<SamPairUtil.PairOrientation> expectedOrientations) {
        return expectedOrientations.contains((Object)SamPairUtil.getPairOrientation(rec)) && rec.getAttribute(SAMTag.SA.toString()) == null;
    }
}

