/*
 * Decompiled with CFR 0.152.
 */
package picard.analysis;

import htsjdk.samtools.metrics.MetricsFile;
import htsjdk.samtools.reference.ReferenceSequence;
import htsjdk.samtools.util.AbstractLocusInfo;
import htsjdk.samtools.util.AbstractRecordAndOffset;
import htsjdk.samtools.util.Histogram;
import htsjdk.samtools.util.IntervalList;
import htsjdk.samtools.util.SequenceUtil;
import picard.analysis.CollectWgsMetrics;
import picard.filter.CountingFilter;
import picard.filter.CountingPairedFilter;

public abstract class AbstractWgsMetricsCollector<T extends AbstractRecordAndOffset> {
    final CollectWgsMetrics collectWgsMetrics;
    protected final long[] unfilteredDepthHistogramArray;
    protected final long[] unfilteredBaseQHistogramArray;
    protected final long[] highQualityDepthHistogramArray;
    long basesExcludedByBaseq = 0L;
    long basesExcludedByOverlap = 0L;
    long basesExcludedByCapping = 0L;
    protected final int coverageCap;
    protected final IntervalList intervals;
    private final boolean usingStopAfter;
    protected long counter = 0L;

    AbstractWgsMetricsCollector(CollectWgsMetrics collectWgsMetrics, int coverageCap, IntervalList intervals) {
        if (coverageCap <= 0) {
            throw new IllegalArgumentException("Coverage cap must be positive.");
        }
        this.collectWgsMetrics = collectWgsMetrics;
        this.unfilteredDepthHistogramArray = new long[coverageCap + 1];
        this.highQualityDepthHistogramArray = new long[coverageCap + 1];
        this.unfilteredBaseQHistogramArray = new long[127];
        this.coverageCap = coverageCap;
        this.intervals = intervals;
        this.usingStopAfter = collectWgsMetrics.STOP_AFTER > 0L;
    }

    public abstract void addInfo(AbstractLocusInfo<T> var1, ReferenceSequence var2, boolean var3);

    public void addToMetricsFile(MetricsFile<CollectWgsMetrics.WgsMetrics, Integer> file, boolean includeBQHistogram, CountingFilter dupeFilter, CountingFilter mapqFilter, CountingPairedFilter pairFilter) {
        CollectWgsMetrics.WgsMetrics metrics = this.getMetrics(dupeFilter, mapqFilter, pairFilter);
        file.addMetric(metrics);
        file.addHistogram(this.getHighQualityDepthHistogram());
        if (includeBQHistogram) {
            this.addBaseQHistogram(file);
        }
    }

    protected void addBaseQHistogram(MetricsFile<CollectWgsMetrics.WgsMetrics, Integer> file) {
        file.addHistogram(this.getUnfilteredBaseQHistogram());
    }

    protected Histogram<Integer> getHighQualityDepthHistogram() {
        return this.getHistogram(this.highQualityDepthHistogramArray, "coverage", "high_quality_coverage_count");
    }

    protected Histogram<Integer> getUnfilteredDepthHistogram() {
        return this.getHistogram(this.unfilteredDepthHistogramArray, "coverage", "unfiltered_coverage_count");
    }

    protected Histogram<Integer> getUnfilteredBaseQHistogram() {
        return this.getHistogram(this.unfilteredBaseQHistogramArray, "baseq", "unfiltered_baseq_count");
    }

    protected Histogram<Integer> getHistogram(long[] array, String binLabel, String valueLabel) {
        Histogram<Integer> histogram = new Histogram<Integer>(binLabel, valueLabel);
        for (int i = 0; i < array.length; ++i) {
            histogram.increment(i, array[i]);
        }
        return histogram;
    }

    protected CollectWgsMetrics.WgsMetrics getMetrics(CountingFilter dupeFilter, CountingFilter mapqFilter, CountingPairedFilter pairFilter) {
        return this.collectWgsMetrics.generateWgsMetrics(this.intervals, this.getHighQualityDepthHistogram(), this.getUnfilteredDepthHistogram(), this.collectWgsMetrics.getBasesExcludedBy(mapqFilter), this.collectWgsMetrics.getBasesExcludedBy(dupeFilter), this.collectWgsMetrics.getBasesExcludedBy(pairFilter), this.basesExcludedByBaseq, this.basesExcludedByOverlap, this.basesExcludedByCapping, this.coverageCap, this.getUnfilteredBaseQHistogram(), this.collectWgsMetrics.SAMPLE_SIZE);
    }

    boolean isTimeToStop(long processedLoci) {
        return this.usingStopAfter && processedLoci > this.collectWgsMetrics.STOP_AFTER - 1L;
    }

    public void setCounter(long counter) {
        this.counter = counter;
    }

    boolean isReferenceBaseN(int position, ReferenceSequence ref) {
        byte base = ref.getBases()[position - 1];
        return SequenceUtil.isNoCall(base);
    }
}

