/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.help;

import com.sun.javadoc.ClassDoc;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.CommandLineProgramGroup;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.help.DocWorkUnitHandler;
import org.broadinstitute.barclay.help.DocumentedFeature;
import org.broadinstitute.barclay.utils.Utils;

public class DocWorkUnit
implements Comparable<DocWorkUnit> {
    protected static final Logger logger = LogManager.getLogger(DocWorkUnit.class);
    private final String name;
    private final Class<?> clazz;
    private final ClassDoc classDoc;
    private final DocWorkUnitHandler workUnitHandler;
    private final DocumentedFeature documentedFeature;
    private final CommandLineProgramProperties commandLineProperties;
    private final ExperimentalFeature experimentalFeature;
    private final BetaFeature betaFeature;
    private Map<String, Object> propertyMap = new HashMap<String, Object>();
    protected String summary;
    protected String groupName;
    protected String groupSummary;

    public DocWorkUnit(DocWorkUnitHandler workUnitHandler, DocumentedFeature documentedFeatureAnnotation, ClassDoc classDoc, Class<?> clazz) {
        Utils.nonNull(workUnitHandler, "workUnitHandler cannot be null");
        Utils.nonNull(documentedFeatureAnnotation, "DocumentedFeature annotation cannot be null");
        Utils.nonNull(classDoc, "classDoc cannot be null");
        Utils.nonNull(clazz, "class cannot be null");
        this.name = clazz.getSimpleName();
        this.documentedFeature = documentedFeatureAnnotation;
        this.commandLineProperties = clazz.getAnnotation(CommandLineProgramProperties.class);
        this.experimentalFeature = clazz.getAnnotation(ExperimentalFeature.class);
        this.betaFeature = clazz.getAnnotation(BetaFeature.class);
        this.workUnitHandler = workUnitHandler;
        this.classDoc = classDoc;
        this.clazz = clazz;
        this.summary = workUnitHandler.getSummaryForWorkUnit(this);
        this.groupName = workUnitHandler.getGroupNameForWorkUnit(this);
        this.groupSummary = workUnitHandler.getGroupSummaryForWorkUnit(this);
    }

    public Map<String, Object> getRootMap() {
        return this.propertyMap;
    }

    public void setProperty(String key, Object value) {
        this.propertyMap.put(key, value);
    }

    public Object getProperty(String key) {
        return this.propertyMap.get(key);
    }

    public DocumentedFeature getDocumentedFeature() {
        return this.documentedFeature;
    }

    public ClassDoc getClassDoc() {
        return this.classDoc;
    }

    public String getName() {
        return this.name;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public String getGroupSummary() {
        return this.groupSummary;
    }

    public String getSummary() {
        return this.summary;
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public void processDoc(List<Map<String, String>> featureMaps, List<Map<String, String>> groupMaps) {
        this.workUnitHandler.processWorkUnit(this, featureMaps, groupMaps);
    }

    public String getTemplateName() {
        return this.workUnitHandler.getTemplateName(this);
    }

    public String getTargetFileName() {
        return this.workUnitHandler.getDestinationFilename(this);
    }

    public String getJSONFileName() {
        return this.workUnitHandler.getJSONFilename(this);
    }

    public CommandLineProgramProperties getCommandLineProperties() {
        return this.commandLineProperties;
    }

    public boolean isBetaFeature() {
        return this.betaFeature != null;
    }

    public boolean isExperimentalFeature() {
        return this.experimentalFeature != null;
    }

    public CommandLineProgramGroup getCommandLineProgramGroup() {
        if (this.commandLineProperties != null) {
            try {
                return this.commandLineProperties.programGroup().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                logger.warn(String.format("Can't instantiate program group class to retrieve summary for group %s for class %s", this.commandLineProperties.programGroup().getName(), this.clazz.getName()));
            }
        }
        return null;
    }

    @Override
    public int compareTo(DocWorkUnit other) {
        return this.name.compareTo(other.name);
    }
}

