/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.barclay.argparser;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.broadinstitute.barclay.argparser.Advanced;
import org.broadinstitute.barclay.argparser.Argument;
import org.broadinstitute.barclay.argparser.ArgumentCollection;
import org.broadinstitute.barclay.argparser.BetaFeature;
import org.broadinstitute.barclay.argparser.ClassFinder;
import org.broadinstitute.barclay.argparser.CommandLineException;
import org.broadinstitute.barclay.argparser.CommandLineParser;
import org.broadinstitute.barclay.argparser.CommandLineParserOptions;
import org.broadinstitute.barclay.argparser.CommandLinePluginDescriptor;
import org.broadinstitute.barclay.argparser.CommandLineProgramProperties;
import org.broadinstitute.barclay.argparser.ExperimentalFeature;
import org.broadinstitute.barclay.argparser.Hidden;
import org.broadinstitute.barclay.argparser.PositionalArguments;
import org.broadinstitute.barclay.argparser.StrictBooleanConverter;
import org.broadinstitute.barclay.argparser.TaggedArgument;
import org.broadinstitute.barclay.argparser.TaggedArgumentParser;
import org.broadinstitute.barclay.utils.Utils;

public final class CommandLineArgumentParser
implements CommandLineParser {
    private static final int ARGUMENT_COLUMN_WIDTH = 30;
    private static final int DESCRIPTION_COLUMN_WIDTH = 90;
    private static final String ENUM_OPTION_DOC_PREFIX = "Possible values: {";
    private static final String ENUM_OPTION_DOC_SUFFIX = "} ";
    private static final String defaultUsagePreamble = "Usage: program [arguments...]\n";
    private static final String defaultUsagePreambleWithPositionalArguments = "Usage: program [arguments...] [positional-arguments...]\n";
    protected static final String BETA_PREFIX = "\n\n**BETA FEATURE - WORK IN PROGRESS**\n\n";
    protected static final String EXPERIMENTAL_PREFIX = "\n\n**EXPERIMENTAL FEATURE - USE AT YOUR OWN RISK**\n\n";
    private static final String NULL_STRING = "null";
    public static final String COMMENT = "#";
    public static final String POSITIONAL_ARGUMENTS_NAME = "Positional Argument";
    static final String COLLECTION_LIST_FILE_EXTENSION = ".args";
    private static final Logger logger = LogManager.getLogger();
    private Map<String, CommandLinePluginDescriptor<?>> pluginDescriptors = new HashMap();
    private TaggedArgumentParser tagParser = new TaggedArgumentParser();
    private final Set<String> argumentsFilesLoadedAlready = new LinkedHashSet<String>();
    private final Object callerArguments;
    private final Set<CommandLineParserOptions> parserOptions;
    private Field positionalArguments;
    private int minPositionalArguments;
    private int maxPositionalArguments;
    private Object positionalArgumentsParent;
    private List<ArgumentDefinition> argumentDefinitions = new ArrayList<ArgumentDefinition>();
    private final Map<String, ArgumentDefinition> argumentMap = new LinkedHashMap<String, ArgumentDefinition>();
    private final CommandLineProgramProperties programProperties;

    @Override
    public <T> T getPluginDescriptor(Class<T> targetDescriptor) {
        return targetDescriptor.cast(this.pluginDescriptors.get(targetDescriptor.getName()));
    }

    @Override
    public String getStandardUsagePreamble(Class<?> mainClass) {
        String preamble = "USAGE: " + mainClass.getSimpleName() + " [arguments]\n\n";
        if (mainClass.getAnnotation(ExperimentalFeature.class) != null) {
            return EXPERIMENTAL_PREFIX + preamble;
        }
        if (mainClass.getAnnotation(BetaFeature.class) != null) {
            return BETA_PREFIX + preamble;
        }
        return preamble;
    }

    private void putInArgumentMap(ArgumentDefinition arg) {
        for (String key : arg.getNames()) {
            this.argumentMap.put(key, arg);
        }
    }

    private boolean inArgumentMap(ArgumentDefinition arg) {
        for (String key : arg.getNames()) {
            if (!this.argumentMap.containsKey(key)) continue;
            return true;
        }
        return false;
    }

    private String getUsagePreamble() {
        String usagePreamble = "";
        usagePreamble = null != this.programProperties ? usagePreamble + this.programProperties.summary() : (this.positionalArguments == null ? usagePreamble + defaultUsagePreamble : usagePreamble + defaultUsagePreambleWithPositionalArguments);
        return usagePreamble;
    }

    public CommandLineArgumentParser(Object callerArguments) {
        this(callerArguments, Collections.emptyList(), Collections.emptySet());
    }

    public CommandLineArgumentParser(Object callerArguments, List<? extends CommandLinePluginDescriptor<?>> pluginDescriptors, Set<CommandLineParserOptions> parserOptions) {
        Utils.nonNull(callerArguments, "The object with command line arguments cannot be null");
        Utils.nonNull(pluginDescriptors, "The list of pluginDescriptors cannot be null");
        Utils.nonNull(parserOptions, "The set of parser options cannot be null");
        this.callerArguments = callerArguments;
        this.parserOptions = parserOptions;
        this.createArgumentDefinitions(callerArguments, null);
        this.createCommandLinePluginArgumentDefinitions(pluginDescriptors);
        if (this.callerArguments.getClass().getAnnotation(ExperimentalFeature.class) != null && this.callerArguments.getClass().getAnnotation(BetaFeature.class) != null) {
            throw new CommandLineException.CommandLineParserInternalException("Features cannot be both Beta and Experimental");
        }
        this.programProperties = this.callerArguments.getClass().getAnnotation(CommandLineProgramProperties.class);
    }

    private void createArgumentDefinitions(Object callerArguments, CommandLinePluginDescriptor<?> controllingDescriptor) {
        for (Field field : CommandLineParser.getAllFields(callerArguments.getClass())) {
            if (field.getAnnotation(Argument.class) != null && field.getAnnotation(ArgumentCollection.class) != null) {
                throw new CommandLineException.CommandLineParserInternalException("An Argument cannot be an argument collection: " + field.getName() + " in " + callerArguments.toString() + " is annotated as both.");
            }
            if (field.getAnnotation(PositionalArguments.class) != null) {
                this.handlePositionalArgumentAnnotation(field, callerArguments);
            }
            if (field.getAnnotation(Argument.class) != null) {
                this.handleArgumentAnnotation(field, callerArguments, controllingDescriptor);
            }
            if (field.getAnnotation(ArgumentCollection.class) == null) continue;
            try {
                field.setAccessible(true);
                this.createArgumentDefinitions(field.get(callerArguments), controllingDescriptor);
            }
            catch (IllegalAccessException e) {
                throw new CommandLineException.ShouldNeverReachHereException("should never reach here because we setAccessible(true)", e);
            }
        }
    }

    private void createCommandLinePluginArgumentDefinitions(List<? extends CommandLinePluginDescriptor<?>> requestedPluginDescriptors) {
        requestedPluginDescriptors.forEach(descriptor -> {
            this.pluginDescriptors.put(descriptor.getClass().getName(), (CommandLinePluginDescriptor<?>)descriptor);
            this.createArgumentDefinitions(descriptor, null);
            this.findPluginsForDescriptor((CommandLinePluginDescriptor<?>)descriptor);
        });
    }

    private void findPluginsForDescriptor(CommandLinePluginDescriptor<?> pluginDescriptor) {
        ClassFinder classFinder = new ClassFinder();
        pluginDescriptor.getPackageNames().forEach(pkg -> classFinder.find((String)pkg, pluginDescriptor.getPluginBaseClass()));
        Set<Class<?>> pluginClasses = classFinder.getClasses();
        ArrayList plugins = new ArrayList(pluginClasses.size());
        for (Class<?> c : pluginClasses) {
            if (!pluginDescriptor.includePluginClass(c)) continue;
            try {
                Object plugin = pluginDescriptor.createInstanceForPlugin(c);
                plugins.add(plugin);
                this.createArgumentDefinitions(plugin, pluginDescriptor);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new CommandLineException.CommandLineParserInternalException("Problem making an instance of plugin " + c + " Do check that the class has a non-arg constructor", e);
            }
        }
    }

    public List<ArgumentDefinition> getArgumentDefinitions() {
        return this.argumentDefinitions;
    }

    public Field getPositionalArguments() {
        return this.positionalArguments;
    }

    @Override
    public String getVersion() {
        return "Version:" + this.callerArguments.getClass().getPackage().getImplementationVersion();
    }

    private final void printArgumentUsageBlock(StringBuilder sb, String preamble, List<ArgumentDefinition> args) {
        if (args != null && !args.isEmpty()) {
            sb.append(preamble);
            args.stream().sorted(ArgumentDefinition.sortByLongName).forEach(argumentDefinition -> this.printArgumentUsage(sb, (ArgumentDefinition)argumentDefinition));
        }
    }

    @Override
    public String usage(boolean printCommon, boolean printHidden) {
        List<ArgumentDefinition> conditionalArgs;
        StringBuilder sb = new StringBuilder();
        String preamble = this.getStandardUsagePreamble(this.callerArguments.getClass()) + this.getUsagePreamble();
        sb.append(Utils.wrapParagraph(preamble, 120));
        sb.append("\n" + this.getVersion() + "\n");
        Map<Boolean, List<ArgumentDefinition>> allArgsMap = this.argumentDefinitions.stream().filter(argumentDefinition -> printCommon || !argumentDefinition.isCommon).filter(argumentDefinition -> printHidden || !argumentDefinition.isHidden).collect(Collectors.partitioningBy(a -> a.controllingDescriptor == null));
        List<ArgumentDefinition> nonPluginArgs = allArgsMap.get(true);
        if (null != nonPluginArgs && !nonPluginArgs.isEmpty()) {
            Map<Boolean, List<ArgumentDefinition>> unconditionalArgsMap = nonPluginArgs.stream().collect(Collectors.partitioningBy(a -> a.optional));
            this.printArgumentUsageBlock(sb, "\n\nRequired Arguments:\n\n", unconditionalArgsMap.get(false));
            List<ArgumentDefinition> optArgs = unconditionalArgsMap.get(true);
            if (null != optArgs && !optArgs.isEmpty()) {
                Map<Boolean, List<ArgumentDefinition>> byAdvanced = optArgs.stream().collect(Collectors.partitioningBy(a -> a.isAdvanced));
                this.printArgumentUsageBlock(sb, "\nOptional Arguments:\n\n", byAdvanced.get(false));
                this.printArgumentUsageBlock(sb, "\nAdvanced Arguments:\n\n", byAdvanced.get(true));
            }
        }
        if (null != (conditionalArgs = allArgsMap.get(false)) && !conditionalArgs.isEmpty()) {
            Map<CommandLinePluginDescriptor, List<ArgumentDefinition>> argsByControllingDescriptor = conditionalArgs.stream().collect(Collectors.groupingBy(argDef -> argDef.controllingDescriptor));
            ArrayList<CommandLinePluginDescriptor> pluginDescriptorSortedByName = new ArrayList<CommandLinePluginDescriptor>(argsByControllingDescriptor.keySet());
            pluginDescriptorSortedByName.sort((a, b) -> String.CASE_INSENSITIVE_ORDER.compare(a.getDisplayName(), b.getDisplayName()));
            for (CommandLinePluginDescriptor descriptor : pluginDescriptorSortedByName) {
                sb.append("Conditional Arguments for " + descriptor.getDisplayName() + ":\n\n");
                Map<String, List<ArgumentDefinition>> byPlugin = argsByControllingDescriptor.get(descriptor).stream().collect(Collectors.groupingBy(argDef -> argDef.parent.getClass().getSimpleName()));
                ArrayList<String> sortedPluginNames = new ArrayList<String>(byPlugin.keySet());
                sortedPluginNames.sort(String.CASE_INSENSITIVE_ORDER);
                for (String pluginName : sortedPluginNames) {
                    this.printArgumentUsageBlock(sb, "Valid only if \"" + pluginName + "\" is specified:\n", byPlugin.get(pluginName));
                }
            }
        }
        return sb.toString();
    }

    @Override
    public boolean parseArguments(PrintStream messageStream, String[] args) {
        OptionSet parsedArguments;
        args = this.tagParser.preprocessTaggedOptions(args);
        OptionParser parser = new OptionParser(false);
        for (ArgumentDefinition arg : this.argumentDefinitions) {
            OptionSpecBuilder bld = parser.acceptsAll(arg.getNames(), arg.doc);
            if (arg.isFlag()) {
                bld.withOptionalArg().withValuesConvertedBy(new StrictBooleanConverter());
                continue;
            }
            bld.withRequiredArg();
        }
        if (this.positionalArguments != null) {
            parser.nonOptions();
        }
        try {
            parsedArguments = parser.parse(args);
        }
        catch (OptionException e) {
            throw new CommandLineException(e.getMessage());
        }
        if (parsedArguments.has("arguments_file")) {
            List argfiles = parsedArguments.valuesOf("arguments_file").stream().map(f -> (String)f).collect(Collectors.toList());
            List<String> newargs = argfiles.stream().distinct().filter(file -> !this.argumentsFilesLoadedAlready.contains(file)).flatMap(file -> this.loadArgumentsFile((String)file).stream()).collect(Collectors.toList());
            this.argumentsFilesLoadedAlready.addAll(argfiles);
            if (!newargs.isEmpty()) {
                newargs.addAll(Arrays.asList(args));
                return this.parseArguments(messageStream, newargs.toArray(new String[newargs.size()]));
            }
        }
        if (this.isSpecialFlagSet(parsedArguments, "help")) {
            messageStream.print(this.usage(true, this.isSpecialFlagSet(parsedArguments, "showHidden")));
            return false;
        }
        if (this.isSpecialFlagSet(parsedArguments, "version")) {
            messageStream.println(this.getVersion());
            return false;
        }
        for (OptionSpec<?> optSpec : parsedArguments.asMap().keySet()) {
            if (!parsedArguments.has(optSpec)) continue;
            ArgumentDefinition argDef = this.argumentMap.get(optSpec.options().get(0));
            this.setArgument(argDef, optSpec.values(parsedArguments));
        }
        for (OptionSpec<?> arg : parsedArguments.nonOptionArguments()) {
            this.setPositionalArgument((String)((Object)arg));
        }
        this.assertArgumentsAreValid();
        return true;
    }

    private boolean isSpecialFlagSet(OptionSet parsedArguments, String flagName) {
        if (parsedArguments.has(flagName)) {
            Object value = parsedArguments.valueOf(flagName);
            return value == null || !value.equals("false");
        }
        return false;
    }

    private void assertArgumentsAreValid() {
        this.validatePluginArguments();
        try {
            Collection c;
            for (ArgumentDefinition argumentDefinition : this.argumentDefinitions) {
                Collection c2;
                String fullName = argumentDefinition.getLongName();
                StringBuilder mutextArgumentNames = new StringBuilder();
                for (String mutexArgument : argumentDefinition.mutuallyExclusive) {
                    ArgumentDefinition mutextArgumentDef = this.argumentMap.get(mutexArgument);
                    if (mutextArgumentDef == null || !mutextArgumentDef.hasBeenSet) continue;
                    mutextArgumentNames.append(" ").append(mutextArgumentDef.getLongName());
                }
                if (argumentDefinition.hasBeenSet && mutextArgumentNames.length() > 0) {
                    throw new CommandLineException("Argument '" + fullName + "' cannot be used in conjunction with argument(s)" + mutextArgumentNames.toString());
                }
                if (!(argumentDefinition.isCollection && !argumentDefinition.optional ? (c2 = (Collection)argumentDefinition.getFieldValue()).isEmpty() && mutextArgumentNames.length() == 0 : !argumentDefinition.optional && !argumentDefinition.hasBeenSet && mutextArgumentNames.length() == 0)) continue;
                throw new CommandLineException.MissingArgument(fullName, this.getArgRequiredErrorMessage(argumentDefinition));
            }
            if (this.positionalArguments != null && (c = (Collection)this.positionalArguments.get(this.positionalArgumentsParent)).size() < this.minPositionalArguments) {
                throw new CommandLineException.MissingArgument(POSITIONAL_ARGUMENTS_NAME, "At least " + this.minPositionalArguments + " positional arguments must be specified.");
            }
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.ShouldNeverReachHereException("Should never happen", e);
        }
    }

    private String getArgRequiredErrorMessage(ArgumentDefinition argumentDefinition) {
        return "Argument '" + argumentDefinition.getLongName() + "' is required" + (argumentDefinition.mutuallyExclusive.isEmpty() ? "." : " unless any of " + argumentDefinition.mutuallyExclusive + " are specified.");
    }

    private void validatePluginArguments() {
        ArrayList<ArgumentDefinition> actualArgumentDefinitions = new ArrayList<ArgumentDefinition>();
        for (ArgumentDefinition argumentDefinition : this.argumentDefinitions) {
            if (!argumentDefinition.isControlledByPlugin()) {
                actualArgumentDefinitions.add(argumentDefinition);
                continue;
            }
            boolean isAllowed = argumentDefinition.controllingDescriptor.isDependentArgumentAllowed(argumentDefinition.parent.getClass());
            if (argumentDefinition.hasBeenSet) {
                if (!isAllowed) {
                    throw new CommandLineException(String.format("Argument \"%s/%s\" is only valid when the argument \"%s\" is specified", argumentDefinition.shortName, argumentDefinition.getLongName(), argumentDefinition.parent.getClass().getSimpleName()));
                }
                actualArgumentDefinitions.add(argumentDefinition);
                continue;
            }
            if (!isAllowed) continue;
            actualArgumentDefinitions.add(argumentDefinition);
        }
        this.argumentDefinitions = actualArgumentDefinitions;
        this.pluginDescriptors.entrySet().forEach(e -> ((CommandLinePluginDescriptor)e.getValue()).validateAndResolvePlugins());
    }

    private void checkArgumentRange(ArgumentDefinition argumentDefinition, Object argumentValue) {
        Double argumentDoubleValue;
        if (!Number.class.isAssignableFrom(argumentDefinition.type)) {
            return;
        }
        Double d = argumentDoubleValue = argumentValue == null ? null : Double.valueOf(((Number)argumentValue).doubleValue());
        if (argumentDefinition.hasBoundedRange() && CommandLineArgumentParser.isOutOfRange(argumentDefinition.minValue, argumentDefinition.maxValue, argumentDoubleValue)) {
            throw new CommandLineException.OutOfRangeArgumentValue(argumentDefinition.getLongName(), argumentDefinition.minValue, argumentDefinition.maxValue, argumentValue);
        }
        if (argumentDefinition.hasRecommendedRange() && CommandLineArgumentParser.isOutOfRange(argumentDefinition.minRecommendedValue, argumentDefinition.maxRecommendedValue, argumentDoubleValue)) {
            boolean outMaxValue;
            boolean outMinValue = argumentDefinition.minRecommendedValue != Double.NEGATIVE_INFINITY;
            boolean bl = outMaxValue = argumentDefinition.maxRecommendedValue != Double.POSITIVE_INFINITY;
            if (outMinValue && outMaxValue) {
                logger.warn("Argument --{} has value {}, but recommended within range ({},{})", argumentDefinition.getLongName(), argumentDoubleValue, argumentDefinition.minRecommendedValue, argumentDefinition.maxRecommendedValue);
            } else if (outMinValue) {
                logger.warn("Argument --{} has value {}, but minimum recommended is {}", argumentDefinition.getLongName(), argumentDoubleValue, argumentDefinition.minRecommendedValue);
            } else if (outMaxValue) {
                logger.warn("Argument --{} has value {}, but maximum recommended is {}", argumentDefinition.getLongName(), argumentDoubleValue, argumentDefinition.maxRecommendedValue);
            }
        }
    }

    private static boolean isOutOfRange(double minValue, double maxValue, Double value) {
        return value == null || minValue != Double.NEGATIVE_INFINITY && value < minValue || maxValue != Double.POSITIVE_INFINITY && value > maxValue;
    }

    private static boolean isInfinityOrMathematicalInteger(double value) {
        return Double.isInfinite(value) || value == Math.rint(value);
    }

    private void setPositionalArgument(String stringValue) {
        Collection c;
        if (this.positionalArguments == null) {
            throw new CommandLineException("Invalid argument '" + stringValue + "'.");
        }
        Object value = this.constructFromString(CommandLineParser.getUnderlyingType(this.positionalArguments), stringValue, POSITIONAL_ARGUMENTS_NAME);
        try {
            c = (Collection)this.positionalArguments.get(this.callerArguments);
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.ShouldNeverReachHereException(e);
        }
        if (c.size() >= this.maxPositionalArguments) {
            throw new CommandLineException("No more than " + this.maxPositionalArguments + " positional arguments may be specified on the command line.");
        }
        c.add(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setArgument(ArgumentDefinition argumentDefinition, List<String> values) {
        if (argumentDefinition.isFlag() && values.isEmpty()) {
            argumentDefinition.hasBeenSet = true;
            argumentDefinition.setFieldValue(true);
            return;
        }
        if (!argumentDefinition.isCollection && (argumentDefinition.hasBeenSet || values.size() > 1)) {
            throw new CommandLineException("Argument '" + argumentDefinition.getNames() + "' cannot be specified more than once.");
        }
        if (argumentDefinition.isCollection) {
            if (!this.parserOptions.contains((Object)CommandLineParserOptions.APPEND_TO_COLLECTIONS)) {
                Collection c = (Collection)argumentDefinition.getFieldValue();
                c.clear();
            }
            values = this.expandListFile(values);
        }
        for (int i = 0; i < values.size(); ++i) {
            Object value;
            String stringValue = values.get(i);
            if (stringValue.equals(NULL_STRING)) {
                if (argumentDefinition.isCollection && i != 0) {
                    logger.warn("A \"null\" value was detected for an option after values for that option were already set. Clobbering previously set values for this option: " + argumentDefinition.getNames() + ".");
                }
                if (!argumentDefinition.optional) throw new CommandLineException("Non \"null\" value must be provided for '" + argumentDefinition.getNames() + "'.");
                value = null;
            } else {
                Pair<String, String> taggedOptionPair = this.tagParser.getTaggedOptionForSurrogate(stringValue);
                if (TaggedArgument.class.isAssignableFrom(argumentDefinition.type)) {
                    value = this.constructFromString(CommandLineParser.getUnderlyingType(argumentDefinition.field), taggedOptionPair == null ? stringValue : taggedOptionPair.getRight(), argumentDefinition.getLongName());
                    TaggedArgument taggedArgument = (TaggedArgument)value;
                    this.tagParser.populateArgumentTags(taggedArgument, argumentDefinition.getLongName(), taggedOptionPair == null ? null : taggedOptionPair.getLeft());
                } else {
                    if (taggedOptionPair != null) throw new CommandLineException(String.format("The argument: \"%s/%s\" does not accept tags: \"%s\"", argumentDefinition.shortName, argumentDefinition.fullName, taggedOptionPair.getLeft()));
                    value = this.constructFromString(CommandLineParser.getUnderlyingType(argumentDefinition.field), stringValue, argumentDefinition.getLongName());
                }
            }
            this.checkArgumentRange(argumentDefinition, value);
            if (argumentDefinition.isCollection) {
                Collection c = (Collection)argumentDefinition.getFieldValue();
                if (value == null) {
                    c.clear();
                } else {
                    c.add(value);
                }
                argumentDefinition.hasBeenSet = true;
                continue;
            }
            argumentDefinition.setFieldValue(value);
            argumentDefinition.hasBeenSet = true;
        }
    }

    private List<String> expandListFile(List<String> originalValues) {
        ArrayList<String> expandedValues = new ArrayList<String>(originalValues.size());
        for (String stringValue : originalValues) {
            if (stringValue.endsWith(COLLECTION_LIST_FILE_EXTENSION)) {
                expandedValues.addAll(this.loadCollectionListFile(stringValue));
                continue;
            }
            expandedValues.add(stringValue);
        }
        return expandedValues;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> loadCollectionListFile(String collectionListFile) {
        try (BufferedReader reader = new BufferedReader(new FileReader(collectionListFile));){
            List<String> list = reader.lines().map(String::trim).filter(line -> !line.isEmpty()).filter(line -> !line.startsWith(COMMENT)).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new CommandLineException("I/O error loading list file:" + collectionListFile, e);
        }
    }

    private List<String> loadArgumentsFile(String argumentsFile) {
        ArrayList<String> args = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new FileReader(argumentsFile));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith(COMMENT) || line.trim().isEmpty()) continue;
                args.addAll(Arrays.asList(StringUtils.split(line)));
            }
        }
        catch (IOException e) {
            throw new CommandLineException("I/O error loading arguments file:" + argumentsFile, e);
        }
        return args;
    }

    private void printArgumentUsage(StringBuilder sb, ArgumentDefinition argumentDefinition) {
        this.printArgumentParamUsage(sb, argumentDefinition.getLongName(), argumentDefinition.shortName, CommandLineParser.getUnderlyingType(argumentDefinition.field).getSimpleName(), this.makeArgumentDescription(argumentDefinition));
    }

    private void printArgumentParamUsage(StringBuilder sb, String name, String shortName, String type, String argumentDescription) {
        String argumentLabel = name;
        if (type != null) {
            argumentLabel = "--" + argumentLabel;
        }
        if (!shortName.isEmpty()) {
            argumentLabel = argumentLabel + ",-" + shortName;
        }
        argumentLabel = argumentLabel + ":" + type;
        sb.append(argumentLabel);
        int numSpaces = 30 - argumentLabel.length();
        if (argumentLabel.length() > 30) {
            sb.append("\n");
            numSpaces = 30;
        }
        this.printSpaces(sb, numSpaces);
        String wrappedDescription = Utils.wrapParagraph(argumentDescription, 90);
        String[] descriptionLines = wrappedDescription.split("\n");
        for (int i = 0; i < descriptionLines.length; ++i) {
            if (i > 0) {
                this.printSpaces(sb, 30);
            }
            sb.append(descriptionLines[i]);
            sb.append("\n");
        }
        sb.append("\n");
    }

    private String makeArgumentDescription(ArgumentDefinition argumentDefinition) {
        StringBuilder sb = new StringBuilder();
        if (!argumentDefinition.doc.isEmpty()) {
            sb.append(argumentDefinition.doc);
            sb.append("  ");
        }
        if (argumentDefinition.isCollection) {
            if (argumentDefinition.optional) {
                sb.append("This argument may be specified 0 or more times. ");
            } else {
                sb.append("This argument must be specified at least once. ");
            }
        }
        if (argumentDefinition.optional) {
            sb.append("Default value: ");
            sb.append(argumentDefinition.defaultValue);
            sb.append(". ");
        } else {
            sb.append("Required. ");
        }
        this.usageForPluginDescriptorArgumentIfApplicable(argumentDefinition, sb);
        if (!argumentDefinition.mutuallyExclusive.isEmpty()) {
            sb.append(" Cannot be used in conjuction with argument(s)");
            for (String argument : argumentDefinition.mutuallyExclusive) {
                ArgumentDefinition mutextArgumentDefinition = this.argumentMap.get(argument);
                if (mutextArgumentDefinition == null) {
                    throw new CommandLineException("Invalid argument definition in source code.  " + argument + " doesn't match any known argument.");
                }
                sb.append(" ").append(mutextArgumentDefinition.fieldName);
                if (mutextArgumentDefinition.shortName.isEmpty()) continue;
                sb.append(" (").append(mutextArgumentDefinition.shortName).append(")");
            }
        }
        return sb.toString();
    }

    private void usageForPluginDescriptorArgumentIfApplicable(ArgumentDefinition argDef, StringBuilder sb) {
        if (CommandLineParser.getUnderlyingType(argDef.field).equals(String.class)) {
            for (CommandLinePluginDescriptor<?> descriptor : this.pluginDescriptors.values()) {
                Set<String> allowedValues = descriptor.getAllowedValuesForDescriptorHelp(argDef.getLongName());
                if (allowedValues == null) continue;
                if (allowedValues.isEmpty()) {
                    sb.append("Any value allowed");
                } else {
                    sb.append("Possible Values: {");
                    sb.append(String.join((CharSequence)", ", allowedValues.stream().sorted(String::compareToIgnoreCase).collect(Collectors.toList())));
                    sb.append("}");
                }
                return;
            }
        }
        sb.append(this.getOptions(CommandLineParser.getUnderlyingType(argDef.field)));
    }

    private String getBooleanOptions() {
        return String.format("%s%s, %s%s", ENUM_OPTION_DOC_PREFIX, Boolean.TRUE, Boolean.FALSE, ENUM_OPTION_DOC_SUFFIX);
    }

    private <T extends Enum<T>, U extends Enum<U>> String getEnumOptions(Class<T> clazz) {
        Enum[] enumConstants = (Enum[])clazz.getEnumConstants();
        if (enumConstants.length == 0) {
            throw new CommandLineException(String.format("Bad argument enum type '%s' with no options", clazz.getName()));
        }
        if (CommandLineParser.ClpEnum.class.isAssignableFrom(clazz)) {
            Enum[] clpEnumCastedConstants = enumConstants;
            return this.getEnumOptionsWithDescription(clpEnumCastedConstants);
        }
        return this.getEnumOptionsWithoutDescription(enumConstants);
    }

    private <T extends Enum<T>> String getEnumOptionsWithoutDescription(T[] enumConstants) {
        return Stream.of(enumConstants).map(Enum::name).collect(Collectors.joining(", ", ENUM_OPTION_DOC_PREFIX, ENUM_OPTION_DOC_SUFFIX));
    }

    private <T extends Enum<T>> String getEnumOptionsWithDescription(T[] enumConstants) {
        String optionsString = Stream.of(enumConstants).map(c -> String.format("%s (%s)", c.name(), ((CommandLineParser.ClpEnum)((Object)c)).getHelpDoc())).collect(Collectors.joining("\n"));
        return String.join((CharSequence)"\n", ENUM_OPTION_DOC_PREFIX, optionsString, ENUM_OPTION_DOC_SUFFIX);
    }

    private String getOptions(Class<?> clazz) {
        if (clazz == Boolean.class) {
            return this.getBooleanOptions();
        }
        if (clazz.isEnum()) {
            Class<?> enumClass = clazz;
            return this.getEnumOptions(enumClass);
        }
        return "";
    }

    private void printSpaces(StringBuilder sb, int numSpaces) {
        for (int i = 0; i < numSpaces; ++i) {
            sb.append(" ");
        }
    }

    private void handleArgumentAnnotation(Field field, Object parent, CommandLinePluginDescriptor<?> controllingDescriptor) {
        try {
            field.setAccessible(true);
            Argument argumentAnnotation = field.getAnnotation(Argument.class);
            boolean isCollection = CommandLineArgumentParser.isCollectionField(field);
            if (isCollection) {
                field.setAccessible(true);
                if (field.get(parent) == null) {
                    this.createCollection(field, parent, "@Argument");
                }
            }
            if (!this.canBeMadeFromString(CommandLineParser.getUnderlyingType(field))) {
                throw new CommandLineException.CommandLineParserInternalException("@Argument member \"" + field.getName() + "\" must have a String constructor or be an enum");
            }
            ArgumentDefinition argumentDefinition = new ArgumentDefinition(field, argumentAnnotation, parent, controllingDescriptor);
            for (String argument : argumentAnnotation.mutex()) {
                ArgumentDefinition mutextArgumentDef = this.argumentMap.get(argument);
                if (mutextArgumentDef == null) continue;
                mutextArgumentDef.mutuallyExclusive.add(this.getArgumentNameForMutex(field, argumentAnnotation));
            }
            if (this.inArgumentMap(argumentDefinition)) {
                throw new CommandLineException.CommandLineParserInternalException(argumentDefinition.getNames() + " has already been used.");
            }
            this.putInArgumentMap(argumentDefinition);
            this.argumentDefinitions.add(argumentDefinition);
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.ShouldNeverReachHereException("We should not have reached here because we set accessible to true", e);
        }
    }

    private String getArgumentNameForMutex(Field field, Argument argumentAnnotation) {
        if (!argumentAnnotation.fullName().isEmpty()) {
            return argumentAnnotation.fullName();
        }
        if (!argumentAnnotation.shortName().isEmpty()) {
            return argumentAnnotation.shortName();
        }
        return field.getName();
    }

    private void handlePositionalArgumentAnnotation(Field field, Object parent) {
        if (this.positionalArguments != null) {
            throw new CommandLineException.CommandLineParserInternalException("@PositionalArguments cannot be used more than once in an argument class.");
        }
        field.setAccessible(true);
        this.positionalArguments = field;
        this.positionalArgumentsParent = parent;
        if (!CommandLineArgumentParser.isCollectionField(field)) {
            throw new CommandLineException.CommandLineParserInternalException("@PositionalArguments must be applied to a Collection");
        }
        if (!this.canBeMadeFromString(CommandLineParser.getUnderlyingType(field))) {
            throw new CommandLineException.CommandLineParserInternalException("@PositionalParameters member " + field.getName() + "does not have a String ctor");
        }
        PositionalArguments positionalArgumentsAnnotation = field.getAnnotation(PositionalArguments.class);
        this.minPositionalArguments = positionalArgumentsAnnotation.minElements();
        this.maxPositionalArguments = positionalArgumentsAnnotation.maxElements();
        if (this.minPositionalArguments > this.maxPositionalArguments) {
            throw new CommandLineException.CommandLineParserInternalException("In @PositionalArguments, minElements cannot be > maxElements");
        }
        try {
            field.setAccessible(true);
            if (field.get(parent) == null) {
                this.createCollection(field, parent, "@PositionalParameters");
            }
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.ShouldNeverReachHereException("We should not have reached here because we set accessible to true", e);
        }
    }

    private static boolean isCollectionField(Field field) {
        try {
            field.getType().asSubclass(Collection.class);
            return true;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private void createCollection(Field field, Object callerArguments, String annotationType) throws IllegalAccessException {
        try {
            field.set(callerArguments, field.getType().newInstance());
        }
        catch (Exception ex) {
            try {
                field.set(callerArguments, new ArrayList());
            }
            catch (IllegalArgumentException e) {
                throw new CommandLineException.CommandLineParserInternalException("In collection " + annotationType + " member " + field.getName() + " cannot be constructed or auto-initialized with ArrayList, so collection must be initialized explicitly.");
            }
        }
    }

    private boolean canBeMadeFromString(Class<?> clazz) {
        if (clazz.isEnum()) {
            return true;
        }
        try {
            clazz.getDeclaredConstructor(String.class);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Object constructFromString(Class clazz, String s, String argumentName) {
        try {
            if (clazz.isEnum()) {
                try {
                    return Enum.valueOf(clazz, s);
                }
                catch (IllegalArgumentException e) {
                    throw new CommandLineException.BadArgumentValue(argumentName, s, "'" + s + "' is not a valid value for " + clazz.getSimpleName() + ". " + this.getEnumOptions(clazz));
                }
            }
            Constructor ctor = clazz.getDeclaredConstructor(String.class);
            ctor.setAccessible(true);
            return ctor.newInstance(s);
        }
        catch (NoSuchMethodException e) {
            throw new CommandLineException.ShouldNeverReachHereException("Cannot find string ctor for " + clazz.getName(), e);
        }
        catch (InstantiationException e) {
            throw new CommandLineException.CommandLineParserInternalException("Abstract class '" + clazz.getSimpleName() + "'cannot be used for an argument value type.", e);
        }
        catch (IllegalAccessException e) {
            throw new CommandLineException.CommandLineParserInternalException("String constructor for argument value type '" + clazz.getSimpleName() + "' must be public.", e);
        }
        catch (InvocationTargetException e) {
            throw new CommandLineException.BadArgumentValue(argumentName, s, "Problem constructing " + clazz.getSimpleName() + " from the string '" + s + "'.");
        }
    }

    @Override
    public String getCommandLine() {
        String toolName = this.callerArguments.getClass().getSimpleName();
        StringBuilder commandLineString = new StringBuilder();
        if (this.positionalArguments != null) {
            List positionalArgs;
            try {
                this.positionalArguments.setAccessible(true);
                positionalArgs = (List)this.positionalArguments.get(this.positionalArgumentsParent);
            }
            catch (IllegalAccessException e) {
                throw new CommandLineException.ShouldNeverReachHereException("Should never reach here because we setAccessible(true)", e);
            }
            for (Object posArg : positionalArgs) {
                commandLineString.append(" ").append(posArg.toString());
            }
        }
        commandLineString.append(this.argumentDefinitions.stream().filter(argumentDefinition -> argumentDefinition.hasBeenSet).map(ArgumentDefinition::toCommandLineString).collect(Collectors.joining(" ", " ", "  "))).append(this.argumentDefinitions.stream().filter(argumentDefinition -> !argumentDefinition.hasBeenSet && !argumentDefinition.defaultValue.equals(NULL_STRING)).map(ArgumentDefinition::toCommandLineString).collect(Collectors.joining(" ")));
        return toolName + " " + commandLineString.toString();
    }

    public static class ArgumentDefinition {
        public final Field field;
        public final Class<?> type;
        final String fieldName;
        public final String fullName;
        public final String shortName;
        public final String doc;
        public final boolean optional;
        final boolean isCollection;
        public final String defaultValue;
        public final boolean isCommon;
        boolean hasBeenSet = false;
        public final Set<String> mutuallyExclusive;
        public final Object parent;
        final boolean isSpecial;
        final boolean isSensitive;
        public final CommandLinePluginDescriptor<?> controllingDescriptor;
        final Double maxValue;
        final Double minValue;
        final Double maxRecommendedValue;
        final Double minRecommendedValue;
        final boolean isHidden;
        final boolean isAdvanced;
        public static Comparator<ArgumentDefinition> sortByLongName = (argDef1, argDef2) -> String.CASE_INSENSITIVE_ORDER.compare(argDef1.getLongName(), argDef2.getLongName());

        public ArgumentDefinition(Field field, Argument annotation, Object parent, CommandLinePluginDescriptor<?> controllingDescriptor) {
            this.field = field;
            this.fieldName = field.getName();
            this.parent = parent;
            this.fullName = annotation.fullName();
            this.shortName = annotation.shortName();
            this.doc = annotation.doc();
            this.isCollection = CommandLineArgumentParser.isCollectionField(field);
            this.isCommon = annotation.common();
            this.isSpecial = annotation.special();
            this.isSensitive = annotation.sensitive();
            this.mutuallyExclusive = new LinkedHashSet<String>(Arrays.asList(annotation.mutex()));
            this.controllingDescriptor = controllingDescriptor;
            Object tmpDefault = this.getFieldValue();
            this.defaultValue = tmpDefault != null ? (this.isCollection && ((Collection)tmpDefault).isEmpty() ? CommandLineArgumentParser.NULL_STRING : tmpDefault.toString()) : CommandLineArgumentParser.NULL_STRING;
            this.optional = annotation.optional() || !this.defaultValue.equals(CommandLineArgumentParser.NULL_STRING);
            this.maxValue = annotation.maxValue();
            this.minValue = annotation.minValue();
            this.maxRecommendedValue = annotation.maxRecommendedValue();
            this.minRecommendedValue = annotation.minRecommendedValue();
            this.type = CommandLineParser.getUnderlyingType(this.field);
            if (!Number.class.isAssignableFrom(this.type) && (this.hasBoundedRange() || this.hasRecommendedRange())) {
                throw new CommandLineException.CommandLineParserInternalException(String.format("Min/max value ranges can only be set for numeric arguments. Argument --%s has a minimum or maximum value but has a non-numeric type.", this.getLongName()));
            }
            if (!(!Integer.class.isAssignableFrom(this.type) || CommandLineArgumentParser.isInfinityOrMathematicalInteger(this.maxValue) && CommandLineArgumentParser.isInfinityOrMathematicalInteger(this.minValue) && CommandLineArgumentParser.isInfinityOrMathematicalInteger(this.maxRecommendedValue) && CommandLineArgumentParser.isInfinityOrMathematicalInteger(this.minRecommendedValue))) {
                throw new CommandLineException.CommandLineParserInternalException(String.format("Integer argument --%s has a minimum or maximum attribute with a non-integral value.", this.getLongName()));
            }
            boolean bl = this.isHidden = field.getAnnotation(Hidden.class) != null;
            if (this.isHidden && !this.optional) {
                throw new CommandLineException.CommandLineParserInternalException(String.format("A required argument cannot be annotated with @Hidden: %s", this.getLongName()));
            }
            boolean bl2 = this.isAdvanced = field.getAnnotation(Advanced.class) != null;
            if (this.isAdvanced && !this.optional) {
                throw new CommandLineException.CommandLineParserInternalException(String.format("A required argument cannot be annotated with @Advanced: %s", this.getLongName()));
            }
        }

        public Object getFieldValue() {
            try {
                this.field.setAccessible(true);
                return this.field.get(this.parent);
            }
            catch (IllegalAccessException e) {
                throw new CommandLineException.ShouldNeverReachHereException("This shouldn't happen since we setAccessible(true).", e);
            }
        }

        public void setFieldValue(Object value) {
            try {
                this.field.setAccessible(true);
                this.field.set(this.parent, value);
            }
            catch (IllegalAccessException e) {
                throw new CommandLineException.ShouldNeverReachHereException("BUG: couldn't set field value. For " + this.fieldName + " in " + this.parent.toString() + " with value " + value.toString() + " This shouldn't happen since we setAccessible(true)", e);
            }
        }

        public boolean isFlag() {
            return this.field.getType().equals(Boolean.TYPE) || this.field.getType().equals(Boolean.class);
        }

        private boolean hasBoundedRange() {
            return this.minValue != Double.NEGATIVE_INFINITY || this.maxValue != Double.POSITIVE_INFINITY;
        }

        private boolean hasRecommendedRange() {
            return this.maxRecommendedValue != Double.POSITIVE_INFINITY || this.minRecommendedValue != Double.NEGATIVE_INFINITY;
        }

        public boolean isControlledByPlugin() {
            return this.controllingDescriptor != null;
        }

        public List<String> getNames() {
            ArrayList<String> names = new ArrayList<String>();
            if (!this.shortName.isEmpty()) {
                names.add(this.shortName);
            }
            if (!this.fullName.isEmpty()) {
                names.add(this.fullName);
            } else {
                names.add(this.fieldName);
            }
            return names;
        }

        public String getLongName() {
            return !this.fullName.isEmpty() ? this.fullName : this.fieldName;
        }

        private String prettyNameValue(Object value) {
            if (value != null) {
                if (this.isSensitive) {
                    return String.format("--%s ***********", this.getLongName());
                }
                if (value instanceof TaggedArgument) {
                    TaggedArgument taggedArg = (TaggedArgument)value;
                    return String.format("--%s %s", TaggedArgumentParser.getDisplayString(this.getLongName(), taggedArg), value);
                }
                return String.format("--%s %s", this.getLongName(), value);
            }
            return "";
        }

        public String toCommandLineString() {
            Object value = this.getFieldValue();
            if (this.isCollection) {
                Collection collect = (Collection)value;
                return collect.stream().map(this::prettyNameValue).collect(Collectors.joining(" "));
            }
            return this.prettyNameValue(value);
        }
    }
}

