/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.common.Version;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.cram.structure.CramHeader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class CramContainerIterator
implements Iterator<Container> {
    private CramHeader cramHeader;
    private CountingInputStream countingInputStream;
    private Container nextContainer;
    private boolean eof = false;
    private long offset = 0L;

    public CramContainerIterator(InputStream inputStream) throws IOException {
        this.countingInputStream = new CountingInputStream(inputStream);
        this.cramHeader = CramIO.readCramHeader(this.countingInputStream);
        this.offset = this.countingInputStream.getCount();
    }

    void readNextContainer() {
        try {
            this.nextContainer = this.containerFromStream(this.cramHeader.getVersion(), this.countingInputStream);
            long containerSizeInBytes = this.countingInputStream.getCount() - this.offset;
            this.nextContainer.offset = this.offset;
            this.offset += containerSizeInBytes;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (this.nextContainer.isEOF()) {
            this.eof = true;
            this.nextContainer = null;
        }
    }

    protected Container containerFromStream(Version cramVersion, CountingInputStream countingStream) throws IOException {
        return ContainerIO.readContainer(this.cramHeader.getVersion(), (InputStream)countingStream);
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this.nextContainer == null) {
            this.readNextContainer();
        }
        return !this.eof;
    }

    @Override
    public Container next() {
        Container result = this.nextContainer;
        this.nextContainer = null;
        return result;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Read only iterator.");
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    public void close() {
        this.nextContainer = null;
        this.cramHeader = null;
        try {
            this.countingInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

