/*
 * Decompiled with CFR 0.152.
 */
package com.intel.gkl;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NativeLibraryLoader {
    private static final Logger logger = LogManager.getLogger(NativeLibraryLoader.class);
    private static final String USE_LIBRARY_PATH = "USE_LIBRARY_PATH";
    private static final Set<String> loadedLibraries = new HashSet<String>();

    public static synchronized boolean load(File tempDir, String libraryName) {
        if (loadedLibraries.contains(libraryName)) {
            return true;
        }
        String systemLibraryName = System.mapLibraryName(libraryName);
        if (System.getenv(USE_LIBRARY_PATH) != null) {
            String javaLibraryPath = System.getProperty("java.library.path");
            try {
                logger.warn(String.format("OVERRIDE DEFAULT: Loading %s from %s", systemLibraryName, javaLibraryPath));
                logger.warn(String.format("LD_LIBRARY_PATH = %s", System.getenv("LD_LIBRARY_PATH")));
                System.loadLibrary(libraryName);
                return true;
            }
            catch (Error | Exception e) {
                logger.warn(String.format("OVERRIDE DEFAULT: Unable to load %s from %s", systemLibraryName, javaLibraryPath));
                return false;
            }
        }
        String resourcePath = "native/" + systemLibraryName;
        URL inputUrl = NativeLibraryLoader.class.getResource(resourcePath);
        if (inputUrl == null) {
            logger.warn("Unable to find native library: " + resourcePath);
            return false;
        }
        logger.info(String.format("Loading %s from %s", systemLibraryName, inputUrl.toString()));
        try {
            File temp = File.createTempFile(FilenameUtils.getBaseName(resourcePath), "." + FilenameUtils.getExtension(resourcePath), tempDir);
            FileUtils.copyURLToFile(inputUrl, temp);
            temp.deleteOnExit();
            logger.debug(String.format("Extracting %s to %s", systemLibraryName, temp.getAbsolutePath()));
            System.load(temp.getAbsolutePath());
        }
        catch (Error | Exception e) {
            logger.warn(String.format("Unable to load %s from %s (%s)", systemLibraryName, resourcePath, e.getMessage()));
            return false;
        }
        loadedLibraries.add(libraryName);
        return true;
    }
}

