# Executable Workflow

[![PyPI](https://img.shields.io/pypi/v/py-executable-checklist?style=flat-square)](https://pypi.python.org/pypi/py-executable-checklist/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/py-executable-checklist?style=flat-square)](https://pypi.python.org/pypi/py-executable-checklist/)
[![PyPI - License](https://img.shields.io/pypi/l/py-executable-checklist?style=flat-square)](https://pypi.python.org/pypi/py-executable-checklist/)
[![Coookiecutter - Wolt](https://img.shields.io/badge/cookiecutter-Wolt-00c2e8?style=flat-square&logo=cookiecutter&logoColor=D4AA00&link=https://github.com/woltapp/wolt-python-package-cookiecutter)](https://github.com/woltapp/wolt-python-package-cookiecutter)


---

**Documentation**: [https://namuan.github.io/py-executable-checklist](https://namuan.github.io/py-executable-checklist)

**Source Code**: [https://github.com/namuan/py-executable-checklist](https://github.com/namuan/py-executable-checklist)

**PyPI**: [https://pypi.org/project/py-executable-checklist/](https://pypi.org/project/py-executable-checklist/)

---

Helper classes to develop executable workflow scripts

## Installation

```sh
pip install py-executable-checklist
```

## Example Usage

```python
import logging
from argparse import ArgumentParser, RawDescriptionHelpFormatter

from py_executable_checklist import run_workflow, WorkflowBase


# Common functions across steps

# Workflow steps


class DoSomething(WorkflowBase):
    """
    Go to this page
    Copy the command
    Run the command
    Copy the output and paste it into the email
    """

    username: str

    def run(self, context):
        logging.info(f"Hello {self.username}")

        # output
        context["greetings"] = f"Hello {context['username']}"


# Workflow definition


def workflow():
    return [
        DoSomething,
    ]


# Boilerplate


def parse_args():
    parser = ArgumentParser(
        description=__doc__, formatter_class=RawDescriptionHelpFormatter
    )
    parser.add_argument("-u", "--username", type=str, required=True, help="User name")
    parser.add_argument(
        "-v",
        "--verbose",
        action="store_true",
        default=False,
        dest="verbose",
        help="Display context variables at each step",
    )
    return parser.parse_args()


def main(args):
    context = args.__dict__
    run_workflow(context, workflow())


if __name__ == "__main__":
    args = parse_args()
    main(args)
```

## Development

* Clone this repository
* Requirements:
  * [Poetry](https://python-poetry.org/)
  * Python 3.7+
* Create a virtual environment and install the dependencies

```sh
poetry install
```

* Activate the virtual environment

```sh
poetry shell
```

### Validating build

```sh
make build
```
