/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.Cluster;
import TCGA.DoubleHashMap;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSample;
import TCGA.GenomicSet;
import TCGA.HashMapArrayList;
import TCGA.PearsonRCluster;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleSortTools {
    public static String AVERAGE_VALUE = "Average value";
    public static String HIGHEST_ABSOLUTE_VALUE = "Highest absolute value";
    public static String CLUSTER_SUBSET_ALL = "All visible subsets";
    public static String CLUSTER_VALUE_ANY = "Positive or negative";
    public static String CLUSTER_VALUE_POSITIVE = "Positive only";
    public static String CLUSTER_VALUE_NEGATIVE = "Negative only";
    private static final int NEUTRAL_VALUE = 0;
    private GenomicMeasurement gm;
    private GenomicSet gset;
    private ArrayList<GenomicSample> rows;
    private HashMap<String, ArrayList<GenomicSample>> patient2samples;
    private float minimum_value_to_cluster = 0.0f;
    private boolean rearrange_columns = true;
    private float average;
    private int column_count;
    private String multi_sample_representative_method = AVERAGE_VALUE;
    private String subset_filter = CLUSTER_SUBSET_ALL;
    private String value_filter = CLUSTER_VALUE_ANY;

    public SampleSortTools(GenomicMeasurement gm, GenomicSet gset) {
        this.gm = gm;
        this.gset = gset;
        this.rows = gm.get_rows();
        this.column_count = gm.get_column_count();
        this.setup();
    }

    public SampleSortTools(GenomicMeasurement gm) {
        this.gm = gm;
        this.rows = gm.get_rows();
        this.column_count = gm.get_column_count();
        this.setup();
    }

    public SampleSortTools(ArrayList<GenomicSample> rows) {
        this.rows = rows;
        this.column_count = rows.get((int)0).copynum_data.length;
        this.setup();
    }

    public void set_rearrange_columns(boolean value) {
        this.rearrange_columns = value;
    }

    public void set_multi_sample_representative_method(String method) {
        this.multi_sample_representative_method = method;
    }

    public void set_minimum_value_to_cluster(float value) {
        this.minimum_value_to_cluster = value;
    }

    public void set_value_filter(String method) {
        this.value_filter = method;
    }

    private void setup() {
        this.patient2samples = this.build_patient_to_sample_map();
    }

    public void set_subset_filter(String subset) {
        this.subset_filter = subset;
    }

    public HashMap<String, ArrayList<GenomicSample>> get_patient2samples() {
        return this.patient2samples;
    }

    public float get_representative_value(String patient, int index) {
        float representative;
        ArrayList<Byte> points = new ArrayList<Byte>();
        ArrayList<GenomicSample> samples = this.patient2samples.get(patient);
        boolean filter_by_subset = !this.subset_filter.equals(CLUSTER_SUBSET_ALL);
        boolean filter_by_value = !this.value_filter.equals(CLUSTER_VALUE_ANY);
        boolean filter_by_value_positive = this.value_filter.equals(CLUSTER_VALUE_POSITIVE);
        for (GenomicSample gs : samples) {
            byte point;
            if (filter_by_subset && gs.sample_id.indexOf(this.subset_filter) == -1 || !gs.visible_in_display || (point = gs.copynum_data[index]) == -99 || filter_by_value && (filter_by_value_positive ? point < 0 : point > 0)) continue;
            points.add(new Byte(point));
        }
        int size = points.size();
        if (size == 0) {
            representative = -99.0f;
        } else if (size == 1) {
            representative = ((Byte)points.get(0)).byteValue();
        } else if (this.multi_sample_representative_method.equals(AVERAGE_VALUE)) {
            float total = 0.0f;
            for (Byte b : points) {
                total += (float)b.byteValue();
            }
            representative = total / (float)size;
        } else {
            Collections.sort(points);
            byte min = (Byte)points.get(0);
            byte max = (Byte)points.get(points.size() - 1);
            int abs_min = Math.abs(min);
            representative = abs_min > max ? (float)min : (float)max;
        }
        return representative;
    }

    public DoubleHashMap build_patient_subset_map() {
        System.err.println("FIX ME: replaced by gm.get_sample_for_patient_subset()");
        DoubleHashMap dhm = new DoubleHashMap();
        for (GenomicSample gs : this.rows) {
            dhm.put(gs.patient_id, gs.subset_id, gs);
        }
        return dhm;
    }

    public HashMap<String, ArrayList<GenomicSample>> build_patient_to_sample_map() {
        HashMap<String, ArrayList<GenomicSample>> patient2samples = new HashMap<String, ArrayList<GenomicSample>>();
        for (GenomicSample gs : this.rows) {
            ArrayList<GenomicSample> bucket = patient2samples.get(gs.patient_id);
            if (bucket == null) {
                bucket = new ArrayList();
                patient2samples.put(gs.patient_id, bucket);
            }
            bucket.add(gs);
        }
        return patient2samples;
    }

    public ArrayList<GenomicSample> sort_by_cluster() {
        HashSet<Integer> headers_left = new HashSet<Integer>();
        for (int i = 0; i < this.column_count; ++i) {
            headers_left.add(i);
        }
        ArrayList<Integer> reordered_headers = new ArrayList<Integer>();
        HashSet<String> ids_left = new HashSet<String>(this.patient2samples.keySet());
        ArrayList<GenomicSample> rows_new = new ArrayList<GenomicSample>();
        ArrayList<Cluster> clusters = new ArrayList<Cluster>();
        while (headers_left.size() > 0 && ids_left.size() > 0) {
            int id_count = ids_left.size();
            float best_frac = -1.0f;
            boolean best_up = false;
            int best_header = -1;
            for (Integer h : headers_left) {
                int hi = h;
                int total_up = 0;
                int total_down = 0;
                for (String id : ids_left) {
                    float rep = this.get_representative_value(id, hi);
                    if (rep == -99.0f || rep == 0.0f) continue;
                    if (rep >= this.minimum_value_to_cluster) {
                        ++total_up;
                        continue;
                    }
                    if (!(rep <= -this.minimum_value_to_cluster)) continue;
                    ++total_down;
                }
                float frac_up = (float)total_up / (float)id_count;
                float frac_down = (float)total_down / (float)id_count;
                if (best_frac == -1.0f || frac_up > best_frac) {
                    best_header = h;
                    best_frac = frac_up;
                    best_up = true;
                }
                if (!(frac_down > best_frac)) continue;
                best_header = h;
                best_frac = frac_down;
                best_up = false;
            }
            ArrayList<String> ids_to_remove = new ArrayList<String>();
            ArrayList<GenomicSample> queue = new ArrayList<GenomicSample>();
            for (String id : ids_left) {
                float rep = this.get_representative_value(id, best_header);
                if (rep == -99.0f || rep == 0.0f || !(best_up ? rep >= this.minimum_value_to_cluster : rep <= -this.minimum_value_to_cluster)) continue;
                queue.addAll((Collection<GenomicSample>)this.patient2samples.get(id));
                ids_to_remove.add(id);
            }
            if (queue.size() == 0) break;
            SampleSortTools sst = new SampleSortTools(queue);
            ArrayList<GenomicSample> sorted = sst.sort_by_bin(best_header);
            rows_new.addAll(sorted);
            PearsonRCluster cluster = new PearsonRCluster();
            for (int i = 0; i < sorted.size(); ++i) {
                cluster.add(i);
            }
            cluster.set_sample_data(sorted);
            clusters.add(cluster);
            headers_left.remove(best_header);
            reordered_headers.add(best_header);
            ids_left.removeAll(ids_to_remove);
        }
        reordered_headers.addAll(headers_left);
        for (String id : ids_left) {
            rows_new.addAll((Collection<GenomicSample>)this.patient2samples.get(id));
        }
        if (this.gset != null && this.rearrange_columns) {
            if (this.gset.is_marker_bin()) {
                for (GenomicSample gs : rows_new) {
                    gs.reorder_data(reordered_headers);
                }
                this.gm.reorder_headers(reordered_headers);
                this.gset.generate_marker_bins();
            } else {
                System.err.println("can't reorder headers: set not binned by marker");
            }
        }
        if (this.gm != null) {
            this.gm.get_divider_manager().set_cluster_list(clusters);
            this.gm.set_rows(rows_new, false);
        }
        return rows_new;
    }

    public ArrayList<GenomicSample> sort_by_bin(int index) {
        HashMapArrayList rep2samples = new HashMapArrayList();
        float total_data = 0.0f;
        int usable_values = 0;
        for (String patient : this.patient2samples.keySet()) {
            float rep = this.get_representative_value(patient, index);
            if (rep != -99.0f) {
                total_data += rep;
                ++usable_values;
            }
            rep2samples.addAll(new Float(rep), this.patient2samples.get(patient));
        }
        this.average = total_data / (float)usable_values;
        ArrayList representative = new ArrayList(rep2samples.keySet());
        Collections.sort(representative);
        ArrayList<GenomicSample> rows_new = new ArrayList<GenomicSample>();
        for (Float f : representative) {
            ArrayList all = rep2samples.get(f);
            rows_new.addAll(all);
        }
        return rows_new;
    }

    public float get_average() {
        return this.average;
    }
}

