/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.LookAndFeeler;
import Funk.Str;
import TCGA.BinIndex;
import TCGA.ColorManager;
import TCGA.ColorScheme;
import TCGA.ColorSchemeModel;
import TCGA.Formatter;
import TCGA.GenomicMeasurement;
import TCGA.GenomicSet;
import TCGA.HeatmapConfiguration;
import TCGA.JComboBoxToolTipHelper;
import TCGA.NavigationRequest;
import TCGA.Observable2;
import TCGA.Options;
import TCGA.Pathway;
import TCGA.PathwayGenes;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Observer;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class NavigationBar
extends JPanel
implements Formatter {
    private static final String LABEL_OK = "Go";
    private JComboBox jc_type;
    private JComboBox jc_what;
    private JCheckBox cb_sort;
    private JCheckBox cb_zoom;
    private BinIndex bin_index;
    private GenomicMeasurement gm;
    private GenomicSet gs;
    private PathwayGenes pathway_genes;
    private Observable2 obs;
    private Pathway last_pathway;
    private HashSet<String> markers;
    private HashSet<String> pathways;
    private HashSet<String> samples;
    private HeatmapConfiguration config;
    private static String TYPE_MARKER = "Marker";
    private static String TYPE_PATHWAY = "Pathway";
    private static String TYPE_SAMPLE = "Sample";
    private static String TYPE_GENOMIC_REGION = "Genomic region";
    private static String TYPE_ALL = "All";
    private static String TYPE_MARKER_SET = "Marker list";
    private static String TYPE_SEPARATOR = "- - - - - - - - -";
    private JComboBoxToolTipHelper tth;

    public NavigationBar(HeatmapConfiguration config) {
        this.config = config;
        this.gm = config.gm;
        this.gs = config.gs;
        this.setup();
    }

    private void setup() {
        this.obs = new Observable2();
        this.pathway_genes = new PathwayGenes();
        this.pathway_genes.sleep_until_ready();
        this.bin_index = new BinIndex(this.gm);
        this.markers = new HashSet<String>(this.bin_index.get_unique_list());
        this.pathways = new HashSet(this.get_pathway_labels());
        this.samples = new HashSet<String>(this.gm.get_visible_sample_ids());
        JButton jb = new JButton("Background");
        this.add(jb);
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.toggle_background_colors();
            }
        });
        this.add(new JToolBar.Separator());
        this.add(new JToolBar.Separator());
        this.add(new JToolBar.Separator());
        this.add(new JToolBar.Separator());
        JLabel label = new JLabel("Search for:", 11);
        this.add(label);
        Vector<String> types = new Vector<String>();
        types.add(TYPE_ALL);
        types.add(TYPE_MARKER);
        types.add(TYPE_PATHWAY);
        types.add(TYPE_SAMPLE);
        types.add(TYPE_SEPARATOR);
        if (this.gm.is_genome_formatted()) {
            types.add(TYPE_GENOMIC_REGION);
        }
        types.add(TYPE_MARKER_SET);
        this.jc_type = new JComboBox(new Vector(types));
        this.add(this.jc_type);
        this.jc_type.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.search_box_setup();
            }
        });
        this.jc_what = new JComboBox();
        this.add(this.jc_what);
        this.jc_what.setPrototypeDisplayValue("WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
        this.tth = new JComboBoxToolTipHelper(this.jc_what, this);
        this.jc_what.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
                if (ke.getKeyCode() == 10) {
                    NavigationBar.this.handle_result();
                }
            }

            public void keyReleased(KeyEvent ke) {
            }

            public void keyTyped(KeyEvent ke) {
            }
        });
        this.jc_what.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String wanted_type;
                String wanted_result = (String)NavigationBar.this.jc_what.getSelectedItem();
                if (NavigationBar.this.pathways.contains(wanted_result)) {
                    NavigationBar.this.last_pathway = NavigationBar.this.pathway_genes.get_pathway(wanted_result);
                }
                if ((wanted_type = (String)NavigationBar.this.jc_type.getSelectedItem()).equals(TYPE_GENOMIC_REGION) || wanted_type.equals(TYPE_MARKER_SET)) {
                    NavigationBar.this.handle_result();
                }
            }
        });
        this.cb_zoom = new JCheckBox("Zoom", Options.NAVIGATION_DEFAULT_ZOOM);
        this.add(this.cb_zoom);
        this.cb_zoom.setToolTipText("Zoom the viewer to the selected item when navigating to a marker, sample, or region.  Pathways will open in a new window.");
        this.cb_sort = new JCheckBox("Sort", false);
        this.add(this.cb_sort);
        this.cb_sort.setToolTipText("When navigating to a marker, sort the view by the data at the marker position.");
        jb = new JButton(LABEL_OK);
        this.add(jb);
        jb.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                NavigationBar.this.handle_result();
            }
        });
        this.search_box_setup();
    }

    private Vector get_pathway_labels() {
        Vector<String> pathway_labels = new Vector<String>();
        for (String s : this.pathway_genes.get_pathway_names()) {
            pathway_labels.add(s);
        }
        return pathway_labels;
    }

    public void addObserver(Observer o) {
        this.obs.addObserver(o);
    }

    private void search_box_setup() {
        Vector<String> combo_data = null;
        String wanted_type = (String)this.jc_type.getSelectedItem();
        Vector<String> marker_labels = new Vector<String>(this.bin_index.get_unique_list());
        Vector<String> pathway_labels = this.get_pathway_labels();
        Vector<String> sample_labels = new Vector<String>(this.gm.get_visible_sample_ids());
        boolean zoom_enabled = true;
        boolean sort_enabled = true;
        if (wanted_type.equals(TYPE_MARKER)) {
            combo_data = marker_labels;
        } else if (wanted_type.equals(TYPE_PATHWAY)) {
            combo_data = pathway_labels;
            sort_enabled = false;
            zoom_enabled = false;
        } else if (wanted_type.equals(TYPE_SAMPLE)) {
            combo_data = sample_labels;
            sort_enabled = false;
            zoom_enabled = false;
        } else if (wanted_type.equals(TYPE_GENOMIC_REGION)) {
            combo_data = new Vector();
            combo_data.add("chr7:3000000-10000000");
            zoom_enabled = true;
            sort_enabled = false;
        } else if (wanted_type.equals(TYPE_MARKER_SET)) {
            combo_data = new Vector();
            if (this.last_pathway != null) {
                combo_data.add(Str.join(" ", this.last_pathway.genes.iterator()));
            }
            combo_data.add("");
            zoom_enabled = false;
            sort_enabled = false;
        } else if (wanted_type.equals(TYPE_ALL)) {
            combo_data = new Vector();
            combo_data.addAll(marker_labels);
            combo_data.addAll(pathway_labels);
            combo_data.addAll(sample_labels);
        } else {
            System.err.println("ERROR, unknown filter subtype");
        }
        if (wanted_type.equals(TYPE_GENOMIC_REGION)) {
            this.tth.setToolTipText("enter genomic region in format chrX:start-end, e.g. \"chr7:3000000-100000000\"");
            this.jc_what.setEditable(true);
        } else if (wanted_type.equals(TYPE_MARKER_SET)) {
            this.tth.setToolTipText("Enter a list of marker names, separated by spaces.  Results will open in a new window.");
            this.jc_what.setEditable(true);
        } else {
            this.tth.setToolTipText(null);
            this.jc_what.setEditable(false);
        }
        this.cb_zoom.setEnabled(zoom_enabled);
        this.cb_sort.setEnabled(sort_enabled);
        if (combo_data != null) {
            DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>(combo_data);
            this.jc_what.setModel(dcbm);
            Dimension d = this.jc_what.getMinimumSize();
            d.width = 50;
            this.jc_what.setMinimumSize(d);
        }
    }

    private void handle_result() {
        String wanted_type = (String)this.jc_type.getSelectedItem();
        String wanted_result = (String)this.jc_what.getSelectedItem();
        NavigationRequest request = new NavigationRequest();
        request.wants_zoom = this.cb_zoom.isSelected();
        request.wants_sort = this.cb_sort.isSelected();
        if (wanted_type.equals(TYPE_GENOMIC_REGION)) {
            String[] pos;
            String[] f = wanted_result.split(":");
            boolean parse_error = true;
            String error_msg = "Please specify genomic search coordinates in the format chrX:start-end, e.g. \"chr7:1-30000000\"";
            int[] positions = new int[]{-1, -1};
            int ok = 0;
            if (f.length == 2 && (pos = f[1].split("-")).length == 2) {
                for (int i = 0; i < 2; ++i) {
                    try {
                        positions[i] = Integer.parseInt(pos[i]);
                        ++ok;
                        continue;
                    }
                    catch (NumberFormatException e) {
                        // empty catch block
                    }
                }
                if (this.gs == null) {
                    System.err.println("error: no GenomicSet");
                } else {
                    int chr = this.gs.chr2int(f[0]);
                    if (ok == 2 && chr > 0) {
                        int start_bin = this.gs.get_bin_for(chr, positions[0]);
                        int end_bin = this.gs.get_bin_for(chr, positions[1]);
                        if (start_bin == -1 || end_bin == -1) {
                            error_msg = "Can't find genomic positions; is this not a genomically-formatted dataset?";
                        } else {
                            request.selection = this.gm.generate_selection(start_bin, end_bin - start_bin + 1);
                            parse_error = false;
                        }
                    }
                }
            }
            if (parse_error) {
                JOptionPane.showMessageDialog(this, error_msg, "Formatting error", 0);
            }
        } else if (wanted_type.equals(TYPE_MARKER_SET)) {
            String[] markers = wanted_result.split("\\s+");
            ArrayList<Integer> wanted = new ArrayList<Integer>();
            ArrayList<String> missing = new ArrayList<String>();
            for (int i = 0; i < markers.length; ++i) {
                String marker = markers[i];
                int index = this.bin_index.find(markers[i]);
                if (index == -1) {
                    missing.add(marker);
                    continue;
                }
                wanted.add(new Integer(index));
            }
            if (missing.size() > 0) {
                System.err.println("MISSING:" + missing.toString());
                int missing_count = missing.size();
                JOptionPane.showMessageDialog(this, "Can't find " + missing_count + " marker" + (missing_count == 1 ? "" : "s") + " " + missing.toString(), "Warning", 2);
            }
            if (wanted.size() > 0) {
                request.bin_index_list = wanted;
            }
        } else if (this.markers.contains(wanted_result)) {
            request.marker = wanted_result;
            request.bin_index = new Integer(this.bin_index.find(wanted_result));
        } else if (this.pathways.contains(wanted_result)) {
            request.pathway = this.pathway_genes.get_pathway(wanted_result);
        } else if (this.samples.contains(wanted_result)) {
            request.sample = wanted_result;
            request.selection = this.gm.generate_selection(wanted_result);
        } else {
            System.err.println("handle_result(): ERROR, unhandled result");
        }
        if (request != null) {
            this.obs.setChanged();
            this.obs.notifyObservers(request);
        }
    }

    public static void main(String[] argv) {
        LookAndFeeler.set_native_lookandfeel();
        try {
            GenomicMeasurement gm = new GenomicMeasurement("carl.txt", false);
            System.err.println("fix me");
            JFrame jf = new JFrame();
            jf.setLayout(new BorderLayout());
            jf.pack();
            jf.setVisible(true);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public String format(String v) {
        String label = null;
        if (this.markers.contains(v)) {
            label = "marker";
        } else if (this.pathways.contains(v)) {
            label = "pathway";
        } else if (this.samples.contains(v)) {
            label = "sample";
        }
        return label == null ? v : v + " (" + label + ")";
    }

    private void toggle_background_colors() {
        this.config.white_mode = !this.config.white_mode;
        ColorManager cm = this.gm.get_color_manager();
        ArrayList<ColorScheme> schemes = cm.get_all_color_schemes();
        for (ColorScheme cs : schemes) {
            ColorSchemeModel csm = cs.get_colorscheme_model();
            csm.white_mode = this.config.white_mode;
            cs.set_colorscheme_model(csm, false);
        }
        schemes.get(0).notify_observers();
    }
}

