/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import Funk.Str;

public class IdentifierMunger {
    private String raw_id;
    private String[] chunks;
    private String delimiter = "-";

    public IdentifierMunger(String id) {
        this.setup(id);
    }

    private void setup(String id) {
        int i;
        this.raw_id = id;
        String[] tokens = id.split(" ");
        for (i = 0; i < tokens.length; ++i) {
            if (tokens[i].indexOf("TCGA") < 0) continue;
            id = tokens[i];
            break;
        }
        this.chunks = null;
        if (id.indexOf("-") >= 0) {
            this.chunks = id.split("-");
        } else if (id.indexOf(".") >= 0) {
            this.chunks = id.split("\\.");
        }
        if (this.chunks != null) {
            i = this.chunks[0].indexOf("TCGA");
            if (i > 0) {
                this.chunks[0] = this.chunks[0].substring(i);
            }
            if (this.chunks.length >= 6) {
                while (this.chunks[5].indexOf("0") == 0) {
                    this.chunks[5] = this.chunks[5].substring(1);
                }
            }
        }
    }

    public String get_aliquot() {
        return this.build_id(7);
    }

    public String get_analyte() {
        return this.build_id(5);
    }

    public String get_sample() {
        return this.build_id(4);
    }

    public String get_patient() {
        return this.build_id(3);
    }

    private String build_id(int fields) {
        String result = null;
        if (this.chunks != null && this.chunks.length >= fields) {
            return Str.join(this.delimiter, this.chunks, fields);
        }
        return result;
    }

    public static void main(String[] argv) {
        IdentifierMunger im = new IdentifierMunger("TCGA.02.0069.01A.01D.00193.01");
        System.err.println(im.get_aliquot());
        System.err.println(im.get_analyte());
        System.err.println(im.get_sample());
        System.err.println(im.get_patient());
    }
}

