/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.GenomeScaler;
import TCGA.GenomicBin;
import TCGA.GenomicLocation;
import java.util.ArrayList;
import java.util.HashSet;

public class GenomicBinRange {
    private GenomicBin bin;
    private GenomicLocation gl;
    private GenomeScaler gs;
    HashSet<Integer> bins_hit_set;
    ArrayList<Integer> bins_hit_list;
    private int first_bin;
    private int last_bin;

    public GenomicBinRange(GenomicBin bin, GenomicLocation gl, GenomeScaler gs) {
        this.bin = bin;
        this.gl = gl;
        this.gs = gs;
        this.setup();
    }

    private void setup() {
        int chr_len = this.gs.get_chromosome_length_bp(this.gl.chromosome);
        int bin_count = this.bin.end - this.bin.start + 1;
        int nt_per_bin = chr_len / bin_count;
        this.first_bin = this.bin.start + this.gl.start / nt_per_bin;
        this.last_bin = this.bin.start + this.gl.end / nt_per_bin + 1;
        this.bins_hit_set = new HashSet();
        this.bins_hit_list = new ArrayList();
        for (int i = this.first_bin; i <= this.last_bin; ++i) {
            this.bins_hit_set.add(i);
            this.bins_hit_list.add(i);
        }
    }

    public boolean contains(int bin_num) {
        return this.bins_hit_set.contains(bin_num);
    }

    public int get_distance(int bin_num) {
        int distance = -1;
        distance = this.contains(bin_num) ? 0 : (bin_num < this.first_bin ? this.first_bin - bin_num : bin_num - this.last_bin);
        return distance;
    }
}

