/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.ColorScheme;
import TCGA.ColorSchemeModel;
import TCGA.CommentOptions;
import TCGA.GenomicMeasurement;
import TCGA.HeatmapConfiguration;
import TCGA.Options;
import TCGA.SampleSubsets;
import TCGA.SampleSummaryInfo;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColorManager {
    private HashMap<String, ColorScheme> subset_colors;
    private SampleSubsets sample_subsets;
    private GenomicMeasurement gm;
    private HeatmapConfiguration config = null;
    private static final String GLOBAL_KEY = "__GLOBAL_COLOR__";
    private boolean multicolor_enabled = Options.ENABLE_INDEPENDENT_SUBSET_COLORS;
    private static Color COLOR_SELECTION = new Color(255, 255, 150);
    private static Color COLOR_PATIENT_DIVIDER = Color.gray;
    private static Color COLOR_CLUSTER_DIVIDER = Color.yellow;
    private static Color COLOR_ZOOM_FOREGROUND = Color.black;
    private static Color COLOR_ZOOM_BACKGROUND = Color.white;

    public ColorManager(GenomicMeasurement gm) {
        this.gm = gm;
        this.sample_subsets = gm.get_sample_subsets();
        this.setup();
    }

    private void setup() {
        int[] scale;
        this.subset_colors = new HashMap();
        this.subset_colors.put(GLOBAL_KEY, new ColorScheme(Options.DEFAULT_COLOR_SCHEME));
        if (!this.sample_subsets.isEmpty()) {
            for (String subset : this.sample_subsets.get_subsets_arraylist()) {
                this.subset_colors.put(subset, new ColorScheme(Options.DEFAULT_COLOR_SCHEME));
            }
        }
        boolean colors_set_from_data = false;
        CommentOptions options = this.gm.get_options();
        SampleSummaryInfo ssi = this.gm.get_sample_summary_info();
        String brightness = options.get("brightness");
        if (brightness != null) {
            Options.DEFAULT_MIN_COLOR_INTENSITY_PERCENT = Integer.parseInt(brightness);
            colors_set_from_data = true;
        }
        if ((scale = options.get_int_list("scale")) != null) {
            byte neutral;
            if (options.has_option("neutral") && (neutral = (byte)options.get_single_neutral_level()) > 0) {
                int i = 0;
                while (i < scale.length) {
                    int n = i++;
                    scale[n] = scale[n] - neutral;
                }
            }
            colors_set_from_data = true;
            Options.DEFAULT_COPYNUMBER_GRADIENTS = scale;
            Options.MAX_GRADIENTS = scale[scale.length - 1] * 2;
        }
        if (colors_set_from_data) {
            ColorSchemeModel csm = new ColorSchemeModel();
            csm.gradients = Options.DEFAULT_COPYNUMBER_GRADIENTS;
            csm.min_intensity_percent = Options.DEFAULT_MIN_COLOR_INTENSITY_PERCENT;
            for (ColorScheme cs : this.get_all_color_schemes()) {
                cs.import_gradients(csm);
            }
        } else if (Options.AUTO_OPTIMIZE_GRADIENTS) {
            this.get_global_color_scheme().import_gradients(ssi.calculate_gradients(null));
            if (this.is_multicolor_enabled()) {
                for (String subset : this.sample_subsets.get_subsets_arraylist()) {
                    ColorScheme cs = this.subset_colors.get(subset);
                    cs.import_gradients(ssi.calculate_gradients(subset));
                }
            }
        } else {
            System.err.println("Warning: no gradients set in data or auto-optimize");
        }
    }

    public boolean is_multicolor_enabled() {
        return this.multicolor_enabled && !this.sample_subsets.isEmpty();
    }

    public void set_multicolor_enabled(boolean v) {
        this.multicolor_enabled = v;
    }

    public ColorScheme get_global_color_scheme() {
        return this.subset_colors.get(GLOBAL_KEY);
    }

    public HashMap<String, ColorScheme> get_subset_colors() {
        return this.subset_colors;
    }

    public ArrayList<ColorScheme> get_all_color_schemes() {
        ArrayList<ColorScheme> results = new ArrayList<ColorScheme>();
        if (this.is_multicolor_enabled()) {
            for (String subset : this.sample_subsets.get_subsets_arraylist()) {
                results.add(this.subset_colors.get(subset));
            }
        }
        results.add(this.subset_colors.get(GLOBAL_KEY));
        return results;
    }

    public boolean is_white_mode() {
        if (this.config != null) {
            return this.config.white_mode;
        }
        System.err.println("warning: no HeatmapConfiguration ref!");
        return !Options.DEFAULT_BACKGROUND_BLACK;
    }

    private Color invert_check(Color result) {
        if (this.is_white_mode()) {
            result = ColorManager.invert_color(result);
        }
        return result;
    }

    public Color get_selection_color() {
        return this.invert_check(COLOR_SELECTION);
    }

    public Color get_patient_divider_color() {
        return this.invert_check(COLOR_PATIENT_DIVIDER);
    }

    public Color get_cluster_divider_color() {
        return this.invert_check(COLOR_CLUSTER_DIVIDER);
    }

    public Color get_zoom_foreground_color() {
        return this.invert_check(COLOR_ZOOM_FOREGROUND);
    }

    public Color get_zoom_background_color() {
        return this.invert_check(COLOR_ZOOM_BACKGROUND);
    }

    private static Color invert_color(Color c) {
        return new Color(255 - c.getRed(), 255 - c.getGreen(), 255 - c.getBlue());
    }

    public void set_config(HeatmapConfiguration config) {
        this.config = config;
    }
}

