/*
 * Decompiled with CFR 0.152.
 */
package TCGA;

import TCGA.GenomicMeasurement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinIndex {
    private GenomicMeasurement gm;
    private HashMap<String, Integer> header2index;
    private HashMap<String, Integer> header2index_lc;
    private ArrayList<String> unique_sorted;
    private boolean is_multi_bin = false;

    public BinIndex(GenomicMeasurement gm) {
        this.gm = gm;
        String[] headers = gm.get_headers();
        this.header2index = new HashMap();
        this.header2index_lc = new HashMap();
        for (int i = 0; i < headers.length; ++i) {
            String header = headers[i];
            Integer here = new Integer(i);
            if (header.indexOf(",") > 0) {
                this.is_multi_bin = true;
                String[] things = header.split(",");
                for (int j = 0; j < things.length; ++j) {
                    this.header2index.put(things[j], here);
                    this.header2index_lc.put(things[j].toLowerCase(), here);
                }
                continue;
            }
            this.header2index.put(header, here);
            this.header2index_lc.put(header.toLowerCase(), here);
        }
        this.unique_sorted = new ArrayList<String>(this.header2index.keySet());
        Collections.sort(this.unique_sorted);
    }

    public int find(String name) {
        Integer index = this.header2index.get(name);
        if (index == null) {
            index = this.header2index_lc.get(name.toLowerCase());
        }
        return index == null ? -1 : index;
    }

    public boolean is_multi_bin() {
        return this.is_multi_bin;
    }

    public ArrayList<String> get_unique_list() {
        return this.unique_sorted;
    }
}

