/*
 * Decompiled with CFR 0.152.
 */
package IsoView;

import Funk.BucketMap;
import Funk.FileUtils;
import IsoView.DatabaseAnnotationLoader;
import IsoView.IsoViewConfig;
import IsoView.UCSCRefGene;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Observer;

public class DatabaseAnnotationLoaderFlatfile
extends DatabaseAnnotationLoader
implements Runnable {
    public DatabaseAnnotationLoaderFlatfile(IsoViewConfig config, Observer o) {
        super(config, o);
    }

    public void run() {
        try {
            BucketMap bucket;
            UCSCRefGene rg;
            BufferedReader br;
            String line;
            long start = System.currentTimeMillis();
            HashMap<String, String> transcript2gene = new HashMap<String, String>();
            if (this.config.USE_TRANSCRIPT2GENE) {
                BufferedReader br2 = FileUtils.getUniversalBufferedReader(this.config.transcript2gene_file);
                while ((line = br2.readLine()) != null) {
                    String[] f = line.split("\t");
                    if (f.length == 2) {
                        transcript2gene.put(f[0], f[1]);
                        continue;
                    }
                    System.err.println("transcript2gene format must be 2 fields");
                }
            }
            HashMap<String, BucketMap<UCSCRefGene>> chr2bucket = null;
            if (this.config.STANDARDIZE_GENE_SYMBOLS) {
                chr2bucket = new HashMap<String, BucketMap<UCSCRefGene>>();
                br = FileUtils.getUniversalBufferedReader(this.config.standardize_flatfile);
                while ((line = br.readLine()) != null) {
                    rg = new UCSCRefGene(line);
                    bucket = (BucketMap)chr2bucket.get(rg.chrom);
                    if (bucket == null) {
                        bucket = new BucketMap(100000);
                        chr2bucket.put(rg.chrom, bucket);
                    }
                    bucket.add(rg, rg.txStart, rg.txEnd);
                }
                System.err.println("index elapsed: " + (System.currentTimeMillis() - start));
            }
            br = FileUtils.getUniversalBufferedReader(this.config.refgene_flatfile);
            while ((line = br.readLine()) != null) {
                rg = new UCSCRefGene(line);
                if (this.config.USE_TRANSCRIPT2GENE) {
                    String gene = (String)transcript2gene.get(rg.name);
                    if (gene == null) {
                        System.err.println("MISS for " + rg.name);
                    } else {
                        rg.name2 = gene;
                    }
                }
                if (this.config.STANDARDIZE_GENE_SYMBOLS) {
                    bucket = (BucketMap)chr2bucket.get(rg.chrom);
                    if (bucket == null) {
                        System.err.println("WTF, no bucket for " + rg.chrom);
                    } else {
                        ArrayList set = bucket.find_by_position(rg.txStart, rg.txEnd);
                        ArrayList<UCSCRefGene> matches = new ArrayList<UCSCRefGene>();
                        for (UCSCRefGene candidate : set) {
                            if (candidate.txEnd < rg.txStart || candidate.txStart > rg.txEnd) continue;
                            matches.add(candidate);
                            System.err.println("hit! " + rg.name + ":" + rg.txStart + "-" + rg.txEnd + " " + candidate.name + ":" + candidate.txStart + "-" + candidate.txEnd + " " + candidate.name2);
                        }
                        System.err.println("match count=" + matches.size());
                    }
                }
                this.add_gene(rg);
            }
            System.err.println("flatfile db load: " + (System.currentTimeMillis() - start) + " ms");
            this.setChanged();
            this.notifyObservers();
        }
        catch (Exception e) {
            System.err.println("parse error: " + e);
        }
    }

    public static void main(String[] argv) {
        IsoViewConfig config = new IsoViewConfig();
        config.refgene_flatfile = "refGene.txt.gz";
        DatabaseAnnotationLoaderFlatfile ff = new DatabaseAnnotationLoaderFlatfile(config, null);
    }
}

