/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.AssemblySequence;
import Ace2.MemoryMonitor;
import Ace2.ProgressInfo;
import Ace2.ReferenceSequence;
import Ace2.SAMConsensusMapFactory;
import Ace2.SAMConsensusMapping;
import Ace2.SAMMismatchFilter;
import Ace2.SAMRecordArrayIterable;
import Ace2.SAMRegion;
import Ace2.SAMResourceTags;
import Ace2.Sample;
import Funk.ErrorReporter;
import Funk.Timer;
import htsjdk.samtools.Cigar;
import htsjdk.samtools.CigarElement;
import htsjdk.samtools.CigarOperator;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.SamReaderFactory;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.util.CloseableIterator;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Observable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SAMResource
extends Observable {
    URL url = null;
    public File file = null;
    public ReferenceSequence reference_sequence = null;
    Sample sample;
    SAMRegion region = null;
    int query_overlap_base = 0;
    boolean LOAD_DUPLICATES = true;
    boolean sam_load_error;
    Color custom_color = null;
    static int filter_skip_size = 0;
    static boolean FILTER_REQUIRE_INDEL = false;
    static CigarOperator FILTER_REQUIRE_INDEL_TYPE = null;
    static int FILTER_REQUIRE_INDEL_LENGTH = 0;
    static boolean FILTER_IGNORE_PERFECT = false;
    private SAMRecord[] srs;
    private SAMConsensusMapping[] maps;
    private SAMConsensusMapping[] maps_by_name;
    private HashMap<String, SAMConsensusMapping> name2map = new HashMap();
    private static final int NOTIFY_MOD = 10000;
    private static final int ALIGNMENT_MEMORY_CHECK_MOD = 250;
    private static final int SAM_MEMORY_CHECK_MOD = 25;
    private static SAMMismatchFilter mf = null;
    private int unmapped_reads;
    private int filtered_reads;
    private int duplicate_ignored_reads;
    private SamReader mysr = null;
    private static boolean RESTRICT_LOAD = false;
    private static ArrayList<String> RESTRICT_STRINGS = new ArrayList();
    private static ArrayList<String> RESTRICT_FRS = new ArrayList();
    private static ArrayList<String> RESTRICT_STRINGS_NEGATIVE = new ArrayList();
    private static boolean RESTRICT_LOAD_OVERLAP = false;
    private static int RESTRICT_OVERLAP = 0;
    private static boolean RESTRICT_LOAD_FR = false;
    private static boolean RESTRICT_LOAD_FR_F = false;

    public SAMResource() {
        this.sample = new Sample();
    }

    public int get_size() {
        return this.srs == null ? 0 : this.srs.length;
    }

    public void close() throws IOException {
        if (this.mysr != null) {
            this.mysr.close();
            this.mysr = null;
        }
    }

    public void set_file(String filename) {
        this.file = new File(filename);
    }

    public File get_file() {
        return this.file;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SamReader getSamReader() throws IOException {
        if (this.mysr == null) {
            if (this.file != null) {
                ReferenceSource rs;
                SamReaderFactory srf = SamReaderFactory.makeDefault();
                srf.validationStringency(ValidationStringency.SILENT);
                if (this.reference_sequence != null && (rs = this.reference_sequence.getReferenceSource()) != null) {
                    srf.referenceSource((CRAMReferenceSource)rs);
                }
                this.mysr = srf.open(this.file);
                return this.mysr;
            } else {
                if (this.url == null) throw new IOException("need file or URL");
                if (this.region != null) {
                    System.err.println("WARNING: can't query regions in URL mode: " + this.region);
                }
                System.err.println("ERROR: URL SAM query not yet reimplemented");
                System.exit(1);
            }
            return this.mysr;
        } else {
            System.err.println("using cached SFR");
        }
        return this.mysr;
    }

    public CloseableIterator<SAMRecord> get_iterator() throws IOException {
        SamReader reader = this.getSamReader();
        SAMRecordIterator iterator = null;
        if (this.region != null && this.url == null) {
            int qs;
            int qe;
            String tname2;
            SAMFileHeader header = reader.getFileHeader();
            SAMSequenceRecord sr = header.getSequence(this.region.tname);
            String region_key = this.region.tname;
            if (sr == null && (sr = header.getSequence(tname2 = this.region.tname.indexOf("chr") == 0 ? new String(this.region.tname.substring(3)) : "chr" + this.region.tname)) != null) {
                region_key = tname2;
            }
            if (sr != null) {
                if (this.region.range.start == -1) {
                    this.region.range.start = 1;
                }
                if (this.region.range.end == -1) {
                    this.region.range.end = sr.getSequenceLength();
                }
            }
            if (this.query_overlap_base > 0) {
                qs = qe = this.query_overlap_base;
            } else {
                qs = this.region.range.start;
                qe = this.region.range.end;
            }
            System.err.println("querying " + region_key + " " + qs + " " + qe);
            iterator = reader.queryOverlapping(region_key, qs, qe);
        } else {
            iterator = reader.iterator();
        }
        return iterator;
    }

    public URL get_url() {
        return this.url;
    }

    public SAMRecord[] get_sams() {
        this.sam_load_error = false;
        try {
            if (this.srs == null) {
                CloseableIterator<SAMRecord> iterator = this.get_iterator();
                Timer timer = new Timer("sam load");
                ArrayList<SAMRecord> sams = new ArrayList<SAMRecord>();
                this.unmapped_reads = 0;
                this.filtered_reads = 0;
                this.duplicate_ignored_reads = 0;
                int count = 0;
                MemoryMonitor mm = new MemoryMonitor();
                if (RESTRICT_LOAD || RESTRICT_LOAD_OVERLAP || RESTRICT_LOAD_FR) {
                    System.err.println("DEBUG: RESTRICTING LOAD");
                }
                while (iterator.hasNext()) {
                    Cigar c;
                    List cels;
                    Cigar c2;
                    SAMRecord samRecord = (SAMRecord)iterator.next();
                    boolean usable = true;
                    if (samRecord.getReadUnmappedFlag()) {
                        ++this.unmapped_reads;
                        usable = false;
                    } else if (mf != null && !mf.filter(samRecord)) {
                        usable = false;
                        ++this.filtered_reads;
                    }
                    if (RESTRICT_LOAD_FR) {
                        usable = samRecord.getReadNegativeStrandFlag() ? !RESTRICT_LOAD_FR_F : RESTRICT_LOAD_FR_F;
                    }
                    if (RESTRICT_LOAD_OVERLAP && (samRecord.getAlignmentStart() > RESTRICT_OVERLAP || samRecord.getAlignmentEnd() < RESTRICT_OVERLAP)) {
                        usable = false;
                    }
                    if (RESTRICT_LOAD) {
                        String rn = samRecord.getReadName();
                        if (RESTRICT_STRINGS.size() > 0 && usable) {
                            boolean ok = false;
                            int len = RESTRICT_STRINGS.size();
                            for (int i = 0; i < len; ++i) {
                                if (rn.indexOf(RESTRICT_STRINGS.get(i)) <= -1) continue;
                                if (RESTRICT_LOAD_FR) {
                                    String dir = RESTRICT_FRS.get(i);
                                    if (dir.equals("F")) {
                                        if (!samRecord.getReadNegativeStrandFlag()) {
                                            ok = true;
                                        }
                                    } else if (dir.equals("R") && samRecord.getReadNegativeStrandFlag()) {
                                        ok = true;
                                    }
                                } else {
                                    ok = true;
                                }
                                if (!ok) continue;
                                usable = true;
                            }
                            usable = ok;
                        }
                        for (String neg : RESTRICT_STRINGS_NEGATIVE) {
                            if (rn.indexOf(neg) <= -1) continue;
                            usable = false;
                            break;
                        }
                    }
                    if (!this.LOAD_DUPLICATES && samRecord.getDuplicateReadFlag()) {
                        usable = false;
                        ++this.duplicate_ignored_reads;
                    }
                    if (usable && filter_skip_size > 0) {
                        boolean ok = false;
                        c2 = samRecord.getCigar();
                        for (CigarElement ce : c2.getCigarElements()) {
                            if (!ce.getOperator().equals((Object)CigarOperator.SKIPPED_REGION) || ce.getLength() != filter_skip_size) continue;
                            ok = true;
                        }
                        if (!ok) {
                            usable = false;
                        }
                    }
                    if (usable && FILTER_REQUIRE_INDEL) {
                        boolean ok = false;
                        c2 = samRecord.getCigar();
                        for (CigarElement ce : c2.getCigarElements()) {
                            CigarOperator co = ce.getOperator();
                            if (!co.equals((Object)CigarOperator.INSERTION) && !co.equals((Object)CigarOperator.DELETION)) continue;
                            if (FILTER_REQUIRE_INDEL_TYPE == null) {
                                ok = true;
                                continue;
                            }
                            if (!co.equals((Object)FILTER_REQUIRE_INDEL_TYPE)) continue;
                            if (FILTER_REQUIRE_INDEL_LENGTH > 0) {
                                ok = ce.getLength() == FILTER_REQUIRE_INDEL_LENGTH;
                                continue;
                            }
                            ok = true;
                        }
                        if (!ok) {
                            usable = false;
                        }
                    }
                    if (usable && FILTER_IGNORE_PERFECT && (cels = (c = samRecord.getCigar()).getCigarElements()).size() == 1) {
                        for (CigarElement ce : cels) {
                            CigarOperator co = ce.getOperator();
                            if (!co.equals((Object)CigarOperator.MATCH_OR_MISMATCH)) continue;
                            usable = false;
                        }
                    }
                    if (!usable) continue;
                    sams.add(samRecord);
                    if (++count % 25 != 0 || !mm.is_sustained_stressed()) continue;
                    this.sam_load_error = true;
                    break;
                }
                iterator.close();
                this.close();
                timer.finish();
                System.err.println("final SAM count: " + sams.size());
                if (this.sam_load_error) {
                    System.err.println("ERROR: ran out of RAM during SAM load");
                } else {
                    System.err.println("reads: removed " + this.unmapped_reads + " unmapped, " + this.duplicate_ignored_reads + " ignored_duplicates, " + this.filtered_reads + " by filters, " + sams.size() + " remaining");
                    SAMRecord[] srs_tmp = new SAMRecord[sams.size()];
                    int i = 0;
                    for (SAMRecord sr : sams) {
                        srs_tmp[i++] = sr;
                    }
                    this.srs = srs_tmp;
                }
            }
        }
        catch (Exception e) {
            new ErrorReporter(e);
        }
        return this.srs;
    }

    public boolean has_load_error() {
        return this.sam_load_error;
    }

    public boolean build_mappings(SAMConsensusMapFactory mf, ProgressInfo info) {
        boolean ok = true;
        try {
            int i;
            this.maps = new SAMConsensusMapping[this.srs.length];
            MemoryMonitor mm = new MemoryMonitor();
            for (i = 0; i < this.srs.length; ++i) {
                this.maps[i] = mf.map(this.srs[i]);
                this.name2map.put(new String(this.maps[i].get_name()), this.maps[i]);
                if (i % 10000 == 0) {
                    if (i > 0) {
                        info.add_processed(10000);
                    }
                    this.setChanged();
                    this.notifyObservers(info);
                }
                if (i % 250 != 0 || !mm.is_sustained_stressed()) continue;
                System.err.println("ERROR: sustained low-memory condition!  Quitting.");
                this.maps = null;
                this.name2map = null;
                ok = false;
                break;
            }
            info.add_processed(i % 10000);
            this.setChanged();
            this.notifyObservers(info);
            this.maps_by_name = null;
            this.srs = null;
        }
        catch (Exception e) {
            System.err.println("mapping error!: " + e);
            e.printStackTrace();
            ok = false;
        }
        return ok;
    }

    public SAMConsensusMapping[] get_sequences() {
        return this.maps;
    }

    public void get_sequences(ArrayList<AssemblySequence> list, boolean by_position) {
        int i;
        if (!by_position && this.maps_by_name == null) {
            ArrayList<String> names = new ArrayList<String>(this.name2map.keySet());
            Collections.sort(names);
            this.maps_by_name = new SAMConsensusMapping[this.maps.length];
            i = 0;
            for (String name : names) {
                this.maps_by_name[i++] = this.name2map.get(name);
            }
        }
        SAMConsensusMapping[] set = by_position ? this.maps : this.maps_by_name;
        for (i = 0; i < set.length; ++i) {
            list.add(set[i]);
        }
    }

    public AssemblySequence get_sequence(String id) {
        return this.name2map.get(id);
    }

    public void set_tumor_normal(String tn) {
        if (tn == null) {
            this.sample.set_normal(false);
            this.sample.set_tumor(false);
        } else if ((tn = tn.toUpperCase()).equals("N")) {
            this.sample.set_normal(true);
        } else if (tn.equals("T")) {
            this.sample.set_tumor(true);
        } else if (tn.equals("R")) {
            this.sample.set_recurrent();
        } else {
            System.err.println("ERROR: invalid tumor/normal value (N/T/R)");
        }
    }

    public void import_data(SAMResourceTags dtype, String value) {
        try {
            switch (dtype) {
                case SAM_URL: {
                    try {
                        this.url = new URL(value);
                    }
                    catch (MalformedURLException e) {
                        this.url = null;
                        File f = new File(value);
                        if (f.exists()) {
                            this.set_file(value);
                            break;
                        }
                        System.err.println("ERROR: can't find " + value + " as file or URL");
                    }
                    break;
                }
                case SAM_SAMPLE: {
                    this.sample.set_sample_id(new String(value));
                    break;
                }
                case SAM_TUMOR_NORMAL: {
                    this.set_tumor_normal(value);
                    break;
                }
                default: {
                    System.err.println("unhandled dtype " + (Object)((Object)dtype));
                }
            }
        }
        catch (Exception e) {
            System.err.println("SAMResource import error:");
            e.printStackTrace();
        }
    }

    public static void set_mismatch_filter(SAMMismatchFilter mf) {
        SAMResource.mf = mf;
    }

    private static String localfile_to_url(String s) {
        String result = null;
        try {
            File f = new File(s);
            result = "file://localhost/" + f.getCanonicalFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public SAMRegion get_region() {
        return this.region;
    }

    public void set_region(SAMRegion region) throws IOException {
        this.close();
        this.srs = null;
        this.name2map = new HashMap();
        this.region = region;
    }

    public void detect_sample_id() {
        String basename = null;
        if (this.url != null) {
            String path = this.url.getPath();
            int li = path.lastIndexOf("/");
            if (li > 0) {
                basename = path.substring(li + 1);
            }
        } else if (this.file != null) {
            basename = this.file.getName();
        }
        if (basename != null) {
            this.sample.set_sample_id(basename);
        }
    }

    public static void add_restrict_string(String pattern) {
        String[] s = pattern.split(",");
        RESTRICT_LOAD = true;
        System.err.println("adding restrict of " + s[0]);
        RESTRICT_STRINGS.add(new String(s[0]));
        RESTRICT_FRS.add(s.length == 1 ? "" : new String(s[1]));
    }

    public static void add_negative_restrict_string(String pattern) {
        String[] s = pattern.split(",");
        RESTRICT_LOAD = true;
        System.err.println("adding negative restrict of " + s[0]);
        RESTRICT_STRINGS_NEGATIVE.add(new String(s[0]));
    }

    public static void set_restrict_overlap(int pos) {
        RESTRICT_LOAD_OVERLAP = true;
        RESTRICT_OVERLAP = pos;
    }

    public static void set_restrict_fr(boolean is_f) {
        RESTRICT_LOAD_FR = true;
        RESTRICT_LOAD_FR_F = is_f;
    }

    public boolean has_maps() {
        return this.maps != null;
    }

    public Iterable<SAMRecord> get_samrecord_iterable() {
        return new SAMRecordArrayIterable(this.maps);
    }

    public void set_load_duplicates(boolean v) {
        this.LOAD_DUPLICATES = v;
    }

    public Sample get_sample() {
        return this.sample;
    }

    public String get_basename() {
        String result = null;
        if (this.file != null) {
            result = this.file.getName();
        } else if (this.url != null) {
            result = this.url.toString();
            System.err.println("FIX ME: basename for URL?");
        } else {
            System.err.println("error: no file or url!");
        }
        return result;
    }

    public void set_sams(SAMRecord[] srs) {
        this.srs = srs;
    }

    public void set_sams(ArrayList<SAMRecord> sams) {
        this.srs = new SAMRecord[sams.size()];
        int i = 0;
        for (SAMRecord sr : sams) {
            this.srs[i++] = sr;
        }
    }

    public static void set_skip_size(int filter_skip_size) {
        SAMResource.filter_skip_size = filter_skip_size;
    }

    public static void set_require_indel(boolean v) {
        FILTER_REQUIRE_INDEL = v;
    }

    public static void set_require_indel_type(String s) {
        CigarOperator op = null;
        if (s.equals("I")) {
            op = CigarOperator.INSERTION;
        } else if (s.equals("D")) {
            op = CigarOperator.DELETION;
        } else {
            System.err.println("ERROR: indel type filter must be I or D");
            System.exit(1);
        }
        FILTER_REQUIRE_INDEL_TYPE = op;
    }

    public static void set_require_indel_length(int i) {
        FILTER_REQUIRE_INDEL_LENGTH = i;
    }

    public static void set_ignore_perfect(boolean v) {
        FILTER_IGNORE_PERFECT = v;
    }

    public void set_query_overlap_base(int i) {
        this.query_overlap_base = i;
    }
}

