/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Chromosome;
import Ace2.ChromosomeDisambiguator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.SamReader;
import java.util.List;

public class SAMCanonicalReference {
    private ChromosomeDisambiguator cd;
    private boolean[] usable;

    public SAMCanonicalReference(SamReader reader) {
        this.setup(reader);
    }

    public void setup(SamReader reader) {
        this.cd = new ChromosomeDisambiguator(reader);
        SAMSequenceDictionary dict = reader.getFileHeader().getSequenceDictionary();
        List seqs = dict.getSequences();
        this.usable = new boolean[seqs.size()];
        for (SAMSequenceRecord ssr : seqs) {
            boolean ok;
            String name = ssr.getSequenceName();
            Chromosome ref = Chromosome.valueOfString(name);
            this.usable[ssr.getSequenceIndex()] = ok = ref != null;
        }
    }

    public boolean is_canonical(int index) {
        return this.usable[index];
    }
}

