/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntBucketIndex {
    private HashMap<Integer, ArrayList<Object>> map = new HashMap();
    private int bucket_size;

    public IntBucketIndex(int bucket_size) {
        this.bucket_size = bucket_size;
    }

    public void add(int index, Object thing) {
        Integer i = index / this.bucket_size;
        ArrayList<Object> sublist = this.map.get(i);
        if (sublist == null) {
            sublist = new ArrayList();
            this.map.put(i, sublist);
        }
        sublist.add(thing);
    }

    public void add_range(int index1, int index2, Object thing) {
        HashSet<Integer> keys = new HashSet<Integer>();
        for (int i = index1; i <= index2; ++i) {
            keys.add(i / this.bucket_size);
        }
        for (Integer key : keys) {
            ArrayList<Object> sublist = this.map.get(key);
            if (sublist == null) {
                sublist = new ArrayList();
                this.map.put(key, sublist);
            }
            Integer i2 = index2 / this.bucket_size;
            sublist.add(thing);
        }
    }

    public ArrayList<Object> find(int wanted) {
        ArrayList<Object> results = new ArrayList<Object>();
        ArrayList<Object> hits = this.map.get(wanted / this.bucket_size);
        if (hits != null) {
            results.addAll(hits);
        }
        return results;
    }

    public static void main(String[] argv) {
        int i;
        IntBucketIndex idx = new IntBucketIndex(1000);
        idx.add(1, "object at 1");
        idx.add(1, "another object at 1");
        idx.add(1, "yet another object at 1");
        for (i = 5; i < 10; ++i) {
            idx.add(i, "some obj at " + i);
        }
        for (i = 5000; i < 5020; ++i) {
            idx.add(i, "some obj at " + i);
        }
        idx.add(10, "object at 10");
        idx.add(13, "object at 13");
        ArrayList<Object> results = idx.find(5000);
        System.err.println("results:");
        for (Object o : results) {
            System.err.println((String)o);
        }
    }
}

