/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

public class IndelEquivalence {
    byte[] reference_sequence;
    static int FLANKING_BASES = 3;

    public IndelEquivalence(byte[] reference_sequence) {
        this.reference_sequence = reference_sequence;
    }

    public boolean check_insertion_equivalence(int site_1, String seq_1, int site_2, String seq_2) {
        if (site_1 > site_2) {
            System.err.println("ERROR: check_insertion_equivalence site_1 must be < site_2");
            System.exit(1);
        }
        int chunk_start = site_1 - FLANKING_BASES;
        int chunk_end = site_2 + FLANKING_BASES;
        String net1 = this.build_chunked_insertion(chunk_start, chunk_end, site_1, seq_1);
        String net2 = this.build_chunked_insertion(chunk_start, chunk_end, site_2, seq_2);
        return net1.equalsIgnoreCase(net2);
    }

    private String build_chunked_insertion(int chunk_start, int chunk_end, int site_1, String seq_1) {
        String result = "";
        String upstream = new String(this.reference_sequence, chunk_start, site_1 - chunk_start);
        String downstream = new String(this.reference_sequence, site_1, chunk_end - site_1);
        return upstream + seq_1 + downstream;
    }

    public boolean check_deletion_equivalence(int site_1, int site_2, int length) {
        if (site_1 > site_2) {
            System.err.println("ERROR: check_deletion_equivalence site_1 must be < site_2");
            System.exit(1);
        }
        int chunk_start = site_1 - FLANKING_BASES;
        int chunk_end = site_2 + FLANKING_BASES + length;
        String net1 = this.build_chunked_deletion(chunk_start, chunk_end, site_1, length);
        String net2 = this.build_chunked_deletion(chunk_start, chunk_end, site_2, length);
        System.err.println("del_net1=" + net1);
        System.err.println("del_net2=" + net2);
        return net1.equalsIgnoreCase(net2);
    }

    private String build_chunked_deletion(int chunk_start, int chunk_end, int site_1, int length) {
        String result = "";
        String upstream = new String(this.reference_sequence, chunk_start, site_1 - chunk_start);
        String downstream = new String(this.reference_sequence, site_1 + length, chunk_end - (site_1 + length));
        System.err.print("chunk = " + upstream + "/");
        for (int i = 0; i < length; ++i) {
            System.err.print(" ");
        }
        System.err.println("/" + downstream);
        return upstream + downstream;
    }
}

