/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import Ace2.Assembly;
import Ace2.AssemblySequence;
import java.awt.FontMetrics;
import java.util.HashSet;

public class FontWidthTracker
implements Runnable {
    private FontMetrics fm;
    private Assembly assembly;
    private int max_width;
    private boolean finished;
    static HashSet<String> tracked_strings = new HashSet();

    public FontWidthTracker(FontMetrics fm, Assembly assembly) {
        this.fm = fm;
        this.assembly = assembly;
        if (assembly.alignment_is_built()) {
            this.run();
        } else {
            System.err.println("ERROR: asm must be built first");
        }
    }

    public void run() {
        int w;
        this.finished = false;
        this.max_width = 0;
        for (AssemblySequence as : this.assembly.get_sequences()) {
            w = this.fm.stringWidth(as.get_name());
            if (w <= this.max_width) continue;
            this.max_width = w;
        }
        for (String s : tracked_strings) {
            w = this.fm.stringWidth(s);
            if (w <= this.max_width) continue;
            this.max_width = w;
        }
        this.finished = true;
    }

    public int get_max_width() {
        if (this.finished) {
            return this.max_width;
        }
        return this.assembly.get_max_id_length() * this.fm.stringWidth("W");
    }

    public static void add_tracked_string(String s) {
        tracked_strings.add(s);
    }
}

