/*
 * Decompiled with CFR 0.152.
 */
package Ace2;

import htsjdk.samtools.SAMRecord;
import java.util.HashMap;

public class DuplicateLimiter {
    int LIMIT;
    boolean REPORT_LIMITS = true;
    int last_chr = -1;
    int last_start = -1;
    HashMap<String, Integer> counter;
    SAMRecord last_sr;

    public DuplicateLimiter(int limit) {
        this.set_limit(limit);
        this.reset();
    }

    public void set_limit(int limit) {
        this.LIMIT = limit;
    }

    private void reset() {
        if (this.REPORT_LIMITS && this.counter != null) {
            boolean limited_read_count = false;
            for (String s : this.counter.keySet()) {
                int count = this.counter.get(s);
                if (count <= this.LIMIT) continue;
                System.err.print("limited read " + s + " at ");
                if (this.last_sr == null) {
                    System.err.print("index " + this.last_chr);
                } else {
                    System.err.print(this.last_sr.getReferenceName());
                }
                System.err.println("." + this.last_start + " with count " + count);
            }
        }
        this.counter = new HashMap();
    }

    public boolean add(SAMRecord sr, String prefix) {
        String seq = prefix + "_" + new String(sr.getReadBases());
        boolean result = this.add(sr.getReferenceIndex(), sr.getAlignmentStart(), seq);
        this.last_sr = sr;
        return result;
    }

    public boolean add(int chr_index, int map_start, String sequence) {
        if (chr_index != this.last_chr || map_start != this.last_start) {
            this.reset();
        }
        this.last_chr = chr_index;
        this.last_start = map_start;
        Integer ci = this.counter.get(sequence);
        if (ci == null) {
            ci = 0;
        }
        int count = ci + 1;
        this.counter.put(sequence, count);
        return count <= this.LIMIT;
    }

    public void finish() {
        this.reset();
    }

    public static void main(String[] argv) {
        int i;
        DuplicateLimiter dl = new DuplicateLimiter(3);
        dl.set_limit(3);
        for (i = 0; i < 5; ++i) {
            System.err.println(dl.add(1, 1, "test"));
        }
        for (i = 0; i < 5; ++i) {
            System.err.println(dl.add(1, 2, "test"));
        }
        for (i = 0; i < 5; ++i) {
            System.err.println(dl.add(2, 1, "test"));
        }
        dl.finish();
    }
}

