# cryptoapis
Crypto APIs 2.0 is a complex and innovative infrastructure layer that radically simplifies the development of any Blockchain and Crypto related applications. Organized around REST, Crypto APIs 2.0 can assist both novice Bitcoin/Ethereum enthusiasts and crypto experts with the development of their blockchain applications. Crypto APIs 2.0 provides unified endpoints and data, raw data, automatic tokens and coins forwardings, callback functionalities, and much more.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2.0.0
- Package version: 1.2.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://cryptoapis.io](https://cryptoapis.io)

## Requirements.

Python >= 3.6

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install cryptoapis
```

Then import the package:
```python
import cryptoapis
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import cryptoapis
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import time
import cryptoapis
from pprint import pprint
from cryptoapis.api import assets_api
from cryptoapis.model.feature_mainnets_not_allowed_for_plan import FeatureMainnetsNotAllowedForPlan
from cryptoapis.model.insufficient_credits import InsufficientCredits
from cryptoapis.model.invalid_api_key import InvalidApiKey
from cryptoapis.model.invalid_data import InvalidData
from cryptoapis.model.invalid_pagination import InvalidPagination
from cryptoapis.model.invalid_request_body_structure import InvalidRequestBodyStructure
from cryptoapis.model.list_assets_details_r import ListAssetsDetailsR
from cryptoapis.model.request_limit_reached import RequestLimitReached
from cryptoapis.model.unexpected_server_error import UnexpectedServerError
from cryptoapis.model.unsupported_media_type import UnsupportedMediaType
# Defining the host is optional and defaults to https://rest.cryptoapis.io/v2
# See configuration.py for a list of all supported configuration parameters.
configuration = cryptoapis.Configuration(
    host = "https://rest.cryptoapis.io/v2"
)

# The client must configure the authentication and authorization parameters
# in accordance with the API server security policy.
# Examples for each auth method are provided below, use the example that
# satisfies your auth use case.

# Configure API key authorization: ApiKey
configuration.api_key['ApiKey'] = 'YOUR_API_KEY'

# Uncomment below to setup prefix (e.g. Bearer) for API key, if needed
# configuration.api_key_prefix['ApiKey'] = 'Bearer'


# Enter a context with an instance of the API client
with cryptoapis.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = assets_api.AssetsApi(api_client)
    context = "context_example" # str | In batch situations the user can use the context to correlate responses with requests. This property is present regardless of whether the response was successful or returned as an error. `context` is specified by the user. (optional)
asset_type = "crypto" # str | Defines the type of the supported asset. This could be either \"crypto\" or \"fiat\". (optional)
crypto_type = "coin" # str | Subtype of the crypto assets. Could be COIN or TOKEN (optional)
limit = 50 # int | Defines how many items should be returned in the response per page basis. (optional) (default to 50)
offset = 10 # int | The starting index of the response items, i.e. where the response should start listing the returned items. (optional) (default to 0)
waas_enabled = True # bool | Show only if WaaS is/not enabled (optional)

    try:
        # List Assets Details
        api_response = api_instance.list_assets_details(context=context, asset_type=asset_type, crypto_type=crypto_type, limit=limit, offset=offset, waas_enabled=waas_enabled)
        pprint(api_response)
    except cryptoapis.ApiException as e:
        print("Exception when calling AssetsApi->list_assets_details: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://rest.cryptoapis.io/v2*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AssetsApi* | [**list_assets_details**](docs/AssetsApi.md#list_assets_details) | **GET** /market-data/assets/details | List Assets Details
*AutomaticCoinsForwardingApi* | [**create_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#create_automatic_coins_forwarding) | **POST** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | Create Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**delete_automatic_coins_forwarding**](docs/AutomaticCoinsForwardingApi.md#delete_automatic_coins_forwarding) | **DELETE** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations/{referenceId} | Delete Automatic Coins Forwarding
*AutomaticCoinsForwardingApi* | [**list_coins_forwarding_automations**](docs/AutomaticCoinsForwardingApi.md#list_coins_forwarding_automations) | **GET** /blockchain-automations/{blockchain}/{network}/coins-forwarding/automations | List Coins Forwarding Automations
*AutomaticTokensForwardingApi* | [**add_tokens_to_existing_from_address**](docs/AutomaticTokensForwardingApi.md#add_tokens_to_existing_from_address) | **POST** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/add-token | Add Tokens To Existing fromAddress
*AutomaticTokensForwardingApi* | [**create_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#create_automatic_tokens_forwarding) | **POST** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | Create Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**delete_automatic_tokens_forwarding**](docs/AutomaticTokensForwardingApi.md#delete_automatic_tokens_forwarding) | **DELETE** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations/{referenceId} | Delete Automatic Tokens Forwarding
*AutomaticTokensForwardingApi* | [**get_fee_address_details**](docs/AutomaticTokensForwardingApi.md#get_fee_address_details) | **GET** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/fee-addresses | Get Fee Address Details
*AutomaticTokensForwardingApi* | [**list_tokens_forwarding_automations**](docs/AutomaticTokensForwardingApi.md#list_tokens_forwarding_automations) | **GET** /blockchain-automations/{blockchain}/{network}/tokens-forwarding/automations | List Tokens Forwarding Automations
*CreateSubscriptionsForApi* | [**mined_transaction**](docs/CreateSubscriptionsForApi.md#mined_transaction) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/transaction-mined | Mined transaction
*CreateSubscriptionsForApi* | [**new_block**](docs/CreateSubscriptionsForApi.md#new_block) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/block-mined | New Block
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed | New confirmed coins transactions
*CreateSubscriptionsForApi* | [**new_confirmed_coins_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_coins_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-confirmed-each-confirmation | New confirmed coins transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_confirmed_internal_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_internal_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-internal-transactions-confirmed | New confirmed internal transactions
*CreateSubscriptionsForApi* | [**new_confirmed_internal_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_internal_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-internal-transactions-confirmed-each-confirmation | New confirmed internal transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed | New confirmed tokens transactions
*CreateSubscriptionsForApi* | [**new_confirmed_tokens_transactions_and_each_confirmation**](docs/CreateSubscriptionsForApi.md#new_confirmed_tokens_transactions_and_each_confirmation) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-confirmed-each-confirmation | New confirmed tokens transactions and each confirmation
*CreateSubscriptionsForApi* | [**new_unconfirmed_coins_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_coins_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-coins-transactions-unconfirmed | New unconfirmed coins transactions
*CreateSubscriptionsForApi* | [**new_unconfirmed_tokens_transactions**](docs/CreateSubscriptionsForApi.md#new_unconfirmed_tokens_transactions) | **POST** /blockchain-events/{blockchain}/{network}/subscriptions/address-tokens-transactions-unconfirmed | New unconfirmed tokens transactions
*ExchangeRatesApi* | [**get_exchange_rate_by_asset_symbols**](docs/ExchangeRatesApi.md#get_exchange_rate_by_asset_symbols) | **GET** /market-data/exchange-rates/by-symbols/{fromAssetSymbol}/{toAssetSymbol} | Get Exchange Rate By Asset Symbols
*ExchangeRatesApi* | [**get_exchange_rate_by_assets_ids**](docs/ExchangeRatesApi.md#get_exchange_rate_by_assets_ids) | **GET** /market-data/exchange-rates/by-asset-ids/{fromAssetId}/{toAssetId} | Get Exchange Rate By Assets IDs
*FeaturesApi* | [**broadcast_locally_signed_transaction**](docs/FeaturesApi.md#broadcast_locally_signed_transaction) | **POST** /blockchain-tools/{blockchain}/{network}/transactions/broadcast | Broadcast Locally Signed Transaction
*FeaturesApi* | [**validate_address**](docs/FeaturesApi.md#validate_address) | **POST** /blockchain-tools/{blockchain}/{network}/addresses/validate | Validate Address
*GeneratingApi* | [**generate_deposit_address**](docs/GeneratingApi.md#generate_deposit_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses | Generate Deposit Address
*InformativeApi* | [**get_wallet_asset_details**](docs/InformativeApi.md#get_wallet_asset_details) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network} | Get Wallet Asset Details
*InformativeApi* | [**list_deposit_addresses**](docs/InformativeApi.md#list_deposit_addresses) | **GET** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses | List Deposit Addresses
*InformativeApi* | [**list_supported_tokens**](docs/InformativeApi.md#list_supported_tokens) | **GET** /wallet-as-a-service/info/{blockchain}/{network}/supported-tokens | List Supported Tokens
*ManageSubscriptionsApi* | [**delete_blockchain_event_subscription**](docs/ManageSubscriptionsApi.md#delete_blockchain_event_subscription) | **DELETE** /blockchain-events/{blockchain}/{network}/subscriptions/{referenceId} | Delete Blockchain Event Subscription
*ManageSubscriptionsApi* | [**list_blockchain_events_subscriptions**](docs/ManageSubscriptionsApi.md#list_blockchain_events_subscriptions) | **GET** /blockchain-events/{blockchain}/{network}/subscriptions | List Blockchain Events Subscriptions
*MetadataApi* | [**list_supported_assets**](docs/MetadataApi.md#list_supported_assets) | **GET** /market-data/assets/supported | List Supported Assets
*OmniLayerApi* | [**get_omni_transaction_details_by_transaction_id__txid**](docs/OmniLayerApi.md#get_omni_transaction_details_by_transaction_id__txid) | **GET** /blockchain-data/{blockchain}/{network}/omni/transactions/{transactionId} | Get Omni Transaction Details By Transaction ID (Txid)
*OmniLayerApi* | [**get_unconfirmed_omni_transaction_by_transaction_id__txid**](docs/OmniLayerApi.md#get_unconfirmed_omni_transaction_by_transaction_id__txid) | **GET** /blockchain-data/{blockchain}/{network}/omni/transactions-unconfirmed/{transactionId} | Get Unconfirmed Omni Transaction By Transaction ID (Txid)
*OmniLayerApi* | [**list_omni_tokens_by_address**](docs/OmniLayerApi.md#list_omni_tokens_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/addresses/{address} | List Omni Tokens By Address
*OmniLayerApi* | [**list_omni_transactions_by_address**](docs/OmniLayerApi.md#list_omni_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/addresses/{address}/transactions | List Omni Transactions By Address
*OmniLayerApi* | [**list_omni_transactions_by_block_hash**](docs/OmniLayerApi.md#list_omni_transactions_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/omni/blocks/hash/{blockHash}/transactions | List Omni Transactions By Block Hash
*OmniLayerApi* | [**list_omni_transactions_by_block_height**](docs/OmniLayerApi.md#list_omni_transactions_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/omni/blocks/height/{blockHeight}/transactions | List Omni Transactions By Block Height
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_address**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/omni/address-transactions-unconfirmed/{address} | List Unconfirmed Omni Transactions By Address
*OmniLayerApi* | [**list_unconfirmed_omni_transactions_by_property_id**](docs/OmniLayerApi.md#list_unconfirmed_omni_transactions_by_property_id) | **GET** /blockchain-data/{blockchain}/{network}/omni/properties/{propertyId}/transactions | List Unconfirmed Omni Transactions By Property ID
*TokensApi* | [**get_contract_details_by_address**](docs/TokensApi.md#get_contract_details_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{contractAddress}/contract | Get Contract Details by Address
*TokensApi* | [**list_tokens_by_address**](docs/TokensApi.md#list_tokens_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens | List Tokens By Address
*TokensApi* | [**list_tokens_transfers_by_address**](docs/TokensApi.md#list_tokens_transfers_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/tokens-transfers | List Tokens Transfers By Address
*TokensApi* | [**list_tokens_transfers_by_transaction_hash**](docs/TokensApi.md#list_tokens_transfers_by_transaction_hash) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/tokens-transfers | List Tokens Transfers By Transaction Hash
*TransactionsApi* | [**create_coins_transaction_request_from_address**](docs/TransactionsApi.md#create_coins_transaction_request_from_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{address}/transaction-requests | Create Coins Transaction Request from Address
*TransactionsApi* | [**create_coins_transaction_request_from_wallet**](docs/TransactionsApi.md#create_coins_transaction_request_from_wallet) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/transaction-requests | Create Coins Transaction Request from Wallet
*TransactionsApi* | [**create_tokens_transaction_request_from_address**](docs/TransactionsApi.md#create_tokens_transaction_request_from_address) | **POST** /wallet-as-a-service/wallets/{walletId}/{blockchain}/{network}/addresses/{senderAddress}/token-transaction-requests | Create Tokens Transaction Request from Address
*UTXOBasedApi* | [**get_hd_wallet__x_pub_y_pub_z_pub_details**](docs/UTXOBasedApi.md#get_hd_wallet__x_pub_y_pub_z_pub_details) | **GET** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/details | Get HD Wallet (xPub, yPub, zPub) Details
*UTXOBasedApi* | [**list_hd_wallet__x_pub_y_pub_z_pub_transactions**](docs/UTXOBasedApi.md#list_hd_wallet__x_pub_y_pub_z_pub_transactions) | **GET** /blockchain-data/{blockchain}/{network}/hd/{extendedPublicKey}/transactions | List HD Wallet (xPub, yPub, zPub) Transactions
*UTXOBasedApi* | [**sync_hd_wallet__x_pub_y_pub_z_pub**](docs/UTXOBasedApi.md#sync_hd_wallet__x_pub_y_pub_z_pub) | **POST** /blockchain-data/{blockchain}/{network}/hd/sync | Sync HD Wallet (xPub, yPub, zPub)
*UnifiedEndpointsApi* | [**get_address_details**](docs/UnifiedEndpointsApi.md#get_address_details) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address} | Get Address Details
*UnifiedEndpointsApi* | [**get_block_details_by_block_hash**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash} | Get Block Details By Block Hash
*UnifiedEndpointsApi* | [**get_block_details_by_block_height**](docs/UnifiedEndpointsApi.md#get_block_details_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/blocks/height/{height} | Get Block Details By Block Height
*UnifiedEndpointsApi* | [**get_fee_recommendations**](docs/UnifiedEndpointsApi.md#get_fee_recommendations) | **GET** /blockchain-data/{blockchain}/{network}/mempool/fees | Get Fee Recommendations
*UnifiedEndpointsApi* | [**get_latest_mined_block**](docs/UnifiedEndpointsApi.md#get_latest_mined_block) | **GET** /blockchain-data/{blockchain}/{network}/blocks/last | Get Latest Mined Block
*UnifiedEndpointsApi* | [**get_transaction_details_by_transaction_id**](docs/UnifiedEndpointsApi.md#get_transaction_details_by_transaction_id) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionId} | Get Transaction Details By Transaction ID
*UnifiedEndpointsApi* | [**list_transactions_by_address**](docs/UnifiedEndpointsApi.md#list_transactions_by_address) | **GET** /blockchain-data/{blockchain}/{network}/addresses/{address}/transactions | List Transactions By Address
*UnifiedEndpointsApi* | [**list_transactions_by_block_hash**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_hash) | **GET** /blockchain-data/{blockchain}/{network}/blocks/hash/{blockHash}/transactions | List Transactions by Block Hash
*UnifiedEndpointsApi* | [**list_transactions_by_block_height**](docs/UnifiedEndpointsApi.md#list_transactions_by_block_height) | **GET** /blockchain-data/{blockchain}/{network}/blocks/height/{height}/transactions | List Transactions by Block Height
*XRPRippleApi* | [**get_latest_mined_xrp__ripple_block**](docs/XRPRippleApi.md#get_latest_mined_xrp__ripple_block) | **GET** /blockchain-data/xrp-specific/{network}/blocks/last | Get Latest Mined XRP (Ripple) Block
*XRPRippleApi* | [**get_xrp__ripple_address_details**](docs/XRPRippleApi.md#get_xrp__ripple_address_details) | **GET** /blockchain-data/xrp-specific/{network}/addresses/{address} | Get XRP (Ripple) Address Details
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_hash**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_hash) | **GET** /blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash} | Get XRP (Ripple) Block Details By Block Hash
*XRPRippleApi* | [**get_xrp__ripple_block_details_by_block_height**](docs/XRPRippleApi.md#get_xrp__ripple_block_details_by_block_height) | **GET** /blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight} | Get XRP (Ripple) Block Details By Block Height
*XRPRippleApi* | [**get_xrp__ripple_transaction_details_by_transaction_id**](docs/XRPRippleApi.md#get_xrp__ripple_transaction_details_by_transaction_id) | **GET** /blockchain-data/xrp-specific/{network}/transactions/{transactionHash} | Get XRP (Ripple) Transaction Details By Transaction ID
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_address**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_address) | **GET** /blockchain-data/xrp-specific/{network}/addresses/{address}/transactions | List XRP (Ripple) Transactions by Address
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_block_hash**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_block_hash) | **GET** /blockchain-data/xrp-specific/{network}/blocks/hash/{blockHash}/transactions | List XRP (Ripple) Transactions By Block Hash
*XRPRippleApi* | [**list_xrp__ripple_transactions_by_block_height**](docs/XRPRippleApi.md#list_xrp__ripple_transactions_by_block_height) | **GET** /blockchain-data/xrp-specific/{network}/blocks/height/{blockHeight}/transactions | List XRP (Ripple) Transactions By Block Height
*ZilliqaApi* | [**get_latest_mined_zilliqa_block**](docs/ZilliqaApi.md#get_latest_mined_zilliqa_block) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/last | Get Latest Mined Zilliqa Block
*ZilliqaApi* | [**get_zilliqa_address_details**](docs/ZilliqaApi.md#get_zilliqa_address_details) | **GET** /blockchain-data/zilliqa-specific/{network}/addresses/{address} | Get Zilliqa Address Details
*ZilliqaApi* | [**get_zilliqa_block_details_by_block_hash**](docs/ZilliqaApi.md#get_zilliqa_block_details_by_block_hash) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash} | Get Zilliqa Block Details By Block Hash
*ZilliqaApi* | [**get_zilliqa_block_details_by_block_height**](docs/ZilliqaApi.md#get_zilliqa_block_details_by_block_height) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight} | Get Zilliqa Block Details By Block Height
*ZilliqaApi* | [**get_zilliqa_transaction_details_by_transaction_id**](docs/ZilliqaApi.md#get_zilliqa_transaction_details_by_transaction_id) | **GET** /blockchain-data/zilliqa-specific/{network}/transactions/{transactionHash} | Get Zilliqa Transaction Details by Transaction ID
*ZilliqaApi* | [**list_zilliqa_transactions_by_address**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_address) | **GET** /blockchain-data/zilliqa-specific/{network}/addresses/{address}/transactions | List Zilliqa Transactions by Address
*ZilliqaApi* | [**list_zilliqa_transactions_by_block_hash**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_block_hash) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/hash/{blockHash}/transactions | List Zilliqa Transactions By Block Hash
*ZilliqaApi* | [**list_zilliqa_transactions_by_block_height**](docs/ZilliqaApi.md#list_zilliqa_transactions_by_block_height) | **GET** /blockchain-data/zilliqa-specific/{network}/blocks/height/{blockHeight}/transactions | List Zilliqa Transactions By Block Height
*InternalApi* | [**get_internal_transaction_by_transaction_hash_and_operation_id**](docs/InternalApi.md#get_internal_transaction_by_transaction_hash_and_operation_id) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/internal/{operationId} | Get Internal Transaction by Transaction Hash and Operation Id
*InternalApi* | [**list_internal_transaction_details_by_transaction_hash**](docs/InternalApi.md#list_internal_transaction_details_by_transaction_hash) | **GET** /blockchain-data/{blockchain}/{network}/transactions/{transactionHash}/internal | List Internal Transaction Details by Transaction Hash


## Documentation For Models

 - [AddTokensToExistingFromAddressR](docs/AddTokensToExistingFromAddressR.md)
 - [AddTokensToExistingFromAddressRB](docs/AddTokensToExistingFromAddressRB.md)
 - [AddTokensToExistingFromAddressRBData](docs/AddTokensToExistingFromAddressRBData.md)
 - [AddTokensToExistingFromAddressRBDataItem](docs/AddTokensToExistingFromAddressRBDataItem.md)
 - [AddTokensToExistingFromAddressRBTokenData](docs/AddTokensToExistingFromAddressRBTokenData.md)
 - [AddTokensToExistingFromAddressRBTokenDataBitcoinOmniToken](docs/AddTokensToExistingFromAddressRBTokenDataBitcoinOmniToken.md)
 - [AddTokensToExistingFromAddressRBTokenDataEthereumErc20Token](docs/AddTokensToExistingFromAddressRBTokenDataEthereumErc20Token.md)
 - [AddTokensToExistingFromAddressRData](docs/AddTokensToExistingFromAddressRData.md)
 - [AddTokensToExistingFromAddressRI](docs/AddTokensToExistingFromAddressRI.md)
 - [AddTokensToExistingFromAddressRITS](docs/AddTokensToExistingFromAddressRITS.md)
 - [AddTokensToExistingFromAddressRITSBOT](docs/AddTokensToExistingFromAddressRITSBOT.md)
 - [AddTokensToExistingFromAddressRITSEET](docs/AddTokensToExistingFromAddressRITSEET.md)
 - [AddressCoinsTransactionConfirmed](docs/AddressCoinsTransactionConfirmed.md)
 - [AddressCoinsTransactionConfirmedData](docs/AddressCoinsTransactionConfirmedData.md)
 - [AddressCoinsTransactionConfirmedDataItem](docs/AddressCoinsTransactionConfirmedDataItem.md)
 - [AddressCoinsTransactionConfirmedDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressCoinsTransactionConfirmedEachConfirmation](docs/AddressCoinsTransactionConfirmedEachConfirmation.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationData](docs/AddressCoinsTransactionConfirmedEachConfirmationData.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItem](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock](docs/AddressCoinsTransactionConfirmedEachConfirmationDataItemMinedInBlock.md)
 - [AddressCoinsTransactionUnconfirmed](docs/AddressCoinsTransactionUnconfirmed.md)
 - [AddressCoinsTransactionUnconfirmedData](docs/AddressCoinsTransactionUnconfirmedData.md)
 - [AddressCoinsTransactionUnconfirmedDataItem](docs/AddressCoinsTransactionUnconfirmedDataItem.md)
 - [AddressTokensTransactionConfirmed](docs/AddressTokensTransactionConfirmed.md)
 - [AddressTokensTransactionConfirmedData](docs/AddressTokensTransactionConfirmedData.md)
 - [AddressTokensTransactionConfirmedDataItem](docs/AddressTokensTransactionConfirmedDataItem.md)
 - [AddressTokensTransactionConfirmedDataItemMinedInBlock](docs/AddressTokensTransactionConfirmedDataItemMinedInBlock.md)
 - [AddressTokensTransactionConfirmedEachConfirmation](docs/AddressTokensTransactionConfirmedEachConfirmation.md)
 - [AddressTokensTransactionConfirmedEachConfirmationData](docs/AddressTokensTransactionConfirmedEachConfirmationData.md)
 - [AddressTokensTransactionConfirmedEachConfirmationDataItem](docs/AddressTokensTransactionConfirmedEachConfirmationDataItem.md)
 - [AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock](docs/AddressTokensTransactionConfirmedEachConfirmationDataItemMinedInBlock.md)
 - [AddressTokensTransactionConfirmedEachConfirmationEthereumerc20token](docs/AddressTokensTransactionConfirmedEachConfirmationEthereumerc20token.md)
 - [AddressTokensTransactionConfirmedEachConfirmationEthereumerc721token](docs/AddressTokensTransactionConfirmedEachConfirmationEthereumerc721token.md)
 - [AddressTokensTransactionConfirmedEachConfirmationOmnilayertoken](docs/AddressTokensTransactionConfirmedEachConfirmationOmnilayertoken.md)
 - [AddressTokensTransactionConfirmedEachConfirmationToken](docs/AddressTokensTransactionConfirmedEachConfirmationToken.md)
 - [AddressTokensTransactionConfirmedEthereumerc20token](docs/AddressTokensTransactionConfirmedEthereumerc20token.md)
 - [AddressTokensTransactionConfirmedEthereumerc721token](docs/AddressTokensTransactionConfirmedEthereumerc721token.md)
 - [AddressTokensTransactionConfirmedOmnilayertoken](docs/AddressTokensTransactionConfirmedOmnilayertoken.md)
 - [AddressTokensTransactionConfirmedToken](docs/AddressTokensTransactionConfirmedToken.md)
 - [AddressTokensTransactionUnconfirmed](docs/AddressTokensTransactionUnconfirmed.md)
 - [AddressTokensTransactionUnconfirmedData](docs/AddressTokensTransactionUnconfirmedData.md)
 - [AddressTokensTransactionUnconfirmedDataItem](docs/AddressTokensTransactionUnconfirmedDataItem.md)
 - [AddressTokensTransactionUnconfirmedEthereumerc20token](docs/AddressTokensTransactionUnconfirmedEthereumerc20token.md)
 - [AddressTokensTransactionUnconfirmedEthereumerc721token](docs/AddressTokensTransactionUnconfirmedEthereumerc721token.md)
 - [AddressTokensTransactionUnconfirmedOmnilayertoken](docs/AddressTokensTransactionUnconfirmedOmnilayertoken.md)
 - [AddressTokensTransactionUnconfirmedToken](docs/AddressTokensTransactionUnconfirmedToken.md)
 - [AlreadyExists](docs/AlreadyExists.md)
 - [AlreadyExistsError](docs/AlreadyExistsError.md)
 - [BannedIpAddress](docs/BannedIpAddress.md)
 - [BannedIpAddressError](docs/BannedIpAddressError.md)
 - [BannedIpAddressErrorDetails](docs/BannedIpAddressErrorDetails.md)
 - [BlockMined](docs/BlockMined.md)
 - [BlockMinedData](docs/BlockMinedData.md)
 - [BlockMinedDataItem](docs/BlockMinedDataItem.md)
 - [BlockchainDataBlockNotFound](docs/BlockchainDataBlockNotFound.md)
 - [BlockchainDataBlockNotFoundError](docs/BlockchainDataBlockNotFoundError.md)
 - [BlockchainDataInternalTransactionNotFound](docs/BlockchainDataInternalTransactionNotFound.md)
 - [BlockchainDataInternalTransactionNotFoundError](docs/BlockchainDataInternalTransactionNotFoundError.md)
 - [BlockchainDataTransactionNotFound](docs/BlockchainDataTransactionNotFound.md)
 - [BlockchainDataTransactionNotFoundError](docs/BlockchainDataTransactionNotFoundError.md)
 - [BlockchainEventsCallbacksLimitReached](docs/BlockchainEventsCallbacksLimitReached.md)
 - [BlockchainEventsCallbacksLimitReachedError](docs/BlockchainEventsCallbacksLimitReachedError.md)
 - [BroadcastLocallySignedTransactionR](docs/BroadcastLocallySignedTransactionR.md)
 - [BroadcastLocallySignedTransactionRB](docs/BroadcastLocallySignedTransactionRB.md)
 - [BroadcastLocallySignedTransactionRBData](docs/BroadcastLocallySignedTransactionRBData.md)
 - [BroadcastLocallySignedTransactionRBDataItem](docs/BroadcastLocallySignedTransactionRBDataItem.md)
 - [BroadcastLocallySignedTransactionRData](docs/BroadcastLocallySignedTransactionRData.md)
 - [BroadcastLocallySignedTransactionRI](docs/BroadcastLocallySignedTransactionRI.md)
 - [BroadcastTransactionFail](docs/BroadcastTransactionFail.md)
 - [BroadcastTransactionFailData](docs/BroadcastTransactionFailData.md)
 - [BroadcastTransactionFailDataItem](docs/BroadcastTransactionFailDataItem.md)
 - [BroadcastTransactionSuccess](docs/BroadcastTransactionSuccess.md)
 - [BroadcastTransactionSuccessData](docs/BroadcastTransactionSuccessData.md)
 - [BroadcastTransactionSuccessDataItem](docs/BroadcastTransactionSuccessDataItem.md)
 - [CoinsForwardingAutomationsLimitReached](docs/CoinsForwardingAutomationsLimitReached.md)
 - [CoinsForwardingAutomationsLimitReachedError](docs/CoinsForwardingAutomationsLimitReachedError.md)
 - [CoinsForwardingFail](docs/CoinsForwardingFail.md)
 - [CoinsForwardingFailData](docs/CoinsForwardingFailData.md)
 - [CoinsForwardingFailDataItem](docs/CoinsForwardingFailDataItem.md)
 - [CoinsForwardingSuccess](docs/CoinsForwardingSuccess.md)
 - [CoinsForwardingSuccessData](docs/CoinsForwardingSuccessData.md)
 - [CoinsForwardingSuccessDataItem](docs/CoinsForwardingSuccessDataItem.md)
 - [CouldNotCalculateRateForPair](docs/CouldNotCalculateRateForPair.md)
 - [CouldNotCalculateRateForPairError](docs/CouldNotCalculateRateForPairError.md)
 - [CreateAutomaticCoinsForwardingR](docs/CreateAutomaticCoinsForwardingR.md)
 - [CreateAutomaticCoinsForwardingRB](docs/CreateAutomaticCoinsForwardingRB.md)
 - [CreateAutomaticCoinsForwardingRBData](docs/CreateAutomaticCoinsForwardingRBData.md)
 - [CreateAutomaticCoinsForwardingRBDataItem](docs/CreateAutomaticCoinsForwardingRBDataItem.md)
 - [CreateAutomaticCoinsForwardingRData](docs/CreateAutomaticCoinsForwardingRData.md)
 - [CreateAutomaticCoinsForwardingRI](docs/CreateAutomaticCoinsForwardingRI.md)
 - [CreateAutomaticTokensForwardingR](docs/CreateAutomaticTokensForwardingR.md)
 - [CreateAutomaticTokensForwardingRB](docs/CreateAutomaticTokensForwardingRB.md)
 - [CreateAutomaticTokensForwardingRBData](docs/CreateAutomaticTokensForwardingRBData.md)
 - [CreateAutomaticTokensForwardingRBDataItem](docs/CreateAutomaticTokensForwardingRBDataItem.md)
 - [CreateAutomaticTokensForwardingRBTokenData](docs/CreateAutomaticTokensForwardingRBTokenData.md)
 - [CreateAutomaticTokensForwardingRBTokenDataBitcoinOmniToken](docs/CreateAutomaticTokensForwardingRBTokenDataBitcoinOmniToken.md)
 - [CreateAutomaticTokensForwardingRBTokenDataEthereumToken](docs/CreateAutomaticTokensForwardingRBTokenDataEthereumToken.md)
 - [CreateAutomaticTokensForwardingRData](docs/CreateAutomaticTokensForwardingRData.md)
 - [CreateAutomaticTokensForwardingRI](docs/CreateAutomaticTokensForwardingRI.md)
 - [CreateAutomaticTokensForwardingRITS](docs/CreateAutomaticTokensForwardingRITS.md)
 - [CreateAutomaticTokensForwardingRITSBOT](docs/CreateAutomaticTokensForwardingRITSBOT.md)
 - [CreateAutomaticTokensForwardingRITSET](docs/CreateAutomaticTokensForwardingRITSET.md)
 - [CreateCoinsTransactionRequestFromAddressR](docs/CreateCoinsTransactionRequestFromAddressR.md)
 - [CreateCoinsTransactionRequestFromAddressRB](docs/CreateCoinsTransactionRequestFromAddressRB.md)
 - [CreateCoinsTransactionRequestFromAddressRBData](docs/CreateCoinsTransactionRequestFromAddressRBData.md)
 - [CreateCoinsTransactionRequestFromAddressRBDataItem](docs/CreateCoinsTransactionRequestFromAddressRBDataItem.md)
 - [CreateCoinsTransactionRequestFromAddressRData](docs/CreateCoinsTransactionRequestFromAddressRData.md)
 - [CreateCoinsTransactionRequestFromAddressRI](docs/CreateCoinsTransactionRequestFromAddressRI.md)
 - [CreateCoinsTransactionRequestFromAddressRIRecipients](docs/CreateCoinsTransactionRequestFromAddressRIRecipients.md)
 - [CreateCoinsTransactionRequestFromAddressRISenders](docs/CreateCoinsTransactionRequestFromAddressRISenders.md)
 - [CreateCoinsTransactionRequestFromWalletR](docs/CreateCoinsTransactionRequestFromWalletR.md)
 - [CreateCoinsTransactionRequestFromWalletRB](docs/CreateCoinsTransactionRequestFromWalletRB.md)
 - [CreateCoinsTransactionRequestFromWalletRBData](docs/CreateCoinsTransactionRequestFromWalletRBData.md)
 - [CreateCoinsTransactionRequestFromWalletRBDataItem](docs/CreateCoinsTransactionRequestFromWalletRBDataItem.md)
 - [CreateCoinsTransactionRequestFromWalletRBDataItemRecipients](docs/CreateCoinsTransactionRequestFromWalletRBDataItemRecipients.md)
 - [CreateCoinsTransactionRequestFromWalletRData](docs/CreateCoinsTransactionRequestFromWalletRData.md)
 - [CreateCoinsTransactionRequestFromWalletRI](docs/CreateCoinsTransactionRequestFromWalletRI.md)
 - [CreateCoinsTransactionRequestFromWalletRIRecipients](docs/CreateCoinsTransactionRequestFromWalletRIRecipients.md)
 - [CreateTokensTransactionRequestFromAddressR](docs/CreateTokensTransactionRequestFromAddressR.md)
 - [CreateTokensTransactionRequestFromAddressRB](docs/CreateTokensTransactionRequestFromAddressRB.md)
 - [CreateTokensTransactionRequestFromAddressRBData](docs/CreateTokensTransactionRequestFromAddressRBData.md)
 - [CreateTokensTransactionRequestFromAddressRBDataItem](docs/CreateTokensTransactionRequestFromAddressRBDataItem.md)
 - [CreateTokensTransactionRequestFromAddressRData](docs/CreateTokensTransactionRequestFromAddressRData.md)
 - [CreateTokensTransactionRequestFromAddressRI](docs/CreateTokensTransactionRequestFromAddressRI.md)
 - [CreateTokensTransactionRequestFromAddressRIRecipients](docs/CreateTokensTransactionRequestFromAddressRIRecipients.md)
 - [CreateTokensTransactionRequestFromAddressRIS](docs/CreateTokensTransactionRequestFromAddressRIS.md)
 - [CreateTokensTransactionRequestFromAddressRISB](docs/CreateTokensTransactionRequestFromAddressRISB.md)
 - [CreateTokensTransactionRequestFromAddressRISE](docs/CreateTokensTransactionRequestFromAddressRISE.md)
 - [CreateTokensTransactionRequestFromAddressRISenders](docs/CreateTokensTransactionRequestFromAddressRISenders.md)
 - [DeleteAutomaticCoinsForwardingR](docs/DeleteAutomaticCoinsForwardingR.md)
 - [DeleteAutomaticCoinsForwardingRData](docs/DeleteAutomaticCoinsForwardingRData.md)
 - [DeleteAutomaticCoinsForwardingRI](docs/DeleteAutomaticCoinsForwardingRI.md)
 - [DeleteAutomaticTokensForwardingR](docs/DeleteAutomaticTokensForwardingR.md)
 - [DeleteAutomaticTokensForwardingRData](docs/DeleteAutomaticTokensForwardingRData.md)
 - [DeleteAutomaticTokensForwardingRI](docs/DeleteAutomaticTokensForwardingRI.md)
 - [DeleteAutomaticTokensForwardingRITS](docs/DeleteAutomaticTokensForwardingRITS.md)
 - [DeleteAutomaticTokensForwardingRITSBOT](docs/DeleteAutomaticTokensForwardingRITSBOT.md)
 - [DeleteAutomaticTokensForwardingRITSET](docs/DeleteAutomaticTokensForwardingRITSET.md)
 - [DeleteBlockchainEventSubscriptionR](docs/DeleteBlockchainEventSubscriptionR.md)
 - [DeleteBlockchainEventSubscriptionRData](docs/DeleteBlockchainEventSubscriptionRData.md)
 - [DeleteBlockchainEventSubscriptionRI](docs/DeleteBlockchainEventSubscriptionRI.md)
 - [EndpointNotAllowedForApiKey](docs/EndpointNotAllowedForApiKey.md)
 - [EndpointNotAllowedForApiKeyError](docs/EndpointNotAllowedForApiKeyError.md)
 - [EndpointNotAllowedForPlan](docs/EndpointNotAllowedForPlan.md)
 - [EndpointNotAllowedForPlanError](docs/EndpointNotAllowedForPlanError.md)
 - [FeatureMainnetsNotAllowedForPlan](docs/FeatureMainnetsNotAllowedForPlan.md)
 - [FeatureMainnetsNotAllowedForPlanError](docs/FeatureMainnetsNotAllowedForPlanError.md)
 - [GenerateDepositAddressR](docs/GenerateDepositAddressR.md)
 - [GenerateDepositAddressRB](docs/GenerateDepositAddressRB.md)
 - [GenerateDepositAddressRBData](docs/GenerateDepositAddressRBData.md)
 - [GenerateDepositAddressRBDataItem](docs/GenerateDepositAddressRBDataItem.md)
 - [GenerateDepositAddressRData](docs/GenerateDepositAddressRData.md)
 - [GenerateDepositAddressRI](docs/GenerateDepositAddressRI.md)
 - [GetAddressDetailsR](docs/GetAddressDetailsR.md)
 - [GetAddressDetailsRData](docs/GetAddressDetailsRData.md)
 - [GetAddressDetailsRI](docs/GetAddressDetailsRI.md)
 - [GetAddressDetailsRIConfirmedBalance](docs/GetAddressDetailsRIConfirmedBalance.md)
 - [GetAddressDetailsRITotalReceived](docs/GetAddressDetailsRITotalReceived.md)
 - [GetAddressDetailsRITotalSpent](docs/GetAddressDetailsRITotalSpent.md)
 - [GetBlockDetailsByBlockHashR](docs/GetBlockDetailsByBlockHashR.md)
 - [GetBlockDetailsByBlockHashRData](docs/GetBlockDetailsByBlockHashRData.md)
 - [GetBlockDetailsByBlockHashRI](docs/GetBlockDetailsByBlockHashRI.md)
 - [GetBlockDetailsByBlockHashRIBS](docs/GetBlockDetailsByBlockHashRIBS.md)
 - [GetBlockDetailsByBlockHashRIBSB](docs/GetBlockDetailsByBlockHashRIBSB.md)
 - [GetBlockDetailsByBlockHashRIBSBC](docs/GetBlockDetailsByBlockHashRIBSBC.md)
 - [GetBlockDetailsByBlockHashRIBSD](docs/GetBlockDetailsByBlockHashRIBSD.md)
 - [GetBlockDetailsByBlockHashRIBSD2](docs/GetBlockDetailsByBlockHashRIBSD2.md)
 - [GetBlockDetailsByBlockHashRIBSE](docs/GetBlockDetailsByBlockHashRIBSE.md)
 - [GetBlockDetailsByBlockHashRIBSEC](docs/GetBlockDetailsByBlockHashRIBSEC.md)
 - [GetBlockDetailsByBlockHashRIBSL](docs/GetBlockDetailsByBlockHashRIBSL.md)
 - [GetBlockDetailsByBlockHeightR](docs/GetBlockDetailsByBlockHeightR.md)
 - [GetBlockDetailsByBlockHeightRData](docs/GetBlockDetailsByBlockHeightRData.md)
 - [GetBlockDetailsByBlockHeightRI](docs/GetBlockDetailsByBlockHeightRI.md)
 - [GetBlockDetailsByBlockHeightRIBS](docs/GetBlockDetailsByBlockHeightRIBS.md)
 - [GetBlockDetailsByBlockHeightRIBSB](docs/GetBlockDetailsByBlockHeightRIBSB.md)
 - [GetBlockDetailsByBlockHeightRIBSBC](docs/GetBlockDetailsByBlockHeightRIBSBC.md)
 - [GetBlockDetailsByBlockHeightRIBSD](docs/GetBlockDetailsByBlockHeightRIBSD.md)
 - [GetBlockDetailsByBlockHeightRIBSD2](docs/GetBlockDetailsByBlockHeightRIBSD2.md)
 - [GetBlockDetailsByBlockHeightRIBSE](docs/GetBlockDetailsByBlockHeightRIBSE.md)
 - [GetBlockDetailsByBlockHeightRIBSEC](docs/GetBlockDetailsByBlockHeightRIBSEC.md)
 - [GetBlockDetailsByBlockHeightRIBSL](docs/GetBlockDetailsByBlockHeightRIBSL.md)
 - [GetContractDetailsByAddressR](docs/GetContractDetailsByAddressR.md)
 - [GetContractDetailsByAddressRData](docs/GetContractDetailsByAddressRData.md)
 - [GetContractDetailsByAddressRI](docs/GetContractDetailsByAddressRI.md)
 - [GetExchangeRateByAssetSymbolsR](docs/GetExchangeRateByAssetSymbolsR.md)
 - [GetExchangeRateByAssetSymbolsRData](docs/GetExchangeRateByAssetSymbolsRData.md)
 - [GetExchangeRateByAssetSymbolsRI](docs/GetExchangeRateByAssetSymbolsRI.md)
 - [GetExchangeRateByAssetsIDsR](docs/GetExchangeRateByAssetsIDsR.md)
 - [GetExchangeRateByAssetsIDsRData](docs/GetExchangeRateByAssetsIDsRData.md)
 - [GetExchangeRateByAssetsIDsRI](docs/GetExchangeRateByAssetsIDsRI.md)
 - [GetFeeAddressDetailsR](docs/GetFeeAddressDetailsR.md)
 - [GetFeeAddressDetailsRData](docs/GetFeeAddressDetailsRData.md)
 - [GetFeeAddressDetailsRI](docs/GetFeeAddressDetailsRI.md)
 - [GetFeeAddressDetailsRIBalance](docs/GetFeeAddressDetailsRIBalance.md)
 - [GetFeeRecommendationsR](docs/GetFeeRecommendationsR.md)
 - [GetFeeRecommendationsRData](docs/GetFeeRecommendationsRData.md)
 - [GetFeeRecommendationsRI](docs/GetFeeRecommendationsRI.md)
 - [GetHDWalletXPubYPubZPubDetailsR](docs/GetHDWalletXPubYPubZPubDetailsR.md)
 - [GetHDWalletXPubYPubZPubDetailsRData](docs/GetHDWalletXPubYPubZPubDetailsRData.md)
 - [GetHDWalletXPubYPubZPubDetailsRI](docs/GetHDWalletXPubYPubZPubDetailsRI.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdR](docs/GetInternalTransactionByTransactionHashAndOperationIdR.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdRData](docs/GetInternalTransactionByTransactionHashAndOperationIdRData.md)
 - [GetInternalTransactionByTransactionHashAndOperationIdRI](docs/GetInternalTransactionByTransactionHashAndOperationIdRI.md)
 - [GetLatestMinedBlockR](docs/GetLatestMinedBlockR.md)
 - [GetLatestMinedBlockRData](docs/GetLatestMinedBlockRData.md)
 - [GetLatestMinedBlockRI](docs/GetLatestMinedBlockRI.md)
 - [GetLatestMinedBlockRIBS](docs/GetLatestMinedBlockRIBS.md)
 - [GetLatestMinedBlockRIBSB](docs/GetLatestMinedBlockRIBSB.md)
 - [GetLatestMinedBlockRIBSBC](docs/GetLatestMinedBlockRIBSBC.md)
 - [GetLatestMinedBlockRIBSD](docs/GetLatestMinedBlockRIBSD.md)
 - [GetLatestMinedBlockRIBSD2](docs/GetLatestMinedBlockRIBSD2.md)
 - [GetLatestMinedBlockRIBSE](docs/GetLatestMinedBlockRIBSE.md)
 - [GetLatestMinedBlockRIBSEC](docs/GetLatestMinedBlockRIBSEC.md)
 - [GetLatestMinedBlockRIBSL](docs/GetLatestMinedBlockRIBSL.md)
 - [GetLatestMinedXRPRippleBlockR](docs/GetLatestMinedXRPRippleBlockR.md)
 - [GetLatestMinedXRPRippleBlockRData](docs/GetLatestMinedXRPRippleBlockRData.md)
 - [GetLatestMinedXRPRippleBlockRI](docs/GetLatestMinedXRPRippleBlockRI.md)
 - [GetLatestMinedXRPRippleBlockRITotalCoins](docs/GetLatestMinedXRPRippleBlockRITotalCoins.md)
 - [GetLatestMinedXRPRippleBlockRITotalFees](docs/GetLatestMinedXRPRippleBlockRITotalFees.md)
 - [GetLatestMinedZilliqaBlockR](docs/GetLatestMinedZilliqaBlockR.md)
 - [GetLatestMinedZilliqaBlockRData](docs/GetLatestMinedZilliqaBlockRData.md)
 - [GetLatestMinedZilliqaBlockRI](docs/GetLatestMinedZilliqaBlockRI.md)
 - [GetOmniTransactionDetailsByTransactionIDTxidR](docs/GetOmniTransactionDetailsByTransactionIDTxidR.md)
 - [GetOmniTransactionDetailsByTransactionIDTxidRData](docs/GetOmniTransactionDetailsByTransactionIDTxidRData.md)
 - [GetOmniTransactionDetailsByTransactionIDTxidRI](docs/GetOmniTransactionDetailsByTransactionIDTxidRI.md)
 - [GetOmniTransactionDetailsByTransactionIDTxidRISenders](docs/GetOmniTransactionDetailsByTransactionIDTxidRISenders.md)
 - [GetTransactionDetailsByTransactionIDR](docs/GetTransactionDetailsByTransactionIDR.md)
 - [GetTransactionDetailsByTransactionIDRData](docs/GetTransactionDetailsByTransactionIDRData.md)
 - [GetTransactionDetailsByTransactionIDRI](docs/GetTransactionDetailsByTransactionIDRI.md)
 - [GetTransactionDetailsByTransactionIDRIBS](docs/GetTransactionDetailsByTransactionIDRIBS.md)
 - [GetTransactionDetailsByTransactionIDRIBSB](docs/GetTransactionDetailsByTransactionIDRIBSB.md)
 - [GetTransactionDetailsByTransactionIDRIBSBC](docs/GetTransactionDetailsByTransactionIDRIBSBC.md)
 - [GetTransactionDetailsByTransactionIDRIBSBCScriptPubKey](docs/GetTransactionDetailsByTransactionIDRIBSBCScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIDRIBSBCVin](docs/GetTransactionDetailsByTransactionIDRIBSBCVin.md)
 - [GetTransactionDetailsByTransactionIDRIBSBCVout](docs/GetTransactionDetailsByTransactionIDRIBSBCVout.md)
 - [GetTransactionDetailsByTransactionIDRIBSBScriptPubKey](docs/GetTransactionDetailsByTransactionIDRIBSBScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIDRIBSBScriptSig](docs/GetTransactionDetailsByTransactionIDRIBSBScriptSig.md)
 - [GetTransactionDetailsByTransactionIDRIBSBVin](docs/GetTransactionDetailsByTransactionIDRIBSBVin.md)
 - [GetTransactionDetailsByTransactionIDRIBSBVout](docs/GetTransactionDetailsByTransactionIDRIBSBVout.md)
 - [GetTransactionDetailsByTransactionIDRIBSD](docs/GetTransactionDetailsByTransactionIDRIBSD.md)
 - [GetTransactionDetailsByTransactionIDRIBSD2](docs/GetTransactionDetailsByTransactionIDRIBSD2.md)
 - [GetTransactionDetailsByTransactionIDRIBSD2ScriptPubKey](docs/GetTransactionDetailsByTransactionIDRIBSD2ScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIDRIBSD2ScriptSig](docs/GetTransactionDetailsByTransactionIDRIBSD2ScriptSig.md)
 - [GetTransactionDetailsByTransactionIDRIBSD2Vin](docs/GetTransactionDetailsByTransactionIDRIBSD2Vin.md)
 - [GetTransactionDetailsByTransactionIDRIBSD2Vout](docs/GetTransactionDetailsByTransactionIDRIBSD2Vout.md)
 - [GetTransactionDetailsByTransactionIDRIBSDScriptPubKey](docs/GetTransactionDetailsByTransactionIDRIBSDScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIDRIBSDScriptSig](docs/GetTransactionDetailsByTransactionIDRIBSDScriptSig.md)
 - [GetTransactionDetailsByTransactionIDRIBSDVin](docs/GetTransactionDetailsByTransactionIDRIBSDVin.md)
 - [GetTransactionDetailsByTransactionIDRIBSDVout](docs/GetTransactionDetailsByTransactionIDRIBSDVout.md)
 - [GetTransactionDetailsByTransactionIDRIBSE](docs/GetTransactionDetailsByTransactionIDRIBSE.md)
 - [GetTransactionDetailsByTransactionIDRIBSEC](docs/GetTransactionDetailsByTransactionIDRIBSEC.md)
 - [GetTransactionDetailsByTransactionIDRIBSECGasPrice](docs/GetTransactionDetailsByTransactionIDRIBSECGasPrice.md)
 - [GetTransactionDetailsByTransactionIDRIBSEGasPrice](docs/GetTransactionDetailsByTransactionIDRIBSEGasPrice.md)
 - [GetTransactionDetailsByTransactionIDRIBSL](docs/GetTransactionDetailsByTransactionIDRIBSL.md)
 - [GetTransactionDetailsByTransactionIDRIBSLScriptPubKey](docs/GetTransactionDetailsByTransactionIDRIBSLScriptPubKey.md)
 - [GetTransactionDetailsByTransactionIDRIBSLScriptSig](docs/GetTransactionDetailsByTransactionIDRIBSLScriptSig.md)
 - [GetTransactionDetailsByTransactionIDRIBSLVin](docs/GetTransactionDetailsByTransactionIDRIBSLVin.md)
 - [GetTransactionDetailsByTransactionIDRIBSLVout](docs/GetTransactionDetailsByTransactionIDRIBSLVout.md)
 - [GetTransactionDetailsByTransactionIDRIFee](docs/GetTransactionDetailsByTransactionIDRIFee.md)
 - [GetTransactionDetailsByTransactionIDRIRecipients](docs/GetTransactionDetailsByTransactionIDRIRecipients.md)
 - [GetTransactionDetailsByTransactionIDRISenders](docs/GetTransactionDetailsByTransactionIDRISenders.md)
 - [GetUnconfirmedOmniTransactionByTransactionIDTxidR](docs/GetUnconfirmedOmniTransactionByTransactionIDTxidR.md)
 - [GetUnconfirmedOmniTransactionByTransactionIDTxidRData](docs/GetUnconfirmedOmniTransactionByTransactionIDTxidRData.md)
 - [GetUnconfirmedOmniTransactionByTransactionIDTxidRI](docs/GetUnconfirmedOmniTransactionByTransactionIDTxidRI.md)
 - [GetUnconfirmedOmniTransactionByTransactionIDTxidRIRecipients](docs/GetUnconfirmedOmniTransactionByTransactionIDTxidRIRecipients.md)
 - [GetUnconfirmedOmniTransactionByTransactionIDTxidRISenders](docs/GetUnconfirmedOmniTransactionByTransactionIDTxidRISenders.md)
 - [GetWalletAssetDetailsR](docs/GetWalletAssetDetailsR.md)
 - [GetWalletAssetDetailsRData](docs/GetWalletAssetDetailsRData.md)
 - [GetWalletAssetDetailsRI](docs/GetWalletAssetDetailsRI.md)
 - [GetWalletAssetDetailsRIConfirmedBalance](docs/GetWalletAssetDetailsRIConfirmedBalance.md)
 - [GetWalletAssetDetailsRIRecievedConfirmedAmount](docs/GetWalletAssetDetailsRIRecievedConfirmedAmount.md)
 - [GetWalletAssetDetailsRISentConfirmedAmount](docs/GetWalletAssetDetailsRISentConfirmedAmount.md)
 - [GetXRPRippleAddressDetailsR](docs/GetXRPRippleAddressDetailsR.md)
 - [GetXRPRippleAddressDetailsRData](docs/GetXRPRippleAddressDetailsRData.md)
 - [GetXRPRippleAddressDetailsRI](docs/GetXRPRippleAddressDetailsRI.md)
 - [GetXRPRippleAddressDetailsRIBalance](docs/GetXRPRippleAddressDetailsRIBalance.md)
 - [GetXRPRippleBlockDetailsByBlockHashR](docs/GetXRPRippleBlockDetailsByBlockHashR.md)
 - [GetXRPRippleBlockDetailsByBlockHashRData](docs/GetXRPRippleBlockDetailsByBlockHashRData.md)
 - [GetXRPRippleBlockDetailsByBlockHashRI](docs/GetXRPRippleBlockDetailsByBlockHashRI.md)
 - [GetXRPRippleBlockDetailsByBlockHashRITotalCoins](docs/GetXRPRippleBlockDetailsByBlockHashRITotalCoins.md)
 - [GetXRPRippleBlockDetailsByBlockHeightR](docs/GetXRPRippleBlockDetailsByBlockHeightR.md)
 - [GetXRPRippleBlockDetailsByBlockHeightRData](docs/GetXRPRippleBlockDetailsByBlockHeightRData.md)
 - [GetXRPRippleBlockDetailsByBlockHeightRI](docs/GetXRPRippleBlockDetailsByBlockHeightRI.md)
 - [GetXRPRippleBlockDetailsByBlockHeightRITotalCoins](docs/GetXRPRippleBlockDetailsByBlockHeightRITotalCoins.md)
 - [GetXRPRippleBlockDetailsByBlockHeightRITotalFees](docs/GetXRPRippleBlockDetailsByBlockHeightRITotalFees.md)
 - [GetXRPRippleTransactionDetailsByTransactionIDR](docs/GetXRPRippleTransactionDetailsByTransactionIDR.md)
 - [GetXRPRippleTransactionDetailsByTransactionIDRData](docs/GetXRPRippleTransactionDetailsByTransactionIDRData.md)
 - [GetXRPRippleTransactionDetailsByTransactionIDRI](docs/GetXRPRippleTransactionDetailsByTransactionIDRI.md)
 - [GetXRPRippleTransactionDetailsByTransactionIDRIFee](docs/GetXRPRippleTransactionDetailsByTransactionIDRIFee.md)
 - [GetXRPRippleTransactionDetailsByTransactionIDRIOffer](docs/GetXRPRippleTransactionDetailsByTransactionIDRIOffer.md)
 - [GetXRPRippleTransactionDetailsByTransactionIDRIReceive](docs/GetXRPRippleTransactionDetailsByTransactionIDRIReceive.md)
 - [GetXRPRippleTransactionDetailsByTransactionIDRIRecipients](docs/GetXRPRippleTransactionDetailsByTransactionIDRIRecipients.md)
 - [GetXRPRippleTransactionDetailsByTransactionIDRISenders](docs/GetXRPRippleTransactionDetailsByTransactionIDRISenders.md)
 - [GetXRPRippleTransactionDetailsByTransactionIDRIValue](docs/GetXRPRippleTransactionDetailsByTransactionIDRIValue.md)
 - [GetZilliqaAddressDetailsR](docs/GetZilliqaAddressDetailsR.md)
 - [GetZilliqaAddressDetailsRData](docs/GetZilliqaAddressDetailsRData.md)
 - [GetZilliqaAddressDetailsRI](docs/GetZilliqaAddressDetailsRI.md)
 - [GetZilliqaAddressDetailsRIBalance](docs/GetZilliqaAddressDetailsRIBalance.md)
 - [GetZilliqaBlockDetailsByBlockHashR](docs/GetZilliqaBlockDetailsByBlockHashR.md)
 - [GetZilliqaBlockDetailsByBlockHashRData](docs/GetZilliqaBlockDetailsByBlockHashRData.md)
 - [GetZilliqaBlockDetailsByBlockHashRI](docs/GetZilliqaBlockDetailsByBlockHashRI.md)
 - [GetZilliqaBlockDetailsByBlockHeightR](docs/GetZilliqaBlockDetailsByBlockHeightR.md)
 - [GetZilliqaBlockDetailsByBlockHeightRData](docs/GetZilliqaBlockDetailsByBlockHeightRData.md)
 - [GetZilliqaBlockDetailsByBlockHeightRI](docs/GetZilliqaBlockDetailsByBlockHeightRI.md)
 - [GetZilliqaTransactionDetailsByTransactionIDR](docs/GetZilliqaTransactionDetailsByTransactionIDR.md)
 - [GetZilliqaTransactionDetailsByTransactionIDRData](docs/GetZilliqaTransactionDetailsByTransactionIDRData.md)
 - [GetZilliqaTransactionDetailsByTransactionIDRI](docs/GetZilliqaTransactionDetailsByTransactionIDRI.md)
 - [GetZilliqaTransactionDetailsByTransactionIDRIFee](docs/GetZilliqaTransactionDetailsByTransactionIDRIFee.md)
 - [GetZilliqaTransactionDetailsByTransactionIDRIRecipients](docs/GetZilliqaTransactionDetailsByTransactionIDRIRecipients.md)
 - [GetZilliqaTransactionDetailsByTransactionIDRISenders](docs/GetZilliqaTransactionDetailsByTransactionIDRISenders.md)
 - [InsufficientCredits](docs/InsufficientCredits.md)
 - [InsufficientCreditsError](docs/InsufficientCreditsError.md)
 - [InvalidApiKey](docs/InvalidApiKey.md)
 - [InvalidApiKeyError](docs/InvalidApiKeyError.md)
 - [InvalidBlockchain](docs/InvalidBlockchain.md)
 - [InvalidBlockchainError](docs/InvalidBlockchainError.md)
 - [InvalidData](docs/InvalidData.md)
 - [InvalidDataError](docs/InvalidDataError.md)
 - [InvalidNetwork](docs/InvalidNetwork.md)
 - [InvalidNetworkError](docs/InvalidNetworkError.md)
 - [InvalidPagination](docs/InvalidPagination.md)
 - [InvalidPaginationError](docs/InvalidPaginationError.md)
 - [InvalidRequestBodyStructure](docs/InvalidRequestBodyStructure.md)
 - [InvalidRequestBodyStructureError](docs/InvalidRequestBodyStructureError.md)
 - [InvalidXpub](docs/InvalidXpub.md)
 - [InvalidXpubError](docs/InvalidXpubError.md)
 - [LimitGreaterThanAllowed](docs/LimitGreaterThanAllowed.md)
 - [LimitGreaterThanAllowedError](docs/LimitGreaterThanAllowedError.md)
 - [ListAssetsDetailsR](docs/ListAssetsDetailsR.md)
 - [ListAssetsDetailsRData](docs/ListAssetsDetailsRData.md)
 - [ListAssetsDetailsRI](docs/ListAssetsDetailsRI.md)
 - [ListAssetsDetailsRIAssetLogo](docs/ListAssetsDetailsRIAssetLogo.md)
 - [ListAssetsDetailsRILatestRate](docs/ListAssetsDetailsRILatestRate.md)
 - [ListAssetsDetailsRIS](docs/ListAssetsDetailsRIS.md)
 - [ListAssetsDetailsRISC](docs/ListAssetsDetailsRISC.md)
 - [ListBlockchainEventsSubscriptionsR](docs/ListBlockchainEventsSubscriptionsR.md)
 - [ListBlockchainEventsSubscriptionsRData](docs/ListBlockchainEventsSubscriptionsRData.md)
 - [ListBlockchainEventsSubscriptionsRI](docs/ListBlockchainEventsSubscriptionsRI.md)
 - [ListCoinsForwardingAutomationsR](docs/ListCoinsForwardingAutomationsR.md)
 - [ListCoinsForwardingAutomationsRData](docs/ListCoinsForwardingAutomationsRData.md)
 - [ListCoinsForwardingAutomationsRI](docs/ListCoinsForwardingAutomationsRI.md)
 - [ListDepositAddressesR](docs/ListDepositAddressesR.md)
 - [ListDepositAddressesRData](docs/ListDepositAddressesRData.md)
 - [ListDepositAddressesRI](docs/ListDepositAddressesRI.md)
 - [ListHDWalletXPubYPubZPubTransactionsR](docs/ListHDWalletXPubYPubZPubTransactionsR.md)
 - [ListHDWalletXPubYPubZPubTransactionsRData](docs/ListHDWalletXPubYPubZPubTransactionsRData.md)
 - [ListHDWalletXPubYPubZPubTransactionsRI](docs/ListHDWalletXPubYPubZPubTransactionsRI.md)
 - [ListHDWalletXPubYPubZPubTransactionsRIFee](docs/ListHDWalletXPubYPubZPubTransactionsRIFee.md)
 - [ListHDWalletXPubYPubZPubTransactionsRIRecipients](docs/ListHDWalletXPubYPubZPubTransactionsRIRecipients.md)
 - [ListHDWalletXPubYPubZPubTransactionsRISenders](docs/ListHDWalletXPubYPubZPubTransactionsRISenders.md)
 - [ListInternalTransactionDetailsByTransactionHashR](docs/ListInternalTransactionDetailsByTransactionHashR.md)
 - [ListInternalTransactionDetailsByTransactionHashRData](docs/ListInternalTransactionDetailsByTransactionHashRData.md)
 - [ListInternalTransactionDetailsByTransactionHashRI](docs/ListInternalTransactionDetailsByTransactionHashRI.md)
 - [ListOmniTokensByAddressR](docs/ListOmniTokensByAddressR.md)
 - [ListOmniTokensByAddressRData](docs/ListOmniTokensByAddressRData.md)
 - [ListOmniTokensByAddressRI](docs/ListOmniTokensByAddressRI.md)
 - [ListOmniTransactionsByAddressR](docs/ListOmniTransactionsByAddressR.md)
 - [ListOmniTransactionsByAddressRData](docs/ListOmniTransactionsByAddressRData.md)
 - [ListOmniTransactionsByAddressRI](docs/ListOmniTransactionsByAddressRI.md)
 - [ListOmniTransactionsByAddressRIFee](docs/ListOmniTransactionsByAddressRIFee.md)
 - [ListOmniTransactionsByAddressRIRecipients](docs/ListOmniTransactionsByAddressRIRecipients.md)
 - [ListOmniTransactionsByAddressRISenders](docs/ListOmniTransactionsByAddressRISenders.md)
 - [ListOmniTransactionsByBlockHashR](docs/ListOmniTransactionsByBlockHashR.md)
 - [ListOmniTransactionsByBlockHashRData](docs/ListOmniTransactionsByBlockHashRData.md)
 - [ListOmniTransactionsByBlockHashRI](docs/ListOmniTransactionsByBlockHashRI.md)
 - [ListOmniTransactionsByBlockHashRIFee](docs/ListOmniTransactionsByBlockHashRIFee.md)
 - [ListOmniTransactionsByBlockHeightR](docs/ListOmniTransactionsByBlockHeightR.md)
 - [ListOmniTransactionsByBlockHeightRData](docs/ListOmniTransactionsByBlockHeightRData.md)
 - [ListOmniTransactionsByBlockHeightRI](docs/ListOmniTransactionsByBlockHeightRI.md)
 - [ListOmniTransactionsByBlockHeightRIFee](docs/ListOmniTransactionsByBlockHeightRIFee.md)
 - [ListOmniTransactionsByBlockHeightRIRecipients](docs/ListOmniTransactionsByBlockHeightRIRecipients.md)
 - [ListOmniTransactionsByBlockHeightRISenders](docs/ListOmniTransactionsByBlockHeightRISenders.md)
 - [ListSupportedAssetsR](docs/ListSupportedAssetsR.md)
 - [ListSupportedAssetsRData](docs/ListSupportedAssetsRData.md)
 - [ListSupportedAssetsRI](docs/ListSupportedAssetsRI.md)
 - [ListSupportedTokensR](docs/ListSupportedTokensR.md)
 - [ListSupportedTokensRData](docs/ListSupportedTokensRData.md)
 - [ListSupportedTokensRI](docs/ListSupportedTokensRI.md)
 - [ListTokensByAddressR](docs/ListTokensByAddressR.md)
 - [ListTokensByAddressRData](docs/ListTokensByAddressRData.md)
 - [ListTokensByAddressRI](docs/ListTokensByAddressRI.md)
 - [ListTokensForwardingAutomationsR](docs/ListTokensForwardingAutomationsR.md)
 - [ListTokensForwardingAutomationsRData](docs/ListTokensForwardingAutomationsRData.md)
 - [ListTokensForwardingAutomationsRI](docs/ListTokensForwardingAutomationsRI.md)
 - [ListTokensForwardingAutomationsRITS](docs/ListTokensForwardingAutomationsRITS.md)
 - [ListTokensForwardingAutomationsRITSBOT](docs/ListTokensForwardingAutomationsRITSBOT.md)
 - [ListTokensForwardingAutomationsRITSET](docs/ListTokensForwardingAutomationsRITSET.md)
 - [ListTokensTransfersByAddressR](docs/ListTokensTransfersByAddressR.md)
 - [ListTokensTransfersByAddressRData](docs/ListTokensTransfersByAddressRData.md)
 - [ListTokensTransfersByAddressRI](docs/ListTokensTransfersByAddressRI.md)
 - [ListTokensTransfersByTransactionHashR](docs/ListTokensTransfersByTransactionHashR.md)
 - [ListTokensTransfersByTransactionHashRData](docs/ListTokensTransfersByTransactionHashRData.md)
 - [ListTokensTransfersByTransactionHashRI](docs/ListTokensTransfersByTransactionHashRI.md)
 - [ListTransactionsByAddressR](docs/ListTransactionsByAddressR.md)
 - [ListTransactionsByAddressRData](docs/ListTransactionsByAddressRData.md)
 - [ListTransactionsByAddressRI](docs/ListTransactionsByAddressRI.md)
 - [ListTransactionsByAddressRIBS](docs/ListTransactionsByAddressRIBS.md)
 - [ListTransactionsByAddressRIBSB](docs/ListTransactionsByAddressRIBSB.md)
 - [ListTransactionsByAddressRIBSBC](docs/ListTransactionsByAddressRIBSBC.md)
 - [ListTransactionsByAddressRIBSBCVin](docs/ListTransactionsByAddressRIBSBCVin.md)
 - [ListTransactionsByAddressRIBSBScriptPubKey](docs/ListTransactionsByAddressRIBSBScriptPubKey.md)
 - [ListTransactionsByAddressRIBSBVin](docs/ListTransactionsByAddressRIBSBVin.md)
 - [ListTransactionsByAddressRIBSBVout](docs/ListTransactionsByAddressRIBSBVout.md)
 - [ListTransactionsByAddressRIBSD](docs/ListTransactionsByAddressRIBSD.md)
 - [ListTransactionsByAddressRIBSD2](docs/ListTransactionsByAddressRIBSD2.md)
 - [ListTransactionsByAddressRIBSD2ScriptPubKey](docs/ListTransactionsByAddressRIBSD2ScriptPubKey.md)
 - [ListTransactionsByAddressRIBSD2ScriptSig](docs/ListTransactionsByAddressRIBSD2ScriptSig.md)
 - [ListTransactionsByAddressRIBSD2Vin](docs/ListTransactionsByAddressRIBSD2Vin.md)
 - [ListTransactionsByAddressRIBSD2Vout](docs/ListTransactionsByAddressRIBSD2Vout.md)
 - [ListTransactionsByAddressRIBSDScriptSig](docs/ListTransactionsByAddressRIBSDScriptSig.md)
 - [ListTransactionsByAddressRIBSDVin](docs/ListTransactionsByAddressRIBSDVin.md)
 - [ListTransactionsByAddressRIBSE](docs/ListTransactionsByAddressRIBSE.md)
 - [ListTransactionsByAddressRIBSEC](docs/ListTransactionsByAddressRIBSEC.md)
 - [ListTransactionsByAddressRIBSECGasPrice](docs/ListTransactionsByAddressRIBSECGasPrice.md)
 - [ListTransactionsByAddressRIBSEGasPrice](docs/ListTransactionsByAddressRIBSEGasPrice.md)
 - [ListTransactionsByAddressRIBSL](docs/ListTransactionsByAddressRIBSL.md)
 - [ListTransactionsByAddressRIBSLScriptSig](docs/ListTransactionsByAddressRIBSLScriptSig.md)
 - [ListTransactionsByAddressRIBSLVin](docs/ListTransactionsByAddressRIBSLVin.md)
 - [ListTransactionsByBlockHashR](docs/ListTransactionsByBlockHashR.md)
 - [ListTransactionsByBlockHashRData](docs/ListTransactionsByBlockHashRData.md)
 - [ListTransactionsByBlockHashRI](docs/ListTransactionsByBlockHashRI.md)
 - [ListTransactionsByBlockHashRIBS](docs/ListTransactionsByBlockHashRIBS.md)
 - [ListTransactionsByBlockHashRIBSB](docs/ListTransactionsByBlockHashRIBSB.md)
 - [ListTransactionsByBlockHashRIBSBC](docs/ListTransactionsByBlockHashRIBSBC.md)
 - [ListTransactionsByBlockHashRIBSBCScriptPubKey](docs/ListTransactionsByBlockHashRIBSBCScriptPubKey.md)
 - [ListTransactionsByBlockHashRIBSBCVin](docs/ListTransactionsByBlockHashRIBSBCVin.md)
 - [ListTransactionsByBlockHashRIBSBCVout](docs/ListTransactionsByBlockHashRIBSBCVout.md)
 - [ListTransactionsByBlockHashRIBSBVin](docs/ListTransactionsByBlockHashRIBSBVin.md)
 - [ListTransactionsByBlockHashRIBSD](docs/ListTransactionsByBlockHashRIBSD.md)
 - [ListTransactionsByBlockHashRIBSD2](docs/ListTransactionsByBlockHashRIBSD2.md)
 - [ListTransactionsByBlockHashRIBSD2ScriptPubKey](docs/ListTransactionsByBlockHashRIBSD2ScriptPubKey.md)
 - [ListTransactionsByBlockHashRIBSD2ScriptSig](docs/ListTransactionsByBlockHashRIBSD2ScriptSig.md)
 - [ListTransactionsByBlockHashRIBSD2Vin](docs/ListTransactionsByBlockHashRIBSD2Vin.md)
 - [ListTransactionsByBlockHashRIBSD2Vout](docs/ListTransactionsByBlockHashRIBSD2Vout.md)
 - [ListTransactionsByBlockHashRIBSDScriptPubKey](docs/ListTransactionsByBlockHashRIBSDScriptPubKey.md)
 - [ListTransactionsByBlockHashRIBSDVin](docs/ListTransactionsByBlockHashRIBSDVin.md)
 - [ListTransactionsByBlockHashRIBSDVout](docs/ListTransactionsByBlockHashRIBSDVout.md)
 - [ListTransactionsByBlockHashRIBSE](docs/ListTransactionsByBlockHashRIBSE.md)
 - [ListTransactionsByBlockHashRIBSEC](docs/ListTransactionsByBlockHashRIBSEC.md)
 - [ListTransactionsByBlockHashRIBSEGasPrice](docs/ListTransactionsByBlockHashRIBSEGasPrice.md)
 - [ListTransactionsByBlockHashRIBSL](docs/ListTransactionsByBlockHashRIBSL.md)
 - [ListTransactionsByBlockHashRIBSLScriptPubKey](docs/ListTransactionsByBlockHashRIBSLScriptPubKey.md)
 - [ListTransactionsByBlockHashRIBSLVin](docs/ListTransactionsByBlockHashRIBSLVin.md)
 - [ListTransactionsByBlockHashRIBSLVout](docs/ListTransactionsByBlockHashRIBSLVout.md)
 - [ListTransactionsByBlockHashRIFee](docs/ListTransactionsByBlockHashRIFee.md)
 - [ListTransactionsByBlockHashRIRecipients](docs/ListTransactionsByBlockHashRIRecipients.md)
 - [ListTransactionsByBlockHashRISenders](docs/ListTransactionsByBlockHashRISenders.md)
 - [ListTransactionsByBlockHeightR](docs/ListTransactionsByBlockHeightR.md)
 - [ListTransactionsByBlockHeightRData](docs/ListTransactionsByBlockHeightRData.md)
 - [ListTransactionsByBlockHeightRI](docs/ListTransactionsByBlockHeightRI.md)
 - [ListTransactionsByBlockHeightRIBS](docs/ListTransactionsByBlockHeightRIBS.md)
 - [ListTransactionsByBlockHeightRIBSB](docs/ListTransactionsByBlockHeightRIBSB.md)
 - [ListTransactionsByBlockHeightRIBSBC](docs/ListTransactionsByBlockHeightRIBSBC.md)
 - [ListTransactionsByBlockHeightRIBSBScriptPubKey](docs/ListTransactionsByBlockHeightRIBSBScriptPubKey.md)
 - [ListTransactionsByBlockHeightRIBSBVout](docs/ListTransactionsByBlockHeightRIBSBVout.md)
 - [ListTransactionsByBlockHeightRIBSD](docs/ListTransactionsByBlockHeightRIBSD.md)
 - [ListTransactionsByBlockHeightRIBSD2](docs/ListTransactionsByBlockHeightRIBSD2.md)
 - [ListTransactionsByBlockHeightRIBSD2Vin](docs/ListTransactionsByBlockHeightRIBSD2Vin.md)
 - [ListTransactionsByBlockHeightRIBSDScriptPubKey](docs/ListTransactionsByBlockHeightRIBSDScriptPubKey.md)
 - [ListTransactionsByBlockHeightRIBSDScriptSig](docs/ListTransactionsByBlockHeightRIBSDScriptSig.md)
 - [ListTransactionsByBlockHeightRIBSDVin](docs/ListTransactionsByBlockHeightRIBSDVin.md)
 - [ListTransactionsByBlockHeightRIBSDVout](docs/ListTransactionsByBlockHeightRIBSDVout.md)
 - [ListTransactionsByBlockHeightRIBSE](docs/ListTransactionsByBlockHeightRIBSE.md)
 - [ListTransactionsByBlockHeightRIBSEC](docs/ListTransactionsByBlockHeightRIBSEC.md)
 - [ListTransactionsByBlockHeightRIBSECGasPrice](docs/ListTransactionsByBlockHeightRIBSECGasPrice.md)
 - [ListTransactionsByBlockHeightRIBSL](docs/ListTransactionsByBlockHeightRIBSL.md)
 - [ListTransactionsByBlockHeightRIBSLScriptPubKey](docs/ListTransactionsByBlockHeightRIBSLScriptPubKey.md)
 - [ListTransactionsByBlockHeightRIBSLScriptSig](docs/ListTransactionsByBlockHeightRIBSLScriptSig.md)
 - [ListTransactionsByBlockHeightRIBSLVin](docs/ListTransactionsByBlockHeightRIBSLVin.md)
 - [ListTransactionsByBlockHeightRIBSLVout](docs/ListTransactionsByBlockHeightRIBSLVout.md)
 - [ListTransactionsByBlockHeightRIFee](docs/ListTransactionsByBlockHeightRIFee.md)
 - [ListUnconfirmedOmniTransactionsByAddressR](docs/ListUnconfirmedOmniTransactionsByAddressR.md)
 - [ListUnconfirmedOmniTransactionsByAddressRData](docs/ListUnconfirmedOmniTransactionsByAddressRData.md)
 - [ListUnconfirmedOmniTransactionsByAddressRI](docs/ListUnconfirmedOmniTransactionsByAddressRI.md)
 - [ListUnconfirmedOmniTransactionsByAddressRIFee](docs/ListUnconfirmedOmniTransactionsByAddressRIFee.md)
 - [ListUnconfirmedOmniTransactionsByAddressRISenders](docs/ListUnconfirmedOmniTransactionsByAddressRISenders.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIDR](docs/ListUnconfirmedOmniTransactionsByPropertyIDR.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIDRData](docs/ListUnconfirmedOmniTransactionsByPropertyIDRData.md)
 - [ListUnconfirmedOmniTransactionsByPropertyIDRI](docs/ListUnconfirmedOmniTransactionsByPropertyIDRI.md)
 - [ListXRPRippleTransactionsByAddressR](docs/ListXRPRippleTransactionsByAddressR.md)
 - [ListXRPRippleTransactionsByAddressRData](docs/ListXRPRippleTransactionsByAddressRData.md)
 - [ListXRPRippleTransactionsByAddressRI](docs/ListXRPRippleTransactionsByAddressRI.md)
 - [ListXRPRippleTransactionsByAddressRIFee](docs/ListXRPRippleTransactionsByAddressRIFee.md)
 - [ListXRPRippleTransactionsByAddressRIOffer](docs/ListXRPRippleTransactionsByAddressRIOffer.md)
 - [ListXRPRippleTransactionsByAddressRIReceive](docs/ListXRPRippleTransactionsByAddressRIReceive.md)
 - [ListXRPRippleTransactionsByAddressRIValue](docs/ListXRPRippleTransactionsByAddressRIValue.md)
 - [ListXRPRippleTransactionsByBlockHashR](docs/ListXRPRippleTransactionsByBlockHashR.md)
 - [ListXRPRippleTransactionsByBlockHashRData](docs/ListXRPRippleTransactionsByBlockHashRData.md)
 - [ListXRPRippleTransactionsByBlockHashRI](docs/ListXRPRippleTransactionsByBlockHashRI.md)
 - [ListXRPRippleTransactionsByBlockHashRIFee](docs/ListXRPRippleTransactionsByBlockHashRIFee.md)
 - [ListXRPRippleTransactionsByBlockHashRIOffer](docs/ListXRPRippleTransactionsByBlockHashRIOffer.md)
 - [ListXRPRippleTransactionsByBlockHashRIReceive](docs/ListXRPRippleTransactionsByBlockHashRIReceive.md)
 - [ListXRPRippleTransactionsByBlockHashRIRecipients](docs/ListXRPRippleTransactionsByBlockHashRIRecipients.md)
 - [ListXRPRippleTransactionsByBlockHashRISenders](docs/ListXRPRippleTransactionsByBlockHashRISenders.md)
 - [ListXRPRippleTransactionsByBlockHashRIValue](docs/ListXRPRippleTransactionsByBlockHashRIValue.md)
 - [ListXRPRippleTransactionsByBlockHeightR](docs/ListXRPRippleTransactionsByBlockHeightR.md)
 - [ListXRPRippleTransactionsByBlockHeightRData](docs/ListXRPRippleTransactionsByBlockHeightRData.md)
 - [ListXRPRippleTransactionsByBlockHeightRI](docs/ListXRPRippleTransactionsByBlockHeightRI.md)
 - [ListXRPRippleTransactionsByBlockHeightRIFee](docs/ListXRPRippleTransactionsByBlockHeightRIFee.md)
 - [ListXRPRippleTransactionsByBlockHeightRIOffer](docs/ListXRPRippleTransactionsByBlockHeightRIOffer.md)
 - [ListXRPRippleTransactionsByBlockHeightRIReceive](docs/ListXRPRippleTransactionsByBlockHeightRIReceive.md)
 - [ListXRPRippleTransactionsByBlockHeightRIRecipients](docs/ListXRPRippleTransactionsByBlockHeightRIRecipients.md)
 - [ListXRPRippleTransactionsByBlockHeightRISenders](docs/ListXRPRippleTransactionsByBlockHeightRISenders.md)
 - [ListXRPRippleTransactionsByBlockHeightRIValue](docs/ListXRPRippleTransactionsByBlockHeightRIValue.md)
 - [ListZilliqaTransactionsByAddressR](docs/ListZilliqaTransactionsByAddressR.md)
 - [ListZilliqaTransactionsByAddressRData](docs/ListZilliqaTransactionsByAddressRData.md)
 - [ListZilliqaTransactionsByAddressRI](docs/ListZilliqaTransactionsByAddressRI.md)
 - [ListZilliqaTransactionsByAddressRIRecipients](docs/ListZilliqaTransactionsByAddressRIRecipients.md)
 - [ListZilliqaTransactionsByAddressRISenders](docs/ListZilliqaTransactionsByAddressRISenders.md)
 - [ListZilliqaTransactionsByBlockHashR](docs/ListZilliqaTransactionsByBlockHashR.md)
 - [ListZilliqaTransactionsByBlockHashRData](docs/ListZilliqaTransactionsByBlockHashRData.md)
 - [ListZilliqaTransactionsByBlockHashRI](docs/ListZilliqaTransactionsByBlockHashRI.md)
 - [ListZilliqaTransactionsByBlockHeightR](docs/ListZilliqaTransactionsByBlockHeightR.md)
 - [ListZilliqaTransactionsByBlockHeightRData](docs/ListZilliqaTransactionsByBlockHeightRData.md)
 - [ListZilliqaTransactionsByBlockHeightRI](docs/ListZilliqaTransactionsByBlockHeightRI.md)
 - [MinedTransactionR](docs/MinedTransactionR.md)
 - [MinedTransactionRB](docs/MinedTransactionRB.md)
 - [MinedTransactionRBData](docs/MinedTransactionRBData.md)
 - [MinedTransactionRBDataItem](docs/MinedTransactionRBDataItem.md)
 - [MinedTransactionRData](docs/MinedTransactionRData.md)
 - [MinedTransactionRI](docs/MinedTransactionRI.md)
 - [MissingApiKey](docs/MissingApiKey.md)
 - [MissingApiKeyError](docs/MissingApiKeyError.md)
 - [NewBlockR](docs/NewBlockR.md)
 - [NewBlockRB](docs/NewBlockRB.md)
 - [NewBlockRBData](docs/NewBlockRBData.md)
 - [NewBlockRBDataItem](docs/NewBlockRBDataItem.md)
 - [NewBlockRData](docs/NewBlockRData.md)
 - [NewBlockRI](docs/NewBlockRI.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationR](docs/NewConfirmedCoinsTransactionsAndEachConfirmationR.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRB](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRB.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRBData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRBData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRBDataItem](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRBDataItem.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRData](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedCoinsTransactionsAndEachConfirmationRI](docs/NewConfirmedCoinsTransactionsAndEachConfirmationRI.md)
 - [NewConfirmedCoinsTransactionsR](docs/NewConfirmedCoinsTransactionsR.md)
 - [NewConfirmedCoinsTransactionsRB](docs/NewConfirmedCoinsTransactionsRB.md)
 - [NewConfirmedCoinsTransactionsRBData](docs/NewConfirmedCoinsTransactionsRBData.md)
 - [NewConfirmedCoinsTransactionsRBDataItem](docs/NewConfirmedCoinsTransactionsRBDataItem.md)
 - [NewConfirmedCoinsTransactionsRData](docs/NewConfirmedCoinsTransactionsRData.md)
 - [NewConfirmedCoinsTransactionsRI](docs/NewConfirmedCoinsTransactionsRI.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationR](docs/NewConfirmedInternalTransactionsAndEachConfirmationR.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRB](docs/NewConfirmedInternalTransactionsAndEachConfirmationRB.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRBData](docs/NewConfirmedInternalTransactionsAndEachConfirmationRBData.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRBDataItem](docs/NewConfirmedInternalTransactionsAndEachConfirmationRBDataItem.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRData](docs/NewConfirmedInternalTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedInternalTransactionsAndEachConfirmationRI](docs/NewConfirmedInternalTransactionsAndEachConfirmationRI.md)
 - [NewConfirmedInternalTransactionsR](docs/NewConfirmedInternalTransactionsR.md)
 - [NewConfirmedInternalTransactionsRB](docs/NewConfirmedInternalTransactionsRB.md)
 - [NewConfirmedInternalTransactionsRBData](docs/NewConfirmedInternalTransactionsRBData.md)
 - [NewConfirmedInternalTransactionsRBDataItem](docs/NewConfirmedInternalTransactionsRBDataItem.md)
 - [NewConfirmedInternalTransactionsRData](docs/NewConfirmedInternalTransactionsRData.md)
 - [NewConfirmedInternalTransactionsRI](docs/NewConfirmedInternalTransactionsRI.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationR](docs/NewConfirmedTokensTransactionsAndEachConfirmationR.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRB](docs/NewConfirmedTokensTransactionsAndEachConfirmationRB.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRBData](docs/NewConfirmedTokensTransactionsAndEachConfirmationRBData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRBDataItem](docs/NewConfirmedTokensTransactionsAndEachConfirmationRBDataItem.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRData](docs/NewConfirmedTokensTransactionsAndEachConfirmationRData.md)
 - [NewConfirmedTokensTransactionsAndEachConfirmationRI](docs/NewConfirmedTokensTransactionsAndEachConfirmationRI.md)
 - [NewConfirmedTokensTransactionsR](docs/NewConfirmedTokensTransactionsR.md)
 - [NewConfirmedTokensTransactionsRB](docs/NewConfirmedTokensTransactionsRB.md)
 - [NewConfirmedTokensTransactionsRData](docs/NewConfirmedTokensTransactionsRData.md)
 - [NewConfirmedTokensTransactionsRI](docs/NewConfirmedTokensTransactionsRI.md)
 - [NewUnconfirmedCoinsTransactionsR](docs/NewUnconfirmedCoinsTransactionsR.md)
 - [NewUnconfirmedCoinsTransactionsRB](docs/NewUnconfirmedCoinsTransactionsRB.md)
 - [NewUnconfirmedCoinsTransactionsRBData](docs/NewUnconfirmedCoinsTransactionsRBData.md)
 - [NewUnconfirmedCoinsTransactionsRBDataItem](docs/NewUnconfirmedCoinsTransactionsRBDataItem.md)
 - [NewUnconfirmedCoinsTransactionsRData](docs/NewUnconfirmedCoinsTransactionsRData.md)
 - [NewUnconfirmedCoinsTransactionsRI](docs/NewUnconfirmedCoinsTransactionsRI.md)
 - [NewUnconfirmedTokensTransactionsR](docs/NewUnconfirmedTokensTransactionsR.md)
 - [NewUnconfirmedTokensTransactionsRB](docs/NewUnconfirmedTokensTransactionsRB.md)
 - [NewUnconfirmedTokensTransactionsRBData](docs/NewUnconfirmedTokensTransactionsRBData.md)
 - [NewUnconfirmedTokensTransactionsRBDataItem](docs/NewUnconfirmedTokensTransactionsRBDataItem.md)
 - [NewUnconfirmedTokensTransactionsRData](docs/NewUnconfirmedTokensTransactionsRData.md)
 - [NewUnconfirmedTokensTransactionsRI](docs/NewUnconfirmedTokensTransactionsRI.md)
 - [RequestLimitReached](docs/RequestLimitReached.md)
 - [RequestLimitReachedError](docs/RequestLimitReachedError.md)
 - [ResourceNotFound](docs/ResourceNotFound.md)
 - [ResourceNotFoundError](docs/ResourceNotFoundError.md)
 - [SyncHDWalletXPubYPubZPubR](docs/SyncHDWalletXPubYPubZPubR.md)
 - [SyncHDWalletXPubYPubZPubRB](docs/SyncHDWalletXPubYPubZPubRB.md)
 - [SyncHDWalletXPubYPubZPubRBData](docs/SyncHDWalletXPubYPubZPubRBData.md)
 - [SyncHDWalletXPubYPubZPubRBDataItem](docs/SyncHDWalletXPubYPubZPubRBDataItem.md)
 - [SyncHDWalletXPubYPubZPubRData](docs/SyncHDWalletXPubYPubZPubRData.md)
 - [SyncHDWalletXPubYPubZPubRI](docs/SyncHDWalletXPubYPubZPubRI.md)
 - [TokensForwardingAutomationsLimitReached](docs/TokensForwardingAutomationsLimitReached.md)
 - [TokensForwardingAutomationsLimitReachedError](docs/TokensForwardingAutomationsLimitReachedError.md)
 - [TokensForwardingFail](docs/TokensForwardingFail.md)
 - [TokensForwardingFailData](docs/TokensForwardingFailData.md)
 - [TokensForwardingFailDataItem](docs/TokensForwardingFailDataItem.md)
 - [TokensForwardingSuccess](docs/TokensForwardingSuccess.md)
 - [TokensForwardingSuccessData](docs/TokensForwardingSuccessData.md)
 - [TokensForwardingSuccessDataItem](docs/TokensForwardingSuccessDataItem.md)
 - [TokensForwardingSuccessEthereumerc20token](docs/TokensForwardingSuccessEthereumerc20token.md)
 - [TokensForwardingSuccessEthereumerc721token](docs/TokensForwardingSuccessEthereumerc721token.md)
 - [TokensForwardingSuccessOmnilayertoken](docs/TokensForwardingSuccessOmnilayertoken.md)
 - [TokensForwardingSuccessToken](docs/TokensForwardingSuccessToken.md)
 - [TransactionMined](docs/TransactionMined.md)
 - [TransactionMinedData](docs/TransactionMinedData.md)
 - [TransactionMinedDataItem](docs/TransactionMinedDataItem.md)
 - [TransactionMinedDataItemMinedInBlock](docs/TransactionMinedDataItemMinedInBlock.md)
 - [TransactionRequestApproval](docs/TransactionRequestApproval.md)
 - [TransactionRequestApprovalData](docs/TransactionRequestApprovalData.md)
 - [TransactionRequestApprovalDataItem](docs/TransactionRequestApprovalDataItem.md)
 - [TransactionRequestBroadcasted](docs/TransactionRequestBroadcasted.md)
 - [TransactionRequestBroadcastedData](docs/TransactionRequestBroadcastedData.md)
 - [TransactionRequestBroadcastedDataItem](docs/TransactionRequestBroadcastedDataItem.md)
 - [TransactionRequestFail](docs/TransactionRequestFail.md)
 - [TransactionRequestFailData](docs/TransactionRequestFailData.md)
 - [TransactionRequestFailDataItem](docs/TransactionRequestFailDataItem.md)
 - [TransactionRequestMined](docs/TransactionRequestMined.md)
 - [TransactionRequestMinedData](docs/TransactionRequestMinedData.md)
 - [TransactionRequestRejection](docs/TransactionRequestRejection.md)
 - [TransactionRequestRejectionData](docs/TransactionRequestRejectionData.md)
 - [TransactionRequestRejectionDataItem](docs/TransactionRequestRejectionDataItem.md)
 - [UnexpectedServerError](docs/UnexpectedServerError.md)
 - [UnexpectedServerErrorError](docs/UnexpectedServerErrorError.md)
 - [UnsupportedMediaType](docs/UnsupportedMediaType.md)
 - [UnsupportedMediaTypeError](docs/UnsupportedMediaTypeError.md)
 - [UriNotFound](docs/UriNotFound.md)
 - [UriNotFoundError](docs/UriNotFoundError.md)
 - [ValidateAddressR](docs/ValidateAddressR.md)
 - [ValidateAddressRB](docs/ValidateAddressRB.md)
 - [ValidateAddressRBData](docs/ValidateAddressRBData.md)
 - [ValidateAddressRBDataItem](docs/ValidateAddressRBDataItem.md)
 - [ValidateAddressRData](docs/ValidateAddressRData.md)
 - [ValidateAddressRI](docs/ValidateAddressRI.md)
 - [WalletAsAServiceDepositAddressesLimitReached](docs/WalletAsAServiceDepositAddressesLimitReached.md)
 - [WalletAsAServiceDepositAddressesLimitReachedError](docs/WalletAsAServiceDepositAddressesLimitReachedError.md)
 - [WalletAsAServiceNoDepositAddressesFound](docs/WalletAsAServiceNoDepositAddressesFound.md)
 - [WalletAsAServiceNoDepositAddressesFoundError](docs/WalletAsAServiceNoDepositAddressesFoundError.md)
 - [WalletAsAServiceTokenNotSupported](docs/WalletAsAServiceTokenNotSupported.md)
 - [WalletAsAServiceTokenNotSupportedError](docs/WalletAsAServiceTokenNotSupportedError.md)
 - [WalletAsAServiceWalletBalanceNotEnough](docs/WalletAsAServiceWalletBalanceNotEnough.md)
 - [WalletAsAServiceWalletBalanceNotEnoughError](docs/WalletAsAServiceWalletBalanceNotEnoughError.md)
 - [XpubNotSynced](docs/XpubNotSynced.md)
 - [XpubNotSyncedError](docs/XpubNotSyncedError.md)
 - [XpubSyncInProgress](docs/XpubSyncInProgress.md)
 - [XpubSyncInProgressError](docs/XpubSyncInProgressError.md)


## Documentation For Authorization


## ApiKey

- **Type**: API key
- **API key parameter name**: x-api-key
- **Location**: HTTP header


## Author

developers@cryptoapis.io


## Notes for Large OpenAPI documents
If the OpenAPI document is large, imports in cryptoapis.apis and cryptoapis.models may fail with a
RecursionError indicating the maximum recursion limit has been exceeded. In that case, there are a couple of solutions:

Solution 1:
Use specific imports for apis and models like:
- `from cryptoapis.api.default_api import DefaultApi`
- `from cryptoapis.model.pet import Pet`

Solution 2:
Before importing the package, adjust the maximum recursion limit as shown below:
```
import sys
sys.setrecursionlimit(1500)
import cryptoapis
from cryptoapis.apis import *
from cryptoapis.models import *
```

