>>> %run classify_name_nationality.py
>>> state_dict = model.state_dict()
>>> state_dict
OrderedDict([('W_c2h.weight',
              tensor([[-0.0051, -0.0335, -0.0382,  ...,  0.0616, -0.0695,  0.0193],
                      [-0.1102,  0.0726, -0.0416,  ...,  0.0808, -0.0271,  0.1129],
                      [-0.1220, -0.0597,  0.0262,  ...,  0.0170, -0.0049,  0.0412],
                      ...,
                      [-0.1883, -0.0402,  0.0690,  ...,  0.0775,  0.0397,  0.0660],
                      [-0.1181,  0.0583,  0.0576,  ...,  0.0421, -0.0059,  0.0051],
                      [-0.1501,  0.0693, -0.0170,  ..., -0.0006,  0.0332,  0.0728]])),
             ('W_c2h.bias',
              tensor([ 0.0494, -0.0592, -0.0641,  0.1314,  0.0920,  0.0770,  0.0006, -0.0630,
                      -0.0546,  0.0114,  0.0593, -0.0274, -0.0800,  0.0706, -0.0073,  0.0069,
                       0.0247,  0.0187, -0.0693,  0.0300,  0.0660,  0.1126,  0.0817,  0.0254,
                      -0.0790, -0.0988, -0.0167,  0.0157, -0.0416, -0.0206,  0.0707,  0.0637,
                       0.0497, -0.0054,  0.0276,  0.1121, -0.0174, -0.0568,  0.0854,  0.0287,
                      -0.0533, -0.0179,  0.0675, -0.0131, -0.0599,  0.0079, -0.0642,  0.0106,
                       0.0587, -0.0171,  0.0519,  0.1013,  0.0254, -0.0135,  0.0518, -0.0789,
                       0.0255,  0.0534, -0.0364,  0.0034,  0.0224,  0.0302, -0.0548, -0.0526,
                      -0.0906,  0.0271,  0.0330,  0.0256,  0.1020, -0.0197, -0.1040,  0.1572,
                      -0.0995,  0.0215, -0.0128, -0.0184,  0.0106, -0.0180, -0.1013,  0.0232,
                      -0.0202, -0.0626,  0.0272, -0.0267,  0.1304, -0.0489,  0.0489, -0.0445,
                       0.0831,  0.0355, -0.0434, -0.0093,  0.0895,  0.1039, -0.0598,  0.0059,
                      -0.0025,  0.0391, -0.0113, -0.0750,  0.0371, -0.0043, -0.0011, -0.0211,
                      -0.1251,  0.0206, -0.0869, -0.0987,  0.0624,  0.0226,  0.0104, -0.0395,
                       0.0175,  0.0614,  0.0258,  0.0807,  0.0391,  0.0293, -0.0544,  0.0357,
                       0.0266, -0.0082,  0.0888,  0.1008, -0.0480,  0.0222, -0.0545,  0.0860])),
             ('W_c2y.weight',
              tensor([[-2.1247e-02, -1.6972e-03, -6.0694e-02,  ...,  9.2464e-02,
                        2.7908e-02, -4.8735e-02],
                      [ 3.3261e-02, -2.1816e-02,  3.0410e-04,  ...,  9.6723e-02,
                        1.7508e-01,  3.0583e-01],
                      [-4.0028e-02, -5.5038e-03, -5.3480e-02,  ..., -1.1095e-01,
                       -1.7254e-01, -3.9756e-02],
                      ...,
                      [-4.2275e-03,  4.1327e-02,  6.9924e-02,  ...,  4.2675e-02,
                        6.8844e-03, -1.4373e-01],
                      [-4.1026e-02,  5.8044e-02, -3.7005e-02,  ...,  1.6753e-01,
                        6.7291e-02,  5.7418e-02],
                      [-2.9595e-02,  1.1213e-02,  2.7888e-02,  ..., -1.6439e-01,
                        1.0925e-02, -3.2827e-01]])),
             ('W_c2y.bias',
              tensor([ 0.0661, -0.1096, -0.1392, -0.0605,  0.1485,  0.0727,  0.0221,  0.2950,
                       0.1643, -0.4089]))])
>>> model.predict_category("Khalid")
'Arabic'
>>> model.predict_hidden("Khalid")
tensor([[ 0.0136,  0.0120, -0.2849, -0.3234,  0.1025, -0.1838,  0.3154, -0.3039,
          0.3531, -0.5104,  0.2240, -0.5693,  0.6809, -0.2465, -0.0294, -0.4711,
          0.2203, -0.3897,  0.3185, -0.3627, -0.0779, -0.3939, -0.0570, -0.2170,
          0.1018, -0.2001, -0.4139,  0.0506,  0.1336, -0.2123, -0.5224, -0.1908,
         -0.2453, -0.1172, -0.0747, -0.0521,  0.2762, -0.1715, -0.3502, -0.4108,
          0.3832, -0.1743, -0.1263, -0.0704,  0.3227, -0.1194, -0.1510, -0.4599,
          0.2214, -0.1100, -0.0235, -0.1078,  0.0096, -0.7371, -0.0964,  0.2459,
         -0.1979, -0.2487, -0.1933, -0.3228, -0.3969,  0.1832,  0.2185, -0.0848,
         -0.0504, -0.2123,  0.1162,  0.0071,  0.4818, -0.0804,  0.6297, -0.5016,
          0.2862, -0.3867,  0.4614,  0.1989,  0.5330, -0.1623,  0.2863,  0.3111,
         -0.3878,  0.2735, -0.0036,  0.2029, -0.4714, -0.4734, -0.0062,  0.4765,
          0.3502,  0.1806, -0.3461, -0.0427, -0.3056, -0.4644,  0.4051,  0.5902,
         -0.2037,  0.0513,  0.2626,  0.0519,  0.1598,  0.0626,  0.0696,  0.2775,
          0.0267, -0.1617,  0.3613,  0.7991,  0.3888, -0.2694,  0.0656,  0.5121,
         -0.2760,  0.0387, -0.3476,  0.2055, -0.2234,  0.0306, -0.2140, -0.3300,
          0.0669, -0.4551,  0.0914,  0.1402, -0.4747, -0.0176,  0.2638, -0.1072]])
>>> text = "Khalid"
... predicted_classes = []
... hidden_tensors = []
... for i in range(1, len(text) + 1):
...     hidden_tensors.append(model.predict_hidden(text[:i]))
...     predicted_classes.append(model.predict_category(text[:i]))
...
>>> [h[0] for h in hidden_tensors]
[tensor([ 0.0987, -0.0616, -0.0647,  0.2059,  0.0690,  0.0430, -0.0050, -0.0810,
         -0.0288, -0.0503,  0.1594,  0.0395, -0.0935,  0.1161,  0.0451,  0.0925,
          0.0600, -0.0817, -0.1161,  0.0211,  0.1478,  0.2092,  0.0444,  0.0351,
         -0.0837, -0.1195, -0.0661, -0.0177, -0.0353,  0.0767,  0.0620,  0.0722,
          0.1111,  0.0500,  0.0177,  0.0631, -0.0847,  0.0431,  0.1372, -0.0223,
         -0.1623,  0.0198,  0.1158,  0.0040, -0.0295, -0.0349,  0.0356, -0.0871,
          0.1167,  0.0419,  0.0495,  0.1556, -0.0348, -0.0027, -0.0043, -0.0112,
         -0.1045,  0.0867, -0.0615,  0.0656,  0.0232,  0.0295, -0.0187, -0.0327,
         -0.1192, -0.0105,  0.0111,  0.0745,  0.0296,  0.0265, -0.0628,  0.1696,
         -0.0453,  0.1328, -0.0611, -0.0149,  0.0124,  0.0375, -0.1953,  0.0592,
         -0.0220, -0.1347,  0.0066, -0.0994,  0.1722, -0.0492,  0.1257, -0.0396,
          0.0929,  0.0856,  0.0945,  0.1004,  0.1560,  0.0795, -0.0734,  0.0720,
          0.0674,  0.0274, -0.1112, -0.0050,  0.0063,  0.0190, -0.0307, -0.0816,
         -0.2036,  0.0970, -0.0320, -0.0450,  0.0100, -0.0341,  0.0392, -0.1170,
         -0.0908,  0.0573,  0.0171,  0.0399, -0.0281, -0.0429, -0.1048,  0.1236,
          0.1507,  0.1017,  0.1617,  0.1196,  0.0306,  0.0575, -0.1116,  0.1077]),
 tensor([-0.0271,  0.0338,  0.0189,  0.3837,  0.2865,  0.2669, -0.0196,  0.0458,
         -0.0040, -0.1248,  0.0538, -0.0395, -0.2571,  0.2866,  0.0877,  0.1219,
         -0.0480,  0.1452, -0.1052,  0.2664, -0.0928,  0.1883, -0.0440, -0.1270,
          0.2182, -0.1221,  0.2479, -0.1739,  0.0474,  0.0477,  0.4026, -0.2479,
          0.1411, -0.2547,  0.0526,  0.0078,  0.1163,  0.1723,  0.2292,  0.1180,
         -0.1818,  0.0522, -0.0259,  0.0831, -0.1822,  0.1403,  0.0434,  0.1079,
          0.1134, -0.0033, -0.1517,  0.3352, -0.0088,  0.3254, -0.1181, -0.0917,
          0.1238,  0.0734,  0.1150, -0.0428,  0.0263, -0.3169, -0.0963,  0.0730,
         -0.2799,  0.1610, -0.0490,  0.0979,  0.0050,  0.0299, -0.1247,  0.1781,
         -0.1001, -0.0388,  0.1160,  0.0721, -0.1564,  0.0286, -0.2798,  0.0570,
         -0.1126, -0.0555,  0.1143, -0.0570,  0.1330,  0.1408,  0.1249, -0.0091,
          0.1843, -0.1965,  0.0871,  0.1142,  0.1426,  0.2731, -0.1353, -0.0728,
          0.0629,  0.1048, -0.2422,  0.0678, -0.0327, -0.2476, -0.0955,  0.0141,
         -0.0604, -0.2301, -0.0895, -0.2373, -0.1269,  0.0283,  0.0236,  0.0523,
          0.0186,  0.1607,  0.0657, -0.0504,  0.0386, -0.0780, -0.0550,  0.1889,
          0.1680,  0.4310, -0.0810,  0.0351,  0.1186,  0.2984, -0.1126,  0.3683]),
 tensor([-0.0593,  0.1420,  0.1533,  0.6017,  0.0219,  0.1645,  0.1774,  0.2621,
          0.0212, -0.0885, -0.0479, -0.2454, -0.0795,  0.4369,  0.0683,  0.0471,
         -0.1646,  0.1388,  0.0949,  0.3442, -0.2943, -0.1061,  0.2031, -0.3346,
          0.3015, -0.1600,  0.1266, -0.2006,  0.0115,  0.1629,  0.3384, -0.3062,
         -0.0538, -0.2762,  0.1174, -0.0889,  0.1763,  0.0932,  0.0640,  0.0376,
          0.1299, -0.1066, -0.0375, -0.0830, -0.1458,  0.2624, -0.1884, -0.0963,
          0.2504, -0.1007, -0.1249,  0.5548, -0.0274,  0.1474, -0.3272, -0.0193,
          0.2393, -0.1210,  0.4339, -0.1526,  0.0066, -0.5064,  0.1976,  0.1576,
         -0.3193,  0.2895, -0.1209,  0.1067, -0.0385, -0.0581,  0.0205,  0.1668,
         -0.1674, -0.0023,  0.4589, -0.0747,  0.1174, -0.0012, -0.6666, -0.0306,
         -0.2241,  0.0050,  0.2620,  0.0178,  0.0173,  0.0906,  0.1987, -0.1455,
          0.0020, -0.0512, -0.0978,  0.0429,  0.2200, -0.0360,  0.1892,  0.0426,
         -0.2668,  0.3987, -0.0021,  0.2752, -0.0113, -0.3654, -0.1054,  0.1678,
         -0.0348, -0.2717,  0.0717, -0.2477, -0.1778, -0.1425,  0.3031,  0.4260,
         -0.0400, -0.0244,  0.0875, -0.1158,  0.3348,  0.0620, -0.0484,  0.2946,
          0.0861,  0.4925, -0.3672,  0.2184,  0.3023,  0.3281,  0.2583,  0.6263]),
 tensor([-0.0415,  0.1784,  0.1385,  0.2364, -0.1765,  0.0204,  0.1957,  0.0045,
          0.3516, -0.2949,  0.3590, -0.3617,  0.2157,  0.1069, -0.2205, -0.2979,
          0.0347,  0.0031,  0.0822, -0.0190, -0.1740, -0.0795,  0.1851, -0.1591,
         -0.1496, -0.0485, -0.2972, -0.1455,  0.0039, -0.2822,  0.1094, -0.2870,
         -0.2260,  0.0831, -0.1085, -0.1762,  0.0819,  0.2101, -0.3505, -0.0324,
          0.0177, -0.0179, -0.1127, -0.0051,  0.1997,  0.0091, -0.1254, -0.3334,
         -0.1060, -0.1126,  0.2488,  0.0868,  0.0142, -0.3247, -0.5512, -0.1816,
         -0.0839, -0.1708,  0.1774, -0.2722, -0.5706, -0.1360,  0.2516,  0.2567,
         -0.3281, -0.0140,  0.2495, -0.0315,  0.1981, -0.2101,  0.2356, -0.2233,
         -0.0726,  0.1125,  0.5438, -0.0057,  0.0961,  0.1772, -0.1980,  0.3614,
         -0.4167,  0.3661, -0.0156,  0.0452, -0.1945, -0.3669,  0.2274,  0.0314,
          0.0824,  0.2614, -0.6486,  0.1165, -0.0102, -0.3618,  0.6639, -0.0735,
         -0.5733,  0.5602, -0.1278,  0.2259, -0.1493, -0.0347,  0.2010,  0.0670,
          0.1909, -0.0317,  0.4074,  0.3331, -0.0321, -0.6009,  0.0993,  0.7361,
         -0.0188, -0.1460,  0.0284, -0.0832,  0.4093, -0.3671, -0.1219, -0.0624,
         -0.1361, -0.0297,  0.2749, -0.0408,  0.0820, -0.0153,  0.4638,  0.0027]),
 tensor([-1.1463e-01,  1.2043e-01, -8.6213e-04,  2.3034e-01,  3.3252e-02,
         -1.8702e-01,  2.1048e-01, -3.3407e-01,  4.0918e-01, -3.3458e-01,
          3.6198e-02, -5.0157e-01,  2.8624e-01,  2.1760e-01,  3.3183e-01,
         -1.6113e-01,  3.2419e-01, -2.1497e-01,  1.6998e-01, -1.9075e-01,
         -4.0376e-02, -3.0472e-01, -3.9767e-02, -3.0934e-01,  4.0553e-01,
          3.7530e-02, -2.5721e-01, -7.2560e-03,  4.0108e-02,  6.6949e-02,
         -2.7757e-01, -2.6576e-01, -2.8464e-01, -2.1223e-01,  3.1095e-01,
         -1.9256e-01, -7.3817e-02,  7.3461e-02, -2.7131e-01, -2.4159e-01,
          3.9428e-01, -4.9797e-01, -1.9729e-01,  8.3525e-02,  4.4831e-01,
          2.2019e-01, -1.5277e-01, -2.7589e-01,  3.8723e-01, -1.9952e-01,
          1.2896e-01,  1.1762e-01,  7.0422e-02, -3.7493e-01,  1.1459e-01,
          2.6654e-01, -8.8077e-02, -4.1883e-01, -5.9344e-02, -2.1558e-01,
         -1.5561e-01,  1.4683e-01, -1.4747e-01, -3.0577e-01, -1.5856e-03,
         -1.7510e-01, -1.3241e-01, -3.1303e-02, -3.0086e-02, -8.7066e-02,
          5.0187e-01, -4.1475e-01,  1.9708e-01, -4.0167e-01,  3.4030e-01,
          1.9865e-01,  3.8311e-01, -5.7059e-01,  6.8296e-02,  2.1768e-01,
         -6.9277e-01,  3.5171e-01, -6.1977e-02,  3.6378e-01, -3.8806e-01,
         -1.8209e-01,  1.4052e-01,  5.6935e-01,  1.8562e-01,  3.4785e-01,
         -1.9034e-01,  8.6349e-02, -1.9852e-01, -3.8862e-01,  7.5386e-01,
          6.3473e-01, -6.8075e-01,  2.2781e-01, -4.0939e-02,  4.3158e-01,
         -6.1801e-02, -2.7268e-02,  1.0936e-01,  4.4113e-01,  8.4110e-02,
         -9.9831e-02,  2.5669e-01,  3.4121e-01,  3.7302e-01, -2.3532e-01,
          1.1826e-01,  9.1222e-01, -4.7261e-01, -9.8384e-02, -6.1488e-01,
          1.3564e-01, -1.4147e-01, -1.1639e-01, -1.0185e-01, -4.0147e-01,
          9.8633e-02, -4.6847e-01, -4.3858e-02,  2.8529e-01, -1.6777e-01,
          8.1113e-02,  1.3948e-01,  2.3764e-01]),
 tensor([ 0.0136,  0.0120, -0.2849, -0.3234,  0.1025, -0.1838,  0.3154, -0.3039,
          0.3531, -0.5104,  0.2240, -0.5693,  0.6809, -0.2465, -0.0294, -0.4711,
          0.2203, -0.3897,  0.3185, -0.3627, -0.0779, -0.3939, -0.0570, -0.2170,
          0.1018, -0.2001, -0.4139,  0.0506,  0.1336, -0.2123, -0.5224, -0.1908,
         -0.2453, -0.1172, -0.0747, -0.0521,  0.2762, -0.1715, -0.3502, -0.4108,
          0.3832, -0.1743, -0.1263, -0.0704,  0.3227, -0.1194, -0.1510, -0.4599,
          0.2214, -0.1100, -0.0235, -0.1078,  0.0096, -0.7371, -0.0964,  0.2459,
         -0.1979, -0.2487, -0.1933, -0.3228, -0.3969,  0.1832,  0.2185, -0.0848,
         -0.0504, -0.2123,  0.1162,  0.0071,  0.4818, -0.0804,  0.6297, -0.5016,
          0.2862, -0.3867,  0.4614,  0.1989,  0.5330, -0.1623,  0.2863,  0.3111,
         -0.3878,  0.2735, -0.0036,  0.2029, -0.4714, -0.4734, -0.0062,  0.4765,
          0.3502,  0.1806, -0.3461, -0.0427, -0.3056, -0.4644,  0.4051,  0.5902,
         -0.2037,  0.0513,  0.2626,  0.0519,  0.1598,  0.0626,  0.0696,  0.2775,
          0.0267, -0.1617,  0.3613,  0.7991,  0.3888, -0.2694,  0.0656,  0.5121,
         -0.2760,  0.0387, -0.3476,  0.2055, -0.2234,  0.0306, -0.2140, -0.3300,
          0.0669, -0.4551,  0.0914,  0.1402, -0.4747, -0.0176,  0.2638, -0.1072])]
>>> h
>>> h = hidden_tensors[0]
>>> h.tolist()
[[0.09867188334465027,
  -0.061636634171009064,
  -0.06473945081233978,
  0.20592372119426727,
  0.06902039051055908,
  0.04304133355617523,
  -0.00502582686021924,
  -0.08104116469621658,
  -0.028812488541007042,
  -0.05031339079141617,
  0.15937945246696472,
  0.03947604075074196,
  -0.09352868795394897,
  0.11606296896934509,
  0.045090239495038986,
  0.0924711674451828,
  0.05996483936905861,
  -0.08165499567985535,
  -0.11606156826019287,
  0.021084897220134735,
  0.14779087901115417,
  0.209245502948761,
  0.04439651966094971,
  0.03509187698364258,
  -0.08374463021755219,
  -0.1195266991853714,
  -0.0661124438047409,
  -0.017691858112812042,
  -0.03532690927386284,
  0.07666069269180298,
  0.06204456463456154,
  0.07219357043504715,
  0.11106771230697632,
  0.049975086003541946,
  0.017673533409833908,
  0.06309910118579865,
  -0.08466477692127228,
  0.04305030405521393,
  0.13719184696674347,
  -0.022323530167341232,
  -0.16230237483978271,
  0.01982230320572853,
  0.11575087904930115,
  0.004030349664390087,
  -0.02949056774377823,
  -0.03488871827721596,
  0.03563132882118225,
  -0.08708962053060532,
  0.11671438813209534,
  0.04192052036523819,
  0.04950148984789848,
  0.15555183589458466,
  -0.03483416140079498,
  -0.0027252212166786194,
  -0.004293784499168396,
  -0.0111631378531456,
  -0.10449085384607315,
  0.08665064722299576,
  -0.06145211681723595,
  0.06559208035469055,
  0.02320089563727379,
  0.029463745653629303,
  -0.018726177513599396,
  -0.03273530676960945,
  -0.11922456324100494,
  -0.010459233075380325,
  0.011134481057524681,
  0.07452782988548279,
  0.02956508845090866,
  0.026488104835152626,
  -0.0628320500254631,
  0.16963723301887512,
  -0.04525872692465782,
  0.13283786177635193,
  -0.06112777069211006,
  -0.014891952276229858,
  0.012416142039000988,
  0.03746883571147919,
  -0.1953231692314148,
  0.059215471148490906,
  -0.022000174969434738,
  -0.13468612730503082,
  0.006625140085816383,
  -0.09937001764774323,
  0.1722387969493866,
  -0.049155790358781815,
  0.12569457292556763,
  -0.03961236774921417,
  0.09289080649614334,
  0.08564148843288422,
  0.09450841695070267,
  0.10038807988166809,
  0.155985027551651,
  0.07945527881383896,
  -0.07335320860147476,
  0.0719585195183754,
  0.06737423688173294,
  0.02741236984729767,
  -0.11122001707553864,
  -0.004952557384967804,
  0.006298555061221123,
  0.01901005208492279,
  -0.03065549209713936,
  -0.08158189058303833,
  -0.2036026567220688,
  0.09702081978321075,
  -0.032049231231212616,
  -0.04500420391559601,
  0.009962417185306549,
  -0.03409381955862045,
  0.03923932462930679,
  -0.11703518033027649,
  -0.09079503268003464,
  0.05729862302541733,
  0.017073992639780045,
  0.03993241861462593,
  -0.028139963746070862,
  -0.04287685453891754,
  -0.10477828234434128,
  0.1235681027173996,
  0.1507020890712738,
  0.10172807425260544,
  0.16174089908599854,
  0.11958857625722885,
  0.030610162764787674,
  0.0574532076716423,
  -0.11163301765918732,
  0.10769279301166534]]
>>> h = hidden_tensors[0].tolist()
>>> h
[[0.09867188334465027,
  -0.061636634171009064,
  -0.06473945081233978,
  0.20592372119426727,
  0.06902039051055908,
  0.04304133355617523,
  -0.00502582686021924,
  -0.08104116469621658,
  -0.028812488541007042,
  -0.05031339079141617,
  0.15937945246696472,
  0.03947604075074196,
  -0.09352868795394897,
  0.11606296896934509,
  0.045090239495038986,
  0.0924711674451828,
  0.05996483936905861,
  -0.08165499567985535,
  -0.11606156826019287,
  0.021084897220134735,
  0.14779087901115417,
  0.209245502948761,
  0.04439651966094971,
  0.03509187698364258,
  -0.08374463021755219,
  -0.1195266991853714,
  -0.0661124438047409,
  -0.017691858112812042,
  -0.03532690927386284,
  0.07666069269180298,
  0.06204456463456154,
  0.07219357043504715,
  0.11106771230697632,
  0.049975086003541946,
  0.017673533409833908,
  0.06309910118579865,
  -0.08466477692127228,
  0.04305030405521393,
  0.13719184696674347,
  -0.022323530167341232,
  -0.16230237483978271,
  0.01982230320572853,
  0.11575087904930115,
  0.004030349664390087,
  -0.02949056774377823,
  -0.03488871827721596,
  0.03563132882118225,
  -0.08708962053060532,
  0.11671438813209534,
  0.04192052036523819,
  0.04950148984789848,
  0.15555183589458466,
  -0.03483416140079498,
  -0.0027252212166786194,
  -0.004293784499168396,
  -0.0111631378531456,
  -0.10449085384607315,
  0.08665064722299576,
  -0.06145211681723595,
  0.06559208035469055,
  0.02320089563727379,
  0.029463745653629303,
  -0.018726177513599396,
  -0.03273530676960945,
  -0.11922456324100494,
  -0.010459233075380325,
  0.011134481057524681,
  0.07452782988548279,
  0.02956508845090866,
  0.026488104835152626,
  -0.0628320500254631,
  0.16963723301887512,
  -0.04525872692465782,
  0.13283786177635193,
  -0.06112777069211006,
  -0.014891952276229858,
  0.012416142039000988,
  0.03746883571147919,
  -0.1953231692314148,
  0.059215471148490906,
  -0.022000174969434738,
  -0.13468612730503082,
  0.006625140085816383,
  -0.09937001764774323,
  0.1722387969493866,
  -0.049155790358781815,
  0.12569457292556763,
  -0.03961236774921417,
  0.09289080649614334,
  0.08564148843288422,
  0.09450841695070267,
  0.10038807988166809,
  0.155985027551651,
  0.07945527881383896,
  -0.07335320860147476,
  0.0719585195183754,
  0.06737423688173294,
  0.02741236984729767,
  -0.11122001707553864,
  -0.004952557384967804,
  0.006298555061221123,
  0.01901005208492279,
  -0.03065549209713936,
  -0.08158189058303833,
  -0.2036026567220688,
  0.09702081978321075,
  -0.032049231231212616,
  -0.04500420391559601,
  0.009962417185306549,
  -0.03409381955862045,
  0.03923932462930679,
  -0.11703518033027649,
  -0.09079503268003464,
  0.05729862302541733,
  0.017073992639780045,
  0.03993241861462593,
  -0.028139963746070862,
  -0.04287685453891754,
  -0.10477828234434128,
  0.1235681027173996,
  0.1507020890712738,
  0.10172807425260544,
  0.16174089908599854,
  0.11958857625722885,
  0.030610162764787674,
  0.0574532076716423,
  -0.11163301765918732,
  0.10769279301166534]]
>>> hidden_lists = [h[0].tolist() for h in hidden_tensors]
>>> hidden_lists
[[0.09867188334465027,
  -0.061636634171009064,
  -0.06473945081233978,
  0.20592372119426727,
  0.06902039051055908,
  0.04304133355617523,
  -0.00502582686021924,
  -0.08104116469621658,
  -0.028812488541007042,
  -0.05031339079141617,
  0.15937945246696472,
  0.03947604075074196,
  -0.09352868795394897,
  0.11606296896934509,
  0.045090239495038986,
  0.0924711674451828,
  0.05996483936905861,
  -0.08165499567985535,
  -0.11606156826019287,
  0.021084897220134735,
  0.14779087901115417,
  0.209245502948761,
  0.04439651966094971,
  0.03509187698364258,
  -0.08374463021755219,
  -0.1195266991853714,
  -0.0661124438047409,
  -0.017691858112812042,
  -0.03532690927386284,
  0.07666069269180298,
  0.06204456463456154,
  0.07219357043504715,
  0.11106771230697632,
  0.049975086003541946,
  0.017673533409833908,
  0.06309910118579865,
  -0.08466477692127228,
  0.04305030405521393,
  0.13719184696674347,
  -0.022323530167341232,
  -0.16230237483978271,
  0.01982230320572853,
  0.11575087904930115,
  0.004030349664390087,
  -0.02949056774377823,
  -0.03488871827721596,
  0.03563132882118225,
  -0.08708962053060532,
  0.11671438813209534,
  0.04192052036523819,
  0.04950148984789848,
  0.15555183589458466,
  -0.03483416140079498,
  -0.0027252212166786194,
  -0.004293784499168396,
  -0.0111631378531456,
  -0.10449085384607315,
  0.08665064722299576,
  -0.06145211681723595,
  0.06559208035469055,
  0.02320089563727379,
  0.029463745653629303,
  -0.018726177513599396,
  -0.03273530676960945,
  -0.11922456324100494,
  -0.010459233075380325,
  0.011134481057524681,
  0.07452782988548279,
  0.02956508845090866,
  0.026488104835152626,
  -0.0628320500254631,
  0.16963723301887512,
  -0.04525872692465782,
  0.13283786177635193,
  -0.06112777069211006,
  -0.014891952276229858,
  0.012416142039000988,
  0.03746883571147919,
  -0.1953231692314148,
  0.059215471148490906,
  -0.022000174969434738,
  -0.13468612730503082,
  0.006625140085816383,
  -0.09937001764774323,
  0.1722387969493866,
  -0.049155790358781815,
  0.12569457292556763,
  -0.03961236774921417,
  0.09289080649614334,
  0.08564148843288422,
  0.09450841695070267,
  0.10038807988166809,
  0.155985027551651,
  0.07945527881383896,
  -0.07335320860147476,
  0.0719585195183754,
  0.06737423688173294,
  0.02741236984729767,
  -0.11122001707553864,
  -0.004952557384967804,
  0.006298555061221123,
  0.01901005208492279,
  -0.03065549209713936,
  -0.08158189058303833,
  -0.2036026567220688,
  0.09702081978321075,
  -0.032049231231212616,
  -0.04500420391559601,
  0.009962417185306549,
  -0.03409381955862045,
  0.03923932462930679,
  -0.11703518033027649,
  -0.09079503268003464,
  0.05729862302541733,
  0.017073992639780045,
  0.03993241861462593,
  -0.028139963746070862,
  -0.04287685453891754,
  -0.10477828234434128,
  0.1235681027173996,
  0.1507020890712738,
  0.10172807425260544,
  0.16174089908599854,
  0.11958857625722885,
  0.030610162764787674,
  0.0574532076716423,
  -0.11163301765918732,
  0.10769279301166534],
 [-0.027102962136268616,
  0.033778417855501175,
  0.018886983394622803,
  0.3836577534675598,
  0.2864515781402588,
  0.2669029235839844,
  -0.019623905420303345,
  0.04576360434293747,
  -0.004016891121864319,
  -0.12475377321243286,
  0.05378139764070511,
  -0.03946045786142349,
  -0.25705596804618835,
  0.2866072654724121,
  0.08765678107738495,
  0.1219358965754509,
  -0.048030219972133636,
  0.1452266126871109,
  -0.10522302985191345,
  0.26635172963142395,
  -0.09280160814523697,
  0.18829628825187683,
  -0.043952576816082,
  -0.12701892852783203,
  0.21820305287837982,
  -0.12211743742227554,
  0.24788141250610352,
  -0.1739102303981781,
  0.047365546226501465,
  0.04766116663813591,
  0.4025893211364746,
  -0.24786357581615448,
  0.14112639427185059,
  -0.25472357869148254,
  0.05262594670057297,
  0.007802635431289673,
  0.11626744270324707,
  0.17230282723903656,
  0.22922176122665405,
  0.11797408759593964,
  -0.1818120777606964,
  0.05220232903957367,
  -0.02590777724981308,
  0.08307250589132309,
  -0.1822243183851242,
  0.14028117060661316,
  0.043375179171562195,
  0.10791502892971039,
  0.11341045051813126,
  -0.003325565718114376,
  -0.15169504284858704,
  0.3351660966873169,
  -0.008830631151795387,
  0.3253709077835083,
  -0.11810009181499481,
  -0.0916508361697197,
  0.12384414672851562,
  0.0733705535531044,
  0.11498293280601501,
  -0.04278815537691116,
  0.02631659060716629,
  -0.3169202506542206,
  -0.09633411467075348,
  0.073032908141613,
  -0.27986636757850647,
  0.16096524894237518,
  -0.04896001145243645,
  0.09792616963386536,
  0.004960149526596069,
  0.029913796111941338,
  -0.12474891543388367,
  0.17811056971549988,
  -0.10007188469171524,
  -0.03878997266292572,
  0.11595079302787781,
  0.07211838662624359,
  -0.1563762128353119,
  0.02856680192053318,
  -0.2798413634300232,
  0.056991156190633774,
  -0.11256200075149536,
  -0.055546849966049194,
  0.11431910842657089,
  -0.056967996060848236,
  0.13296614587306976,
  0.14081941545009613,
  0.12487189471721649,
  -0.009144652634859085,
  0.18431690335273743,
  -0.196500763297081,
  0.0870545282959938,
  0.11424612253904343,
  0.14263282716274261,
  0.27307987213134766,
  -0.13525067269802094,
  -0.07275786995887756,
  0.06292334198951721,
  0.10484939813613892,
  -0.24218913912773132,
  0.06783947348594666,
  -0.032652925699949265,
  -0.247560515999794,
  -0.09548871219158173,
  0.014091650024056435,
  -0.06036520004272461,
  -0.2301451414823532,
  -0.08946873247623444,
  -0.23730126023292542,
  -0.1269456446170807,
  0.028284531086683273,
  0.023580089211463928,
  0.052261050790548325,
  0.018638979643583298,
  0.16066588461399078,
  0.06568136811256409,
  -0.050355494022369385,
  0.03859316185116768,
  -0.07796616107225418,
  -0.05500272288918495,
  0.18889763951301575,
  0.1680268496274948,
  0.4309538006782532,
  -0.08100086450576782,
  0.03510066866874695,
  0.11856205761432648,
  0.29844728112220764,
  -0.11257490515708923,
  0.3683359622955322],
 [-0.05928950011730194,
  0.14198815822601318,
  0.15330758690834045,
  0.6017482280731201,
  0.021925605833530426,
  0.16454963386058807,
  0.1774294227361679,
  0.26205840706825256,
  0.02123192325234413,
  -0.08854684233665466,
  -0.047880809754133224,
  -0.2454243302345276,
  -0.07954137772321701,
  0.43687596917152405,
  0.06831738352775574,
  0.047147028148174286,
  -0.1646386682987213,
  0.13877509534358978,
  0.09487427026033401,
  0.3441847562789917,
  -0.2942551374435425,
  -0.10606853663921356,
  0.20314550399780273,
  -0.3345891833305359,
  0.30148541927337646,
  -0.1599501222372055,
  0.12662936747074127,
  -0.20060032606124878,
  0.011490747332572937,
  0.16287726163864136,
  0.3384316563606262,
  -0.3061533570289612,
  -0.05379332974553108,
  -0.2762353718280792,
  0.11739155650138855,
  -0.08892043679952621,
  0.1762789934873581,
  0.09323881566524506,
  0.06397384405136108,
  0.037600643932819366,
  0.1299149990081787,
  -0.10662186145782471,
  -0.037503182888031006,
  -0.08300438523292542,
  -0.1457914263010025,
  0.2623938322067261,
  -0.188434898853302,
  -0.09633874893188477,
  0.250448614358902,
  -0.10066600143909454,
  -0.12487651407718658,
  0.5547515749931335,
  -0.02744544856250286,
  0.14739000797271729,
  -0.3272291123867035,
  -0.019293397665023804,
  0.23931200802326202,
  -0.12100866436958313,
  0.433942586183548,
  -0.15263380110263824,
  0.0065622106194496155,
  -0.5063711404800415,
  0.19764384627342224,
  0.15757179260253906,
  -0.31925442814826965,
  0.28948602080345154,
  -0.12094955146312714,
  0.10666128993034363,
  -0.03852070868015289,
  -0.05810254067182541,
  0.020491108298301697,
  0.1668352335691452,
  -0.167373389005661,
  -0.0023349281400442123,
  0.4588552415370941,
  -0.07468540221452713,
  0.11743811517953873,
  -0.001234034076333046,
  -0.6666339635848999,
  -0.03063715249300003,
  -0.22409561276435852,
  0.005037263035774231,
  0.2619839906692505,
  0.017840908840298653,
  0.017264552414417267,
  0.09057535231113434,
  0.1986621916294098,
  -0.14545433223247528,
  0.0019655227661132812,
  -0.05121948942542076,
  -0.09776576608419418,
  0.042867451906204224,
  0.21996665000915527,
  -0.03601163625717163,
  0.1891520470380783,
  0.042636722326278687,
  -0.2667914927005768,
  0.39870715141296387,
  -0.0020827213302254677,
  0.2751810550689697,
  -0.01126440241932869,
  -0.36542001366615295,
  -0.10536764562129974,
  0.16777724027633667,
  -0.03475291281938553,
  -0.27172374725341797,
  0.0716908723115921,
  -0.24774380028247833,
  -0.17776623368263245,
  -0.14247150719165802,
  0.3031177520751953,
  0.42603322863578796,
  -0.03996949642896652,
  -0.024422433227300644,
  0.08754031360149384,
  -0.11581307649612427,
  0.3347742557525635,
  0.061983831226825714,
  -0.0484200157225132,
  0.2945695221424103,
  0.08610141277313232,
  0.4925415813922882,
  -0.3671990633010864,
  0.2184354066848755,
  0.3023034632205963,
  0.3281364142894745,
  0.25826457142829895,
  0.6263269186019897],
 [-0.0414702370762825,
  0.17839860916137695,
  0.13846410810947418,
  0.2364363819360733,
  -0.17648020386695862,
  0.02039831131696701,
  0.19571489095687866,
  0.004495076835155487,
  0.35159537196159363,
  -0.2949226200580597,
  0.3590029180049896,
  -0.3616890013217926,
  0.21573945879936218,
  0.10690140724182129,
  -0.22051936388015747,
  -0.29793602228164673,
  0.03467452898621559,
  0.0030834414064884186,
  0.08216353505849838,
  -0.01904994435608387,
  -0.17401635646820068,
  -0.07954388856887817,
  0.18510055541992188,
  -0.15910987555980682,
  -0.14961694180965424,
  -0.04852170869708061,
  -0.2972172796726227,
  -0.14548131823539734,
  0.0038642995059490204,
  -0.28219369053840637,
  0.10941457003355026,
  -0.2870345711708069,
  -0.2259615957736969,
  0.08308149874210358,
  -0.10851230472326279,
  -0.1762215495109558,
  0.08186101913452148,
  0.21006865799427032,
  -0.350504994392395,
  -0.03238596394658089,
  0.017679665237665176,
  -0.017882369458675385,
  -0.11265544593334198,
  -0.005114031955599785,
  0.19969555735588074,
  0.009148405864834785,
  -0.12535563111305237,
  -0.33343735337257385,
  -0.10598956793546677,
  -0.11261022090911865,
  0.2488003820180893,
  0.0867634117603302,
  0.01424376480281353,
  -0.3247065246105194,
  -0.5511899590492249,
  -0.18155257403850555,
  -0.08385760337114334,
  -0.17082926630973816,
  0.17739620804786682,
  -0.2721749246120453,
  -0.5706002116203308,
  -0.13603666424751282,
  0.2516420781612396,
  0.25670573115348816,
  -0.32810676097869873,
  -0.013972502201795578,
  0.24949300289154053,
  -0.0314856618642807,
  0.19814373552799225,
  -0.21011491119861603,
  0.2356172502040863,
  -0.22332455217838287,
  -0.07259565591812134,
  0.11245632916688919,
  0.5437632203102112,
  -0.005652640014886856,
  0.09614262729883194,
  0.17723293602466583,
  -0.19800540804862976,
  0.3613510727882385,
  -0.4167260229587555,
  0.3661426901817322,
  -0.01563776470720768,
  0.04516492784023285,
  -0.19454921782016754,
  -0.36685457825660706,
  0.22735831141471863,
  0.03141414746642113,
  0.08236938714981079,
  0.26138636469841003,
  -0.6486499905586243,
  0.11654893308877945,
  -0.010177910327911377,
  -0.36184316873550415,
  0.6639012098312378,
  -0.07347553968429565,
  -0.5732595920562744,
  0.5601975321769714,
  -0.12779739499092102,
  0.22588931024074554,
  -0.1492747962474823,
  -0.03467169031500816,
  0.20096497237682343,
  0.0670461654663086,
  0.1909434050321579,
  -0.03174210712313652,
  0.40735024213790894,
  0.33307066559791565,
  -0.032104313373565674,
  -0.6009100675582886,
  0.09931524097919464,
  0.7360959053039551,
  -0.018813008442521095,
  -0.14596618711948395,
  0.02841230109333992,
  -0.08322988450527191,
  0.40928027033805847,
  -0.3670597970485687,
  -0.1219487264752388,
  -0.06238711252808571,
  -0.13605011999607086,
  -0.029716307297348976,
  0.2748873829841614,
  -0.04080963879823685,
  0.08201770484447479,
  -0.01532871462404728,
  0.4637925624847412,
  0.002680167555809021],
 [-0.11463098973035812,
  0.12042711675167084,
  -0.0008621290326118469,
  0.23033873736858368,
  0.03325168415904045,
  -0.18702295422554016,
  0.2104831486940384,
  -0.33406659960746765,
  0.40917980670928955,
  -0.33457693457603455,
  0.036198485642671585,
  -0.5015746355056763,
  0.28624042868614197,
  0.21760429441928864,
  0.3318314552307129,
  -0.1611342579126358,
  0.324194073677063,
  -0.21496716141700745,
  0.1699821650981903,
  -0.19075319170951843,
  -0.04037598520517349,
  -0.3047216534614563,
  -0.039767421782016754,
  -0.3093373775482178,
  0.4055277109146118,
  0.03752971440553665,
  -0.25720933079719543,
  -0.007256034761667252,
  0.040107809007167816,
  0.06694866716861725,
  -0.27757352590560913,
  -0.26576316356658936,
  -0.2846420705318451,
  -0.21223357319831848,
  0.3109451234340668,
  -0.19255799055099487,
  -0.0738166943192482,
  0.07346096634864807,
  -0.2713075280189514,
  -0.24159188568592072,
  0.394282728433609,
  -0.4979728162288666,
  -0.1972932070493698,
  0.08352476358413696,
  0.4483145773410797,
  0.22019027173519135,
  -0.15276576578617096,
  -0.2758946120738983,
  0.38722750544548035,
  -0.19952058792114258,
  0.12896350026130676,
  0.11762301623821259,
  0.07042204588651657,
  -0.37492653727531433,
  0.11458902806043625,
  0.2665430009365082,
  -0.08807658404111862,
  -0.41882964968681335,
  -0.059344496577978134,
  -0.21557846665382385,
  -0.15561078488826752,
  0.1468321681022644,
  -0.1474682241678238,
  -0.30576857924461365,
  -0.0015855580568313599,
  -0.17509540915489197,
  -0.13241280615329742,
  -0.031302887946367264,
  -0.030085548758506775,
  -0.08706578612327576,
  0.5018686056137085,
  -0.41474825143814087,
  0.1970774233341217,
  -0.4016748070716858,
  0.34030452370643616,
  0.19864864647388458,
  0.3831119239330292,
  -0.5705937743186951,
  0.06829633563756943,
  0.21767953038215637,
  -0.6927695274353027,
  0.35170841217041016,
  -0.06197650730609894,
  0.3637840449810028,
  -0.38806188106536865,
  -0.18208910524845123,
  0.14052091538906097,
  0.569346010684967,
  0.18561550974845886,
  0.3478454351425171,
  -0.19033825397491455,
  0.08634939044713974,
  -0.1985187977552414,
  -0.38862138986587524,
  0.7538561820983887,
  0.6347315907478333,
  -0.6807469129562378,
  0.22780513763427734,
  -0.040939439088106155,
  0.43157893419265747,
  -0.061800938099622726,
  -0.027268061414361,
  0.1093568205833435,
  0.4411284923553467,
  0.08410978317260742,
  -0.0998314917087555,
  0.25669100880622864,
  0.341207355260849,
  0.3730244040489197,
  -0.2353181689977646,
  0.11825543642044067,
  0.9122166633605957,
  -0.4726147949695587,
  -0.0983840674161911,
  -0.6148820519447327,
  0.13564005494117737,
  -0.14147010445594788,
  -0.11639496684074402,
  -0.10185207426548004,
  -0.40146884322166443,
  0.0986328125,
  -0.4684700667858124,
  -0.04385797679424286,
  0.2852908968925476,
  -0.16776856780052185,
  0.08111270517110825,
  0.13947787880897522,
  0.23764216899871826],
 [0.013550225645303726,
  0.012002076953649521,
  -0.2849424183368683,
  -0.3234122097492218,
  0.10252155363559723,
  -0.18382418155670166,
  0.31540876626968384,
  -0.30394259095191956,
  0.35312309861183167,
  -0.510381817817688,
  0.2239532619714737,
  -0.569267988204956,
  0.6809045076370239,
  -0.2465226650238037,
  -0.02941136620938778,
  -0.47107115387916565,
  0.2203465700149536,
  -0.3897486925125122,
  0.31845343112945557,
  -0.36272040009498596,
  -0.07793352752923965,
  -0.3939433693885803,
  -0.05697361379861832,
  -0.21701742708683014,
  0.10181760787963867,
  -0.2000541388988495,
  -0.4138837158679962,
  0.05060926824808121,
  0.133576437830925,
  -0.21225576102733612,
  -0.522405743598938,
  -0.19080699980258942,
  -0.24532020092010498,
  -0.11718733608722687,
  -0.07473994791507721,
  -0.05212797969579697,
  0.2762031853199005,
  -0.17154106497764587,
  -0.3502090275287628,
  -0.4107828736305237,
  0.3832300007343292,
  -0.174327090382576,
  -0.12628191709518433,
  -0.07042767107486725,
  0.3227487802505493,
  -0.11936545372009277,
  -0.15100595355033875,
  -0.4599456489086151,
  0.22142213582992554,
  -0.10998761653900146,
  -0.023521289229393005,
  -0.10779694467782974,
  0.009644405916333199,
  -0.7370857000350952,
  -0.09638155996799469,
  0.24585449695587158,
  -0.1979014128446579,
  -0.24866822361946106,
  -0.19326108694076538,
  -0.3228113651275635,
  -0.3968939781188965,
  0.18315139412879944,
  0.21850436925888062,
  -0.08481315523386002,
  -0.0504283681511879,
  -0.21234895288944244,
  0.11619748175144196,
  0.0071246325969696045,
  0.48178038001060486,
  -0.08039144426584244,
  0.6296958923339844,
  -0.5015998482704163,
  0.28623494505882263,
  -0.38670772314071655,
  0.46143639087677,
  0.19885848462581635,
  0.5329905152320862,
  -0.16228856146335602,
  0.2863025367259979,
  0.3110508918762207,
  -0.3877905607223511,
  0.27346375584602356,
  -0.003557702526450157,
  0.2029283493757248,
  -0.4714251756668091,
  -0.4733903110027313,
  -0.006227407604455948,
  0.47646233439445496,
  0.3502101004123688,
  0.1805575042963028,
  -0.3461121618747711,
  -0.04270598292350769,
  -0.30560165643692017,
  -0.4644315242767334,
  0.4051392078399658,
  0.5901550650596619,
  -0.20372995734214783,
  0.051313407719135284,
  0.2625637352466583,
  0.05188457667827606,
  0.15977297723293304,
  0.06264674663543701,
  0.06960581243038177,
  0.27750295400619507,
  0.026700273156166077,
  -0.1617419719696045,
  0.36133265495300293,
  0.7990573644638062,
  0.38881200551986694,
  -0.26940208673477173,
  0.06555721163749695,
  0.512061357498169,
  -0.27595940232276917,
  0.03874370828270912,
  -0.3475639522075653,
  0.20547819137573242,
  -0.22338971495628357,
  0.03062533773481846,
  -0.21399664878845215,
  -0.32998886704444885,
  0.06689291447401047,
  -0.45505672693252563,
  0.09137095510959625,
  0.14018836617469788,
  -0.4746997654438019,
  -0.01761285401880741,
  0.2638074457645416,
  -0.10722985118627548]]
>>> predicted_classes
['English', 'Chinese', 'Chinese', 'Chinese', 'Algerian', 'Arabic']
>>> pd.DataFrame(hidden_lists, index=list(text)).T
            K         h         a         l         i         d
0    0.098672 -0.027103 -0.059290 -0.041470 -0.114631  0.013550
1   -0.061637  0.033778  0.141988  0.178399  0.120427  0.012002
2   -0.064739  0.018887  0.153308  0.138464 -0.000862 -0.284942
3    0.205924  0.383658  0.601748  0.236436  0.230339 -0.323412
4    0.069020  0.286452  0.021926 -0.176480  0.033252  0.102522
..        ...       ...       ...       ...       ...       ...
123  0.119589  0.035101  0.218435 -0.040810  0.285291  0.140188
124  0.030610  0.118562  0.302303  0.082018 -0.167769 -0.474700
125  0.057453  0.298447  0.328136 -0.015329  0.081113 -0.017613
126 -0.111633 -0.112575  0.258265  0.463793  0.139478  0.263807
127  0.107693  0.368336  0.626327  0.002680  0.237642 -0.107230

[128 rows x 6 columns]
>>> df_hidden = pd.DataFrame(hidden_lists, index=list(text)).T
>>> df_hidden.iloc[128] = predicted_classes
>>> predicted_classes = pd.Series(predicted_classes, index=list(text))
>>> predicted_classes
K     English
h     Chinese
a     Chinese
l     Chinese
i    Algerian
d      Arabic
dtype: object
>>> df_hidden.iloc[128] = predicted_classes
>>> pd.DataFrame(predicted_categories)
>>> df_hidden
            K         h         a         l         i         d
0    0.098672 -0.027103 -0.059290 -0.041470 -0.114631  0.013550
1   -0.061637  0.033778  0.141988  0.178399  0.120427  0.012002
2   -0.064739  0.018887  0.153308  0.138464 -0.000862 -0.284942
3    0.205924  0.383658  0.601748  0.236436  0.230339 -0.323412
4    0.069020  0.286452  0.021926 -0.176480  0.033252  0.102522
..        ...       ...       ...       ...       ...       ...
123  0.119589  0.035101  0.218435 -0.040810  0.285291  0.140188
124  0.030610  0.118562  0.302303  0.082018 -0.167769 -0.474700
125  0.057453  0.298447  0.328136 -0.015329  0.081113 -0.017613
126 -0.111633 -0.112575  0.258265  0.463793  0.139478  0.263807
127  0.107693  0.368336  0.626327  0.002680  0.237642 -0.107230

[128 rows x 6 columns]
>>> predicted_classes
K     English
h     Chinese
a     Chinese
l     Chinese
i    Algerian
d      Arabic
dtype: object
>>> predicted_classes..T
>>> predicted_classes.T
K     English
h     Chinese
a     Chinese
l     Chinese
i    Algerian
d      Arabic
dtype: object
>>> df_hidden.T
        0         1         2         3         4    ...       123       124       125       126       127
K  0.098672 -0.061637 -0.064739  0.205924  0.069020  ...  0.119589  0.030610  0.057453 -0.111633  0.107693
h -0.027103  0.033778  0.018887  0.383658  0.286452  ...  0.035101  0.118562  0.298447 -0.112575  0.368336
a -0.059290  0.141988  0.153308  0.601748  0.021926  ...  0.218435  0.302303  0.328136  0.258265  0.626327
l -0.041470  0.178399  0.138464  0.236436 -0.176480  ... -0.040810  0.082018 -0.015329  0.463793  0.002680
i -0.114631  0.120427 -0.000862  0.230339  0.033252  ...  0.285291 -0.167769  0.081113  0.139478  0.237642
d  0.013550  0.012002 -0.284942 -0.323412  0.102522  ...  0.140188 -0.474700 -0.017613  0.263807 -0.107230

[6 rows x 128 columns]
>>> df_hidden = df_hidden.T
>>> df_hidden['prediction'] = predicted_classes
>>> df_hidden
          0         1         2         3         4  ...       124       125       126       127  prediction
K  0.098672 -0.061637 -0.064739  0.205924  0.069020  ...  0.030610  0.057453 -0.111633  0.107693     English
h -0.027103  0.033778  0.018887  0.383658  0.286452  ...  0.118562  0.298447 -0.112575  0.368336     Chinese
a -0.059290  0.141988  0.153308  0.601748  0.021926  ...  0.302303  0.328136  0.258265  0.626327     Chinese
l -0.041470  0.178399  0.138464  0.236436 -0.176480  ...  0.082018 -0.015329  0.463793  0.002680     Chinese
i -0.114631  0.120427 -0.000862  0.230339  0.033252  ... -0.167769  0.081113  0.139478  0.237642    Algerian
d  0.013550  0.012002 -0.284942 -0.323412  0.102522  ... -0.474700 -0.017613  0.263807 -0.107230      Arabic

[6 rows x 129 columns]
>>> df_hidden['position'] = range(len(text))
>>> df_hidden['textlen'] = len(text)
>>> df_hidden
          0         1         2         3         4  ...       126       127  prediction  position  textlen
K  0.098672 -0.061637 -0.064739  0.205924  0.069020  ... -0.111633  0.107693     English         0        6
h -0.027103  0.033778  0.018887  0.383658  0.286452  ... -0.112575  0.368336     Chinese         1        6
a -0.059290  0.141988  0.153308  0.601748  0.021926  ...  0.258265  0.626327     Chinese         2        6
l -0.041470  0.178399  0.138464  0.236436 -0.176480  ...  0.463793  0.002680     Chinese         3        6
i -0.114631  0.120427 -0.000862  0.230339  0.033252  ...  0.139478  0.237642    Algerian         4        6
d  0.013550  0.012002 -0.284942 -0.323412  0.102522  ...  0.263807 -0.107230      Arabic         5        6

[6 rows x 131 columns]
>>> df_hidden['pred_index'] = [categories.index(p) for p in df_hidden['prediction']]
>>> df_hidden
          0         1         2         3         4  ...       127  prediction  position  textlen  pred_index
K  0.098672 -0.061637 -0.064739  0.205924  0.069020  ...  0.107693     English         0        6           7
h -0.027103  0.033778  0.018887  0.383658  0.286452  ...  0.368336     Chinese         1        6           4
a -0.059290  0.141988  0.153308  0.601748  0.021926  ...  0.626327     Chinese         2        6           4
l -0.041470  0.178399  0.138464  0.236436 -0.176480  ...  0.002680     Chinese         3        6           4
i -0.114631  0.120427 -0.000862  0.230339  0.033252  ...  0.237642    Algerian         4        6           0
d  0.013550  0.012002 -0.284942 -0.323412  0.102522  ... -0.107230      Arabic         5        6           1

[6 rows x 132 columns]
>>> df_hidden.index = list(zip(df_hidden.index, df_hidden['prediction']))
>>> df_hidden
                      0         1         2         3  ...  prediction  position  textlen  pred_index
(K, English)   0.098672 -0.061637 -0.064739  0.205924  ...     English         0        6           7
(h, Chinese)  -0.027103  0.033778  0.018887  0.383658  ...     Chinese         1        6           4
(a, Chinese)  -0.059290  0.141988  0.153308  0.601748  ...     Chinese         2        6           4
(l, Chinese)  -0.041470  0.178399  0.138464  0.236436  ...     Chinese         3        6           4
(i, Algerian) -0.114631  0.120427 -0.000862  0.230339  ...    Algerian         4        6           0
(d, Arabic)    0.013550  0.012002 -0.284942 -0.323412  ...      Arabic         5        6           1

[6 rows x 132 columns]
>>> df_hidden.drop(columns=['prediction'])
                      0         1         2         3  ...       127  position  textlen  pred_index
(K, English)   0.098672 -0.061637 -0.064739  0.205924  ...  0.107693         0        6           7
(h, Chinese)  -0.027103  0.033778  0.018887  0.383658  ...  0.368336         1        6           4
(a, Chinese)  -0.059290  0.141988  0.153308  0.601748  ...  0.626327         2        6           4
(l, Chinese)  -0.041470  0.178399  0.138464  0.236436  ...  0.002680         3        6           4
(i, Algerian) -0.114631  0.120427 -0.000862  0.230339  ...  0.237642         4        6           0
(d, Arabic)    0.013550  0.012002 -0.284942 -0.323412  ... -0.107230         5        6           1

[6 rows x 131 columns]
>>> df_hidden = df_hidden.drop(columns=['prediction']).round(2)
>>> df_hidden.corr()
                   0         1         2         3         4  ...       126       127  position  textlen  pred_index
0           1.000000 -0.813900 -0.437891 -0.326820  0.169354  ... -0.433670 -0.402680 -0.501646      NaN    0.697572
1          -0.813900  1.000000  0.691014  0.408212 -0.631600  ...  0.765156  0.274817  0.386766      NaN   -0.359115
2          -0.437891  0.691014  1.000000  0.896458 -0.393383  ...  0.221561  0.625876 -0.396565      NaN    0.324230
3          -0.326820  0.408212  0.896458  1.000000 -0.022166  ... -0.146936  0.871565 -0.608336      NaN    0.410832
4           0.169354 -0.631600 -0.393383 -0.022166  1.000000  ... -0.797728  0.274049 -0.293111      NaN    0.005278
...              ...       ...       ...       ...       ...  ...       ...       ...       ...      ...         ...
126        -0.433670  0.765156  0.221561 -0.146936 -0.797728  ...  1.000000 -0.230977  0.661955      NaN   -0.378094
127        -0.402680  0.274817  0.625876  0.871565  0.274049  ... -0.230977  1.000000 -0.422706      NaN    0.156958
position   -0.501646  0.386766 -0.396565 -0.608336 -0.293111  ...  0.661955 -0.422706  1.000000      NaN   -0.896803
textlen          NaN       NaN       NaN       NaN       NaN  ...       NaN       NaN       NaN      NaN         NaN
pred_index  0.697572 -0.359115  0.324230  0.410832  0.005278  ... -0.378094  0.156958 -0.896803      NaN    1.000000

[131 rows x 131 columns]
>>> df_hidden.std(axis=0)
0             0.071391
1             0.091214
2             0.157702
3             0.304018
4             0.151360
                ...   
126           0.226097
127           0.268080
position      1.870829
textlen       0.000000
pred_index    2.503331
Length: 131, dtype: float64
>>> df_hidden.std(axis=0).argmin()
129
>>> df_hidden.std(axis=0).values[:128].argmin()
52
>>> df_hidden.std(axis=0)[52]
0.03723797345005051
>>> df_hidden.std(axis=0)[51]
0.22710496838833508
>>> df_hidden.std(axis=0)[53]
0.3918885896101935
>>> df_hidden.drop(columns=['textlen'])
                  0     1     2     3     4     5     6     7     8     9  ...   120   121   122   123   124   125   126   127  position  pred_index
(K, English)   0.10 -0.06 -0.06  0.21  0.07  0.04 -0.01 -0.08 -0.03 -0.05  ...  0.15  0.10  0.16  0.12  0.03  0.06 -0.11  0.11         0           7
(h, Chinese)  -0.03  0.03  0.02  0.38  0.29  0.27 -0.02  0.05 -0.00 -0.12  ...  0.17  0.43 -0.08  0.04  0.12  0.30 -0.11  0.37         1           4
(a, Chinese)  -0.06  0.14  0.15  0.60  0.02  0.16  0.18  0.26  0.02 -0.09  ...  0.09  0.49 -0.37  0.22  0.30  0.33  0.26  0.63         2           4
(l, Chinese)  -0.04  0.18  0.14  0.24 -0.18  0.02  0.20  0.00  0.35 -0.29  ... -0.14 -0.03  0.27 -0.04  0.08 -0.02  0.46  0.00         3           4
(i, Algerian) -0.11  0.12 -0.00  0.23  0.03 -0.19  0.21 -0.33  0.41 -0.33  ...  0.10 -0.47 -0.04  0.29 -0.17  0.08  0.14  0.24         4           0
(d, Arabic)    0.01  0.01 -0.28 -0.32  0.10 -0.18  0.32 -0.30  0.35 -0.51  ...  0.07 -0.46  0.09  0.14 -0.47 -0.02  0.26 -0.11         5           1

[6 rows x 130 columns]
>>> hist -o -p -f classify_name_nationality_heatmap.hist.md
>>> hist -f classify_name_nationality_heatmap.hist.py
>>> df_hidden.corr()['position'].argmax()
128
>>> df_hidden.corr()['position']
0            -0.501646
1             0.386766
2            -0.396565
3            -0.608336
4            -0.293111
                ...   
126           0.661955
127          -0.422706
position      1.000000
textlen            NaN
pred_index   -0.896803
Name: position, Length: 131, dtype: float64
>>> df_hidden.corr()['position'][128]
>>> df_hidden.corr()['position'].ilog[128]
>>> df_hidden.corr()['position'].iloc[128]
1.0
>>> df_hidden.corr()['position'][:128].argmax
<bound method IndexOpsMixin.argmax of 0     -0.501646
1      0.386766
2     -0.396565
3     -0.608336
4     -0.293111
         ...   
123    0.264869
124   -0.715659
125   -0.484715
126    0.661955
127   -0.422706
Name: position, Length: 128, dtype: float64>
>>> df_hidden.corr()['position'][:128].argmax()
18
>>> df_hidden.corr()['position'].ilog[18]
>>> df_hidden.corr()['position'].iloc[18]
0.9628108304083981
>>> hist
>>> hist -f classify_name_nationality_heatmap.hist.py
>>> hist -o -p -f classify_name_nationality_heatmap.hist.md
>>> text = "Khalid"
... predicted_classes = []
... hidden_tensors = []
... for i in range(1, len(text) + 1):
...     hidden_tensors.append(model.predict_hidden(text[:i]))
...     predicted_classes.append(model.predict_category(text[:i]))
...
>>> df_hidden
                  0     1     2     3     4     5     6     7     8  ...   122   123   124   125   126   127  position  textlen  pred_index
(K, English)   0.10 -0.06 -0.06  0.21  0.07  0.04 -0.01 -0.08 -0.03  ...  0.16  0.12  0.03  0.06 -0.11  0.11         0        6           7
(h, Chinese)  -0.03  0.03  0.02  0.38  0.29  0.27 -0.02  0.05 -0.00  ... -0.08  0.04  0.12  0.30 -0.11  0.37         1        6           4
(a, Chinese)  -0.06  0.14  0.15  0.60  0.02  0.16  0.18  0.26  0.02  ... -0.37  0.22  0.30  0.33  0.26  0.63         2        6           4
(l, Chinese)  -0.04  0.18  0.14  0.24 -0.18  0.02  0.20  0.00  0.35  ...  0.27 -0.04  0.08 -0.02  0.46  0.00         3        6           4
(i, Algerian) -0.11  0.12 -0.00  0.23  0.03 -0.19  0.21 -0.33  0.41  ... -0.04  0.29 -0.17  0.08  0.14  0.24         4        6           0
(d, Arabic)    0.01  0.01 -0.28 -0.32  0.10 -0.18  0.32 -0.30  0.35  ...  0.09  0.14 -0.47 -0.02  0.26 -0.11         5        6           1

[6 rows x 131 columns]
>>> df_hidden.corr()['position'][:128].argmax()
18
>>> df_hidden.corr()['position'][:128].argmin)
>>> df_hidden.corr()['position'][:128].argmin()
11
>>> df_hidden.corr()['position'].iloc[[11,18]]
11   -0.991040
18    0.962811
Name: position, dtype: float64
>>> hist -o -p
>>> categories
['Algerian',
 'Arabic',
 'Brazilian',
 'Chilean',
 'Chinese',
 'Czech',
 'Dutch',
 'English',
 'Ethiopian',
 'Finnish']
>>> predicted_categories
>>> predicted_classes
['English', 'Chinese', 'Chinese', 'Chinese', 'Algerian', 'Arabic']
>>> pred_categories = predicted_classes
>>> input_texts = [text[:i]) for i in range(1, len(text) + 1)]
>>> input_texts = [text[:i] for i in range(1, len(text) + 1)]
>>> input_texts
['K', 'Kh', 'Kha', 'Khal', 'Khali', 'Khalid']
>>> pd.Series(index=input_texts, data=pred_categories)
K          English
Kh         Chinese
Kha        Chinese
Khal       Chinese
Khali     Algerian
Khalid      Arabic
dtype: object
>>> pd.Series(pred_categories, input_texts)
K          English
Kh         Chinese
Kha        Chinese
Khal       Chinese
Khali     Algerian
Khalid      Arabic
dtype: object
>>> hist
>>> hist -o
>>> df_hidden
                  0     1     2     3     4     5     6     7     8  ...   122   123   124   125   126   127  position  textlen  pred_index
(K, English)   0.10 -0.06 -0.06  0.21  0.07  0.04 -0.01 -0.08 -0.03  ...  0.16  0.12  0.03  0.06 -0.11  0.11         0        6           7
(h, Chinese)  -0.03  0.03  0.02  0.38  0.29  0.27 -0.02  0.05 -0.00  ... -0.08  0.04  0.12  0.30 -0.11  0.37         1        6           4
(a, Chinese)  -0.06  0.14  0.15  0.60  0.02  0.16  0.18  0.26  0.02  ... -0.37  0.22  0.30  0.33  0.26  0.63         2        6           4
(l, Chinese)  -0.04  0.18  0.14  0.24 -0.18  0.02  0.20  0.00  0.35  ...  0.27 -0.04  0.08 -0.02  0.46  0.00         3        6           4
(i, Algerian) -0.11  0.12 -0.00  0.23  0.03 -0.19  0.21 -0.33  0.41  ... -0.04  0.29 -0.17  0.08  0.14  0.24         4        6           0
(d, Arabic)    0.01  0.01 -0.28 -0.32  0.10 -0.18  0.32 -0.30  0.35  ...  0.09  0.14 -0.47 -0.02  0.26 -0.11         5        6           1

[6 rows x 131 columns]
>>> df_hidden[:128]
                  0     1     2     3     4     5     6     7     8  ...   122   123   124   125   126   127  position  textlen  pred_index
(K, English)   0.10 -0.06 -0.06  0.21  0.07  0.04 -0.01 -0.08 -0.03  ...  0.16  0.12  0.03  0.06 -0.11  0.11         0        6           7
(h, Chinese)  -0.03  0.03  0.02  0.38  0.29  0.27 -0.02  0.05 -0.00  ... -0.08  0.04  0.12  0.30 -0.11  0.37         1        6           4
(a, Chinese)  -0.06  0.14  0.15  0.60  0.02  0.16  0.18  0.26  0.02  ... -0.37  0.22  0.30  0.33  0.26  0.63         2        6           4
(l, Chinese)  -0.04  0.18  0.14  0.24 -0.18  0.02  0.20  0.00  0.35  ...  0.27 -0.04  0.08 -0.02  0.46  0.00         3        6           4
(i, Algerian) -0.11  0.12 -0.00  0.23  0.03 -0.19  0.21 -0.33  0.41  ... -0.04  0.29 -0.17  0.08  0.14  0.24         4        6           0
(d, Arabic)    0.01  0.01 -0.28 -0.32  0.10 -0.18  0.32 -0.30  0.35  ...  0.09  0.14 -0.47 -0.02  0.26 -0.11         5        6           1

[6 rows x 131 columns]
>>> df_hidden[list(range(128))]
                0     1     2     3     4     5     6     7     8     9    ...   118   119   120   121   122   123   124   125   126   127
(K, English)   0.10 -0.06 -0.06  0.21  0.07  0.04 -0.01 -0.08 -0.03 -0.05  ... -0.10  0.12  0.15  0.10  0.16  0.12  0.03  0.06 -0.11  0.11
(h, Chinese)  -0.03  0.03  0.02  0.38  0.29  0.27 -0.02  0.05 -0.00 -0.12  ... -0.06  0.19  0.17  0.43 -0.08  0.04  0.12  0.30 -0.11  0.37
(a, Chinese)  -0.06  0.14  0.15  0.60  0.02  0.16  0.18  0.26  0.02 -0.09  ... -0.05  0.29  0.09  0.49 -0.37  0.22  0.30  0.33  0.26  0.63
(l, Chinese)  -0.04  0.18  0.14  0.24 -0.18  0.02  0.20  0.00  0.35 -0.29  ... -0.12 -0.06 -0.14 -0.03  0.27 -0.04  0.08 -0.02  0.46  0.00
(i, Algerian) -0.11  0.12 -0.00  0.23  0.03 -0.19  0.21 -0.33  0.41 -0.33  ... -0.10 -0.40  0.10 -0.47 -0.04  0.29 -0.17  0.08  0.14  0.24
(d, Arabic)    0.01  0.01 -0.28 -0.32  0.10 -0.18  0.32 -0.30  0.35 -0.51  ... -0.21 -0.33  0.07 -0.46  0.09  0.14 -0.47 -0.02  0.26 -0.11

[6 rows x 128 columns]
>>> hist -o
>>> df_hidden.index = list(text)
>>> df_hidden
      0     1     2     3     4     5     6     7     8     9  ...   121   122   123   124   125   126   127  position  textlen  pred_index
K  0.10 -0.06 -0.06  0.21  0.07  0.04 -0.01 -0.08 -0.03 -0.05  ...  0.10  0.16  0.12  0.03  0.06 -0.11  0.11         0        6           7
h -0.03  0.03  0.02  0.38  0.29  0.27 -0.02  0.05 -0.00 -0.12  ...  0.43 -0.08  0.04  0.12  0.30 -0.11  0.37         1        6           4
a -0.06  0.14  0.15  0.60  0.02  0.16  0.18  0.26  0.02 -0.09  ...  0.49 -0.37  0.22  0.30  0.33  0.26  0.63         2        6           4
l -0.04  0.18  0.14  0.24 -0.18  0.02  0.20  0.00  0.35 -0.29  ... -0.03  0.27 -0.04  0.08 -0.02  0.46  0.00         3        6           4
i -0.11  0.12 -0.00  0.23  0.03 -0.19  0.21 -0.33  0.41 -0.33  ... -0.47 -0.04  0.29 -0.17  0.08  0.14  0.24         4        6           0
d  0.01  0.01 -0.28 -0.32  0.10 -0.18  0.32 -0.30  0.35 -0.51  ... -0.46  0.09  0.14 -0.47 -0.02  0.26 -0.11         5        6           1

[6 rows x 131 columns]
>>> df_hidden[list(range(128))]
    0     1     2     3     4     5     6     7     8     9     10   ...   117   118   119   120   121   122   123   124   125   126   127
K  0.10 -0.06 -0.06  0.21  0.07  0.04 -0.01 -0.08 -0.03 -0.05  0.16  ... -0.04 -0.10  0.12  0.15  0.10  0.16  0.12  0.03  0.06 -0.11  0.11
h -0.03  0.03  0.02  0.38  0.29  0.27 -0.02  0.05 -0.00 -0.12  0.05  ... -0.08 -0.06  0.19  0.17  0.43 -0.08  0.04  0.12  0.30 -0.11  0.37
a -0.06  0.14  0.15  0.60  0.02  0.16  0.18  0.26  0.02 -0.09 -0.05  ...  0.06 -0.05  0.29  0.09  0.49 -0.37  0.22  0.30  0.33  0.26  0.63
l -0.04  0.18  0.14  0.24 -0.18  0.02  0.20  0.00  0.35 -0.29  0.36  ... -0.37 -0.12 -0.06 -0.14 -0.03  0.27 -0.04  0.08 -0.02  0.46  0.00
i -0.11  0.12 -0.00  0.23  0.03 -0.19  0.21 -0.33  0.41 -0.33  0.04  ... -0.12 -0.10 -0.40  0.10 -0.47 -0.04  0.29 -0.17  0.08  0.14  0.24
d  0.01  0.01 -0.28 -0.32  0.10 -0.18  0.32 -0.30  0.35 -0.51  0.22  ...  0.03 -0.21 -0.33  0.07 -0.46  0.09  0.14 -0.47 -0.02  0.26 -0.11

[6 rows x 128 columns]
>>> pd.options.display.max_columns = 12
>>> df_hidden[list(range(128))]
    0     1     2     3     4     5    ...   122   123   124   125   126   127
K  0.10 -0.06 -0.06  0.21  0.07  0.04  ...  0.16  0.12  0.03  0.06 -0.11  0.11
h -0.03  0.03  0.02  0.38  0.29  0.27  ... -0.08  0.04  0.12  0.30 -0.11  0.37
a -0.06  0.14  0.15  0.60  0.02  0.16  ... -0.37  0.22  0.30  0.33  0.26  0.63
l -0.04  0.18  0.14  0.24 -0.18  0.02  ...  0.27 -0.04  0.08 -0.02  0.46  0.00
i -0.11  0.12 -0.00  0.23  0.03 -0.19  ... -0.04  0.29 -0.17  0.08  0.14  0.24
d  0.01  0.01 -0.28 -0.32  0.10 -0.18  ...  0.09  0.14 -0.47 -0.02  0.26 -0.11

[6 rows x 128 columns]
>>> pd.options.display.float_format = '{:.2f}'.format
>>> df_hidden_raw = pd.DataFrame(hidden_lists, index=list(text)).T
>>> df_hidden_raw
        K     h     a     l     i     d
0    0.10 -0.03 -0.06 -0.04 -0.11  0.01
1   -0.06  0.03  0.14  0.18  0.12  0.01
2   -0.06  0.02  0.15  0.14 -0.00 -0.28
3    0.21  0.38  0.60  0.24  0.23 -0.32
4    0.07  0.29  0.02 -0.18  0.03  0.10
..    ...   ...   ...   ...   ...   ...
123  0.12  0.04  0.22 -0.04  0.29  0.14
124  0.03  0.12  0.30  0.08 -0.17 -0.47
125  0.06  0.30  0.33 -0.02  0.08 -0.02
126 -0.11 -0.11  0.26  0.46  0.14  0.26
127  0.11  0.37  0.63  0.00  0.24 -0.11

[128 rows x 6 columns]
>>> df_hidden_raw = pd.DataFrame(hidden_lists, index=list(text))
>>> df_hidden_raw
    0     1     2     3     4     5    ...   122   123   124   125   126   127
K  0.10 -0.06 -0.06  0.21  0.07  0.04  ...  0.16  0.12  0.03  0.06 -0.11  0.11
h -0.03  0.03  0.02  0.38  0.29  0.27  ... -0.08  0.04  0.12  0.30 -0.11  0.37
a -0.06  0.14  0.15  0.60  0.02  0.16  ... -0.37  0.22  0.30  0.33  0.26  0.63
l -0.04  0.18  0.14  0.24 -0.18  0.02  ...  0.27 -0.04  0.08 -0.02  0.46  0.00
i -0.11  0.12 -0.00  0.23  0.03 -0.19  ... -0.04  0.29 -0.17  0.08  0.14  0.24
d  0.01  0.01 -0.28 -0.32  0.10 -0.18  ...  0.09  0.14 -0.47 -0.02  0.26 -0.11

[6 rows x 128 columns]
>>> pd.options.display.float_format = '{: .2f}'.format
>>> df_hidden_raw
    0     1     2     3     4     5    ...   122   123   124   125   126   127
K  0.10 -0.06 -0.06  0.21  0.07  0.04  ...  0.16  0.12  0.03  0.06 -0.11  0.11
h -0.03  0.03  0.02  0.38  0.29  0.27  ... -0.08  0.04  0.12  0.30 -0.11  0.37
a -0.06  0.14  0.15  0.60  0.02  0.16  ... -0.37  0.22  0.30  0.33  0.26  0.63
l -0.04  0.18  0.14  0.24 -0.18  0.02  ...  0.27 -0.04  0.08 -0.02  0.46  0.00
i -0.11  0.12 -0.00  0.23  0.03 -0.19  ... -0.04  0.29 -0.17  0.08  0.14  0.24
d  0.01  0.01 -0.28 -0.32  0.10 -0.18  ...  0.09  0.14 -0.47 -0.02  0.26 -0.11

[6 rows x 128 columns]
>>> pd.options.display.float_format = '{:0.2f}'.format
>>> df_hidden_raw
    0     1     2     3     4     5    ...   122   123   124   125   126   127
K  0.10 -0.06 -0.06  0.21  0.07  0.04  ...  0.16  0.12  0.03  0.06 -0.11  0.11
h -0.03  0.03  0.02  0.38  0.29  0.27  ... -0.08  0.04  0.12  0.30 -0.11  0.37
a -0.06  0.14  0.15  0.60  0.02  0.16  ... -0.37  0.22  0.30  0.33  0.26  0.63
l -0.04  0.18  0.14  0.24 -0.18  0.02  ...  0.27 -0.04  0.08 -0.02  0.46  0.00
i -0.11  0.12 -0.00  0.23  0.03 -0.19  ... -0.04  0.29 -0.17  0.08  0.14  0.24
d  0.01  0.01 -0.28 -0.32  0.10 -0.18  ...  0.09  0.14 -0.47 -0.02  0.26 -0.11

[6 rows x 128 columns]
>>> df_hidden_raw
    0     1     2     3     4     5    ...   122   123   124   125   126   127
K  0.10 -0.06 -0.06  0.21  0.07  0.04  ...  0.16  0.12  0.03  0.06 -0.11  0.11
h -0.03  0.03  0.02  0.38  0.29  0.27  ... -0.08  0.04  0.12  0.30 -0.11  0.37
a -0.06  0.14  0.15  0.60  0.02  0.16  ... -0.37  0.22  0.30  0.33  0.26  0.63
l -0.04  0.18  0.14  0.24 -0.18  0.02  ...  0.27 -0.04  0.08 -0.02  0.46  0.00
i -0.11  0.12 -0.00  0.23  0.03 -0.19  ... -0.04  0.29 -0.17  0.08  0.14  0.24
d  0.01  0.01 -0.28 -0.32  0.10 -0.18  ...  0.09  0.14 -0.47 -0.02  0.26 -0.11

[6 rows x 128 columns]
>>> df_hidden_raw.corr(df_hidden['position'])
>>> df_hidden_raw.corr?
>>> df_hidden_raw.corrwith(df_hidden['position'])
0     -0.50
1      0.39
2     -0.39
3     -0.61
4     -0.28
       ... 
123    0.27
124   -0.71
125   -0.48
126    0.66
127   -0.42
Length: 128, dtype: float64
>>> df_hidden_raw.corrwith(range(len(text)))
>>> df_hidden_raw.corrwith(pd.Series(range(len(text))))
0     nan
1     nan
2     nan
3     nan
4     nan
       ..
123   nan
124   nan
125   nan
126   nan
127   nan
Length: 128, dtype: float64
>>> df_hidden_raw.corrwith(pd.Series(range(len(text)), index=df_hidden_raw.index))
0     -0.50
1      0.39
2     -0.39
3     -0.61
4     -0.28
       ... 
123    0.27
124   -0.71
125   -0.48
126    0.66
127   -0.42
Length: 128, dtype: float64
>>> position = pd.Series(range(len(text)), index=df_hidden_raw.index)
>>> position
K    0
h    1
a    2
l    3
i    4
d    5
dtype: int64
>>> pd.DataFrame(position)
   0
K  0
h  1
a  2
l  3
i  4
d  5
>>> pd.DataFrame(position).T
   K  h  a  l  i  d
0  0  1  2  3  4  5
>>> df_hidden_raw.corrwith(position).argmax()
18
>>> df_hidden_raw.corrwith(position).sort_values()
11   -0.99
84   -0.98
21   -0.97
9    -0.95
59   -0.94
      ... 
12    0.91
40    0.91
6     0.94
70    0.96
18    0.96
Length: 128, dtype: float64
>>> df_hidden_raw.corrwith(len(text) - position).sort_values()
18   -0.96
70   -0.96
6    -0.94
40   -0.91
12   -0.91
      ... 
59    0.94
9     0.95
21    0.97
84    0.98
11    0.99
Length: 128, dtype: float64
>>> hist -o -p -f classify_name_nationality_position_correlation.hist.md
