>>> from char_rnn_from_scratch_refactored import *
>>> df = load_dataset()
>>> filename = 'char_rnn_from_scratch_refactored-1_311-17min_28sec'
>>> df
         name category
0      Khoury   Arabic
1       Nahas   Arabic
2       Daher   Arabic
3      Gerges   Arabic
4      Nazari   Arabic
...       ...      ...
20069    Zhai  Chinese
20070   Zhang  Chinese
20071     Zhi  Chinese
20072   Zhuan  Chinese
20073    Zhui  Chinese

[20074 rows x 2 columns]
>>> prefix = df['name'].str[:3]
>>> prefix
0        Kho
1        Nah
2        Dah
3        Ger
4        Naz
        ... 
20069    Zha
20070    Zha
20071    Zhi
20072    Zhu
20073    Zhu
Name: name, Length: 20074, dtype: object
>>> prefix_nationality = zip(prefix, df['category'])
>>> from collections import Counter
>>> Counter(prefix_nationality.values)
>>> prefix_nationality = list(zip(prefix, df['category']))
>>> Counter(prefix_nationality)
Counter({('Kho', 'Arabic'): 42,
         ('Nah', 'Arabic'): 24,
         ('Dah', 'Arabic'): 22,
         ('Ger', 'Arabic'): 24,
         ('Naz', 'Arabic'): 16,
         ('Maa', 'Arabic'): 14,
         ('Nai', 'Arabic'): 22,
         ('Gui', 'Arabic'): 21,
         ('Bab', 'Arabic'): 16,
         ('Sab', 'Arabic'): 27,
         ('Att', 'Arabic'): 18,
         ('Tah', 'Arabic'): 28,
         ('Had', 'Arabic'): 46,
         ('Asw', 'Arabic'): 15,
         ('Naj', 'Arabic'): 22,
         ('Dag', 'Arabic'): 19,
         ('Mal', 'Arabic'): 35,
         ('Isa', 'Arabic'): 17,
         ('Asg', 'Arabic'): 21,
         ('Nad', 'Arabic'): 27,
         ('Gab', 'Arabic'): 21,
         ('Abb', 'Arabic'): 18,
         ('Zog', 'Arabic'): 21,
         ('Sro', 'Arabic'): 18,
         ('Bah', 'Arabic'): 15,
         ('Mus', 'Arabic'): 26,
         ('Han', 'Arabic'): 37,
         ('Tum', 'Arabic'): 23,
         ('Sal', 'Arabic'): 42,
         ('Sha', 'Arabic'): 108,
         ('Ama', 'Arabic'): 18,
         ('Ati', 'Arabic'): 23,
         ('Sai', 'Arabic'): 21,
         ('Sle', 'Arabic'): 20,
         ('Sei', 'Arabic'): 19,
         ('Har', 'Arabic'): 21,
         ('Ask', 'Arabic'): 14,
         ('Ant', 'Arabic'): 40,
         ('Awa', 'Arabic'): 24,
         ('Haj', 'Arabic'): 15,
         ('Kal', 'Arabic'): 21,
         ('Baz', 'Arabic'): 38,
         ('Mas', 'Arabic'): 12,
         ('Gha', 'Arabic'): 31,
         ('Sar', 'Arabic'): 43,
         ('Nas', 'Arabic'): 32,
         ('Was', 'Arabic'): 21,
         ('Kan', 'Arabic'): 16,
         ('Bou', 'Arabic'): 32,
         ('Mog', 'Arabic'): 15,
         ('Cha', 'Arabic'): 25,
         ('Ass', 'Arabic'): 20,
         ('Qur', 'Arabic'): 33,
         ('Mif', 'Arabic'): 25,
         ('Tan', 'Arabic'): 14,
         ('Rah', 'Arabic'): 20,
         ('Alm', 'Arabic'): 15,
         ('Bas', 'Arabic'): 16,
         ('Bat', 'Arabic'): 8,
         ('Dee', 'Arabic'): 18,
         ('Tou', 'Arabic'): 13,
         ('Asf', 'Arabic'): 11,
         ('Ari', 'Arabic'): 22,
         ('Kou', 'Arabic'): 44,
         ('Tom', 'Arabic'): 18,
         ('Hal', 'Arabic'): 13,
         ('Fak', 'Arabic'): 28,
         ('Man', 'Arabic'): 19,
         ('Say', 'Arabic'): 22,
         ('Mor', 'Arabic'): 22,
         ('Gan', 'Arabic'): 37,
         ('Hak', 'Arabic'): 17,
         ('Mar', 'Arabic'): 16,
         ('Bis', 'Arabic'): 21,
         ('Ba', 'Arabic'): 12,
         ('Bit', 'Arabic'): 16,
         ('Hai', 'Arabic'): 13,
         ('Bot', 'Arabic'): 20,
         ('Ess', 'Arabic'): 13,
         ('Kat', 'Arabic'): 16,
         ('Kas', 'Arabic'): 37,
         ('Aba', 'Arabic'): 17,
         ('Iss', 'Arabic'): 14,
         ('Sam', 'Arabic'): 17,
         ('Saf', 'Arabic'): 15,
         ('Mik', 'Arabic'): 13,
         ('Tot', 'Arabic'): 19,
         ('Ada', 'Irish'): 1,
         ('Ahe', 'Irish'): 1,
         ('Aod', 'Irish'): 2,
         ('Aon', 'Irish'): 2,
         ('Bhr', 'Irish'): 1,
         ('Bra', 'Irish'): 6,
         ('Bri', 'Irish'): 1,
         ('Cal', 'Irish'): 1,
         ('Cao', 'Irish'): 1,
         ('Car', 'Irish'): 1,
         ('Cas', 'Irish'): 2,
         ('Cat', 'Irish'): 3,
         ('Cea', 'Irish'): 3,
         ('Cen', 'Irish'): 1,
         ('Cia', 'Irish'): 1,
         ('Cla', 'Irish'): 1,
         ('Cle', 'Irish'): 2,
         ('Cna', 'Irish'): 1,
         ('Cog', 'Irish'): 1,
         ('Coi', 'Irish'): 1,
         ('Col', 'Irish'): 2,
         ('Con', 'Irish'): 5,
         ('Cor', 'Irish'): 2,
         ('Cui', 'Irish'): 1,
         ('Cur', 'Irish'): 1,
         ('Dub', 'Irish'): 3,
         ('Dal', 'Irish'): 2,
         ('Dam', 'Irish'): 2,
         ('Del', 'Irish'): 1,
         ('Des', 'Irish'): 1,
         ('Dev', 'Irish'): 1,
         ('Dia', 'Irish'): 1,
         ('Doh', 'Irish'): 1,
         ('Dom', 'Irish'): 1,
         ('Don', 'Irish'): 5,
         ('Doy', 'Irish'): 1,
         ('Dun', 'Irish'): 1,
         ('Eog', 'Irish'): 1,
         ('Eoi', 'Irish'): 2,
         ('Fao', 'Irish'): 1,
         ('Far', 'Irish'): 1,
         ('Fea', 'Irish'): 1,
         ('Fer', 'Irish'): 1,
         ('Fin', 'Irish'): 2,
         ('Fio', 'Irish'): 1,
         ('Fla', 'Irish'): 2,
         ('Fly', 'Irish'): 1,
         ('Gal', 'Irish'): 1,
         ('Ger', 'Irish'): 1,
         ('Gio', 'Irish'): 1,
         ('Gor', 'Irish'): 1,
         ('Hay', 'Irish'): 1,
         ('Ivo', 'Irish'): 1,
         ('Joh', 'Irish'): 1,
         ('Kav', 'Irish'): 1,
         ('Kee', 'Irish'): 1,
         ('Kel', 'Irish'): 1,
         ('Ken', 'Irish'): 1,
         ('Len', 'Irish'): 1,
         ('Log', 'Irish'): 1,
         ('Mac', 'Irish'): 7,
         ('Mad', 'Irish'): 2,
         ('Mag', 'Irish'): 1,
         ('Mah', 'Irish'): 1,
         ('Mai', 'Irish'): 1,
         ('Mal', 'Irish'): 1,
         ('Man', 'Irish'): 1,
         ('Mao', 'Irish'): 1,
         ('Mat', 'Irish'): 1,
         ('Mau', 'Irish'): 1,
         ('Mcg', 'Irish'): 1,
         ('Mck', 'Irish'): 1,
         ('Mcl', 'Irish'): 1,
         ('Mcm', 'Irish'): 1,
         ('Mcn', 'Irish'): 2,
         ('Mea', 'Irish'): 1,
         ('Mic', 'Irish'): 1,
         ('Mil', 'Irish'): 1,
         ('Moc', 'Irish'): 1,
         ('Moh', 'Irish'): 1,
         ('Mol', 'Irish'): 1,
         ('Mon', 'Irish'): 1,
         ('Moo', 'Irish'): 1,
         ('Mui', 'Irish'): 1,
         ('Mul', 'Irish'): 2,
         ('Mur', 'Irish'): 2,
         ('Nam', 'Irish'): 1,
         ('Nao', 'Irish'): 2,
         ('Nei', 'Irish'): 1,
         ('Nev', 'Irish'): 2,
         ('Nia', 'Irish'): 2,
         ('Nol', 'Irish'): 1,
         ('Nua', 'Irish'): 1,
         ("O'B", 'Irish'): 7,
         ("O'D", 'Irish'): 7,
         ("O'H", 'Irish'): 7,
         ("O'K", 'Irish'): 5,
         ("O'M", 'Irish'): 5,
         ("O'N", 'Irish'): 3,
         ("O'C", 'Irish'): 3,
         ("O'G", 'Irish'): 2,
         ("O'L", 'Irish'): 2,
         ("O'R", 'Irish'): 3,
         ("O'S", 'Irish'): 2,
         ("O'T", 'Irish'): 1,
         ('Pat', 'Irish'): 1,
         ('Pea', 'Irish'): 1,
         ('Pha', 'Irish'): 1,
         ('Pow', 'Irish'): 1,
         ('Qui', 'Irish'): 3,
         ('Rag', 'Irish'): 1,
         ('Rea', 'Irish'): 1,
         ('Reg', 'Irish'): 1,
         ('Rei', 'Irish'): 1,
         ('Rey', 'Irish'): 1,
         ('Rhy', 'Irish'): 1,
         ('Ria', 'Irish'): 4,
         ('Rin', 'Irish'): 1,
         ('Roa', 'Irish'): 1,
         ('Rod', 'Irish'): 1,
         ('Ror', 'Irish'): 1,
         ('Rua', 'Irish'): 4,
         ('Sam', 'Irish'): 1,
         ('Sco', 'Irish'): 1,
         ('Sea', 'Irish'): 1,
         ('Sec', 'Irish'): 1,
         ('Sei', 'Irish'): 1,
         ('Sha', 'Irish'): 1,
         ('She', 'Irish'): 1,
         ('Sim', 'Irish'): 1,
         ('Sio', 'Irish'): 1,
         ('Slo', 'Irish'): 1,
         ('Slu', 'Irish'): 1,
         ('Sua', 'Irish'): 1,
         ('Sul', 'Irish'): 1,
         ('Tad', 'Irish'): 2,
         ('Tai', 'Irish'): 1,
         ('Tea', 'Irish'): 2,
         ('Tig', 'Irish'): 1,
         ('Tra', 'Irish'): 1,
         ('Tre', 'Irish'): 1,
         ('Wha', 'Irish'): 1,
         ('Whe', 'Irish'): 1,
         ('Wil', 'Irish'): 1,
         ('Aba', 'Spanish'): 6,
         ('Abe', 'Spanish'): 3,
         ('Abr', 'Spanish'): 1,
         ('Aco', 'Spanish'): 1,
         ('Agr', 'Spanish'): 1,
         ('Aiz', 'Spanish'): 1,
         ('Ala', 'Spanish'): 1,
         ('Alb', 'Spanish'): 2,
         ('Ald', 'Spanish'): 1,
         ('Alf', 'Spanish'): 1,
         ('Alv', 'Spanish'): 3,
         ('Ama', 'Spanish'): 1,
         ('And', 'Spanish'): 1,
         ('Ant', 'Spanish'): 1,
         ('Aqu', 'Spanish'): 2,
         ('Ara', 'Spanish'): 3,
         ('Arc', 'Spanish'): 1,
         ('Are', 'Spanish'): 2,
         ('Ari', 'Spanish'): 1,
         ('Arm', 'Spanish'): 1,
         ('Arr', 'Spanish'): 2,
         ('Asi', 'Spanish'): 1,
         ('Ast', 'Spanish'): 1,
         ('Ava', 'Spanish'): 1,
         ('Aza', 'Spanish'): 1,
         ('Ban', 'Spanish'): 1,
         ('Bar', 'Spanish'): 1,
         ('Bas', 'Spanish'): 1,
         ('Bau', 'Spanish'): 1,
         ('Bel', 'Spanish'): 2,
         ('Ben', 'Spanish'): 2,
         ('Ber', 'Spanish'): 1,
         ('Bla', 'Spanish'): 2,
         ('Bol', 'Spanish'): 1,
         ('Bon', 'Spanish'): 1,
         ('Bos', 'Spanish'): 1,
         ('Bus', 'Spanish'): 3,
         ('Cab', 'Spanish'): 2,
         ('Cam', 'Spanish'): 2,
         ('Cap', 'Spanish'): 1,
         ('Car', 'Spanish'): 2,
         ('Cas', 'Spanish'): 6,
         ('Cha', 'Spanish'): 2,
         ('Col', 'Spanish'): 1,
         ('Cos', 'Spanish'): 1,
         ('Cre', 'Spanish'): 1,
         ('Cru', 'Spanish'): 1,
         ('Cue', 'Spanish'): 2,
         ("D'c", 'Spanish'): 2,
         ('De ', 'Spanish'): 4,
         ('Del', 'Spanish'): 3,
         ('Dia', 'Spanish'): 1,
         ('Dom', 'Spanish'): 1,
         ('Dua', 'Spanish'): 1,
         ('Dur', 'Spanish'): 1,
         ('Ech', 'Spanish'): 2,
         ('Eli', 'Spanish'): 1,
         ('Esc', 'Spanish'): 3,
         ('Esp', 'Spanish'): 5,
         ('Est', 'Spanish'): 1,
         ('Etx', 'Spanish'): 2,
         ('Fel', 'Spanish'): 1,
         ('Fer', 'Spanish'): 2,
         ('Fie', 'Spanish'): 1,
         ('Flo', 'Spanish'): 1,
         ('Fon', 'Spanish'): 1,
         ('Fra', 'Spanish'): 1,
         ('Fue', 'Spanish'): 1,
         ('Gal', 'Spanish'): 2,
         ('Gar', 'Spanish'): 3,
         ('Gas', 'Spanish'): 1,
         ('Geb', 'Spanish'): 1,
         ('Gom', 'Spanish'): 1,
         ('Gon', 'Spanish'): 2,
         ('Gre', 'Spanish'): 1,
         ('Gua', 'Spanish'): 1,
         ('Gue', 'Spanish'): 2,
         ('Gut', 'Spanish'): 2,
         ('Her', 'Spanish'): 3,
         ('Hie', 'Spanish'): 1,
         ('Hol', 'Spanish'): 1,
         ('Hue', 'Spanish'): 1,
         ('Iba', 'Spanish'): 2,
         ('Ini', 'Spanish'): 1,
         ('Itu', 'Spanish'): 1,
         ('Jas', 'Spanish'): 2,
         ('Jim', 'Spanish'): 1,
         ('Jor', 'Spanish'): 1,
         ('Jua', 'Spanish'): 1,
         ('Lob', 'Spanish'): 1,
         ('Lop', 'Spanish'): 1,
         ('Los', 'Spanish'): 1,
         ('Loy', 'Spanish'): 1,
         ('Mac', 'Spanish'): 2,
         ('Mar', 'Spanish'): 8,
         ('Mas', 'Spanish'): 1,
         ('Mat', 'Spanish'): 2,
         ('Med', 'Spanish'): 1,
         ('Mel', 'Spanish'): 1,
         ('Men', 'Spanish'): 3,
         ('Mer', 'Spanish'): 1,
         ('Mic', 'Spanish'): 1,
         ('Min', 'Spanish'): 1,
         ('Mol', 'Spanish'): 2,
         ('Mon', 'Spanish'): 1,
         ('Mor', 'Spanish'): 3,
         ('Nar', 'Spanish'): 1,
         ('Nie', 'Spanish'): 1,
         ('Nog', 'Spanish'): 1,
         ('Nun', 'Spanish'): 1,
         ('Oba', 'Spanish'): 1,
         ('Och', 'Spanish'): 1,
         ('Oje', 'Spanish'): 1,
         ('Ola', 'Spanish'): 1,
         ('Ole', 'Spanish'): 1,
         ('Olg', 'Spanish'): 1,
         ('Oli', 'Spanish'): 1,
         ('Olm', 'Spanish'): 1,
         ('Oqu', 'Spanish'): 1,
         ('Ore', 'Spanish'): 1,
         ('Ori', 'Spanish'): 1,
         ('Ort', 'Spanish'): 2,
         ('Pal', 'Spanish'): 1,
         ('Par', 'Spanish'): 1,
         ('Pav', 'Spanish'): 1,
         ('Pel', 'Spanish'): 1,
         ('Pen', 'Spanish'): 1,
         ('Per', 'Spanish'): 2,
         ('Pet', 'Spanish'): 1,
         ('Pic', 'Spanish'): 1,
         ('Por', 'Spanish'): 2,
         ('Pri', 'Spanish'): 1,
         ('Pue', 'Spanish'): 1,
         ('Pug', 'Spanish'): 1,
         ('Pui', 'Spanish'): 1,
         ('Qui', 'Spanish'): 3,
         ('Ram', 'Spanish'): 2,
         ('Ran', 'Spanish'): 1,
         ('Ren', 'Spanish'): 1,
         ('Rey', 'Spanish'): 2,
         ('Rio', 'Spanish'): 1,
         ('Riv', 'Spanish'): 2,
         ('Rob', 'Spanish'): 2,
         ('Roc', 'Spanish'): 1,
         ('Rod', 'Spanish'): 2,
         ('Roi', 'Spanish'): 1,
         ('Roj', 'Spanish'): 2,
         ('Rol', 'Spanish'): 1,
         ('Rom', 'Spanish'): 3,
         ('Ros', 'Spanish'): 2,
         ('Rub', 'Spanish'): 1,
         ('Rui', 'Spanish'): 1,
         ('Sal', 'Spanish'): 5,
         ('San', 'Spanish'): 7,
         ('Sas', 'Spanish'): 1,
         ('Sep', 'Spanish'): 1,
         ('Sie', 'Spanish'): 1,
         ('Sil', 'Spanish'): 1,
         ('Sol', 'Spanish'): 3,
         ('Sot', 'Spanish'): 1,
         ('Sua', 'Spanish'): 1,
         ('Sue', 'Spanish'): 1,
         ('Tap', 'Spanish'): 1,
         ('Ter', 'Spanish'): 1,
         ('Tom', 'Spanish'): 1,
         ('Tor', 'Spanish'): 1,
         ('Tos', 'Spanish'): 3,
         ('Tra', 'Spanish'): 1,
         ('Tru', 'Spanish'): 1,
         ('Ubi', 'Spanish'): 1,
         ('Urb', 'Spanish'): 1,
         ('Ure', 'Spanish'): 1,
         ('Val', 'Spanish'): 2,
         ('Var', 'Spanish'): 2,
         ('Vas', 'Spanish'): 1,
         ('Vaz', 'Spanish'): 1,
         ('Veg', 'Spanish'): 1,
         ('Vel', 'Spanish'): 3,
         ('Ven', 'Spanish'): 1,
         ('Vic', 'Spanish'): 1,
         ('Vil', 'Spanish'): 5,
         ('Vio', 'Spanish'): 1,
         ('Vit', 'Spanish'): 1,
         ('Viv', 'Spanish'): 2,
         ('Yba', 'Spanish'): 1,
         ('Zab', 'Spanish'): 1,
         ('Zam', 'Spanish'): 2,
         ('Zap', 'Spanish'): 1,
         ('Zav', 'Spanish'): 1,
         ('Zub', 'Spanish'): 1,
         ('Zun', 'Spanish'): 1,
         ('Abe', 'French'): 1,
         ('Abr', 'French'): 1,
         ('Ada', 'French'): 1,
         ('Alb', 'French'): 1,
         ('All', 'French'): 1,
         ('Arc', 'French'): 1,
         ('Arm', 'French'): 1,
         ('Art', 'French'): 1,
         ('Aug', 'French'): 1,
         ('Bab', 'French'): 1,
         ('Bau', 'French'): 1,
         ('Bea', 'French'): 3,
         ('Bel', 'French'): 4,
         ('Ber', 'French'): 4,
         ('Bis', 'French'): 2,
         ('Bla', 'French'): 4,
         ('Bon', 'French'): 7,
         ('Bor', 'French'): 2,
         ('Bou', 'French'): 2,
         ('Bri', 'French'): 1,
         ('Bro', 'French'): 1,
         ('Bur', 'French'): 1,
         ('Car', 'French'): 1,
         ('Cav', 'French'): 1,
         ('Cha', 'French'): 5,
         ('Che', 'French'): 2,
         ('Clo', 'French'): 1,
         ('Col', 'French'): 1,
         ('Com', 'French'): 1,
         ('Cor', 'French'): 1,
         ('Cot', 'French'): 1,
         ('Cou', 'French'): 4,
         ('Dan', 'French'): 1,
         ("D'a", 'French'): 1,
         ('Dav', 'French'): 2,
         ('Def', 'French'): 1,
         ('Deg', 'French'): 1,
         ('Del', 'French'): 1,
         ('De ', 'French'): 2,
         ('Den', 'French'): 4,
         ('Des', 'French'): 5,
         ('Dub', 'French'): 1,
         ('Duc', 'French'): 1,
         ('Duf', 'French'): 2,
         ('Dug', 'French'): 1,
         ('Dup', 'French'): 2,
         ('Dur', 'French'): 2,
         ('Duv', 'French'): 1,
         ('Emi', 'French'): 1,
         ('Eus', 'French'): 1,
         ('Fab', 'French'): 3,
         ('Fau', 'French'): 3,
         ('Fav', 'French'): 3,
         ('Fay', 'French'): 1,
         ('Fel', 'French'): 1,
         ('Fir', 'French'): 1,
         ('Fon', 'French'): 1,
         ('For', 'French'): 3,
         ('Fos', 'French'): 1,
         ('Fou', 'French'): 1,
         ('Gag', 'French'): 4,
         ('Gar', 'French'): 2,
         ('Ger', 'French'): 2,
         ('Gil', 'French'): 1,
         ('Gir', 'French'): 2,
         ('Gla', 'French'): 1,
         ('Gos', 'French'): 2,
         ('Gra', 'French'): 1,
         ('Gue', 'French'): 1,
         ('Gui', 'French'): 1,
         ('Har', 'French'): 2,
         ('Heb', 'French'): 1,
         ('Her', 'French'): 2,
         ('Jac', 'French'): 1,
         ('Jan', 'French'): 1,
         ('Jor', 'French'): 1,
         ('Jou', 'French'): 1,
         ('Lab', 'French'): 1,
         ('Lac', 'French'): 2,
         ('Lam', 'French'): 2,
         ('Lan', 'French'): 3,
         ('Lap', 'French'): 1,
         ('Lar', 'French'): 1,
         ('Lau', 'French'): 1,
         ('Lav', 'French'): 2,
         ('Lea', 'French'): 1,
         ('Leb', 'French'): 2,
         ('Lec', 'French'): 3,
         ('Lef', 'French'): 3,
         ('Leg', 'French'): 1,
         ('Lem', 'French'): 2,
         ('Leo', 'French'): 1,
         ('Ler', 'French'): 1,
         ('Les', 'French'): 2,
         ('Lev', 'French'): 2,
         ('Lin', 'French'): 1,
         ('Lyo', 'French'): 2,
         ('Mac', 'French'): 1,
         ('Mar', 'French'): 6,
         ('Mas', 'French'): 2,
         ('Mat', 'French'): 1,
         ('Mer', 'French'): 2,
         ('Mic', 'French'): 2,
         ('Mon', 'French'): 3,
         ('Mor', 'French'): 1,
         ('Mou', 'French'): 1,
         ('Mul', 'French'): 1,
         ('Noe', 'French'): 1,
         ('Oli', 'French'): 2,
         ('Pag', 'French'): 2,
         ('Pal', 'French'): 1,
         ('Pan', 'French'): 1,
         ('Pap', 'French'): 1,
         ('Paq', 'French'): 2,
         ('Par', 'French'): 3,
         ('Pas', 'French'): 1,
         ('Pat', 'French'): 2,
         ('Pau', 'French'): 1,
         ('Pel', 'French'): 1,
         ('Per', 'French'): 3,
         ('Pet', 'French'): 2,
         ('Pie', 'French'): 1,
         ('Pla', 'French'): 1,
         ('Plo', 'French'): 1,
         ('Poi', 'French'): 2,
         ('Por', 'French'): 1,
         ('Pou', 'French'): 1,
         ('Pro', 'French'): 1,
         ('Ren', 'French'): 1,
         ('Rey', 'French'): 2,
         ('Ric', 'French'): 2,
         ('Rob', 'French'): 1,
         ('Roc', 'French'): 1,
         ('Rom', 'French'): 2,
         ('Ros', 'French'): 1,
         ('Rou', 'French'): 2,
         ('Roy', 'French'): 2,
         ('Sal', 'French'): 2,
         ('Sam', 'French'): 2,
         ('Sar', 'French'): 4,
         ('Sau', 'French'): 6,
         ('Sav', 'French'): 1,
         ('Seg', 'French'): 1,
         ('Ser', 'French'): 1,
         ('Sev', 'French'): 1,
         ('Sim', 'French'): 1,
         ('Sol', 'French'): 1,
         ('Sou', 'French'): 1,
         ('St ', 'French'): 2,
         ('Tai', 'French'): 1,
         ('Tas', 'French'): 1,
         ('Tha', 'French'): 1,
         ('Thi', 'French'): 1,
         ('Tho', 'French'): 1,
         ('Tob', 'French'): 1,
         ('Tol', 'French'): 1,
         ('Tra', 'French'): 5,
         ('Tre', 'French'): 2,
         ('Vic', 'French'): 2,
         ('Vil', 'French'): 1,
         ('Vin', 'French'): 1,
         ('Vip', 'French'): 1,
         ('Voc', 'French'): 1,
         ('You', 'French'): 1,
         ('Abb', 'German'): 1,
         ('Abe', 'German'): 2,
         ('Abt', 'German'): 1,
         ('Ach', 'German'): 2,
         ('Ack', 'German'): 2,
         ('Ada', 'German'): 1,
         ('Ade', 'German'): 1,
         ('Adl', 'German'): 2,
         ('Aes', 'German'): 1,
         ('Alb', 'German'): 2,
         ('Ale', 'German'): 2,
         ('Alt', 'German'): 1,
         ('Ams', 'German'): 1,
         ('And', 'German'): 1,
         ('Arm', 'German'): 2,
         ('Art', 'German'): 1,
         ('Aue', 'German'): 2,
         ('Aug', 'German'): 1,
         ('Aus', 'German'): 1,
         ('Aut', 'German'): 2,
         ('Baa', 'German'): 1,
         ('Bac', 'German'): 3,
         ('Bad', 'German'): 1,
         ('Bah', 'German'): 1,
         ('Bam', 'German'): 1,
         ('Bau', 'German'): 8,
         ('Bay', 'German'): 1,
         ('Bec', 'German'): 5,
         ('Beh', 'German'): 2,
         ('Bei', 'German'): 1,
         ('Bel', 'German'): 1,
         ('Ben', 'German'): 1,
         ('Ber', 'German'): 5,
         ('Bes', 'German'): 1,
         ('Beu', 'German'): 1,
         ('Bey', 'German'): 2,
         ('Bie', 'German'): 2,
         ('Bis', 'German'): 1,
         ('Bla', 'German'): 1,
         ('Ble', 'German'): 2,
         ('Blu', 'German'): 2,
         ('Boc', 'German'): 1,
         ('Boe', 'German'): 3,
         ('Boh', 'German'): 5,
         ('Bor', 'German'): 1,
         ('Bos', 'German'): 2,
         ('Bot', 'German'): 1,
         ('Bra', 'German'): 7,
         ('Bre', 'German'): 4,
         ('Bri', 'German'): 1,
         ('Bro', 'German'): 3,
         ('Bru', 'German'): 3,
         ('Buc', 'German'): 2,
         ('Buh', 'German'): 1,
         ('Bum', 'German'): 1,
         ('Bur', 'German'): 1,
         ('Bus', 'German'): 1,
         ('Car', 'German'): 1,
         ('Che', 'German'): 1,
         ('Cli', 'German'): 1,
         ('Dah', 'German'): 1,
         ('Den', 'German'): 1,
         ('Der', 'German'): 1,
         ('Die', 'German'): 3,
         ('Dir', 'German'): 1,
         ('Dit', 'German'): 1,
         ('Doh', 'German'): 1,
         ('Dre', 'German'): 5,
         ('Due', 'German'): 1,
         ('Dun', 'German'): 2,
         ('Dur', 'German'): 1,
         ('Ebe', 'German'): 1,
         ('Ebn', 'German'): 2,
         ('Eck', 'German'): 1,
         ('Egg', 'German'): 1,
         ('Eic', 'German'): 1,
         ('Eil', 'German'): 1,
         ('Eng', 'German'): 1,
         ('Enn', 'German'): 1,
         ('Ess', 'German'): 2,
         ('Eve', 'German'): 1,
         ('Fab', 'German'): 1,
         ('Fae', 'German'): 1,
         ('Fal', 'German'): 2,
         ('Far', 'German'): 1,
         ('Fas', 'German'): 1,
         ('Fau', 'German'): 1,
         ('Fei', 'German'): 1,
         ('Fel', 'German'): 2,
         ('Fen', 'German'): 1,
         ('Fer', 'German'): 1,
         ('Fie', 'German'): 1,
         ('Fis', 'German'): 1,
         ('Fla', 'German'): 1,
         ('Fle', 'German'): 1,
         ('Foe', 'German'): 1,
         ('For', 'German'): 2,
         ('Fot', 'German'): 1,
         ('Fra', 'German'): 2,
         ('Fre', 'German'): 4,
         ('Fri', 'German'): 2,
         ('Fro', 'German'): 2,
         ('Fuc', 'German'): 1,
         ('Fuh', 'German'): 1,
         ('Fur', 'German'): 1,
         ('Fux', 'German'): 1,
         ('Gab', 'German'): 1,
         ('Gae', 'German'): 1,
         ('Gar', 'German'): 4,
         ('Gas', 'German'): 1,
         ('Geh', 'German'): 2,
         ('Gei', 'German'): 5,
         ('Gen', 'German'): 1,
         ('Ger', 'German'): 7,
         ('Gie', 'German'): 2,
         ('Glo', 'German'): 1,
         ('Goe', 'German'): 1,
         ('Gol', 'German'): 1,
         ('Gor', 'German'): 1,
         ('Got', 'German'): 4,
         ('Gra', 'German'): 1,
         ('Gre', 'German'): 1,
         ('Gro', 'German'): 11,
         ('Gru', 'German'): 1,
         ('Gun', 'German'): 2,
         ('Gut', 'German'): 1,
         ('Gwe', 'German'): 1,
         ('Haa', 'German'): 2,
         ('Hab', 'German'): 3,
         ('Haf', 'German'): 1,
         ('Hah', 'German'): 1,
         ('Hal', 'German'): 2,
         ('Har', 'German'): 2,
         ('Has', 'German'): 4,
         ('Hau', 'German'): 3,
         ('Hav', 'German'): 1,
         ('Hei', 'German'): 4,
         ('Hel', 'German'): 1,
         ('Hep', 'German'): 1,
         ('Her', 'German'): 5,
         ('Hil', 'German'): 1,
         ('Hin', 'German'): 2,
         ('Hir', 'German'): 1,
         ('Hoc', 'German'): 2,
         ('Hoe', 'German'): 1,
         ('Hof', 'German'): 6,
         ('Hol', 'German'): 6,
         ('Hoo', 'German'): 1,
         ('Hor', 'German'): 3,
         ('Hou', 'German'): 1,
         ('Hub', 'German'): 2,
         ('Huf', 'German'): 3,
         ('Hum', 'German'): 2,
         ('Hut', 'German'): 1,
         ('Ing', 'German'): 1,
         ('Jae', 'German'): 1,
         ('Jag', 'German'): 2,
         ('Jan', 'German'): 3,
         ('Jol', 'German'): 1,
         ('Jor', 'German'): 1,
         ('Jun', 'German'): 3,
         ('Kah', 'German'): 1,
         ('Kai', 'German'): 1,
         ('Kal', 'German'): 2,
         ('Kap', 'German'): 1,
         ('Kar', 'German'): 1,
         ('Kas', 'German'): 3,
         ('Kat', 'German'): 1,
         ('Kau', 'German'): 5,
         ('Kei', 'German'): 1,
         ('Kel', 'German'): 1,
         ('Kem', 'German'): 1,
         ('Ker', 'German'): 4,
         ('Kie', 'German'): 2,
         ('Kir', 'German'): 1,
         ('Kis', 'German'): 2,
         ('Kle', 'German'): 2,
         ('Klo', 'German'): 1,
         ('Kne', 'German'): 4,
         ('Kno', 'German'): 3,
         ('Koc', 'German'): 2,
         ('Koe', 'German'): 2,
         ('Koh', 'German'): 4,
         ('Kol', 'German'): 1,
         ('Kon', 'German'): 2,
         ('Kop', 'German'): 1,
         ('Kra', 'German'): 9,
         ('Kre', 'German'): 1,
         ('Kro', 'German'): 2,
         ('Kru', 'German'): 6,
         ('Kuc', 'German'): 1,
         ('Kuh', 'German'): 1,
         ('Kun', 'German'): 5,
         ('Kur', 'German'): 1,
         ('Lab', 'German'): 1,
         ('Laf', 'German'): 2,
         ('Lan', 'German'): 5,
         ('Lar', 'German'): 1,
         ('Lau', 'German'): 2,
         ('Law', 'German'): 2,
         ('Leh', 'German'): 2,
         ('Lei', 'German'): 3,
         ('Len', 'German'): 1,
         ('Lev', 'German'): 1,
         ('Lew', 'German'): 2,
         ('Lic', 'German'): 1,
         ('Lie', 'German'): 1,
         ('Lin', 'German'): 1,
         ('Loe', 'German'): 1,
         ('Loh', 'German'): 1,
         ('Lor', 'German'): 5,
         ('Low', 'German'): 1,
         ('Lud', 'German'): 1,
         ('Lut', 'German'): 1,
         ('Maa', 'German'): 1,
         ('Mai', 'German'): 1,
         ('Man', 'German'): 2,
         ('Mar', 'German'): 7,
         ('Mas', 'German'): 1,
         ('Mau', 'German'): 2,
         ('May', 'German'): 1,
         ('Mei', 'German'): 6,
         ('Mel', 'German'): 1,
         ('Men', 'German'): 3,
         ('Mes', 'German'): 4,
         ('Met', 'German'): 3,
         ('Mey', 'German'): 1,
         ('Mic', 'German'): 1,
         ('Moh', 'German'): 1,
         ('Mol', 'German'): 1,
         ('Mor', 'German'): 1,
         ('Mos', 'German'): 1,
         ('Mue', 'German'): 1,
         ('Muh', 'German'): 1,
         ('Mul', 'German'): 1,
         ('Nag', 'German'): 1,
         ('Neu', 'German'): 2,
         ('Nur', 'German'): 1,
         ('Nus', 'German'): 2,
         ('Obe', 'German'): 1,
         ('Oel', 'German'): 1,
         ('Ohm', 'German'): 1,
         ('Oli', 'German'): 1,
         ('Opp', 'German'): 1,
         ('Ott', 'German'): 2,
         ('Our', 'German'): 1,
         ('Pah', 'German'): 1,
         ('Pap', 'German'): 2,
         ('Pat', 'German'): 1,
         ('Pau', 'German'): 2,
         ('Paw', 'German'): 1,
         ('Pen', 'German'): 1,
         ('Pet', 'German'): 2,
         ('Pfa', 'German'): 1,
         ('Pfe', 'German'): 1,
         ('Pla', 'German'): 1,
         ('Ple', 'German'): 1,
         ('Por', 'German'): 2,
         ('Pri', 'German'): 1,
         ('Pro', 'German'): 1,
         ('Rad', 'German'): 2,
         ('Rap', 'German'): 1,
         ('Ras', 'German'): 4,
         ('Reg', 'German'): 1,
         ('Rei', 'German'): 3,
         ('Ret', 'German'): 1,
         ('Reu', 'German'): 2,
         ('Ric', 'German'): 2,
         ('Rie', 'German'): 2,
         ('Rit', 'German'): 1,
         ('Ros', 'German'): 4,
         ('Rot', 'German'): 5,
         ('Sac', 'German'): 1,
         ('Sal', 'German'): 4,
         ('Sam', 'German'): 1,
         ('San', 'German'): 1,
         ('Sau', 'German'): 1,
         ('Sch', 'German'): 54,
         ('See', 'German'): 1,
         ('Sei', 'German'): 1,
         ('Sen', 'German'): 2,
         ('She', 'German'): 1,
         ('Shr', 'German'): 1,
         ('Sie', 'German'): 4,
         ('Sil', 'German'): 1,
         ('Sim', 'German'): 4,
         ('Sis', 'German'): 2,
         ('Sit', 'German'): 2,
         ('Slu', 'German'): 1,
         ('Sol', 'German'): 1,
         ('Som', 'German'): 4,
         ('Son', 'German'): 1,
         ('Sor', 'German'): 2,
         ('Spa', 'German'): 1,
         ('Spe', 'German'): 2,
         ('Spi', 'German'): 1,
         ('Spo', 'German'): 1,
         ('Sta', 'German'): 2,
         ('Ste', 'German'): 8,
         ('Sti', 'German'): 1,
         ('Sto', 'German'): 2,
         ('Str', 'German'): 5,
         ('Stu', 'German'): 4,
         ('Sue', 'German'): 1,
         ('Sul', 'German'): 1,
         ('Swa', 'German'): 1,
         ('Swi', 'German'): 1,
         ('Tan', 'German'): 2,
         ('Teu', 'German'): 1,
         ('Tie', 'German'): 1,
         ('Tif', 'German'): 1,
         ('Til', 'German'): 1,
         ('Tob', 'German'): 1,
         ('Tol', 'German'): 1,
         ('Tre', 'German'): 1,
         ('Tri', 'German'): 1,
         ('Tru', 'German'): 1,
         ('Tsc', 'German'): 1,
         ('Unk', 'German'): 1,
         ('Unr', 'German'): 1,
         ('Unt', 'German'): 1,
         ('Urs', 'German'): 1,
         ('Van', 'German'): 2,
         ('Vie', 'German'): 1,
         ('Vog', 'German'): 3,
         ('Voi', 'German'): 2,
         ('Vol', 'German'): 2,
         ('Von', 'German'): 6,
         ('Vos', 'German'): 2,
         ('Wag', 'German'): 2,
         ('Wah', 'German'): 2,
         ('Wal', 'German'): 6,
         ('Wan', 'German'): 1,
         ('War', 'German'): 1,
         ('Wax', 'German'): 1,
         ('Web', 'German'): 1,
         ('Wec', 'German'): 1,
         ('Wed', 'German'): 1,
         ('Wee', 'German'): 1,
         ('Weg', 'German'): 2,
         ('Weh', 'German'): 2,
         ('Wei', 'German'): 5,
         ('Wel', 'German'): 1,
         ('Wen', 'German'): 2,
         ('Wer', 'German'): 2,
         ('Wes', 'German'): 2,
         ('Wet', 'German'): 2,
         ('Wex', 'German'): 1,
         ('Wie', 'German'): 2,
         ('Wil', 'German'): 1,
         ('Win', 'German'): 3,
         ('Wir', 'German'): 4,
         ('Wol', 'German'): 3,
         ('Wor', 'German'): 2,
         ('Wru', 'German'): 1,
         ('Wym', 'German'): 1,
         ('Xyl', 'German'): 1,
         ('Zel', 'German'): 1,
         ('Zil', 'German'): 1,
         ('Zim', 'German'): 2,
         ('Abb', 'English'): 3,
         ('Abd', 'English'): 1,
         ('Abe', 'English'): 1,
         ('Abr', 'English'): 3,
         ('Ack', 'English'): 2,
         ('Act', 'English'): 1,
         ('Ada', 'English'): 5,
         ('Add', 'English'): 6,
         ('Ade', 'English'): 2,
         ('Adk', 'English'): 1,
         ('Adl', 'English'): 2,
         ('Adr', 'English'): 1,
         ('Ads', 'English'): 1,
         ('Aga', 'English'): 1,
         ('Ahe', 'English'): 2,
         ('Ahm', 'English'): 2,
         ('Aik', 'English'): 1,
         ('Ain', 'English'): 2,
         ('Air', 'English'): 2,
         ('Ait', 'English'): 2,
         ('Akh', 'English'): 1,
         ('Akr', 'English'): 1,
         ('Ala', 'English'): 2,
         ('Alb', 'English'): 4,
         ('Alc', 'English'): 1,
         ('Ald', 'English'): 8,
         ('Ale', 'English'): 4,
         ('Alf', 'English'): 1,
         ('Alg', 'English'): 1,
         ('Ali', 'English'): 1,
         ('Alk', 'English'): 1,
         ('All', 'English'): 20,
         ('Alm', 'English'): 1,
         ('Alp', 'English'): 1,
         ('Als', 'English'): 1,
         ('Alt', 'English'): 2,
         ('Alv', 'English'): 2,
         ('Alw', 'English'): 1,
         ('Amb', 'English'): 1,
         ('Ame', 'English'): 1,
         ('Ami', 'English'): 1,
         ('Amn', 'English'): 1,
         ('Amo', 'English'): 3,
         ('Ana', 'English'): 1,
         ('And', 'English'): 5,
         ('Ang', 'English'): 1,
         ('Ank', 'English'): 1,
         ('Anl', 'English'): 1,
         ('Ann', 'English'): 1,
         ('Ans', 'English'): 3,
         ('Ant', 'English'): 5,
         ('Anw', 'English'): 1,
         ('App', 'English'): 3,
         ('Aps', 'English'): 1,
         ...})
>>> pd.Series(Counter(prefix_nationality))
Kho  Arabic     42
Nah  Arabic     24
Dah  Arabic     22
Ger  Arabic     24
Naz  Arabic     16
                ..
Xio  Chinese     1
Xua  Chinese     1
Yue  Chinese     1
Yun  Chinese     1
Zhi  Chinese     1
Length: 4964, dtype: int64
>>> df.groupby('name')
<pandas.core.groupby.generic.DataFrameGroupBy object at 0x7f3a50d25a90>
>>> for g in df.groupby('name'):
...     print(g['nationality'].nunique())
...
>>> g
('Aalsburg',
            name category
 19509  Aalsburg    Dutch)
>>> for i, g in df.groupby('name'):
...     n = g['nationality'].nunique()
...     if n > 1:
...         print(f"{i}: {n}")
...
>>> for i, g in df.groupby('name'):
...     n = g['category'].nunique()
...     if n > 1:
...         print(f"{i}: {n}")
...
>>> overlap = {}
... for i, g in df.groupby('name'):
...     n = g['category'].nunique()
...     if n > 1:
...         print(f"{i}: {n}")
...         overlap[i] = n
...
>>> overlap = {}
... for i, g in df.groupby('name'):
...     n = g['category'].nunique()
...     if n > 1:
...         overlap[i] = n
...
>>> pd.Series(overlap)
Abel        5
Abello      2
Abraham     2
Abreu       2
Adam        5
           ..
Yim         2
You         2
Young       2
Yun         2
Zambrano    2
Length: 477, dtype: int64
>>> pd.Series(overlap).sort_values()
Zambrano      2
Mcmillan      2
Mcmahon       2
Mclean        2
Mclaughlin    2
             ..
Simon         5
Albert        5
Adam          5
Abel          5
Michel        6
Length: 477, dtype: int64
>>> pd.Series(overlap).sort_values(ascending=False)
Michel        6
Abel          5
Adam          5
Albert        5
Simon         5
             ..
Mclaughlin    2
Mclean        2
Mcmahon       2
Mcmillan      2
Zambrano      2
Length: 477, dtype: int64
>>> overlap = {}
... for i, g in df.groupby('name'):
...     n = g['category'].nunique()
...     if n > 1:
...         overlap[i] = list(g['category'].unique())
...
>>> pd.Series(overlap).sort_values(ascending=False)
Tron       [Vietnamese, Russian]
Sai        [Vietnamese, Russian]
Cao        [Vietnamese, Chinese]
Mai        [Vietnamese, Chinese]
Bui        [Vietnamese, Chinese]
                   ...          
Baba          [Arabic, Japanese]
Kalb            [Arabic, German]
Awad           [Arabic, English]
Mustafa        [Arabic, English]
Said           [Arabic, English]
Length: 477, dtype: object
>>> overlap = {}
... for i, g in df.groupby('name'):
...     n = g['category'].nunique()
...     if n > 1:
...         overlap[i] = [n, list(g['category'].unique())]
...
>>> overlap = {}
... for i, g in df.groupby('name'):
...     n = g['category'].nunique()
...     if n > 1:
...         overlap[i] = {'nunique': n, 'unique': list(g['category'].unique())}
...
>>> pd.DataFrame(overlap)
                                                Abel  ...            Zambrano
nunique                                            5  ...                   2
unique   [Spanish, French, German, English, Russian]  ...  [Spanish, Italian]

[2 rows x 477 columns]
>>> overlap = pd.DataFrame(overlap).T
>>> overlap.sort_values('nunique')
           nunique                                             unique
Zambrano         2                                 [Spanish, Italian]
Mcmillan         2                                [English, Scottish]
Mcmahon          2                                   [Irish, English]
Mclean           2                                [English, Scottish]
Mclaughlin       2                                [English, Scottish]
...            ...                                                ...
Simon            5            [Irish, French, German, English, Dutch]
Albert           5        [Spanish, French, German, English, Russian]
Adam             5          [Irish, French, German, English, Russian]
Abel             5        [Spanish, French, German, English, Russian]
Michel           6  [Spanish, French, German, English, Polish, Dutch]

[477 rows x 2 columns]
>>> overlap.sort_values('nunique', ascending=False)
         nunique                                             unique
Michel         6  [Spanish, French, German, English, Polish, Dutch]
Abel           5        [Spanish, French, German, English, Russian]
Simon          5            [Irish, French, German, English, Dutch]
Martin         5       [French, German, English, Scottish, Russian]
Adam           5          [Irish, French, German, English, Russian]
...          ...                                                ...
Best           2                                  [German, English]
Katz           2                                  [German, Russian]
Karl           2                                    [German, Dutch]
Kappel         2                                    [German, Dutch]
Zambrano       2                                 [Spanish, Italian]

[477 rows x 2 columns]
>>> hist
>>> hist -o -p -f char_rnn_name_nationality_overlap.hist.md
