# coding: utf-8

"""
    NCBI Datasets API

    NCBI service to query and download biological sequence data across all domains of life from NCBI databases.  # noqa: E501

    The version of the OpenAPI document: v1alpha
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ncbi.datasets.openapi.configuration import Configuration


class V1alpha1Organism(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'assembly_count': 'str',
        'assembly_counts': 'OrganismCounts',
        'blast_node': 'bool',
        'breed': 'str',
        'children': 'list[V1alpha1Organism]',
        'common_name': 'str',
        'counts': 'list[OrganismCountByType]',
        'cultivar': 'str',
        'ecotype': 'str',
        'icon': 'bool',
        'isolate': 'str',
        'key': 'str',
        'max_ord': 'int',
        'merged': 'list[V1alpha1Organism]',
        'merged_tax_ids': 'list[str]',
        'min_ord': 'int',
        'parent_tax_id': 'str',
        'rank': 'OrganismRankType',
        'sci_name': 'str',
        'search_text': 'list[str]',
        'sex': 'str',
        'strain': 'str',
        'tax_id': 'str',
        'title': 'str',
        'weight': 'int'
    }

    attribute_map = {
        'assembly_count': 'assembly_count',
        'assembly_counts': 'assembly_counts',
        'blast_node': 'blast_node',
        'breed': 'breed',
        'children': 'children',
        'common_name': 'common_name',
        'counts': 'counts',
        'cultivar': 'cultivar',
        'ecotype': 'ecotype',
        'icon': 'icon',
        'isolate': 'isolate',
        'key': 'key',
        'max_ord': 'max_ord',
        'merged': 'merged',
        'merged_tax_ids': 'merged_tax_ids',
        'min_ord': 'min_ord',
        'parent_tax_id': 'parent_tax_id',
        'rank': 'rank',
        'sci_name': 'sci_name',
        'search_text': 'search_text',
        'sex': 'sex',
        'strain': 'strain',
        'tax_id': 'tax_id',
        'title': 'title',
        'weight': 'weight'
    }

    def __init__(self, assembly_count=None, assembly_counts=None, blast_node=None, breed=None, children=None, common_name=None, counts=None, cultivar=None, ecotype=None, icon=None, isolate=None, key=None, max_ord=None, merged=None, merged_tax_ids=None, min_ord=None, parent_tax_id=None, rank=None, sci_name=None, search_text=None, sex=None, strain=None, tax_id=None, title=None, weight=None, local_vars_configuration=None):  # noqa: E501
        """V1alpha1Organism - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._assembly_count = None
        self._assembly_counts = None
        self._blast_node = None
        self._breed = None
        self._children = None
        self._common_name = None
        self._counts = None
        self._cultivar = None
        self._ecotype = None
        self._icon = None
        self._isolate = None
        self._key = None
        self._max_ord = None
        self._merged = None
        self._merged_tax_ids = None
        self._min_ord = None
        self._parent_tax_id = None
        self._rank = None
        self._sci_name = None
        self._search_text = None
        self._sex = None
        self._strain = None
        self._tax_id = None
        self._title = None
        self._weight = None
        self.discriminator = None

        if assembly_count is not None:
            self.assembly_count = assembly_count
        if assembly_counts is not None:
            self.assembly_counts = assembly_counts
        if blast_node is not None:
            self.blast_node = blast_node
        if breed is not None:
            self.breed = breed
        if children is not None:
            self.children = children
        if common_name is not None:
            self.common_name = common_name
        if counts is not None:
            self.counts = counts
        if cultivar is not None:
            self.cultivar = cultivar
        if ecotype is not None:
            self.ecotype = ecotype
        if icon is not None:
            self.icon = icon
        if isolate is not None:
            self.isolate = isolate
        if key is not None:
            self.key = key
        if max_ord is not None:
            self.max_ord = max_ord
        if merged is not None:
            self.merged = merged
        if merged_tax_ids is not None:
            self.merged_tax_ids = merged_tax_ids
        if min_ord is not None:
            self.min_ord = min_ord
        if parent_tax_id is not None:
            self.parent_tax_id = parent_tax_id
        if rank is not None:
            self.rank = rank
        if sci_name is not None:
            self.sci_name = sci_name
        if search_text is not None:
            self.search_text = search_text
        if sex is not None:
            self.sex = sex
        if strain is not None:
            self.strain = strain
        if tax_id is not None:
            self.tax_id = tax_id
        if title is not None:
            self.title = title
        if weight is not None:
            self.weight = weight

    @property
    def assembly_count(self):
        """Gets the assembly_count of this V1alpha1Organism.  # noqa: E501

        The number of assemblies at this node, and all children.  # noqa: E501

        :return: The assembly_count of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._assembly_count

    @assembly_count.setter
    def assembly_count(self, assembly_count):
        """Sets the assembly_count of this V1alpha1Organism.

        The number of assemblies at this node, and all children.  # noqa: E501

        :param assembly_count: The assembly_count of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._assembly_count = assembly_count

    @property
    def assembly_counts(self):
        """Gets the assembly_counts of this V1alpha1Organism.  # noqa: E501


        :return: The assembly_counts of this V1alpha1Organism.  # noqa: E501
        :rtype: OrganismCounts
        """
        return self._assembly_counts

    @assembly_counts.setter
    def assembly_counts(self, assembly_counts):
        """Sets the assembly_counts of this V1alpha1Organism.


        :param assembly_counts: The assembly_counts of this V1alpha1Organism.  # noqa: E501
        :type: OrganismCounts
        """

        self._assembly_counts = assembly_counts

    @property
    def blast_node(self):
        """Gets the blast_node of this V1alpha1Organism.  # noqa: E501


        :return: The blast_node of this V1alpha1Organism.  # noqa: E501
        :rtype: bool
        """
        return self._blast_node

    @blast_node.setter
    def blast_node(self, blast_node):
        """Sets the blast_node of this V1alpha1Organism.


        :param blast_node: The blast_node of this V1alpha1Organism.  # noqa: E501
        :type: bool
        """

        self._blast_node = blast_node

    @property
    def breed(self):
        """Gets the breed of this V1alpha1Organism.  # noqa: E501


        :return: The breed of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._breed

    @breed.setter
    def breed(self, breed):
        """Sets the breed of this V1alpha1Organism.


        :param breed: The breed of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._breed = breed

    @property
    def children(self):
        """Gets the children of this V1alpha1Organism.  # noqa: E501

        List of all children tax nodes.  # noqa: E501

        :return: The children of this V1alpha1Organism.  # noqa: E501
        :rtype: list[V1alpha1Organism]
        """
        return self._children

    @children.setter
    def children(self, children):
        """Sets the children of this V1alpha1Organism.

        List of all children tax nodes.  # noqa: E501

        :param children: The children of this V1alpha1Organism.  # noqa: E501
        :type: list[V1alpha1Organism]
        """

        self._children = children

    @property
    def common_name(self):
        """Gets the common_name of this V1alpha1Organism.  # noqa: E501


        :return: The common_name of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._common_name

    @common_name.setter
    def common_name(self, common_name):
        """Sets the common_name of this V1alpha1Organism.


        :param common_name: The common_name of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._common_name = common_name

    @property
    def counts(self):
        """Gets the counts of this V1alpha1Organism.  # noqa: E501


        :return: The counts of this V1alpha1Organism.  # noqa: E501
        :rtype: list[OrganismCountByType]
        """
        return self._counts

    @counts.setter
    def counts(self, counts):
        """Sets the counts of this V1alpha1Organism.


        :param counts: The counts of this V1alpha1Organism.  # noqa: E501
        :type: list[OrganismCountByType]
        """

        self._counts = counts

    @property
    def cultivar(self):
        """Gets the cultivar of this V1alpha1Organism.  # noqa: E501


        :return: The cultivar of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._cultivar

    @cultivar.setter
    def cultivar(self, cultivar):
        """Sets the cultivar of this V1alpha1Organism.


        :param cultivar: The cultivar of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._cultivar = cultivar

    @property
    def ecotype(self):
        """Gets the ecotype of this V1alpha1Organism.  # noqa: E501


        :return: The ecotype of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._ecotype

    @ecotype.setter
    def ecotype(self, ecotype):
        """Sets the ecotype of this V1alpha1Organism.


        :param ecotype: The ecotype of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._ecotype = ecotype

    @property
    def icon(self):
        """Gets the icon of this V1alpha1Organism.  # noqa: E501


        :return: The icon of this V1alpha1Organism.  # noqa: E501
        :rtype: bool
        """
        return self._icon

    @icon.setter
    def icon(self, icon):
        """Sets the icon of this V1alpha1Organism.


        :param icon: The icon of this V1alpha1Organism.  # noqa: E501
        :type: bool
        """

        self._icon = icon

    @property
    def isolate(self):
        """Gets the isolate of this V1alpha1Organism.  # noqa: E501


        :return: The isolate of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._isolate

    @isolate.setter
    def isolate(self, isolate):
        """Sets the isolate of this V1alpha1Organism.


        :param isolate: The isolate of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._isolate = isolate

    @property
    def key(self):
        """Gets the key of this V1alpha1Organism.  # noqa: E501


        :return: The key of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._key

    @key.setter
    def key(self, key):
        """Sets the key of this V1alpha1Organism.


        :param key: The key of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._key = key

    @property
    def max_ord(self):
        """Gets the max_ord of this V1alpha1Organism.  # noqa: E501


        :return: The max_ord of this V1alpha1Organism.  # noqa: E501
        :rtype: int
        """
        return self._max_ord

    @max_ord.setter
    def max_ord(self, max_ord):
        """Sets the max_ord of this V1alpha1Organism.


        :param max_ord: The max_ord of this V1alpha1Organism.  # noqa: E501
        :type: int
        """

        self._max_ord = max_ord

    @property
    def merged(self):
        """Gets the merged of this V1alpha1Organism.  # noqa: E501

        List of all merged tax nodes for the pruned taxonomic tree.  # noqa: E501

        :return: The merged of this V1alpha1Organism.  # noqa: E501
        :rtype: list[V1alpha1Organism]
        """
        return self._merged

    @merged.setter
    def merged(self, merged):
        """Sets the merged of this V1alpha1Organism.

        List of all merged tax nodes for the pruned taxonomic tree.  # noqa: E501

        :param merged: The merged of this V1alpha1Organism.  # noqa: E501
        :type: list[V1alpha1Organism]
        """

        self._merged = merged

    @property
    def merged_tax_ids(self):
        """Gets the merged_tax_ids of this V1alpha1Organism.  # noqa: E501

        List of merged (now deprecated) Taxonomy IDs for the current Organism.  # noqa: E501

        :return: The merged_tax_ids of this V1alpha1Organism.  # noqa: E501
        :rtype: list[str]
        """
        return self._merged_tax_ids

    @merged_tax_ids.setter
    def merged_tax_ids(self, merged_tax_ids):
        """Sets the merged_tax_ids of this V1alpha1Organism.

        List of merged (now deprecated) Taxonomy IDs for the current Organism.  # noqa: E501

        :param merged_tax_ids: The merged_tax_ids of this V1alpha1Organism.  # noqa: E501
        :type: list[str]
        """

        self._merged_tax_ids = merged_tax_ids

    @property
    def min_ord(self):
        """Gets the min_ord of this V1alpha1Organism.  # noqa: E501


        :return: The min_ord of this V1alpha1Organism.  # noqa: E501
        :rtype: int
        """
        return self._min_ord

    @min_ord.setter
    def min_ord(self, min_ord):
        """Sets the min_ord of this V1alpha1Organism.


        :param min_ord: The min_ord of this V1alpha1Organism.  # noqa: E501
        :type: int
        """

        self._min_ord = min_ord

    @property
    def parent_tax_id(self):
        """Gets the parent_tax_id of this V1alpha1Organism.  # noqa: E501


        :return: The parent_tax_id of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._parent_tax_id

    @parent_tax_id.setter
    def parent_tax_id(self, parent_tax_id):
        """Sets the parent_tax_id of this V1alpha1Organism.


        :param parent_tax_id: The parent_tax_id of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._parent_tax_id = parent_tax_id

    @property
    def rank(self):
        """Gets the rank of this V1alpha1Organism.  # noqa: E501


        :return: The rank of this V1alpha1Organism.  # noqa: E501
        :rtype: OrganismRankType
        """
        return self._rank

    @rank.setter
    def rank(self, rank):
        """Sets the rank of this V1alpha1Organism.


        :param rank: The rank of this V1alpha1Organism.  # noqa: E501
        :type: OrganismRankType
        """

        self._rank = rank

    @property
    def sci_name(self):
        """Gets the sci_name of this V1alpha1Organism.  # noqa: E501


        :return: The sci_name of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._sci_name

    @sci_name.setter
    def sci_name(self, sci_name):
        """Sets the sci_name of this V1alpha1Organism.


        :param sci_name: The sci_name of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._sci_name = sci_name

    @property
    def search_text(self):
        """Gets the search_text of this V1alpha1Organism.  # noqa: E501


        :return: The search_text of this V1alpha1Organism.  # noqa: E501
        :rtype: list[str]
        """
        return self._search_text

    @search_text.setter
    def search_text(self, search_text):
        """Sets the search_text of this V1alpha1Organism.


        :param search_text: The search_text of this V1alpha1Organism.  # noqa: E501
        :type: list[str]
        """

        self._search_text = search_text

    @property
    def sex(self):
        """Gets the sex of this V1alpha1Organism.  # noqa: E501


        :return: The sex of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._sex

    @sex.setter
    def sex(self, sex):
        """Sets the sex of this V1alpha1Organism.


        :param sex: The sex of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._sex = sex

    @property
    def strain(self):
        """Gets the strain of this V1alpha1Organism.  # noqa: E501


        :return: The strain of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._strain

    @strain.setter
    def strain(self, strain):
        """Sets the strain of this V1alpha1Organism.


        :param strain: The strain of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._strain = strain

    @property
    def tax_id(self):
        """Gets the tax_id of this V1alpha1Organism.  # noqa: E501


        :return: The tax_id of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._tax_id

    @tax_id.setter
    def tax_id(self, tax_id):
        """Sets the tax_id of this V1alpha1Organism.


        :param tax_id: The tax_id of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._tax_id = tax_id

    @property
    def title(self):
        """Gets the title of this V1alpha1Organism.  # noqa: E501


        :return: The title of this V1alpha1Organism.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this V1alpha1Organism.


        :param title: The title of this V1alpha1Organism.  # noqa: E501
        :type: str
        """

        self._title = title

    @property
    def weight(self):
        """Gets the weight of this V1alpha1Organism.  # noqa: E501

        More frequently searched taxons will have a higher weight.  # noqa: E501

        :return: The weight of this V1alpha1Organism.  # noqa: E501
        :rtype: int
        """
        return self._weight

    @weight.setter
    def weight(self, weight):
        """Sets the weight of this V1alpha1Organism.

        More frequently searched taxons will have a higher weight.  # noqa: E501

        :param weight: The weight of this V1alpha1Organism.  # noqa: E501
        :type: int
        """

        self._weight = weight

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, V1alpha1Organism):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, V1alpha1Organism):
            return True

        return self.to_dict() != other.to_dict()
