"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PgStacApiLambda = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_lambda_python_alpha_1 = require("@aws-cdk/aws-lambda-python-alpha");
const aws_apigatewayv2_alpha_1 = require("@aws-cdk/aws-apigatewayv2-alpha");
const aws_apigatewayv2_integrations_alpha_1 = require("@aws-cdk/aws-apigatewayv2-integrations-alpha");
const constructs_1 = require("constructs");
class PgStacApiLambda extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const apiCode = props.apiCode || {
            entry: `${__dirname}/runtime`,
            index: "src/handler.py",
            handler: "handler",
        };
        const handler = new aws_lambda_python_alpha_1.PythonFunction(this, "stac-api", {
            ...apiCode,
            /**
             * NOTE: Unable to use Py3.9, due to issues with hashes:
             *
             *    ERROR: Hashes are required in --require-hashes mode, but they are missing
             *    from some requirements. Here is a list of those requirements along with the
             *    hashes their downloaded archives actually had. Add lines like these to your
             *    requirements files to prevent tampering. (If you did not enable
             *    --require-hashes manually, note that it turns on automatically when any
             *    package has a hash.)
             *        anyio==3.6.1 --hash=sha256:cb29b9c70620506a9a8f87a309591713446953302d7d995344d0d7c6c0c9a7be
             * */
            runtime: aws_cdk_lib_1.aws_lambda.Runtime.PYTHON_3_8,
            architecture: aws_cdk_lib_1.aws_lambda.Architecture.X86_64,
            environment: {
                PGSTAC_SECRET_ARN: props.dbSecret.secretArn,
                DB_MIN_CONN_SIZE: "0",
                DB_MAX_CONN_SIZE: "1",
                ...props.apiEnv,
            },
            vpc: props.vpc,
            vpcSubnets: props.subnetSelection,
            allowPublicSubnet: true,
            memorySize: 8192,
        });
        props.dbSecret.grantRead(handler);
        handler.connections.allowTo(props.db, aws_cdk_lib_1.aws_ec2.Port.tcp(5432));
        const stacApi = new aws_apigatewayv2_alpha_1.HttpApi(this, `${aws_cdk_lib_1.Stack.of(this).stackName}-stac-api`, {
            defaultIntegration: new aws_apigatewayv2_integrations_alpha_1.HttpLambdaIntegration("integration", handler),
        });
        this.url = stacApi.url;
        new aws_cdk_lib_1.CfnOutput(this, "stac-api-output", {
            exportName: `${aws_cdk_lib_1.Stack.of(this).stackName}-url`,
            value: this.url,
        });
    }
}
exports.PgStacApiLambda = PgStacApiLambda;
_a = JSII_RTTI_SYMBOL_1;
PgStacApiLambda[_a] = { fqn: "cdk-pgstac.PgStacApiLambda", version: "2.0.0" };
//# sourceMappingURL=data:application/json;base64,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