# __init__.py needed for properly configuring pypi distribution of x3d.py package

# According to _Learning Python_ by Mark Lutz, fifth edition:
# - Empty __init.py__ no longer required as of Python 3.3.  p. 761
# - Using __init.py__ is performance advantage for loading, even when empty.  p. 761
# - Using __all__ list to define exported values for import * is allowed but not required.  p. 735 and 771-772.

# 6.4.1. Importing * From a Package
# https://docs.python.org/3/tutorial/modules.html#importing-from-a-package

# indicates that
#     from packagename import *
# "then imports whatever names are defined in the package" and
# "Although certain modules are designed to export only names that follow certain patterns when you use import *,
#     it is still considered bad practice in production code."

# TODO testing continues to fix x3d.py package's class visibility satisfactorily for end users

__all__ = [
    # Field types
    'SFBool', 'MFBool', 'SFColor', 'MFColor', 'SFColorRGBA', 'MFColorRGBA', 'SFDouble', 'MFDouble', 'SFFloat', 'MFFloat', 'SFImage', 'MFImage', 'SFInt32', 'MFInt32', 'SFMatrix3d', 'MFMatrix3d', 'SFMatrix3f', 'MFMatrix3f', 'SFMatrix4d', 'MFMatrix4d', 'SFMatrix4f', 'MFMatrix4f', 'SFNode', 'MFNode', 'SFRotation', 'MFRotation', 'SFString', 'MFString', 'SFTime', 'MFTime', 'SFVec2d', 'MFVec2d', 'SFVec2f', 'MFVec2f', 'SFVec3d', 'MFVec3d', 'SFVec3f', 'MFVec3f', 'SFVec4d', 'MFVec4d', 'SFVec4f', 'MFVec4f', 

    # Simple Type Enumerations
    'accessTypeChoices', 'appliedParametersChoices', 'bboxSizeType', 'closureTypeChoices', 'colorModeChoices', 'componentNameChoices', 'fieldTypeChoices', 'fogTypeChoices', 'fontFamilyValues', 'fontStyleChoices', 'forceOutputValues', 'generatedCubeMapTextureUpdateChoices', 'geoMetadataKeyValues', 'geoSystemEarthEllipsoidValues', 'geoSystemSpatialReferenceFrameValues', 'geoSystemType', 'hanimFeaturePointNameValues', 'hanimHumanoidInfoKeyValues', 'hanimJointNameValues', 'hanimSegmentNameValues', 'hanimVersionChoices', 'intensityType', 'intersectionTypeValues', 'justifyChoices', 'layoutAlignChoices', 'layoutScaleModeChoices', 'layoutUnitsChoices', 'loaType', 'metaDirectionChoices', 'metaNameValues', 'multiTextureFunctionValues', 'multiTextureModeValues', 'multiTextureSourceValues', 'navigationTransitionTypeValues', 'navigationTypeValues', 'networkModeChoices', 'particleSystemGeometryTypeValues', 'phaseFunctionValues', 'pickableObjectTypeValues', 'pickSensorMatchCriterionChoices', 'pickSensorSortOrderValues', 'profileNameChoices', 'projectionVolumeStyleTypeChoices', 'shaderLanguageValues', 'shaderPartTypeValues', 'textureBoundaryModeChoices', 'textureCompressionModeChoices', 'textureCoordinateGeneratorModeChoices', 'textureMagnificationModeChoices', 'textureMinificationModeChoices', 'unitCategoryChoices', 'volumeRenderingWeightFunctionChoices', 'x3dVersionChoices', 

    # Abstract Object Types
    'X3DBoundedObject', 'X3DFogObject', 'X3DMetadataObject', 'X3DPickableObject', 'X3DProgrammableShaderObject', 'X3DUrlObject', 

    # Abstract Node Types
    'X3DAppearanceChildNode', 'X3DAppearanceNode', 'X3DBackgroundNode', 'X3DBindableNode', 'X3DChaserNode', 'X3DChildNode', 'X3DColorNode', 'X3DComposableVolumeRenderStyleNode', 'X3DComposedGeometryNode', 'X3DCoordinateNode', 'X3DDamperNode', 'X3DDragSensorNode', 'X3DEnvironmentalSensorNode', 'X3DEnvironmentTextureNode', 'X3DFollowerNode', 'X3DFontStyleNode', 'X3DGeometricPropertyNode', 'X3DGeometryNode', 'X3DGroupingNode', 'X3DInfoNode', 'X3DInterpolatorNode', 'X3DKeyDeviceSensorNode', 'X3DLayerNode', 'X3DLayoutNode', 'X3DLightNode', 'X3DMaterialNode', 'X3DNBodyCollidableNode', 'X3DNBodyCollisionSpaceNode', 'X3DNetworkSensorNode', 'X3DNode', 'X3DNormalNode', 'X3DNurbsControlCurveNode', 'X3DNurbsSurfaceGeometryNode', 'X3DParametricGeometryNode', 'X3DParticleEmitterNode', 'X3DParticlePhysicsModelNode', 'X3DPickSensorNode', 'X3DPointingDeviceSensorNode', 'X3DProductStructureChildNode', 'X3DPrototypeInstance', 'X3DRigidJointNode', 'X3DScriptNode', 'X3DSensorNode', 'X3DSequencerNode', 'X3DShaderNode', 'X3DShapeNode', 'X3DSoundNode', 'X3DSoundSourceNode', 'X3DTexture2DNode', 'X3DTexture3DNode', 'X3DTextureCoordinateNode', 'X3DTextureNode', 'X3DTextureTransformNode', 'X3DTimeDependentNode', 'X3DTouchSensorNode', 'X3DTriggerNode', 'X3DVertexAttributeNode', 'X3DViewpointNode', 'X3DViewportNode', 'X3DVolumeDataNode', 'X3DVolumeRenderStyleNode', 

    # Concrete Nodes
    'Anchor', 'Appearance', 'Arc2D', 'ArcClose2D', 'AudioClip', 'Background', 'BallJoint', 'Billboard', 'BlendedVolumeStyle', 'BooleanFilter', 'BooleanSequencer', 'BooleanToggle', 'BooleanTrigger', 'BoundaryEnhancementVolumeStyle', 'BoundedPhysicsModel', 'Box', 'CADAssembly', 'CADFace', 'CADLayer', 'CADPart', 'CartoonVolumeStyle', 'Circle2D', 'ClipPlane', 'CollidableOffset', 'CollidableShape', 'Collision', 'CollisionCollection', 'CollisionSensor', 'CollisionSpace', 'Color', 'ColorChaser', 'ColorDamper', 'ColorInterpolator', 'ColorRGBA', 'ComposedCubeMapTexture', 'ComposedShader', 'ComposedTexture3D', 'ComposedVolumeStyle', 'Cone', 'ConeEmitter', 'Contact', 'Contour2D', 'ContourPolyline2D', 'Coordinate', 'CoordinateChaser', 'CoordinateDamper', 'CoordinateDouble', 'CoordinateInterpolator', 'CoordinateInterpolator2D', 'Cylinder', 'CylinderSensor', 'DirectionalLight', 'DISEntityManager', 'DISEntityTypeMapping', 'Disk2D', 'DoubleAxisHingeJoint', 'EaseInEaseOut', 'EdgeEnhancementVolumeStyle', 'ElevationGrid', 'EspduTransform', 'ExplosionEmitter', 'Extrusion', 'FillProperties', 'FloatVertexAttribute', 'Fog', 'FogCoordinate', 'FontStyle', 'ForcePhysicsModel', 'GeneratedCubeMapTexture', 'GeoCoordinate', 'GeoElevationGrid', 'GeoLocation', 'GeoLOD', 'GeoMetadata', 'GeoOrigin', 'GeoPositionInterpolator', 'GeoProximitySensor', 'GeoTouchSensor', 'GeoTransform', 'GeoViewpoint', 'Group', 'HAnimDisplacer', 'HAnimHumanoid', 'HAnimJoint', 'HAnimMotion', 'HAnimSegment', 'HAnimSite', 'ImageCubeMapTexture', 'ImageTexture', 'ImageTexture3D', 'IndexedFaceSet', 'IndexedLineSet', 'IndexedQuadSet', 'IndexedTriangleFanSet', 'IndexedTriangleSet', 'IndexedTriangleStripSet', 'Inline', 'IntegerSequencer', 'IntegerTrigger', 'IsoSurfaceVolumeData', 'KeySensor', 'Layer', 'LayerSet', 'Layout', 'LayoutGroup', 'LayoutLayer', 'LinePickSensor', 'LineProperties', 'LineSet', 'LoadSensor', 'LocalFog', 'LOD', 'Material', 'Matrix3VertexAttribute', 'Matrix4VertexAttribute', 'MetadataBoolean', 'MetadataDouble', 'MetadataFloat', 'MetadataInteger', 'MetadataSet', 'MetadataString', 'MotorJoint', 'MovieTexture', 'MultiTexture', 'MultiTextureCoordinate', 'MultiTextureTransform', 'NavigationInfo', 'Normal', 'NormalInterpolator', 'NurbsCurve', 'NurbsCurve2D', 'NurbsOrientationInterpolator', 'NurbsPatchSurface', 'NurbsPositionInterpolator', 'NurbsSet', 'NurbsSurfaceInterpolator', 'NurbsSweptSurface', 'NurbsSwungSurface', 'NurbsTextureCoordinate', 'NurbsTrimmedSurface', 'OpacityMapVolumeStyle', 'OrientationChaser', 'OrientationDamper', 'OrientationInterpolator', 'OrthoViewpoint', 'PackagedShader', 'ParticleSystem', 'PickableGroup', 'PixelTexture', 'PixelTexture3D', 'PlaneSensor', 'PointEmitter', 'PointLight', 'PointPickSensor', 'PointProperties', 'PointSet', 'Polyline2D', 'PolylineEmitter', 'Polypoint2D', 'PositionChaser', 'PositionChaser2D', 'PositionDamper', 'PositionDamper2D', 'PositionInterpolator', 'PositionInterpolator2D', 'PrimitivePickSensor', 'ProgramShader', 'ProjectionVolumeStyle', 'ProtoInstance', 'ProximitySensor', 'QuadSet', 'ReceiverPdu', 'Rectangle2D', 'RigidBody', 'RigidBodyCollection', 'ScalarChaser', 'ScalarDamper', 'ScalarInterpolator', 'ScreenFontStyle', 'ScreenGroup', 'Script', 'SegmentedVolumeData', 'ShadedVolumeStyle', 'ShaderPart', 'ShaderProgram', 'Shape', 'SignalPdu', 'SilhouetteEnhancementVolumeStyle', 'SingleAxisHingeJoint', 'SliderJoint', 'Sound', 'Sphere', 'SphereSensor', 'SplinePositionInterpolator', 'SplinePositionInterpolator2D', 'SplineScalarInterpolator', 'SpotLight', 'SquadOrientationInterpolator', 'StaticGroup', 'StringSensor', 'SurfaceEmitter', 'Switch', 'TexCoordChaser2D', 'TexCoordDamper2D', 'Text', 'TextureBackground', 'TextureCoordinate', 'TextureCoordinate3D', 'TextureCoordinate4D', 'TextureCoordinateGenerator', 'TextureProperties', 'TextureTransform', 'TextureTransform3D', 'TextureTransformMatrix3D', 'TimeSensor', 'TimeTrigger', 'ToneMappedVolumeStyle', 'TouchSensor', 'Transform', 'TransformSensor', 'TransmitterPdu', 'TriangleFanSet', 'TriangleSet', 'TriangleSet2D', 'TriangleStripSet', 'TwoSidedMaterial', 'UniversalJoint', 'Viewpoint', 'ViewpointGroup', 'Viewport', 'VisibilitySensor', 'VolumeData', 'VolumeEmitter', 'VolumePickSensor', 'WindPhysicsModel', 'WorldInfo', 

    # Statements
    'component', 'connect', 'EXPORT', 'ExternProtoDeclare', 'field', 'fieldValue', 'head', 'IMPORT', 'IS', 'meta', 'ProtoBody', 'ProtoDeclare', 'ProtoInterface', 'ROUTE', 'Scene', 'unit', 'X3D', 

    # Utility functions
    'isValidSFBool', 'assertValidSFBool', 'isValidMFBool', 'assertValidMFBool', 'isValidSFColor', 'assertValidSFColor', 'isValidMFColor', 'assertValidMFColor', 'isValidSFColorRGBA', 'assertValidSFColorRGBA', 'isValidMFColorRGBA', 'assertValidMFColorRGBA', 'isValidSFDouble', 'assertValidSFDouble', 'isValidMFDouble', 'assertValidMFDouble', 'isValidSFFloat', 'assertValidSFFloat', 'isValidMFFloat', 'assertValidMFFloat', 'isValidSFImage', 'assertValidSFImage', 'isValidMFImage', 'assertValidMFImage', 'isValidSFInt32', 'assertValidSFInt32', 'isValidMFInt32', 'assertValidMFInt32', 'isValidSFMatrix3d', 'assertValidSFMatrix3d', 'isValidMFMatrix3d', 'assertValidMFMatrix3d', 'isValidSFMatrix3f', 'assertValidSFMatrix3f', 'isValidMFMatrix3f', 'assertValidMFMatrix3f', 'isValidSFMatrix4d', 'assertValidSFMatrix4d', 'isValidMFMatrix4d', 'assertValidMFMatrix4d', 'isValidSFMatrix4f', 'assertValidSFMatrix4f', 'isValidMFMatrix4f', 'assertValidMFMatrix4f', 'isValidSFNode', 'assertValidSFNode', 'isValidMFNode', 'assertValidMFNode', 'isValidSFRotation', 'assertValidSFRotation', 'isValidMFRotation', 'assertValidMFRotation', 'isValidSFString', 'assertValidSFString', 'isValidMFString', 'assertValidMFString', 'isValidSFTime', 'assertValidSFTime', 'isValidMFTime', 'assertValidMFTime', 'isValidSFVec2d', 'assertValidSFVec2d', 'isValidMFVec2d', 'assertValidMFVec2d', 'isValidSFVec2f', 'assertValidSFVec2f', 'isValidMFVec2f', 'assertValidMFVec2f', 'isValidSFVec3d', 'assertValidSFVec3d', 'isValidMFVec3d', 'assertValidMFVec3d', 'isValidSFVec3f', 'assertValidSFVec3f', 'isValidMFVec3f', 'assertValidMFVec3f', 'isValidSFVec4d', 'assertValidSFVec4d', 'isValidMFVec4d', 'assertValidMFVec4d', 'isValidSFVec4f', 'assertValidSFVec4f', 'isValidMFVec4f', 'assertValidMFVec4f', 
    'fixBoolean', 'isPositive', 'assertPositive', 'isNonNegative', 'assertNonNegative', 'isZeroToOne', 'assertZeroToOne', 'isLessThanEquals', 'assertLessThanEquals', 'isLessThan', 'assertLessThan', 'isGreaterThanEquals', 'assertGreaterThanEquals', 'isGreaterThan', 'assertGreaterThan', 'isBoundingBox', 'assertBoundingBox',
    'metaDiagnostics'
    ]
