(function() {
  ({
    "version": 3,
    "names": [],
    "mappings": "",
    "sources": ["recurrence_admin.coffee"],
    "sourcesContent": ["#---------------------------------------------------------------------------\n# Recurrence Widget\n#---------------------------------------------------------------------------\n\nclass RecurrenceWidget\n    constructor: (widgetId) ->\n        ourDiv = $(\"#" + widgetId + "\")\n        @our = ourDiv.find.bind(ourDiv)\n        @_init()\n        return\n\n    _init: () ->\n        showAdvanced = @_hasAdvanced()\n        @our(\".ev-show-advanced-cbx\").prop(\"checked\", showAdvanced)\n        @our(\".ev-advanced-repeat\").toggle(showAdvanced)\n        freq = @our(\".ev-freq-choice > select\").val()\n        @_freqChanged(freq)\n        @_primaryOrdDayChanged()\n        return\n\n    _hasAdvanced: () ->\n        interval = @our(\".ev-interval-num > input\").val()\n        if interval and parseInt(interval, 10) > 1\n            return true\n        weekdaysTicked = @our(\".ev-weekdays :checkbox:checked\").map ->\n            return this.value\n        .get()\n        if weekdaysTicked.length > 1\n            return true\n        dtstart = new Date(@our(\".ev-start-date > input\").val())\n        weekday = (dtstart.getDay() + 6) % 7  # convert from Sun=0 to Mon=0\n        if weekdaysTicked.length == 1 and parseInt(weekdaysTicked[0], 10) != weekday\n            return true\n        ordChoice = @our(\".ev-primary .ev-ord-choice > select\").val()\n        if parseInt(ordChoice, 10) != 101\n            return true\n        dayChoice = @our(\".ev-primary .ev-day-choice > select\").val()\n        if parseInt(dayChoice, 10) != 200\n            return true\n        secondaryOrdDaySet = $(\".ev-secondary select\").is ->\n            return $(this).val() != \"\"\n        if secondaryOrdDaySet\n            return true\n        return false\n\n    _clearAdvanced: () ->\n        @our(\".ev-interval-num > input\").val(1)\n        @our(\".ev-weekdays :checkbox\").prop(\"checked\", false)\n        dtstart = new Date(@our(\".ev-start-date > input\").val())\n        weekday = (dtstart.getDay() + 6) % 7  # convert from Sun=0 to Mon=0\n        @our(\".ev-weekdays :checkbox[value=" + weekday + "]\").prop(\"checked\", true)\n        @our(\".ev-primary .ev-ord-choice > select\").val(101)\n        @our(\".ev-primary .ev-day-choice > select\").val(200)\n        @our(\".ev-secondary select\").val(\"\").prop('disabled', true)\n        @our(\".ev-month-choice > select\").val(dtstart.getMonth() + 1)\n        return\n\n    enable: () ->\n        @_enableShowAdvanced()\n        @_enableStartDateChange()\n        @_enableFreqChange()\n        @_enableSecondaryOrdDayClear()\n        @_enablePrimaryOrdDayChange()\n        return\n\n    _enableShowAdvanced: () ->\n        @our(\".ev-show-advanced-cbx\").click (ev) =>\n            if $(ev.target).prop(\"checked\")\n                @our(\".ev-advanced-repeat\").show()\n            else\n                @our(\".ev-advanced-repeat\").hide()\n                @_clearAdvanced()\n            return true\n        return\n\n    _enableStartDateChange: () ->\n        @our(\".ev-start-date > input, .ev-\").change (ev) =>\n            showAdvanced = @our(\".ev-show-advanced-cbx\").prop(\"checked\")\n            if not showAdvanced\n                @_clearAdvanced()\n            return false\n        return\n\n    _enableFreqChange: () ->\n        @our(\".ev-freq-choice > select\").change (ev) =>\n            @_freqChanged($(ev.target).val())\n            @_clearAdvanced()\n            return false\n        return\n\n    _enableSecondaryOrdDayClear: () ->\n        @our(\".ev-secondary .ev-ord-choice > select\").change (ev) =>\n            if $(ev.target).find(\"option:selected\").val() == \"\"\n                row = $(ev.target).closest(\".ev-double-field\")\n                row.find(\".ev-day-choice > select\").val(\"\")\n            return false\n        @our(\".ev-secondary .ev-day-choice > select\").change (ev) =>\n            if $(ev.target).find(\"option:selected\").val() == \"\"\n                row = $(ev.target).closest(\".ev-double-field\")\n                row.find(\".ev-ord-choice > select\").val(\"\")\n            return false\n        return\n\n    _enablePrimaryOrdDayChange: () ->\n        @our(\".ev-primary select\").change (ev) =>\n            @_primaryOrdDayChanged()\n            return false\n        return\n\n    _primaryOrdDayChanged: () ->\n        ord = @our(\".ev-primary .ev-ord-choice option:selected\").val()\n        day = @our(\".ev-primary .ev-day-choice option:selected\").val()\n        if -1 <= parseInt(ord, 10) <= 5 and 0 <= parseInt(day, 10) <= 6\n            # enable and clauses\n            @our(\".ev-secondary select\").prop('disabled', false)\n        else\n            @our(\".ev-secondary select\").val(\"\").prop('disabled', true)\n\n        return\n\n    _freqChanged: (freq) ->\n        visible = [false, false, false]\n        units = \"\"\n        switch parseInt(freq, 10)\n            when 3\n                visible = [false, false, false]\n                units = \"Day(s)\"\n            when 2\n                visible = [true,  false, false]\n                units = \"Week(s)\"\n            when 1\n                visible = [false, true,  false]\n                units = \"Month(s)\"\n            when 0\n                visible = [false, true, true]\n                units = \"Year(s)\"\n        @our(\".ev-advanced-weekly-repeat\").toggle(visible[0])\n        @our(\".ev-advanced-monthly-repeat\").toggle(visible[1])\n        @our(\".ev-advanced-yearly-repeat\").toggle(visible[2])\n        @our(\".ev-interval-units\").text(units)\n        return\n\n@initRecurrenceWidget = (id) ->\n    widget = new RecurrenceWidget(id)\n    widget.enable()\n    return\n\n@initExceptionDateChooser = (id, validDates, dowStart=0) ->\n    dtpOpts =\n        onGenerate: (ct) ->\n            past = new Date()\n            past.setDate(past.getDate()-90)\n            past.setDate(1)\n            future = new Date()\n            future.setDate(future.getDate()+217)\n            future.setDate(1)\n            if validDates != -1 and past < ct < future\n                #console.log(ct)\n                $(this).find('td.xdsoft_date').addClass('xdsoft_disabled')\n                for yyyymmdd in validDates\n                    yyyy = parseInt(yyyymmdd[0...4], 10)\n                    mm   = parseInt(yyyymmdd[4...6], 10) - 1\n                    dd   = parseInt(yyyymmdd[6...8], 10)\n                    $(this).find(\"td.xdsoft_date[data-year=" + yyyy + "][data-month=" + mm + "][data-date=" + dd + "]\")\n                           .removeClass('xdsoft_disabled')\n        closeOnDateSelect: true\n        timepicker:        false\n        scrollInput:       false\n        format:            'Y-m-d'\n        dayOfWeekStart:    dowStart\n    if window.dateTimePickerTranslations\n        dtpOpts['i18n'] = lang: window.dateTimePickerTranslations\n        dtpOpts['lang'] = 'lang'\n    $('#' + id).datetimepicker(dtpOpts)\n"],
    "file": "../recurrence_admin.coffee"
  });

}).call(this);
