
"""
The central component of the BASIC tokenization/detokenization. The token map
"""
TOKENS = {
    # Spectrum Next new tokens
    'PEEK$': 0x87,
    'REG': 0x88,
    'DPOKE': 0x89,
    'DPEEK': 0x8a,
    'MOD': 0x8b,
    '<<': 0x8c,
    '>>': 0x8d,
    'UNTIL': 0x8e,
    'ERROR': 0x8f,
    'ON': 0x90,
    'DEFPROC': 0x91,
    'ENDPROC': 0x92,
    'PROC': 0x93,
    'LOCAL': 0x94,
    'DRIVER': 0x95,
    'WHILE': 0x96,
    'REPEAT': 0x97,
    'ELSE': 0x98,
    'REMOUNT': 0x99,
    'BANK': 0x9a,
    'TILE': 0x9b,
    'LAYER': 0x9c,
    'PALETTE': 0x9d,
    'SPRITE': 0x9e,
    'PWD': 0x9f,
    'CD': 0xa0,
    'MKDIR': 0xa1,
    'RMDIR': 0xa2,

    'SPECTRUM1': 0xa3,
    'PLAY1': 0xa4,
    'RND': 0xa5,
    'INKEY$': 0xa6,
    'PI': 0xa7,
    'FN': 0xa8,
    'POINT': 0xa9,
    'SCREEN$': 0xaa,
    'ATTR': 0xab,
    'AT': 0xac,
    'TAB': 0xad,
    'VAL$': 0xae,
    'CODE': 0xaf,
    'VAL': 0xb0,
    'LEN': 0xb1,
    'SIN': 0xb2,
    'COS': 0xb3,
    'TAN': 0xb4,
    'ASN': 0xb5,
    'ACS': 0xb6,
    'ATN': 0xb7,
    'LN': 0xb8,
    'EXP': 0xb9,
    'INT': 0xba,
    'SQR': 0xbb,
    'SGN': 0xbc,
    'ABS': 0xbd,
    'PEEK': 0xbe,
    'IN': 0xbf,
    'USR': 0xc0,
    'STR$': 0xc1,
    'CHR$': 0xc2,
    'NOT': 0xc3,
    'BIN': 0xc4,
    'OR': 0xc5,
    'AND': 0xc6,
    '<=': 0xc7,
    '>=': 0xc8,
    '<>': 0xc9,
    'LINE': 0xca,
    'THEN': 0xcb,
    'TO': 0xcc,
    'STEP': 0xcd,
    'DEF FN': 0xce,
    'CAT': 0xcf,
    'FORMAT': 0xd0,
    'MOVE': 0xd1,
    'ERASE': 0xd2,
    'OPEN #': 0xd3,
    'CLOSE #': 0xd4,
    'MERGE': 0xd5,
    'VERIFY': 0xd6,
    'BEEP': 0xd7,
    'CIRCLE': 0xd8,
    'INK': 0xd9,
    'PAPER': 0xda,
    'FLASH': 0xdb,
    'BRIGHT': 0xdc,
    'INVERSE': 0xdd,
    'OVER': 0xde,
    'OUT': 0xdf,
    'LPRINT': 0xe0,
    'LLIST': 0xe1,
    'STOP': 0xe2,
    'READ': 0xe3,
    'DATA': 0xe4,
    'RESTORE': 0xe5,
    'NEW': 0xe6,
    'BORDER': 0xe7,
    'CONTINUE': 0xe8,
    'DIM': 0xe9,
    'REM': 0xea,
    'FOR': 0xeb,
    'GO TO': 0xec,
    'GO SUB': 0xed,
    'INPUT': 0xee,
    'LOAD': 0xef,
    'LIST': 0xf0,
    'LET': 0xf1,
    'PAUSE': 0xf2,
    'NEXT': 0xf3,
    'POKE': 0xf4,
    'PRINT': 0xf5,
    'PLOT': 0xf6,
    'RUN': 0xf7,
    'SAVE': 0xf8,
    'RANDOMIZE': 0xf9,
    'IF': 0xfa,
    'CLS': 0xfb,
    'DRAW': 0xfc,
    'CLEAR': 0xfd,
    'RETURN': 0xfe,
    'COPY': 0xff,
}

REV_TOKENS = {}

for key, value in TOKENS.items():
    REV_TOKENS[value] = key
