"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.IntegTesting = void 0;
const cdk = require("@aws-cdk/core");
const index_1 = require("./index");
class IntegTesting {
    constructor() {
        const app = new cdk.App();
        const env = {
            region: process.env.CDK_DEFAULT_REGION,
            account: process.env.CDK_DEFAULT_ACCOUNT,
        };
        const stack = new cdk.Stack(app, 'my-demo-stack', { env });
        // Create a loose coupled SSM Parameter from type String
        new index_1.SSMParameter(stack, 'SSMParameter', {
            parameterName: 'foo',
            defaultValue: 'fooValue',
        });
        // Create a loose coupled SSM Parameter from type StringList
        new index_1.SSMParameter(stack, 'SSMParameterStringList', {
            parameterName: 'fooStringList',
            defaultValue: 'fooValue1,fooValue2,fooValue3',
            type: index_1.SSMParameterType.STRING_LIST,
        });
        // Delete the SSM Parameter if the stack gets deleted
        new index_1.SSMParameter(stack, 'SSMParameterWithDelete', {
            parameterName: 'fooWithDelete',
            defaultValue: 'fooValue',
            delete: true,
        });
        this.stack = [stack];
    }
}
exports.IntegTesting = IntegTesting;
new IntegTesting();
//# sourceMappingURL=data:application/json;base64,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