"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.FirehosePutRecordAction = exports.FirehoseRecordSeparator = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const role_1 = require("./private/role");
/**
 * Record Separator to be used to separate records.
 */
var FirehoseRecordSeparator;
(function (FirehoseRecordSeparator) {
    /**
     * Separate by a new line
     */
    FirehoseRecordSeparator["NEWLINE"] = "\n";
    /**
     * Separate by a tab
     */
    FirehoseRecordSeparator["TAB"] = "\t";
    /**
     * Separate by a windows new line
     */
    FirehoseRecordSeparator["WINDOWS_NEWLINE"] = "\r\n";
    /**
     * Separate by a commma
     */
    FirehoseRecordSeparator["COMMA"] = ",";
})(FirehoseRecordSeparator = exports.FirehoseRecordSeparator || (exports.FirehoseRecordSeparator = {}));
/**
 * The action to put the record from an MQTT message to the Kinesis Data Firehose stream.
 */
class FirehosePutRecordAction {
    /**
     * @param stream The Kinesis Data Firehose stream to which to put records.
     * @param props Optional properties to not use default
     */
    constructor(stream, props = {}) {
        this.stream = stream;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_alpha_FirehosePutRecordActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, FirehosePutRecordAction);
            }
            throw error;
        }
        this.batchMode = props.batchMode;
        this.recordSeparator = props.recordSeparator;
        this.role = props.role;
    }
    /**
     * @internal
     */
    _bind(rule) {
        const role = this.role ?? role_1.singletonActionRole(rule);
        this.stream.grantPutRecords(role);
        return {
            configuration: {
                firehose: {
                    batchMode: this.batchMode,
                    deliveryStreamName: this.stream.deliveryStreamName,
                    roleArn: role.roleArn,
                    separator: this.recordSeparator,
                },
            },
        };
    }
}
exports.FirehosePutRecordAction = FirehosePutRecordAction;
_a = JSII_RTTI_SYMBOL_1;
FirehosePutRecordAction[_a] = { fqn: "@aws-cdk/aws-iot-actions-alpha.FirehosePutRecordAction", version: "2.53.0-alpha.0" };
//# sourceMappingURL=data:application/json;base64,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